/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.wsl.ijent.nio;

import com.intellij.execution.ijent.nio.IjentNioPosixFileAttributesWithDosAdapter;
import com.intellij.platform.core.nio.fs.BasicFileAttributesHolder2;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.platform.ide.impl.wsl.ijent.nio.IjentWslNioFileSystem;
import com.intellij.platform.ide.impl.wsl.ijent.nio.IjentWslNioPathKt;
import com.intellij.platform.ijent.community.impl.nio.IjentNioPath;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u0004H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0000H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0000H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0000H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\u0018\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0001H\u0016J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0001H\u0016J\b\u0010\u001e\u001a\u00020\u0000H\u0016J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0001H\u0016J\u0010\u0010 \u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0001H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0000H\u0016J!\u0010$\u001a\u00020\u00002\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0&\"\u00020'H\u0016\u00a2\u0006\u0002\u0010(JE\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0016\u0010-\u001a\u0012\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010.\u0018\u00010&2\u0016\u0010/\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001000&\"\u0004\u0018\u000100H\u0016\u00a2\u0006\u0002\u00101J\u0012\u00102\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0001H\u0096\u0082\u0004J\f\u00103\u001a\u00020\u0000*\u00020\u0001H\u0002J\f\u00104\u001a\u00020\u0001*\u00020\u0001H\u0002J\n\u00105\u001a\u000206H\u0096\u0080\u0004J\u0014\u00107\u001a\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u000108H\u0096\u0082\u0004J\n\u00109\u001a\u00020\u0015H\u0096\u0080\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006:"}, d2={"Lcom/intellij/platform/ide/impl/wsl/ijent/nio/IjentWslNioPath;", "Ljava/nio/file/Path;", "Lcom/intellij/platform/core/nio/fs/BasicFileAttributesHolder2$Impl;", "fileSystem", "Lcom/intellij/platform/ide/impl/wsl/ijent/nio/IjentWslNioFileSystem;", "presentablePath", "cachedAttributes", "Lcom/intellij/execution/ijent/nio/IjentNioPosixFileAttributesWithDosAdapter;", "<init>", "(Lcom/intellij/platform/ide/impl/wsl/ijent/nio/IjentWslNioFileSystem;Ljava/nio/file/Path;Lcom/intellij/execution/ijent/nio/IjentNioPosixFileAttributesWithDosAdapter;)V", "getPresentablePath", "()Ljava/nio/file/Path;", "actualPath", "getActualPath", "getFileSystem", "isAbsolute", "", "getRoot", "getFileName", "getParent", "getNameCount", "", "getName", "index", "subpath", "beginIndex", "endIndex", "startsWith", "other", "endsWith", "normalize", "resolve", "relativize", "toUri", "Ljava/net/URI;", "toAbsolutePath", "toRealPath", "options", "", "Ljava/nio/file/LinkOption;", "([Ljava/nio/file/LinkOption;)Lcom/intellij/platform/ide/impl/wsl/ijent/nio/IjentWslNioPath;", "register", "Ljava/nio/file/WatchKey;", "watcher", "Ljava/nio/file/WatchService;", "events", "Ljava/nio/file/WatchEvent$Kind;", "modifiers", "Ljava/nio/file/WatchEvent$Modifier;", "(Ljava/nio/file/WatchService;[Ljava/nio/file/WatchEvent$Kind;[Ljava/nio/file/WatchEvent$Modifier;)Ljava/nio/file/WatchKey;", "compareTo", "toIjentWslPath", "toOriginalPath", "toString", "", "equals", "", "hashCode", "intellij.platform.ide.impl.wsl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIjentWslNioPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IjentWslNioPath.kt\ncom/intellij/platform/ide/impl/wsl/ijent/nio/IjentWslNioPath\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1#2:130\n*E\n"})
public final class IjentWslNioPath
extends BasicFileAttributesHolder2.Impl
implements Path {
    @NotNull
    private final IjentWslNioFileSystem fileSystem;
    @NotNull
    private final Path presentablePath;
    @NotNull
    private final Path actualPath;

    public IjentWslNioPath(@NotNull IjentWslNioFileSystem fileSystem, @NotNull Path presentablePath, @Nullable IjentNioPosixFileAttributesWithDosAdapter cachedAttributes) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)presentablePath, (String)"presentablePath");
        super((BasicFileAttributes)cachedAttributes);
        this.fileSystem = fileSystem;
        this.presentablePath = presentablePath;
        if (!(!(this.presentablePath instanceof IjentWslNioPath))) {
            boolean bl = false;
            String string = "IjentWslNioPath should be a wrapper over other instances of path, namely WindowsPath or IjentNioPath";
            throw new IllegalArgumentException(string.toString());
        }
        this.actualPath = EelPathUtils.getActualPath((Path)this.presentablePath);
    }

    @NotNull
    public final Path getPresentablePath() {
        return this.presentablePath;
    }

    @NotNull
    public final Path getActualPath() {
        return this.actualPath;
    }

    @Override
    @NotNull
    public IjentWslNioFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.presentablePath.isAbsolute();
    }

    @Override
    @Nullable
    public IjentWslNioPath getRoot() {
        Path path = this.presentablePath.getRoot();
        return path != null ? this.toIjentWslPath(path) : null;
    }

    @Override
    @Nullable
    public IjentWslNioPath getFileName() {
        Path path = this.presentablePath.getFileName();
        return path != null ? this.toIjentWslPath(path) : null;
    }

    @Override
    @Nullable
    public IjentWslNioPath getParent() {
        Path path = this.presentablePath.getParent();
        return path != null ? this.toIjentWslPath(path) : null;
    }

    @Override
    public int getNameCount() {
        return this.presentablePath.getNameCount();
    }

    @Override
    @NotNull
    public IjentWslNioPath getName(int index) {
        Path path = this.presentablePath.getName(index);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getName(...)");
        return this.toIjentWslPath(path);
    }

    @Override
    @NotNull
    public IjentWslNioPath subpath(int beginIndex, int endIndex) {
        Path path = this.presentablePath.subpath(beginIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"subpath(...)");
        return this.toIjentWslPath(path);
    }

    @Override
    public boolean startsWith(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.presentablePath.startsWith(this.toOriginalPath(other));
    }

    @Override
    public boolean endsWith(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.presentablePath.endsWith(this.toOriginalPath(other));
    }

    @Override
    @NotNull
    public IjentWslNioPath normalize() {
        Path path = this.presentablePath.normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
        return this.toIjentWslPath(path);
    }

    @Override
    @NotNull
    public IjentWslNioPath resolve(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Path path = this.presentablePath.resolve(this.toOriginalPath(other));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return this.toIjentWslPath(path);
    }

    @Override
    @NotNull
    public IjentWslNioPath relativize(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Path path = this.presentablePath.relativize(this.toOriginalPath(other));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"relativize(...)");
        return this.toIjentWslPath(path);
    }

    @Override
    @NotNull
    public URI toUri() {
        URI uRI = this.presentablePath.toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        return uRI;
    }

    @Override
    @NotNull
    public IjentWslNioPath toAbsolutePath() {
        Path path = this.presentablePath.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        return this.toIjentWslPath(path);
    }

    @Override
    @NotNull
    public IjentWslNioPath toRealPath(LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!this.isAbsolute()) {
            return this.toAbsolutePath().toRealPath(Arrays.copyOf(options, options.length));
        }
        String string = this.normalize().toString();
        if (Intrinsics.areEqual((Object)string, (Object)("\\\\wsl$\\" + this.fileSystem.getWslId$intellij_platform_ide_impl_wsl() + "\\")) || Intrinsics.areEqual((Object)string, (Object)("\\\\wsl.localhost\\" + this.fileSystem.getWslId$intellij_platform_ide_impl_wsl() + "\\"))) {
            return this;
        }
        IjentNioPath ijentNioPath = this.fileSystem.provider().toIjentNioPath$intellij_platform_ide_impl_wsl(this);
        IjentNioPath ijentNioRealPath = !Intrinsics.areEqual((Object)this.presentablePath, (Object)this.actualPath) ? ijentNioPath.normalize() : ijentNioPath.toRealPath(Arrays.copyOf(options, options.length));
        Path originalPath = this.fileSystem.provider().toOriginalPath$intellij_platform_ide_impl_wsl((Path)ijentNioRealPath, StringsKt.substringBefore$default((String)StringsKt.removePrefix((String)String.valueOf(this.getRoot()), (CharSequence)"\\\\"), (char)'\\', null, (int)2, null));
        return this.toIjentWslPath(originalPath);
    }

    @Override
    @NotNull
    public WatchKey register(@NotNull WatchService watcher, @Nullable WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) {
        Intrinsics.checkNotNullParameter((Object)watcher, (String)"watcher");
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        WatchKey watchKey = this.actualPath.register(watcher, events, Arrays.copyOf(modifiers, modifiers.length));
        Intrinsics.checkNotNullExpressionValue((Object)watchKey, (String)"register(...)");
        return watchKey;
    }

    @Override
    public int compareTo(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.presentablePath.compareTo(this.toOriginalPath(other));
    }

    private final IjentWslNioPath toIjentWslPath(Path $this$toIjentWslPath) {
        return new IjentWslNioPath(this.fileSystem, $this$toIjentWslPath, null);
    }

    private final Path toOriginalPath(Path $this$toOriginalPath) {
        return $this$toOriginalPath instanceof IjentWslNioPath ? ((IjentWslNioPath)$this$toOriginalPath).presentablePath : $this$toOriginalPath;
    }

    @Override
    @NotNull
    public String toString() {
        return ((Object)this.presentablePath).toString();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other ? true : (!(other instanceof IjentWslNioPath) ? false : IjentWslNioPathKt.access$wslPathEqual(this, (IjentWslNioPath)other));
    }

    @Override
    public int hashCode() {
        return this.fileSystem.hashCode() + 31 * ((Object)this.presentablePath).hashCode();
    }
}

