/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.path;

import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.path.ArrayListEelAbsolutePath;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.path.EelPathException;
import com.intellij.platform.eel.path.EelPathKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u0000 02\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002:\u00010B'\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0001H\u0016J\u0016\u0010\u001a\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\u001c\u001a\u00020\u0001H\u0016J\u0010\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\tH\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\tH\u0016J\n\u0010 \u001a\u00020\tH\u0096\u0080\u0004J\b\u0010!\u001a\u00020\tH\u0016J\u0010\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020&H\u0016J\u0012\u0010+\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u0001H\u0096\u0082\u0004J\u0014\u0010,\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010-H\u0096\u0082\u0004J\n\u0010.\u001a\u00020&H\u0096\u0080\u0004J\u0012\u0010/\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020\tH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00018VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\"\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u00061"}, d2={"Lcom/intellij/platform/eel/path/ArrayListEelAbsolutePath;", "Lcom/intellij/platform/eel/path/EelPath;", "", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "_root", "Lcom/intellij/platform/eel/path/ArrayListEelAbsolutePath$Companion$Root;", "parts", "", "", "<init>", "(Lcom/intellij/platform/eel/EelDescriptor;Lcom/intellij/platform/eel/path/ArrayListEelAbsolutePath$Companion$Root;Ljava/util/List;)V", "getDescriptor", "()Lcom/intellij/platform/eel/EelDescriptor;", "getParts", "()Ljava/util/List;", "root", "getRoot", "()Lcom/intellij/platform/eel/path/EelPath;", "root$delegate", "Lkotlin/Lazy;", "parent", "getParent", "startsWith", "", "other", "endsWith", "suffix", "normalize", "resolve", "getChild", "name", "toString", "toDebugString", "fileName", "getFileName", "()Ljava/lang/String;", "nameCount", "", "getNameCount", "()I", "getName", "index", "compareTo", "equals", "", "hashCode", "checkFileName", "Companion", "intellij.platform.eel"})
@SourceDebugExtension(value={"SMAP\nArrayListEelAbsolutePath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayListEelAbsolutePath.kt\ncom/intellij/platform/eel/path/ArrayListEelAbsolutePath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,303:1\n1786#2,3:304\n777#2:307\n873#2,2:308\n1786#2,3:311\n1#3:310\n*S KotlinDebug\n*F\n+ 1 ArrayListEelAbsolutePath.kt\ncom/intellij/platform/eel/path/ArrayListEelAbsolutePath\n*L\n27#1:304,3\n53#1:307\n53#1:308,2\n121#1:311,3\n*E\n"})
public final class ArrayListEelAbsolutePath
implements EelPath,
Comparable<EelPath> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EelDescriptor descriptor;
    @NotNull
    private final Companion.Root _root;
    @NotNull
    private final List<String> parts;
    @NotNull
    private final Lazy root$delegate;

    private ArrayListEelAbsolutePath(EelDescriptor descriptor, Companion.Root _root, List<String> parts2) {
        this.descriptor = descriptor;
        this._root = _root;
        this.parts = parts2;
        this.root$delegate = LazyKt.lazy(() -> ArrayListEelAbsolutePath.root_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public EelDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    @NotNull
    public List<String> getParts() {
        return this.parts;
    }

    @Override
    @NotNull
    public EelPath getRoot() {
        Lazy lazy = this.root$delegate;
        return (EelPath)lazy.getValue();
    }

    @Override
    @Nullable
    public EelPath getParent() {
        return this.getParts().isEmpty() ? null : (EelPath)new ArrayListEelAbsolutePath(this.getDescriptor(), this._root, CollectionsKt.dropLast(this.getParts(), 1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean startsWith(@NotNull EelPath other) {
        int it;
        Intrinsics.checkNotNullParameter(other, "other");
        if (this.getNameCount() < other.getNameCount()) return false;
        if (!Intrinsics.areEqual(this.getRoot().getFileName(), other.getRoot().getFileName())) return false;
        Iterable $this$all$iv = RangesKt.until(0, other.getNameCount());
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            int element$iv;
            if (!iterator2.hasNext()) return true;
            it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
        } while (Intrinsics.areEqual(this.getName(it), other.getName(it)));
        return false;
    }

    @Override
    public boolean endsWith(@NotNull List<String> suffix) {
        Intrinsics.checkNotNullParameter(suffix, "suffix");
        return this.getNameCount() >= suffix.size() && Intrinsics.areEqual(CollectionsKt.takeLast(this.getParts(), suffix.size()), suffix);
    }

    @Override
    @NotNull
    public EelPath normalize() {
        List result = new ArrayList();
        for (String part : this.getParts()) {
            String string = part;
            if (Intrinsics.areEqual(string, ".")) continue;
            if (Intrinsics.areEqual(string, "..")) {
                if (!(!((Collection)result).isEmpty()) || Intrinsics.areEqual(CollectionsKt.last(result), "..")) continue;
                result.removeLast();
                continue;
            }
            ((Collection)result).add(part);
        }
        return new ArrayListEelAbsolutePath(this.getDescriptor(), this._root, result);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public EelPath resolve(@NotNull String other) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(other, "other");
        char[] delimiters = EelPlatformKt.getDirectorySeparators(EelPathKt.getPlatform(this));
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)other, Arrays.copyOf(delimiters, delimiters.length), false, 0, 6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)p0).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List otherParts = (List)destination$iv$iv;
        for (String name : otherParts) {
            String error;
            if (!(((CharSequence)name).length() > 0) || (error = this.checkFileName(name)) == null) continue;
            throw new EelPathException(other.toString(), error);
        }
        List<String> newList = CollectionsKt.plus((Collection)this.getParts(), (Iterable)otherParts);
        return new ArrayListEelAbsolutePath(this.getDescriptor(), this._root, newList);
    }

    @Override
    @NotNull
    public EelPath getChild(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        if (!(((CharSequence)name).length() > 0)) {
            boolean bl = false;
            String string = "Child name must not be empty";
            throw new IllegalArgumentException(string.toString());
        }
        String error = this.checkFileName(name);
        if (error != null) {
            throw new EelPathException(name, error);
        }
        return new ArrayListEelAbsolutePath(this.getDescriptor(), this._root, CollectionsKt.plus((Collection)this.getParts(), name));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String toString() {
        String string;
        Companion.Root root = this._root;
        if (Intrinsics.areEqual(root, Companion.Root.Unix.INSTANCE)) {
            string = CollectionsKt.joinToString$default(this.getParts(), "/", "/", null, 0, null, null, 60, null);
        } else if (root instanceof Companion.Root.Windows) {
            void $this$toString_u24lambda_u240;
            ArrayListEelAbsolutePath arrayListEelAbsolutePath = this;
            CharSequence charSequence = "\\";
            Iterable iterable = this.getParts();
            boolean bl = false;
            String string2 = StringsKt.endsWith$default($this$toString_u24lambda_u240._root.getName(), "\\", false, 2, null) ? $this$toString_u24lambda_u240._root.getName() : $this$toString_u24lambda_u240._root.getName() + '\\';
            string = CollectionsKt.joinToString$default(iterable, charSequence, string2, null, 0, null, null, 60, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Override
    @NotNull
    public String toDebugString() {
        return this.getClass().getSimpleName() + "(_root=" + this.getRoot() + ", parts=" + this.getParts() + ')';
    }

    @Override
    @NotNull
    public String getFileName() {
        String string = CollectionsKt.lastOrNull(this.getParts());
        if (string == null) {
            string = this._root.getName();
        }
        return string;
    }

    @Override
    public int getNameCount() {
        return this.getParts().size();
    }

    @Override
    @NotNull
    public String getName(int index) {
        return this.getParts().get(index);
    }

    @Override
    public int compareTo(@NotNull EelPath other) {
        Intrinsics.checkNotNullParameter(other, "other");
        ArrayListEelAbsolutePath $this$compareTo_u24lambda_u240 = this;
        boolean bl = false;
        int cmp = $this$compareTo_u24lambda_u240.getRoot().getFileName().compareTo(other.getRoot().getFileName());
        if (cmp != 0) {
            return cmp;
        }
        int n = RangesKt.coerceAtMost(this.getNameCount(), other.getNameCount());
        for (int index = 0; index < n; ++index) {
            int cmp2 = this.getName(index).compareTo(other.getName(index));
            if (cmp2 == 0) continue;
            return cmp2;
        }
        return this.getNameCount() - other.getNameCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        int it;
        if (!(other instanceof EelPath)) return false;
        if (this.getNameCount() != ((EelPath)other).getNameCount()) return false;
        if (!Intrinsics.areEqual(this.getRoot().getFileName(), ((EelPath)other).getRoot().getFileName())) return false;
        Iterable $this$all$iv = RangesKt.until(0, this.getNameCount());
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            int element$iv;
            if (!iterator2.hasNext()) return true;
            it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
        } while (Intrinsics.areEqual(this.getName(it), ((EelPath)other).getName(it)));
        return false;
    }

    public int hashCode() {
        return 31 * this._root.hashCode() + ((Object)this.getParts()).hashCode();
    }

    private final String checkFileName(String name) {
        boolean bl;
        Companion.Root root = this._root;
        if (Intrinsics.areEqual(root, Companion.Root.Unix.INSTANCE)) {
            bl = false;
        } else if (root instanceof Companion.Root.Windows) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return ArrayListEelAbsolutePath.Companion.checkFileName(name, bl);
    }

    private static final ArrayListEelAbsolutePath root_delegate$lambda$0(ArrayListEelAbsolutePath this$0) {
        return this$0.getParts().isEmpty() ? this$0 : new ArrayListEelAbsolutePath(this$0.getDescriptor(), this$0._root, CollectionsKt.emptyList());
    }

    public /* synthetic */ ArrayListEelAbsolutePath(EelDescriptor descriptor, Companion.Root _root, List parts2, DefaultConstructorMarker $constructor_marker) {
        this(descriptor, _root, parts2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/eel/path/ArrayListEelAbsolutePath$Companion;", "", "<init>", "()V", "build", "Lcom/intellij/platform/eel/path/EelPath;", "parts", "", "", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "parseOrNull", "Lcom/intellij/platform/eel/path/ArrayListEelAbsolutePath;", "raw", "findAbsoluteUncPath", "findAbsoluteTraditionalDosPath", "findAbsoluteUnixPath", "checkFileName", "name", "isWindows", "", "Root", "intellij.platform.eel"})
    @SourceDebugExtension(value={"SMAP\nArrayListEelAbsolutePath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayListEelAbsolutePath.kt\ncom/intellij/platform/eel/path/ArrayListEelAbsolutePath$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,303:1\n1#2:304\n1#2:316\n1642#3,10:305\n1915#3:315\n1916#3:317\n1652#3:318\n*S KotlinDebug\n*F\n+ 1 ArrayListEelAbsolutePath.kt\ncom/intellij/platform/eel/path/ArrayListEelAbsolutePath$Companion\n*L\n248#1:316\n248#1:305,10\n248#1:315\n248#1:317\n248#1:318\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EelPath build(@NotNull List<String> parts2, @NotNull EelDescriptor descriptor) {
            ArrayListEelAbsolutePath windowsRoot;
            ArrayListEelAbsolutePath arrayListEelAbsolutePath;
            Intrinsics.checkNotNullParameter(parts2, "parts");
            Intrinsics.checkNotNullParameter(descriptor, "descriptor");
            if (!(!((Collection)parts2).isEmpty())) {
                boolean bl = false;
                String string = "Can't build an absolute path from no path parts";
                throw new IllegalArgumentException(string.toString());
            }
            switch (WhenMappings.$EnumSwitchMapping$0[descriptor.getOsFamily().ordinal()]) {
                case 1: {
                    arrayListEelAbsolutePath = this.findAbsoluteUncPath(CollectionsKt.first(parts2), descriptor);
                    if (arrayListEelAbsolutePath != null) break;
                    arrayListEelAbsolutePath = this.findAbsoluteTraditionalDosPath(CollectionsKt.first(parts2), descriptor);
                    break;
                }
                case 2: {
                    arrayListEelAbsolutePath = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if ((windowsRoot = arrayListEelAbsolutePath) == null) {
                List<String> parts3 = Intrinsics.areEqual(CollectionsKt.first(parts2), "/") ? CollectionsKt.drop((Iterable)parts2, 1) : parts2;
                for (String part : parts3) {
                    String error = this.checkFileName(part, false);
                    if (error == null) continue;
                    throw new EelPathException(part, error);
                }
                return new ArrayListEelAbsolutePath(descriptor, Root.Unix.INSTANCE, parts3, null);
            }
            List<String> parts4 = CollectionsKt.drop((Iterable)parts2, 1);
            for (String part : parts4) {
                String error = this.checkFileName(part, true);
                if (error == null) continue;
                throw new EelPathException(part, error);
            }
            return new ArrayListEelAbsolutePath(descriptor, windowsRoot._root, parts4, null);
        }

        @Nullable
        public final ArrayListEelAbsolutePath parseOrNull(@NotNull String raw, @NotNull EelDescriptor descriptor) throws EelPathException {
            ArrayListEelAbsolutePath arrayListEelAbsolutePath;
            Intrinsics.checkNotNullParameter(raw, "raw");
            Intrinsics.checkNotNullParameter(descriptor, "descriptor");
            switch (WhenMappings.$EnumSwitchMapping$0[descriptor.getOsFamily().ordinal()]) {
                case 1: {
                    arrayListEelAbsolutePath = this.findAbsoluteUncPath(raw, descriptor);
                    if (arrayListEelAbsolutePath != null) break;
                    arrayListEelAbsolutePath = this.findAbsoluteTraditionalDosPath(raw, descriptor);
                    break;
                }
                case 2: {
                    arrayListEelAbsolutePath = this.findAbsoluteUnixPath(raw, descriptor);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return arrayListEelAbsolutePath;
        }

        private final ArrayListEelAbsolutePath findAbsoluteUncPath(String raw, EelDescriptor descriptor) {
            if (raw.length() < 3) {
                return null;
            }
            if (!Intrinsics.areEqual(StringsKt.getOrNull(raw, 0), StringsKt.getOrNull(raw, 1))) {
                return null;
            }
            int index = 0;
            index = 2;
            while (StringsKt.contains$default((CharSequence)"/\\", raw.charAt(index), false, 2, null)) {
                if (++index != raw.length()) continue;
                return null;
            }
            Companion $this$findAbsoluteUncPath_u24lambda_u240 = this;
            boolean bl = false;
            String string = raw.substring(2, index);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String error = $this$findAbsoluteUncPath_u24lambda_u240.checkFileName(string, true);
            if (error != null) {
                throw new EelPathException(raw, "Incorrect server name in UNC path");
            }
            int shareNameStart = index++;
            if (index == raw.length()) {
                throw new EelPathException(raw, "Empty share name in UNC path");
            }
            while (!StringsKt.contains$default((CharSequence)"/\\", raw.charAt(index), false, 2, null) && ++index != raw.length()) {
            }
            Companion $this$findAbsoluteUncPath_u24lambda_u241 = this;
            boolean bl2 = false;
            String string2 = raw.substring(shareNameStart, index);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String error2 = $this$findAbsoluteUncPath_u24lambda_u241.checkFileName(string2, true);
            if (error2 != null) {
                throw new EelPathException(raw, "Incorrect share name in UNC path");
            }
            String string3 = raw.substring(index);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            Object object = new char[]{'/', '\\'};
            List parts2 = SequencesKt.toList(SequencesKt.filter(StringsKt.splitToSequence$default((CharSequence)string3, object, false, 0, 6, null), findAbsoluteUncPath.parts.1.INSTANCE));
            object = parts2.iterator();
            while (object.hasNext()) {
                String part = (String)object.next();
                error2 = this.checkFileName(part, true);
                if (error2 == null) continue;
                throw new EelPathException(raw, error2);
            }
            String string4 = raw.substring(0, index);
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
            return new ArrayListEelAbsolutePath(descriptor, new Root.Windows(StringsKt.replace$default(string4, "/", "\\", false, 4, null)), parts2, null);
        }

        private final ArrayListEelAbsolutePath findAbsoluteTraditionalDosPath(String raw, EelDescriptor descriptor) throws EelPathException {
            String raw2 = raw;
            if (raw2.length() == 2 && StringsKt.endsWith$default(raw2, ":", false, 2, null)) {
                raw2 = raw2 + '\\';
            }
            if (raw2.length() < 3) {
                return null;
            }
            if (!Character.isLetter(raw2.charAt(0))) {
                return null;
            }
            if (raw2.charAt(1) != ':') {
                return null;
            }
            if (raw2.charAt(2) != '\\' && raw2.charAt(2) != '/') {
                return null;
            }
            String string = raw2.substring(3);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            Object object = new char[]{'/', '\\'};
            List parts2 = SequencesKt.toList(SequencesKt.filter(StringsKt.splitToSequence$default((CharSequence)string, object, false, 0, 6, null), findAbsoluteTraditionalDosPath.parts.1.INSTANCE));
            object = parts2.iterator();
            while (object.hasNext()) {
                String part = (String)object.next();
                String error = this.checkFileName(part, true);
                if (error == null) continue;
                throw new EelPathException(raw2, error);
            }
            String string2 = raw2.substring(0, 3);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String driveRoot = StringsKt.replace$default(string2, '/', '\\', false, 4, null);
            return new ArrayListEelAbsolutePath(descriptor, new Root.Windows(driveRoot), parts2, null);
        }

        /*
         * WARNING - void declaration
         */
        private final ArrayListEelAbsolutePath findAbsoluteUnixPath(String raw, EelDescriptor descriptor) {
            void $this$mapNotNullTo$iv$iv;
            if (((CharSequence)raw).length() == 0 || raw.charAt(0) != '/') {
                return null;
            }
            String[] stringArray = new String[]{"/"};
            Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)raw, stringArray, false, 0, 6, null);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String part = (String)element$iv$iv;
                boolean bl2 = false;
                if (((CharSequence)part).length() > 0) {
                    String error = Companion.checkFileName(part, false);
                    if (error != null) {
                        throw new EelPathException(raw, error);
                    }
                    string = part;
                } else {
                    string = null;
                }
                if (string == null) continue;
                String it$iv$iv = string;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List parts2 = (List)destination$iv$iv;
            return new ArrayListEelAbsolutePath(descriptor, Root.Unix.INSTANCE, parts2, null);
        }

        private final String checkFileName(String name, boolean isWindows) {
            String invalidSymbols = isWindows ? "\u0000/\\:" : "\u0000/";
            int n = invalidSymbols.length();
            for (int i = 0; i < n; ++i) {
                Object object;
                char symbol = invalidSymbols.charAt(i);
                if (!StringsKt.contains$default((CharSequence)name, symbol, false, 2, null)) continue;
                if (Character.isISOControl(symbol)) {
                    StringBuilder stringBuilder = new StringBuilder().append("\\u");
                    String string = Integer.toString(symbol, CharsKt.checkRadix(16));
                    Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                    object = stringBuilder.append(StringsKt.padStart(string, 4, '0')).toString();
                } else {
                    object = Character.valueOf(symbol);
                }
                Character prettySymbol = object;
                return isWindows ? "Invalid symbol in Windows path: " + prettySymbol : "Invalid symbol in Unix path: " + prettySymbol;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0002\u0006\u0007R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/eel/path/ArrayListEelAbsolutePath$Companion$Root;", "", "name", "", "getName", "()Ljava/lang/String;", "Unix", "Windows", "Lcom/intellij/platform/eel/path/ArrayListEelAbsolutePath$Companion$Root$Unix;", "Lcom/intellij/platform/eel/path/ArrayListEelAbsolutePath$Companion$Root$Windows;", "intellij.platform.eel"})
        private static interface Root {
            @NotNull
            public String getName();

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0083\u0004J\n\u0010\f\u001a\u00020\rH\u00d6\u0081\u0004J\n\u0010\u000e\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/eel/path/ArrayListEelAbsolutePath$Companion$Root$Unix;", "Lcom/intellij/platform/eel/path/ArrayListEelAbsolutePath$Companion$Root;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.eel"})
            public static final class Unix
            implements Root {
                @NotNull
                public static final Unix INSTANCE = new Unix();
                @NotNull
                private static final String name = "/";

                private Unix() {
                }

                @Override
                @NotNull
                public String getName() {
                    return name;
                }

                @NotNull
                public String toString() {
                    return "Unix";
                }

                public int hashCode() {
                    return 772697995;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Unix)) {
                        return false;
                    }
                    Unix cfr_ignored_0 = (Unix)other;
                    return true;
                }
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/eel/path/ArrayListEelAbsolutePath$Companion$Root$Windows;", "Lcom/intellij/platform/eel/path/ArrayListEelAbsolutePath$Companion$Root;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.eel"})
            @SourceDebugExtension(value={"SMAP\nArrayListEelAbsolutePath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayListEelAbsolutePath.kt\ncom/intellij/platform/eel/path/ArrayListEelAbsolutePath$Companion$Root$Windows\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,303:1\n1#2:304\n*E\n"})
            public static final class Windows
            implements Root {
                @NotNull
                private final String name;

                public Windows(@NotNull String name) {
                    Intrinsics.checkNotNullParameter(name, "name");
                    this.name = name;
                    if (!(!StringsKt.contains$default((CharSequence)this.getName(), '/', false, 2, null))) {
                        boolean $i$a$-require-ArrayListEelAbsolutePath$Companion$Root$Windows$32 = false;
                        String $i$a$-require-ArrayListEelAbsolutePath$Companion$Root$Windows$32 = "Windows drives should not contain regular slashes";
                        throw new IllegalArgumentException($i$a$-require-ArrayListEelAbsolutePath$Companion$Root$Windows$32.toString());
                    }
                    if (!StringsKt.contains$default((CharSequence)this.getName(), "\\", false, 2, null)) {
                        boolean bl = false;
                        String string = "Windows drive names must end with a backslash.";
                        throw new IllegalArgumentException(string.toString());
                    }
                }

                @Override
                @NotNull
                public String getName() {
                    return this.name;
                }

                @NotNull
                public final String component1() {
                    return this.name;
                }

                @NotNull
                public final Windows copy(@NotNull String name) {
                    Intrinsics.checkNotNullParameter(name, "name");
                    return new Windows(name);
                }

                public static /* synthetic */ Windows copy$default(Windows windows, String string, int n, Object object) {
                    if ((n & 1) != 0) {
                        string = windows.name;
                    }
                    return windows.copy(string);
                }

                @NotNull
                public String toString() {
                    return "Windows(name=" + this.name + ')';
                }

                public int hashCode() {
                    return this.name.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Windows)) {
                        return false;
                    }
                    Windows windows = (Windows)other;
                    return Intrinsics.areEqual(this.name, windows.name);
                }
            }
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[EelOsFamily.values().length];
                try {
                    nArray[EelOsFamily.Windows.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EelOsFamily.Posix.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

