/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.FilteringIterator;
import java.util.Collection;

@FunctionalInterface
public interface InternalIterator<T> {
    public boolean visit(T var1);

    public static final class Filtering<T>
    implements InternalIterator<T> {
        private final Condition<? super T> myFilter;
        private final InternalIterator<? super T> myIterator;

        public Filtering(InternalIterator<? super T> iterator2, Condition<? super T> filter) {
            this.myIterator = iterator2;
            this.myFilter = filter;
        }

        @Override
        public boolean visit(T value) {
            return !this.myFilter.value(value) || this.myIterator.visit(value);
        }

        public static <T> InternalIterator<T> create(InternalIterator<? super T> iterator2, Condition<? super T> filter) {
            return new Filtering<T>(iterator2, filter);
        }

        public static <T, V extends T> InternalIterator<T> createInstanceOf(InternalIterator<V> iterator2, FilteringIterator.InstanceOf<V> filter) {
            return new Filtering<Object>(iterator2, filter);
        }

        public static <T> InternalIterator createInstanceOf(InternalIterator<T> iterator2, Class<T> aClass) {
            return Filtering.createInstanceOf(iterator2, FilteringIterator.instanceOf(aClass));
        }
    }

    public static final class Collector<T>
    implements InternalIterator<T> {
        private final Collection<? super T> myCollection;

        public Collector(Collection<? super T> collection) {
            this.myCollection = collection;
        }

        @Override
        public boolean visit(T value) {
            return this.myCollection.add(value);
        }

        public static <T> InternalIterator<T> create(Collection<? super T> collection) {
            return new Collector<T>(collection);
        }
    }
}

