/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.detector.ngram.impl;

import ai.grazie.detector.ngram.filter.StandardNgramFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lai/grazie/detector/ngram/impl/NgramExtractor;", "", "gramLengths", "", "", "textPadding", "", "<init>", "(Ljava/util/List;Ljava/lang/Character;)V", "getGramLengths", "()Ljava/util/List;", "Ljava/lang/Character;", "extract", "", "input", "", "applyPadding", "text", "Companion", "nlp-detect"})
@SourceDebugExtension(value={"SMAP\nNgramExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NgramExtractor.kt\nai/grazie/detector/ngram/impl/NgramExtractor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class NgramExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Integer> gramLengths;
    @Nullable
    private final Character textPadding;
    public static final int MAX_NGRAM_LENGTH = 3;
    @NotNull
    private static final Lazy<NgramExtractor> standard$delegate = LazyKt.lazy(NgramExtractor::standard_delegate$lambda$2);

    public NgramExtractor(@NotNull List<Integer> gramLengths, @Nullable Character textPadding) {
        Intrinsics.checkNotNullParameter(gramLengths, (String)"gramLengths");
        this.gramLengths = gramLengths;
        this.textPadding = textPadding;
        if (!(!((Collection)this.gramLengths).isEmpty())) {
            boolean bl = false;
            String string = "GramLengths cannot be empty";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ NgramExtractor(List list, Character c, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            c = Character.valueOf(' ');
        }
        this(list, c);
    }

    @NotNull
    public final List<Integer> getGramLengths() {
        return this.gramLengths;
    }

    @NotNull
    public final List<String> extract(@NotNull CharSequence input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        CharSequence text2 = this.applyPadding(input);
        int len = text2.length();
        ArrayList<String> grams = new ArrayList<String>();
        Iterator<Integer> iterator = this.gramLengths.iterator();
        while (iterator.hasNext()) {
            int gramLength = ((Number)iterator.next()).intValue();
            int numGrams = len - (gramLength - 1);
            if (numGrams < 1) continue;
            for (int pos = 0; pos < numGrams; ++pos) {
                String gram = ((Object)text2.subSequence(pos, pos + gramLength)).toString();
                if (!StandardNgramFilter.INSTANCE.use(gram)) continue;
                grams.add(gram);
            }
        }
        return grams;
    }

    private final CharSequence applyPadding(CharSequence text2) {
        StringBuilder stringBuilder;
        if (this.textPadding == null || text2.length() == 0 || StringsKt.startsWith$default((CharSequence)text2, (char)this.textPadding.charValue(), (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)text2, (char)this.textPadding.charValue(), (boolean)false, (int)2, null)) {
            return text2;
        }
        StringBuilder $this$applyPadding_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!StringsKt.startsWith$default((CharSequence)text2, (char)this.textPadding.charValue(), (boolean)false, (int)2, null)) {
            $this$applyPadding_u24lambda_u241.append(this.textPadding.charValue());
        }
        $this$applyPadding_u24lambda_u241.append(text2);
        if (!StringsKt.endsWith$default((CharSequence)text2, (char)this.textPadding.charValue(), (boolean)false, (int)2, null)) {
            $this$applyPadding_u24lambda_u241.append(this.textPadding.charValue());
        }
        return stringBuilder.toString();
    }

    private static final NgramExtractor standard_delegate$lambda$2() {
        return new NgramExtractor(CollectionsKt.toList((Iterable)((Iterable)new IntRange(1, 3))), null, 2, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lai/grazie/detector/ngram/impl/NgramExtractor$Companion;", "", "<init>", "()V", "MAX_NGRAM_LENGTH", "", "standard", "Lai/grazie/detector/ngram/impl/NgramExtractor;", "getStandard", "()Lai/grazie/detector/ngram/impl/NgramExtractor;", "standard$delegate", "Lkotlin/Lazy;", "nlp-detect"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NgramExtractor getStandard() {
            Lazy lazy = standard$delegate;
            return (NgramExtractor)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

