/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CapturingCleanerInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher CLEANER_REGISTER = CallMatcher.instanceCall((String)"java.lang.ref.Cleaner", (String[])new String[]{"register"}).parameterCount(2);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CapturingCleanerInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel9OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                CapturingCleanerInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                String referenceName;
                PsiElement highlightingElement;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!CLEANER_REGISTER.test(call)) {
                    return;
                }
                PsiExpression[] expressions = call.getArgumentList().getExpressions();
                PsiExpression trackedObject = ExpressionUtils.resolveExpression((PsiExpression)expressions[0]);
                PsiExpression runnableExpression = ExpressionUtils.resolveExpression((PsiExpression)expressions[1]);
                if (trackedObject == null || runnableExpression == null) {
                    return;
                }
                if (trackedObject instanceof PsiThisExpression) {
                    PsiClassType classType = (PsiClassType)ObjectUtils.tryCast((Object)trackedObject.getType(), PsiClassType.class);
                    if (classType == null) {
                        return;
                    }
                    PsiClass trackedClass = classType.resolve();
                    if (trackedClass == null) {
                        return;
                    }
                    PsiElement elementCapturingThis = 1.getElementCapturingThis(runnableExpression, trackedClass);
                    if (elementCapturingThis == null) {
                        return;
                    }
                    highlightingElement = elementCapturingThis;
                    referenceName = "this";
                } else if (trackedObject instanceof PsiReferenceExpression) {
                    PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)trackedObject).resolve(), PsiVariable.class);
                    if (variable == null) {
                        return;
                    }
                    if (variable instanceof PsiField) {
                        return;
                    }
                    if (!VariableAccessUtils.variableIsUsed((PsiVariable)variable, (PsiElement)runnableExpression)) {
                        return;
                    }
                    Optional referenceExpression = StreamEx.ofTree((Object)runnableExpression, el -> StreamEx.of((Object[])el.getChildren())).findAny(el -> el instanceof PsiReferenceExpression && ((PsiReferenceExpression)el).isReferenceTo((PsiElement)variable));
                    if (referenceExpression.isEmpty()) {
                        return;
                    }
                    String variableName = variable.getName();
                    if (variableName == null) {
                        return;
                    }
                    highlightingElement = (PsiElement)referenceExpression.get();
                    referenceName = variableName;
                } else {
                    return;
                }
                holder.registerProblem(highlightingElement, JavaBundle.message((String)"inspection.capturing.cleaner", (Object[])new Object[]{referenceName}), new LocalQuickFix[0]);
            }

            @Nullable
            private static PsiElement getElementCapturingThis(@NotNull PsiExpression runnableExpr, @NotNull PsiClass trackedClass) {
                if (runnableExpr == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (trackedClass == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (runnableExpr instanceof PsiMethodReferenceExpression) {
                    PsiMethodReferenceExpression methodReference = (PsiMethodReferenceExpression)runnableExpr;
                    if (PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)methodReference)) {
                        return null;
                    }
                    PsiElement qualifier = methodReference.getQualifier();
                    if (qualifier instanceof PsiThisExpression) {
                        PsiClass thisClass = PsiUtil.resolveClassInType((PsiType)((PsiThisExpression)qualifier).getType());
                        if (thisClass != trackedClass) {
                            return null;
                        }
                        return qualifier;
                    }
                    return null;
                }
                if (runnableExpr instanceof PsiLambdaExpression) {
                    PsiLambdaExpression lambda = (PsiLambdaExpression)runnableExpr;
                    if (!lambda.getParameterList().isEmpty()) {
                        return null;
                    }
                    PsiElement lambdaBody = lambda.getBody();
                    if (lambdaBody == null) {
                        return null;
                    }
                    return CapturingCleanerInspection.getLambdaOrInnerClassElementCapturingThis(lambdaBody, trackedClass);
                }
                if (runnableExpr instanceof PsiNewExpression) {
                    PsiJavaCodeReferenceElement classReference;
                    PsiNewExpression newExpression = (PsiNewExpression)runnableExpr;
                    if (newExpression.getAnonymousClass() != null) {
                        if (PsiUtil.isAvailable((JavaFeature)JavaFeature.INNER_NOT_CAPTURE_THIS, (PsiElement)trackedClass)) {
                            PsiElement elementCapturingThis = CapturingCleanerInspection.getLambdaOrInnerClassElementCapturingThis((PsiElement)newExpression, trackedClass);
                            if (elementCapturingThis != null) {
                                return elementCapturingThis;
                            }
                        } else {
                            return newExpression;
                        }
                    }
                    if ((classReference = newExpression.getClassReference()) == null) {
                        return null;
                    }
                    PsiClass aClass = (PsiClass)ObjectUtils.tryCast((Object)classReference.resolve(), PsiClass.class);
                    if (aClass == null) {
                        return null;
                    }
                    if (aClass.getContainingClass() != trackedClass) {
                        return null;
                    }
                    if (aClass.hasModifierProperty("static")) {
                        return null;
                    }
                    if (PsiUtil.isAvailable((JavaFeature)JavaFeature.INNER_NOT_CAPTURE_THIS, (PsiElement)trackedClass) && CapturingCleanerInspection.getLambdaOrInnerClassElementCapturingThis((PsiElement)newExpression, trackedClass) == null) {
                        return null;
                    }
                    return classReference;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runnableExpr";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "trackedClass";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/CapturingCleanerInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getElementCapturingThis";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Contract(pure=true)
    @Nullable
    private static PsiElement getLambdaOrInnerClassElementCapturingThis(@NotNull PsiElement lambdaBody, @NotNull PsiClass containingClass) {
        if (lambdaBody == null) {
            CapturingCleanerInspection.$$$reportNull$$$0(2);
        }
        if (containingClass == null) {
            CapturingCleanerInspection.$$$reportNull$$$0(3);
        }
        return StreamEx.ofTree((Object)lambdaBody, el -> StreamEx.of((Object[])el.getChildren())).findAny(element -> CapturingCleanerInspection.isThisCapturingElement(containingClass, element)).orElse(null);
    }

    @Contract(pure=true)
    private static boolean isThisCapturingElement(@NotNull PsiClass containingClass, PsiElement element) {
        if (containingClass == null) {
            CapturingCleanerInspection.$$$reportNull$$$0(4);
        }
        if (element instanceof PsiThisExpression) {
            return PsiUtil.resolveClassInType((PsiType)((PsiThisExpression)element).getType()) == containingClass;
        }
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression qualifierReference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)((PsiReferenceExpression)element).getQualifierExpression(), PsiReferenceExpression.class);
            if (qualifierReference != null) {
                return false;
            }
            PsiMember member = (PsiMember)ObjectUtils.tryCast((Object)((PsiReferenceExpression)element).resolve(), PsiMember.class);
            return CapturingCleanerInspection.memberBringsThisRef(containingClass, member);
        }
        return false;
    }

    @Contract(value="_, null -> false", pure=true)
    private static boolean memberBringsThisRef(@NotNull PsiClass containingClass, PsiMember member) {
        if (containingClass == null) {
            CapturingCleanerInspection.$$$reportNull$$$0(5);
        }
        if (member == null) {
            return false;
        }
        PsiClass memberContainingClass = member.getContainingClass();
        if (memberContainingClass == null) {
            return false;
        }
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)memberContainingClass, (boolean)true) && !CapturingCleanerInspection.isInnerClassOf(containingClass, memberContainingClass)) {
            return false;
        }
        return !member.hasModifierProperty("static");
    }

    @Contract(value="_, null -> false", pure=true)
    private static boolean isInnerClassOf(@Nullable PsiClass inner, @Nullable PsiClass outer) {
        if (inner == null || inner.hasModifierProperty("static")) {
            return false;
        }
        return PsiTreeUtil.isAncestor((PsiElement)outer, (PsiElement)inner, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/CapturingCleanerInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaBody";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/CapturingCleanerInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaOrInnerClassElementCapturingThis";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isThisCapturingElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "memberBringsThisRef";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

