/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.impl.RemoveRedundantParameterTypesFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComparatorCombinatorsInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(ComparatorCombinatorsInspection.class);

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.LAMBDA_EXPRESSIONS);
        if (set == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitLambdaExpression(@NotNull PsiLambdaExpression lambda) {
                if (lambda == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitLambdaExpression(lambda);
                PsiType type = lambda.getFunctionalInterfaceType();
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)lambda.getParent());
                if (parent instanceof PsiTypeCastExpression && ((PsiTypeCastExpression)parent).getType() instanceof PsiIntersectionType) {
                    return;
                }
                PsiParameter[] parameters = lambda.getParameterList().getParameters();
                if (parameters.length != 2 || !PsiTypesUtil.classNameEquals((PsiType)type, (String)"java.util.Comparator")) {
                    return;
                }
                String replacementText = ComparatorCombinatorsInspection.generateSimpleCombinator(lambda, parameters[0], parameters[1]);
                if (replacementText != null) {
                    if (!LambdaUtil.isSafeLambdaReplacement((PsiLambdaExpression)lambda, (String)replacementText)) {
                        return;
                    }
                    String qualifiedName = Objects.requireNonNull(StringUtil.substringBefore((String)replacementText, (String)"("));
                    @NonNls String methodName = "Comparator." + StringUtil.getShortName((String)qualifiedName);
                    String problemMessage = InspectionGadgetsBundle.message((String)"inspection.comparator.combinators.description2", (Object[])new Object[]{methodName});
                    holder.registerProblem((PsiElement)lambda, problemMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceWithComparatorFix(CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{methodName}))});
                    return;
                }
                if (lambda.getBody() instanceof PsiCodeBlock) {
                    PsiStatement[] statements = ((PsiCodeBlock)lambda.getBody()).getStatements();
                    List<ComparisonBlock> blocks = ComparatorCombinatorsInspection.extractComparisonChain(statements, (PsiVariable)parameters[0], (PsiVariable)parameters[1]);
                    if (blocks == null) {
                        return;
                    }
                    String chainCombinator = ComparatorCombinatorsInspection.generateChainCombinator(blocks, (PsiVariable)parameters[0], (PsiVariable)parameters[1]);
                    if (chainCombinator == null) {
                        return;
                    }
                    if (!LambdaUtil.isSafeLambdaReplacement((PsiLambdaExpression)lambda, (String)chainCombinator)) {
                        return;
                    }
                    String problemMessage = InspectionGadgetsBundle.message((String)"inspection.comparator.combinators.description", (Object[])new Object[0]);
                    holder.registerProblem((PsiElement)lambda, problemMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceWithComparatorFix(InspectionGadgetsBundle.message((String)"inspection.comparator.combinators.fix.chain", (Object[])new Object[0]))});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambda", "com/intellij/codeInspection/ComparatorCombinatorsInspection$1", "visitLambdaExpression"));
            }
        };
    }

    @Nullable(value="when failed to extract")
    private static @Nullable(value="when failed to extract") List<ComparisonBlock> extractComparisonChain(PsiStatement @NotNull [] statements, @NotNull PsiVariable first, @NotNull PsiVariable second) {
        PsiStatement lastStmt;
        if (first == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(2);
        }
        if (second == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(3);
        }
        if (statements == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(4);
        }
        if (statements.length == 0) {
            return null;
        }
        ComparisonBlock firstBlock = ComparisonBlock.extractBlock(statements[0], first, second, null);
        if (firstBlock == null) {
            return null;
        }
        ArrayList<ComparisonBlock> blocks = new ArrayList<ComparisonBlock>();
        blocks.add(firstBlock);
        PsiVariable lastResult = firstBlock.getResult();
        int index = 1;
        while (index < statements.length - 1) {
            PsiStatement current = statements[index];
            if (ComparatorCombinatorsInspection.isNotZeroCheck(current, lastResult)) {
                int nextIndex = index + 1;
                if (nextIndex >= statements.length) {
                    return null;
                }
                PsiStatement next = statements[nextIndex];
                ComparisonBlock block = ComparisonBlock.extractBlock(next, first, second, lastResult);
                if (block == null) {
                    if (nextIndex == statements.length - 1) break;
                    return null;
                }
                blocks.add(block);
                index += 2;
                continue;
            }
            PsiStatement nextComparisonStmt = ComparatorCombinatorsInspection.extractZeroCheckedWay(current, lastResult);
            if (nextComparisonStmt != null) {
                ComparisonBlock block = ComparisonBlock.extractBlock(nextComparisonStmt, first, second, lastResult);
                if (block == null) {
                    return null;
                }
                blocks.add(block);
                if (block.getResult() != lastResult) {
                    lastResult = block.getResult();
                }
                ++index;
                continue;
            }
            return null;
        }
        if ((lastStmt = statements[statements.length - 1]) instanceof PsiReturnStatement) {
            PsiExpression returnExpr = ((PsiReturnStatement)lastStmt).getReturnValue();
            if (returnExpr == null) {
                return null;
            }
            if (ExpressionUtils.isReferenceTo((PsiExpression)returnExpr, (PsiVariable)lastResult)) {
                return blocks;
            }
            ComparisonBlock lastBlock = ComparatorCombinatorsInspection.extractTernaryComparison(first, second, lastResult, returnExpr);
            if (lastBlock == null) {
                lastBlock = ComparisonBlock.extractBlock(returnExpr, first, second, lastResult);
            }
            if (lastBlock == null) {
                return null;
            }
            blocks.add(lastBlock);
            return blocks;
        }
        return null;
    }

    @Nullable
    private static ComparisonBlock extractTernaryComparison(@NotNull PsiVariable first, @NotNull PsiVariable second, PsiVariable lastResult, PsiExpression returnExpr) {
        PsiConditionalExpression ternary;
        if (first == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(5);
        }
        if (second == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(6);
        }
        if ((ternary = (PsiConditionalExpression)ObjectUtils.tryCast((Object)returnExpr, PsiConditionalExpression.class)) == null) {
            return null;
        }
        PsiExpression elseExpression = ternary.getElseExpression();
        PsiExpression thenExpression = ternary.getThenExpression();
        if (elseExpression == null || thenExpression == null) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)ternary.getCondition(), PsiBinaryExpression.class);
        if (binOp == null) {
            return null;
        }
        PsiExpression finalResult = ExpressionUtils.getValueComparedWithZero((PsiBinaryExpression)binOp);
        boolean inverted = false;
        if (finalResult == null) {
            finalResult = ExpressionUtils.getValueComparedWithZero((PsiBinaryExpression)binOp, (IElementType)JavaTokenType.NE);
            inverted = true;
        }
        if (!ExpressionUtils.isReferenceTo((PsiExpression)finalResult, (PsiVariable)lastResult)) {
            return null;
        }
        if (!ExpressionUtils.isReferenceTo((PsiExpression)(inverted ? thenExpression : elseExpression), (PsiVariable)lastResult)) {
            return null;
        }
        PsiMethodCallExpression lastComparison = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)(inverted ? elseExpression : thenExpression), PsiMethodCallExpression.class);
        ComparisonBlock lastBlock = ComparisonBlock.extractBlock((PsiExpression)lastComparison, first, second, lastResult);
        if (lastBlock == null) {
            return null;
        }
        return lastBlock;
    }

    @Nullable
    private static PsiStatement extractZeroCheckedWay(@Nullable PsiStatement statement, @NotNull PsiVariable last) {
        PsiIfStatement ifStatement;
        if (last == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(7);
        }
        if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class)) == null || ifStatement.getElseBranch() != null) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)ifStatement.getCondition(), PsiBinaryExpression.class);
        if (binOp == null) {
            return null;
        }
        PsiExpression maybeResult = ExpressionUtils.getValueComparedWithZero((PsiBinaryExpression)binOp);
        if (!ExpressionUtils.isReferenceTo((PsiExpression)maybeResult, (PsiVariable)last)) {
            return null;
        }
        return ControlFlowUtils.stripBraces((PsiStatement)ifStatement.getThenBranch());
    }

    private static boolean isNotZeroCheck(@NotNull PsiStatement statement, @NotNull PsiVariable last) {
        PsiIfStatement ifStatement;
        if (statement == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(8);
        }
        if (last == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(9);
        }
        if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class)) == null || ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)ifStatement.getCondition(), PsiBinaryExpression.class);
        if (binaryExpression == null) {
            return false;
        }
        if (!ExpressionUtils.isReferenceTo((PsiExpression)ExpressionUtils.getValueComparedWithZero((PsiBinaryExpression)binaryExpression, (IElementType)JavaTokenType.NE), (PsiVariable)last)) {
            return false;
        }
        PsiStatement thenStmt = ControlFlowUtils.stripBraces((PsiStatement)ifStatement.getThenBranch());
        if (!(thenStmt instanceof PsiReturnStatement)) {
            return false;
        }
        return ExpressionUtils.isReferenceTo((PsiExpression)((PsiReturnStatement)thenStmt).getReturnValue(), (PsiVariable)last);
    }

    @NotNull
    private static String generateComparison(@NotNull String methodName, @Nullable PsiType type, @NotNull String varName, @NotNull PsiExpression expression, @NotNull PsiVariable exprVariable) {
        if (methodName == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(10);
        }
        if (varName == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(11);
        }
        if (expression == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(12);
        }
        if (exprVariable == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(13);
        }
        String lambdaExpr = ComparatorCombinatorsInspection.getExpressionReplacingReferences(expression, varName, exprVariable);
        String parameter = type == null ? varName : "(" + GenericsUtil.getVariableTypeByExpressionType((PsiType)type).getCanonicalText() + " " + varName + ")";
        String string = methodName + "(" + parameter + "->" + lambdaExpr + ")";
        if (string == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    private static String generateSimpleCombinator(PsiLambdaExpression lambda, PsiParameter leftVar, PsiParameter rightVar) {
        String text;
        PsiExpression left;
        PsiExpression body = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda.getBody()));
        String methodName = null;
        if (body instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)body;
            if (MethodCallUtils.isCompareToCall((PsiMethodCallExpression)methodCall)) {
                left = methodCall.getMethodExpression().getQualifierExpression();
                PsiExpression right = (PsiExpression)ArrayUtil.getFirstElement((Object[])methodCall.getArgumentList().getExpressions());
                if (ExpressionUtils.isReferenceTo((PsiExpression)left, (PsiVariable)leftVar) && ExpressionUtils.isReferenceTo((PsiExpression)right, (PsiVariable)rightVar)) {
                    methodName = "naturalOrder";
                } else if (ExpressionUtils.isReferenceTo((PsiExpression)right, (PsiVariable)leftVar) && ExpressionUtils.isReferenceTo((PsiExpression)left, (PsiVariable)rightVar)) {
                    methodName = "reverseOrder";
                } else if (ComparatorCombinatorsInspection.areEquivalent((PsiVariable)leftVar, left, (PsiVariable)rightVar, right)) {
                    methodName = "comparing";
                }
            } else {
                PrimitiveComparison comparison = PrimitiveComparison.from(methodCall);
                if (comparison == null) {
                    return null;
                }
                PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                if (!ComparatorCombinatorsInspection.areEquivalent((PsiVariable)leftVar, args[0], (PsiVariable)rightVar, args[1])) {
                    return null;
                }
                methodName = comparison.getMethodName();
                left = comparison.getKeyExtractor();
            }
        } else if (body instanceof PsiBinaryExpression) {
            PsiBinaryExpression binOp = (PsiBinaryExpression)body;
            if (!binOp.getOperationTokenType().equals(JavaTokenType.MINUS)) {
                return null;
            }
            left = binOp.getLOperand();
            PsiType type = left.getType();
            if (type == null) {
                return null;
            }
            if (ComparatorCombinatorsInspection.areEquivalent((PsiVariable)leftVar, left, (PsiVariable)rightVar, binOp.getROperand())) {
                methodName = ComparatorCombinatorsInspection.getComparingMethodName(type.getCanonicalText());
            }
        } else {
            return null;
        }
        if (methodName == null) {
            return null;
        }
        if (!methodName.startsWith("comparing")) {
            text = "java.util.Comparator." + methodName + "()";
        } else {
            String parameterName = leftVar.getName();
            PsiTypeElement typeElement = leftVar.getTypeElement();
            if (typeElement != null && PsiUtilCore.hasErrorElementChild((PsiElement)typeElement)) {
                return null;
            }
            String typeText = typeElement == null ? GenericsUtil.getVariableTypeByExpressionType((PsiType)leftVar.getType()).getCanonicalText() : typeElement.getText();
            String parameterDeclaration = "(" + typeText + " " + parameterName + ")";
            text = "java.util.Comparator." + methodName + "(" + parameterDeclaration + " -> " + left.getText() + ")";
        }
        return text;
    }

    @Nullable
    private static String generateChainCombinator(@NotNull List<ComparisonBlock> blocks, @NotNull PsiVariable firstVar, @NotNull PsiVariable secondVar) {
        if (blocks == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(15);
        }
        if (firstVar == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(16);
        }
        if (secondVar == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(17);
        }
        if (blocks.size() < 2) {
            return null;
        }
        ComparisonBlock first = blocks.getFirst();
        StringBuilder builder = new StringBuilder();
        PsiType type = secondVar.getType();
        String name = ComparatorCombinatorsInspection.suggestVarName(firstVar);
        if (name == null) {
            return null;
        }
        PsiExpression firstKey = first.getKey();
        String firstMethodName = ComparatorCombinatorsInspection.getComparingMethodName(firstKey.getType(), true);
        if (firstMethodName == null) {
            return null;
        }
        builder.append("java.util.Comparator").append(".").append(ComparatorCombinatorsInspection.generateComparison(firstMethodName, type, name, firstKey, secondVar));
        for (int i = 1; i < blocks.size(); ++i) {
            ComparisonBlock block = blocks.get(i);
            PsiExpression blockKey = block.getKey();
            String comparatorMethodName = ComparatorCombinatorsInspection.getComparingMethodName(blockKey.getType(), false);
            if (comparatorMethodName == null) {
                return null;
            }
            builder.append(".").append(ComparatorCombinatorsInspection.generateComparison(comparatorMethodName, null, name, blockKey, secondVar));
        }
        return builder.toString();
    }

    @Contract(value="null, _ -> null")
    @Nullable
    @NonNls
    private static String getComparingMethodName(@Nullable PsiType exprType, boolean first) {
        if (exprType == null) {
            return null;
        }
        String name = ComparatorCombinatorsInspection.getComparingMethodName(exprType.getCanonicalText(), first);
        if (name != null) {
            return name;
        }
        if (InheritanceUtil.isInheritor((PsiType)exprType, (String)"java.lang.Comparable")) {
            return first ? "comparing" : "thenComparing";
        }
        return null;
    }

    @Nullable
    private static String suggestVarName(@NotNull PsiVariable variable) {
        String[] names;
        if (variable == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(18);
        }
        String name = variable.getName();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)variable.getProject());
        SuggestedNameInfo nameCandidate = null;
        if (name != null) {
            if (name.length() > 1 && name.endsWith("1")) {
                nameCandidate = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, name.substring(0, name.length() - 1), null, variable.getType(), true);
            } else if (name.equals("first")) {
                nameCandidate = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, variable.getType(), true);
            }
        }
        if (nameCandidate != null && (names = codeStyleManager.suggestUniqueVariableName(nameCandidate, (PsiElement)variable, (boolean)true).names).length > 0) {
            return names[0];
        }
        return name;
    }

    private static String getExpressionReplacingReferences(@NotNull PsiExpression expression, @NotNull String varName, @NotNull PsiVariable exprVariable) {
        if (expression == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(19);
        }
        if (varName == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(20);
        }
        if (exprVariable == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(21);
        }
        PsiExpression copy = (PsiExpression)expression.copy();
        ReferencesSearch.search((PsiElement)exprVariable, (SearchScope)new LocalSearchScope((PsiElement)copy)).asIterable().forEach(reference -> {
            PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)reference.getElement(), PsiReferenceExpression.class);
            if (ref == null) {
                return;
            }
            ExpressionUtils.bindReferenceTo((PsiReferenceExpression)ref, (String)varName);
        });
        return copy.getText();
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    private static String getComparingMethodName(String type) {
        return ComparatorCombinatorsInspection.getComparingMethodName(type, true);
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    @NonNls
    private static String getComparingMethodName(String type, boolean first) {
        if (type == null) {
            return null;
        }
        return switch (PsiTypesUtil.unboxIfPossible((String)type)) {
            case "int", "short", "byte", "char" -> {
                if (first) {
                    yield "comparingInt";
                }
                yield "thenComparingInt";
            }
            case "long" -> {
                if (first) {
                    yield "comparingLong";
                }
                yield "thenComparingLong";
            }
            case "double" -> {
                if (first) {
                    yield "comparingDouble";
                }
                yield "thenComparingDouble";
            }
            default -> null;
        };
    }

    @Contract(value="_, null, _, _ -> false; _, !null, _, null -> false")
    private static boolean areEquivalent(PsiVariable leftVar, @Nullable PsiExpression left, PsiVariable rightVar, @Nullable PsiExpression right) {
        if (left == null || right == null) {
            return false;
        }
        if (VariableAccessUtils.variableIsUsed((PsiVariable)rightVar, (PsiElement)left) || VariableAccessUtils.variableIsUsed((PsiVariable)leftVar, (PsiElement)right)) {
            return false;
        }
        PsiExpression copy = (PsiExpression)right.copy();
        PsiElement[] rightRefs = PsiTreeUtil.collectElements((PsiElement)copy, e -> e instanceof PsiReferenceExpression && ((PsiReferenceExpression)e).resolve() == rightVar);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)left.getProject());
        String paramName = leftVar.getName();
        if (paramName == null) {
            return false;
        }
        for (PsiElement ref : rightRefs) {
            PsiElement nameElement = ((PsiReferenceExpression)ref).getReferenceNameElement();
            LOG.assertTrue(nameElement != null);
            nameElement.replace((PsiElement)factory.createIdentifier(paramName));
        }
        return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(left, copy);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ComparatorCombinatorsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprVariable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocks";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstVar";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondVar";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ComparatorCombinatorsInspection";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generateComparison";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractComparisonChain";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractTernaryComparison";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractZeroCheckedWay";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isNotZeroCheck";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateComparison";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generateChainCombinator";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "suggestVarName";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionReplacingReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21 -> new IllegalArgumentException(string);
        };
    }

    private static final class ComparisonBlock {
        private final PsiExpression myKey;
        private final PsiVariable myResult;

        private ComparisonBlock(PsiExpression key, PsiVariable result) {
            this.myKey = key;
            this.myResult = result;
        }

        public PsiExpression getKey() {
            return this.myKey;
        }

        public PsiVariable getResult() {
            return this.myResult;
        }

        @Nullable
        static ComparisonBlock extractBlock(@NotNull PsiStatement statement, @NotNull PsiVariable firstParam, @NotNull PsiVariable secondParam, @Nullable PsiVariable previousResult) {
            if (statement == null) {
                ComparisonBlock.$$$reportNull$$$0(0);
            }
            if (firstParam == null) {
                ComparisonBlock.$$$reportNull$$$0(1);
            }
            if (secondParam == null) {
                ComparisonBlock.$$$reportNull$$$0(2);
            }
            if (statement instanceof PsiDeclarationStatement) {
                PsiDeclarationStatement declaration = (PsiDeclarationStatement)statement;
                PsiElement[] elements = declaration.getDeclaredElements();
                if (elements.length == 0) {
                    return null;
                }
                PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)elements[0], PsiLocalVariable.class);
                if (variable == null) {
                    return null;
                }
                PsiExpression initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer());
                return ComparisonBlock.extractBlock(initializer, firstParam, secondParam, (PsiVariable)variable);
            }
            if (previousResult != null && statement instanceof PsiExpressionStatement) {
                PsiExpression expr = ExpressionUtils.getAssignmentTo((PsiElement)((PsiExpressionStatement)statement).getExpression(), (PsiVariable)previousResult);
                return ComparisonBlock.extractBlock(expr, firstParam, secondParam, previousResult);
            }
            return null;
        }

        @Contract(value="null, _, _, _ -> null")
        @Nullable
        private static ComparisonBlock extractBlock(@Nullable PsiExpression expr, @NotNull PsiVariable firstParam, @NotNull PsiVariable secondParam, @NotNull PsiVariable variable) {
            if (firstParam == null) {
                ComparisonBlock.$$$reportNull$$$0(3);
            }
            if (secondParam == null) {
                ComparisonBlock.$$$reportNull$$$0(4);
            }
            if (variable == null) {
                ComparisonBlock.$$$reportNull$$$0(5);
            }
            PsiExpression first = null;
            PsiExpression second = null;
            if (expr instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)expr;
                PsiExpression[] parameters = call.getArgumentList().getExpressions();
                if (PrimitiveComparison.from(call) != null) {
                    first = parameters[0];
                    second = parameters[1];
                } else if (MethodCallUtils.isCompareToCall((PsiMethodCallExpression)call)) {
                    first = call.getMethodExpression().getQualifierExpression();
                    second = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions());
                }
            } else if (expr instanceof PsiBinaryExpression) {
                PsiBinaryExpression binOp = (PsiBinaryExpression)expr;
                if (binOp.getOperationTokenType() != JavaTokenType.MINUS) {
                    return null;
                }
                first = binOp.getLOperand();
                if (ComparatorCombinatorsInspection.getComparingMethodName(first.getType(), true) == null) {
                    return null;
                }
                second = binOp.getROperand();
            }
            if (first == null || second == null) {
                return null;
            }
            if (!ComparisonBlock.usagesAreAllowed(firstParam, secondParam, first, second)) {
                return null;
            }
            if (!ComparisonBlock.keyAccessEquivalent(firstParam, secondParam, first, second)) {
                return null;
            }
            return new ComparisonBlock(second, variable);
        }

        private static boolean keyAccessEquivalent(@NotNull PsiVariable firstParam, @NotNull PsiVariable secondParam, PsiExpression first, PsiExpression second) {
            String secondParamName;
            if (firstParam == null) {
                ComparisonBlock.$$$reportNull$$$0(6);
            }
            if (secondParam == null) {
                ComparisonBlock.$$$reportNull$$$0(7);
            }
            if ((secondParamName = secondParam.getName()) == null) {
                return false;
            }
            return ComparatorCombinatorsInspection.areEquivalent(firstParam, first, secondParam, second);
        }

        private static boolean usagesAreAllowed(@NotNull PsiVariable firstParam, @NotNull PsiVariable secondParam, @Nullable PsiExpression firstExpr, @Nullable PsiExpression secondExpr) {
            if (firstParam == null) {
                ComparisonBlock.$$$reportNull$$$0(8);
            }
            if (secondParam == null) {
                ComparisonBlock.$$$reportNull$$$0(9);
            }
            return VariableAccessUtils.variableIsUsed((PsiVariable)firstParam, (PsiElement)firstExpr) && VariableAccessUtils.variableIsUsed((PsiVariable)secondParam, (PsiElement)secondExpr) && !VariableAccessUtils.variableIsUsed((PsiVariable)firstParam, (PsiElement)secondExpr) && !VariableAccessUtils.variableIsUsed((PsiVariable)secondParam, (PsiElement)firstExpr);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstParam";
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "secondParam";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/ComparatorCombinatorsInspection$ComparisonBlock";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extractBlock";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "keyAccessEquivalent";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "usagesAreAllowed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class PrimitiveComparison {
        @NotNull
        private final PsiExpression myKeyExtractor;
        @NotNull
        private final String myMethodName;

        private PrimitiveComparison(@NotNull PsiExpression extractor, @NotNull String name) {
            if (extractor == null) {
                PrimitiveComparison.$$$reportNull$$$0(0);
            }
            if (name == null) {
                PrimitiveComparison.$$$reportNull$$$0(1);
            }
            this.myKeyExtractor = extractor;
            this.myMethodName = name;
        }

        @NotNull
        public PsiExpression getKeyExtractor() {
            PsiExpression psiExpression = this.myKeyExtractor;
            if (psiExpression == null) {
                PrimitiveComparison.$$$reportNull$$$0(2);
            }
            return psiExpression;
        }

        @NotNull
        public String getMethodName() {
            String string = this.myMethodName;
            if (string == null) {
                PrimitiveComparison.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        private static PrimitiveComparison from(PsiMethodCallExpression methodCall) {
            String className;
            PsiClass containingClass;
            PsiMethod method = methodCall.resolveMethod();
            if (method != null && method.getName().equals("compare") && (containingClass = method.getContainingClass()) != null && (className = containingClass.getQualifiedName()) != null) {
                PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                if (args.length != 2) {
                    return null;
                }
                PsiExpression keyExtractor = args[0];
                String methodName = ComparatorCombinatorsInspection.getComparingMethodName(className);
                if (methodName == null) {
                    return null;
                }
                return new PrimitiveComparison(keyExtractor, methodName);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ComparatorCombinatorsInspection$PrimitiveComparison";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ComparatorCombinatorsInspection$PrimitiveComparison";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyExtractor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethodName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    static class ReplaceWithComparatorFix
    extends PsiUpdateModCommandQuickFix {
        @Nls
        private final String myMessage;

        ReplaceWithComparatorFix(@Nls String message) {
            this.myMessage = message;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myMessage;
            if (string == null) {
                ReplaceWithComparatorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message((String)"replace.with.comparator.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithComparatorFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiStatement[] statements;
            boolean keepParameterTypes;
            if (project == null) {
                ReplaceWithComparatorFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceWithComparatorFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceWithComparatorFix.$$$reportNull$$$0(4);
            }
            if (!(element instanceof PsiLambdaExpression)) {
                return;
            }
            PsiLambdaExpression lambda = (PsiLambdaExpression)element;
            PsiParameter[] parameters = lambda.getParameterList().getParameters();
            if (parameters.length != 2) {
                return;
            }
            boolean bl = keepParameterTypes = parameters[0].getTypeElement() != null;
            if (lambda.getBody() instanceof PsiCodeBlock && (statements = ((PsiCodeBlock)lambda.getBody()).getStatements()).length > 1) {
                List<ComparisonBlock> chain = ComparatorCombinatorsInspection.extractComparisonChain(statements, (PsiVariable)parameters[0], (PsiVariable)parameters[1]);
                if (chain == null) {
                    return;
                }
                String code = ComparatorCombinatorsInspection.generateChainCombinator(chain, (PsiVariable)parameters[0], (PsiVariable)parameters[1]);
                if (code == null) {
                    return;
                }
                PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)lambda, code);
                RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments((PsiElement)result);
                LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result);
                CodeStyleManager.getInstance((Project)project).reformat(JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result));
                return;
            }
            String text = ComparatorCombinatorsInspection.generateSimpleCombinator(lambda, parameters[0], parameters[1]);
            if (text == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression replacement = factory.createExpressionFromText(text, element);
            PsiMethodCallExpression result = (PsiMethodCallExpression)lambda.replace((PsiElement)replacement);
            ReplaceWithComparatorFix.normalizeLambda((PsiExpression)ArrayUtil.getFirstElement((Object[])result.getArgumentList().getExpressions()), factory, keepParameterTypes);
            CodeStyleManager.getInstance((Project)project).reformat(JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)result));
        }

        private static void normalizeLambda(PsiExpression expression, PsiElementFactory factory, boolean keepParameterTypes) {
            if (!(expression instanceof PsiLambdaExpression)) {
                return;
            }
            PsiLambdaExpression lambda = (PsiLambdaExpression)expression;
            PsiParameter[] parameters = lambda.getParameterList().getParameters();
            PsiElement body = lambda.getBody();
            if (body == null) {
                return;
            }
            if (LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference((PsiLambdaExpression)lambda) == lambda) {
                PsiParameter parameter = parameters[0];
                String name = ComparatorCombinatorsInspection.suggestVarName((PsiVariable)parameter);
                if (name != null) {
                    Collection references = PsiTreeUtil.collectElementsOfType((PsiElement)body, (Class[])new Class[]{PsiReferenceExpression.class});
                    ((StreamEx)StreamEx.of((Collection)references).filter(ref -> ref.isReferenceTo((PsiElement)parameter))).map(PsiJavaCodeReferenceElement::getReferenceNameElement).nonNull().forEach(nameElement -> nameElement.replace((PsiElement)factory.createIdentifier(name)));
                    parameter.setName(name);
                }
                if (!keepParameterTypes) {
                    RemoveRedundantParameterTypesFix.removeLambdaParameterTypesIfPossible((PsiLambdaExpression)lambda);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ComparatorCombinatorsInspection$ReplaceWithComparatorFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ComparatorCombinatorsInspection$ReplaceWithComparatorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

