/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RedundantStreamOptionalCallInspection;
import com.intellij.java.JavaBundle;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class MappingBeforeCountInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher STREAM_COUNT = CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"count"}).parameterCount(0);
    private static final CallMatcher MAPPING_CALL = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"map", "mapToInt", "mapToLong", "mapToDouble", "mapToObj", "peek"}).parameterCount(1), CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"boxed", "asLongStream", "asDoubleStream"}).parameterCount(0)});

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.STREAM_OPTIONAL);
        if (set == null) {
            MappingBeforeCountInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            MappingBeforeCountInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!STREAM_COUNT.test(call)) {
                    return;
                }
                PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
                if (!MAPPING_CALL.test(qualifierCall)) {
                    return;
                }
                PsiReferenceExpression ref = qualifierCall.getMethodExpression();
                PsiElement anchor = Objects.requireNonNull(ref.getReferenceNameElement());
                String name = Objects.requireNonNull(ref.getReferenceName());
                holder.registerProblem(anchor, JavaBundle.message((String)"inspection.mapping.before.count.message", (Object[])new Object[]{name}), new LocalQuickFix[]{new RedundantStreamOptionalCallInspection.RemoveCallFix(name)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/MappingBeforeCountInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/MappingBeforeCountInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/MappingBeforeCountInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

