/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.IndexedContainer;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class SequencedCollectionMethodCanBeUsedInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher LIST_GET_REMOVE = CallMatcher.instanceCall((String)"java.util.List", (String[])new String[]{"get", "remove"}).parameterTypes(new String[]{"int"});
    private static final CallMatcher LIST_ADD = CallMatcher.instanceCall((String)"java.util.List", (String[])new String[]{"add"}).parameterTypes(new String[]{"int", "E"});
    private static final CallMatcher ITERATOR_NEXT = CallMatcher.instanceCall((String)"java.util.Iterator", (String[])new String[]{"next"}).parameterCount(0);
    private static final CallMatcher COLLECTION_ITERATOR = CallMatcher.instanceCall((String)"java.util.Collection", (String[])new String[]{"iterator"}).parameterCount(0);
    public boolean m_ignoreExpressionsContainingConstants = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignoreExpressionsContainingConstants", (String)InspectionGadgetsBundle.message((String)"sequenced.collection.method.can.be.used.ignore.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            SequencedCollectionMethodCanBeUsedInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.SEQUENCED_COLLECTIONS);
        if (set == null) {
            SequencedCollectionMethodCanBeUsedInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SequencedCollectionMethodCanBeUsedInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (LIST_GET_REMOVE.matches((PsiExpression)call)) {
                    this.processListGetRemove(call);
                }
                if (LIST_ADD.matches((PsiExpression)call)) {
                    this.processListAdd(call);
                }
                if (ITERATOR_NEXT.matches((PsiExpression)call)) {
                    this.processIteratorNext(call);
                }
            }

            private void processIteratorNext(@NotNull PsiMethodCallExpression call) {
                PsiMethodCallExpression qualifierCall;
                if (call == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!COLLECTION_ITERATOR.matches((PsiExpression)(qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call)))) {
                    return;
                }
                PsiExpression collection = qualifierCall.getMethodExpression().getQualifierExpression();
                if (collection == null || collection instanceof PsiThisExpression) {
                    return;
                }
                if (!InheritanceUtil.isInheritor((PsiType)collection.getType(), (String)"java.util.SequencedCollection")) {
                    return;
                }
                String name = "getFirst";
                this.report(call, name);
            }

            private void report(@NotNull PsiMethodCallExpression call, String name) {
                if (call == null) {
                    1.$$$reportNull$$$0(2);
                }
                holder.registerProblem(Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement()), JavaBundle.message((String)"inspection.stream.api.migration.can.be.replaced.with.call", (Object[])new Object[]{name + "()"}), new LocalQuickFix[]{new ReplaceWithCallFix(name)});
            }

            private void processListAdd(@NotNull PsiMethodCallExpression call) {
                PsiReferenceExpression methodExpr;
                PsiExpression list;
                if (call == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((list = PsiUtil.skipParenthesizedExprDown((PsiExpression)(methodExpr = call.getMethodExpression()).getQualifierExpression())) == null || list instanceof PsiThisExpression) {
                    return;
                }
                PsiExpression arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]);
                if (SequencedCollectionMethodCanBeUsedInspection.this.m_ignoreExpressionsContainingConstants && 1.isArgConstant(arg)) {
                    return;
                }
                if (ExpressionUtils.isZero((PsiExpression)arg) && !1.hasDifferentIndexNearby(call)) {
                    this.report(call, "addFirst");
                }
            }

            private static boolean hasDifferentIndexNearby(@NotNull PsiMethodCallExpression call) {
                PsiMethod method;
                if (call == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((method = call.resolveMethod()) == null) {
                    return false;
                }
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                if (qualifier == null) {
                    return false;
                }
                PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)call, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class, PsiMember.class});
                if (block == null) {
                    return false;
                }
                Object[] statements = block.getStatements();
                int index = (int)StreamEx.of((Object[])statements).indexOf(s -> PsiTreeUtil.isAncestor((PsiElement)s, (PsiElement)call, (boolean)true)).orElse(-1L);
                if (index == -1) {
                    return false;
                }
                for (int i = Math.max(0, index - 2); i <= Math.min(statements.length - 1, index + 2); ++i) {
                    Integer otherIndex = (Integer)SyntaxTraverser.psiTraverser((PsiElement)statements[i]).filter(PsiMethodCallExpression.class).filter(c -> c != call).filter(c -> method.isEquivalentTo((PsiElement)c.resolveMethod()) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(qualifier, c.getMethodExpression().getQualifierExpression())).map(c -> PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)ArrayUtil.getFirstElement((Object[])c.getArgumentList().getExpressions())))).filter(PsiLiteralValue.class).map(PsiLiteralValue::getValue).filter(Integer.class).find(idx -> idx > 0 && idx < 10);
                    if (otherIndex == null) continue;
                    return true;
                }
                return false;
            }

            private static boolean isArgConstant(PsiExpression arg) {
                PsiField field;
                PsiReferenceExpression referenceExpr;
                PsiElement resolvedArg;
                return arg instanceof PsiReferenceExpression && (resolvedArg = (referenceExpr = (PsiReferenceExpression)arg).resolve()) instanceof PsiField && ExpressionUtils.isConstant((PsiField)(field = (PsiField)resolvedArg));
            }

            private void processListGetRemove(@NotNull PsiMethodCallExpression call) {
                IndexedContainer container;
                PsiBinaryExpression binOp;
                if (call == null) {
                    1.$$$reportNull$$$0(5);
                }
                PsiReferenceExpression methodExpr = call.getMethodExpression();
                String name = methodExpr.getReferenceName();
                PsiExpression list = PsiUtil.skipParenthesizedExprDown((PsiExpression)methodExpr.getQualifierExpression());
                if (list == null || list instanceof PsiThisExpression) {
                    return;
                }
                PsiExpression arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]);
                if (SequencedCollectionMethodCanBeUsedInspection.this.m_ignoreExpressionsContainingConstants && 1.isArgConstant(arg)) {
                    return;
                }
                if (ExpressionUtils.isZero((PsiExpression)arg) && !1.hasDifferentIndexNearby(call)) {
                    this.report(call, name + "First");
                }
                if (arg instanceof PsiBinaryExpression && (binOp = (PsiBinaryExpression)arg).getOperationTokenType().equals(JavaTokenType.MINUS) && ExpressionUtils.isOne((PsiExpression)binOp.getROperand()) && (container = IndexedContainer.fromLengthExpression((PsiExpression)binOp.getLOperand())) != null && container.isQualifierEquivalent(list)) {
                    this.report(call, name + "Last");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "call";
                objectArray2[1] = "com/intellij/codeInspection/SequencedCollectionMethodCanBeUsedInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processIteratorNext";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "report";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processListAdd";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "hasDifferentIndexNearby";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processListGetRemove";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SequencedCollectionMethodCanBeUsedInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SequencedCollectionMethodCanBeUsedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static class ReplaceWithCallFix
    extends PsiUpdateModCommandQuickFix {
        private final String myName;

        private ReplaceWithCallFix(String methodName) {
            this.myName = methodName;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myName + "()"});
            if (string == null) {
                ReplaceWithCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"intention.sequenced.collection.can.be.used.fix.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithCallFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiExpression collection;
            PsiMethodCallExpression call;
            if (project == null) {
                ReplaceWithCallFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceWithCallFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceWithCallFix.$$$reportNull$$$0(4);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class)) == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            PsiExpression[] expressions = call.getArgumentList().getExpressions();
            if (expressions.length > 0) {
                ct.delete((PsiElement)expressions[0]);
            }
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)call, (String)this.myName);
            PsiMethodCallExpression qualifier = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
            if (qualifier != null && InheritanceUtil.isInheritor((PsiType)qualifier.getType(), (String)"java.util.Iterator") && (collection = qualifier.getMethodExpression().getQualifierExpression()) != null) {
                ct.replace((PsiElement)qualifier, (PsiElement)collection);
            }
            ct.insertCommentsBefore((PsiElement)call);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SequencedCollectionMethodCanBeUsedInspection$ReplaceWithCallFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SequencedCollectionMethodCanBeUsedInspection$ReplaceWithCallFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

