/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class IterableUsedAsVarargInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.VARARGS);
        if (set == null) {
            IterableUsedAsVarargInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            IterableUsedAsVarargInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                PsiMethod newMethod;
                PsiType substitutionWithArray;
                PsiExpressionList argList;
                int argCount;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((argCount = (argList = call.getArgumentList()).getExpressionCount()) < 2) {
                    return;
                }
                JavaResolveResult result = call.getMethodExpression().advancedResolve(false);
                PsiMethod method = (PsiMethod)result.getElement();
                if (method == null || !method.isVarArgs()) {
                    return;
                }
                PsiParameterList paramList = method.getParameterList();
                if (paramList.getParametersCount() != argCount) {
                    return;
                }
                PsiParameter varArgParam = paramList.getParameters()[argCount - 1];
                PsiEllipsisType type = (PsiEllipsisType)ObjectUtils.tryCast((Object)varArgParam.getType(), PsiEllipsisType.class);
                if (type == null) {
                    return;
                }
                PsiTypeParameter componentType = (PsiTypeParameter)ObjectUtils.tryCast((Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)type.getComponentType()), PsiTypeParameter.class);
                if (componentType == null || componentType.getOwner() != method) {
                    return;
                }
                PsiSubstitutor substitutor = result.getSubstitutor();
                if (!TypeUtils.isJavaLangObject((PsiType)substitutor.substitute(componentType))) {
                    return;
                }
                PsiExpression[] args = argList.getExpressions();
                PsiExpression varArgExpression = args[argCount - 1];
                PsiType elementType = PsiUtil.substituteTypeParameter((PsiType)varArgExpression.getType(), (String)"java.lang.Iterable", (int)0, (boolean)false);
                if (elementType == null || TypeUtils.isJavaLangObject((PsiType)elementType)) {
                    return;
                }
                PsiClass elementClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)GenericsUtil.getVariableTypeByExpressionType((PsiType)elementType));
                if (elementClass == null) {
                    return;
                }
                PsiMethodCallExpression callCopy = (PsiMethodCallExpression)call.copy();
                if (callCopy == null) {
                    return;
                }
                PsiExpression argCopy = (PsiExpression)ArrayUtil.getLastElement((Object[])callCopy.getArgumentList().getExpressions());
                if (argCopy == null) {
                    return;
                }
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)holder.getProject());
                String className = elementClass.getQualifiedName();
                if (className == null && (className = elementClass.getName()) == null) {
                    return;
                }
                String replacement = "new " + className + "[0]";
                argCopy.replace((PsiElement)factory.createExpressionFromText(replacement, (PsiElement)argCopy));
                JavaResolveResult copyResult = callCopy.getMethodExpression().advancedResolve(false);
                if (copyResult.getElement() == method ? (substitutionWithArray = copyResult.getSubstitutor().substitute(componentType)) == null || TypeUtils.isJavaLangObject((PsiType)substitutionWithArray) : (newMethod = (PsiMethod)copyResult.getElement()) == null || !newMethod.isVarArgs() || newMethod.getParameterList().getParametersCount() != argCount) {
                    return;
                }
                AddToArrayFix fix = null;
                if (InheritanceUtil.isInheritor((PsiType)varArgExpression.getType(), (String)"java.util.Collection")) {
                    fix = new AddToArrayFix(className);
                }
                holder.registerProblem((PsiElement)varArgExpression, JavaBundle.message((String)"inspection.collection.used.as.vararg.message", (Object[])new Object[0]), new LocalQuickFix[]{fix});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/miscGenerics/IterableUsedAsVarargInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/miscGenerics/IterableUsedAsVarargInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/miscGenerics/IterableUsedAsVarargInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class AddToArrayFix
    extends PsiUpdateModCommandQuickFix {
        private final String myClassName;

        AddToArrayFix(String className) {
            this.myClassName = className;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.call", (Object[])new Object[]{"toArray(new " + StringUtil.getShortName((String)this.myClassName) + "[0])"});
            if (string == null) {
                AddToArrayFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiExpression expression;
            if (project == null) {
                AddToArrayFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                AddToArrayFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                AddToArrayFix.$$$reportNull$$$0(3);
            }
            if ((expression = (PsiExpression)ObjectUtils.tryCast((Object)element, PsiExpression.class)) == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiType)expression.getType(), (String)"java.util.Collection")) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            String fullReplacementText = ParenthesesUtils.getText((PsiExpression)expression, (int)2) + ".toArray(new " + this.myClassName + "[0])";
            expression.replace((PsiElement)factory.createExpressionFromText(fullReplacementText, (PsiElement)expression));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/miscGenerics/IterableUsedAsVarargInspection$AddToArrayFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/miscGenerics/IterableUsedAsVarargInspection$AddToArrayFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

