/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.intention.impl.StreamRefactoringUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.CollectMigration;
import com.intellij.codeInspection.streamMigration.CountMigration;
import com.intellij.codeInspection.streamMigration.FindExtremumMigration;
import com.intellij.codeInspection.streamMigration.FindFirstMigration;
import com.intellij.codeInspection.streamMigration.ForEachMigration;
import com.intellij.codeInspection.streamMigration.JoiningMigration;
import com.intellij.codeInspection.streamMigration.MatchMigration;
import com.intellij.codeInspection.streamMigration.MigrateToStreamFix;
import com.intellij.codeInspection.streamMigration.OperationReductionMigration;
import com.intellij.codeInspection.streamMigration.SumMigration;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.codeInspection.streamMigration.ToArrayMigration;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StreamApiMigrationInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(StreamApiMigrationInspection.class);
    public boolean REPLACE_TRIVIAL_FOREACH;
    public boolean SUGGEST_FOREACH;
    private static final String SHORT_NAME = "Convert2streamapi";

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"SUGGEST_FOREACH", (String)JavaBundle.message((String)"checkbox.warn.if.only.foreach.replacement.is.available", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"REPLACE_TRIVIAL_FOREACH", (String)JavaBundle.message((String)"checkbox.warn.if.the.loop.is.trivial", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            StreamApiMigrationInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.language.level.specific.issues.and.migration.aids", (Object[])new Object[0]);
        if (string == null) {
            StreamApiMigrationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.STREAM_OPTIONAL);
        if (set == null) {
            StreamApiMigrationInspection.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            StreamApiMigrationInspection.$$$reportNull$$$0(3);
        }
        return new StreamApiMigrationVisitor(holder, isOnTheFly);
    }

    @Contract(value="null, null -> true; null, !null -> false")
    private static boolean sameReference(PsiExpression expr1, PsiExpression expr2) {
        PsiReferenceExpression ref1;
        block5: {
            block4: {
                if (expr1 == null && expr2 == null) {
                    return true;
                }
                if (!(expr1 instanceof PsiReferenceExpression)) break block4;
                ref1 = (PsiReferenceExpression)expr1;
                if (expr2 instanceof PsiReferenceExpression) break block5;
            }
            return false;
        }
        PsiReferenceExpression ref2 = (PsiReferenceExpression)expr2;
        return Objects.equals(ref1.getReferenceName(), ref2.getReferenceName()) && StreamApiMigrationInspection.sameReference(ref1.getQualifierExpression(), ref2.getQualifierExpression());
    }

    @Nullable
    static PsiExpression extractAddend(PsiAssignmentExpression assignment) {
        return StreamApiMigrationInspection.extractOperand(assignment, JavaTokenType.PLUSEQ);
    }

    @Nullable
    static PsiExpression extractOperand(PsiAssignmentExpression assignment, IElementType compoundAssignmentOp) {
        PsiExpression psiExpression;
        if (compoundAssignmentOp.equals(assignment.getOperationTokenType())) {
            return assignment.getRExpression();
        }
        if (JavaTokenType.EQ.equals(assignment.getOperationTokenType()) && (psiExpression = assignment.getRExpression()) instanceof PsiBinaryExpression) {
            PsiBinaryExpression binOp = (PsiBinaryExpression)psiExpression;
            IElementType op = TypeConversionUtil.convertEQtoOperation((IElementType)compoundAssignmentOp);
            if (op.equals(binOp.getOperationTokenType())) {
                if (StreamApiMigrationInspection.sameReference(binOp.getLOperand(), assignment.getLExpression())) {
                    return binOp.getROperand();
                }
                if (StreamApiMigrationInspection.sameReference(binOp.getROperand(), assignment.getLExpression())) {
                    return binOp.getLOperand();
                }
            }
        }
        return null;
    }

    @Nullable
    static PsiVariable extractSumAccumulator(PsiAssignmentExpression assignment) {
        return StreamApiMigrationInspection.extractAccumulator(assignment, JavaTokenType.PLUSEQ);
    }

    @Nullable
    static PsiVariable extractAccumulator(PsiAssignmentExpression assignment, IElementType compoundAssignmentOp) {
        PsiExpression psiExpression;
        PsiReferenceExpression lExpr = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
        if (lExpr == null) {
            return null;
        }
        PsiVariable var = (PsiVariable)ObjectUtils.tryCast((Object)lExpr.resolve(), PsiVariable.class);
        if (var == null) {
            return null;
        }
        if (compoundAssignmentOp.equals(assignment.getOperationTokenType())) {
            return var;
        }
        if (JavaTokenType.EQ.equals(assignment.getOperationTokenType()) && (psiExpression = assignment.getRExpression()) instanceof PsiBinaryExpression) {
            PsiBinaryExpression binOp = (PsiBinaryExpression)psiExpression;
            IElementType op = TypeConversionUtil.convertEQtoOperation((IElementType)compoundAssignmentOp);
            if (op.equals(binOp.getOperationTokenType())) {
                PsiExpression left = binOp.getLOperand();
                PsiExpression right = binOp.getROperand();
                if (StreamApiMigrationInspection.sameReference(left, (PsiExpression)lExpr) || StreamApiMigrationInspection.sameReference(right, (PsiExpression)lExpr)) {
                    return var;
                }
            }
        }
        return null;
    }

    @Contract(value="null -> null")
    static PsiExpression extractIncrementedLValue(PsiExpression expression) {
        PsiAssignmentExpression assignment;
        if (expression instanceof PsiUnaryExpression) {
            if (JavaTokenType.PLUSPLUS.equals(((PsiUnaryExpression)expression).getOperationTokenType())) {
                return ((PsiUnaryExpression)expression).getOperand();
            }
        } else if (expression instanceof PsiAssignmentExpression && ExpressionUtils.isLiteral((PsiElement)StreamApiMigrationInspection.extractAddend(assignment = (PsiAssignmentExpression)expression), (Object)1)) {
            return assignment.getLExpression();
        }
        return null;
    }

    @Nullable
    private static PsiLocalVariable getIncrementedVariable(PsiExpression expression, TerminalBlock tb, List<PsiVariable> variables) {
        if (variables.size() != 1) {
            return null;
        }
        PsiReferenceExpression operand = (PsiReferenceExpression)ObjectUtils.tryCast((Object)StreamApiMigrationInspection.extractIncrementedLValue(expression), PsiReferenceExpression.class);
        if (operand == null) {
            return null;
        }
        PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)operand.resolve(), PsiLocalVariable.class);
        if (variable != null && variables.contains(variable) && !tb.isReferencedInOperations((PsiVariable)variable)) {
            return variable;
        }
        return null;
    }

    @Nullable
    private static PsiVariable getAccumulatedVariable(TerminalBlock tb, List<PsiVariable> variables, OperationReductionMigration.ReductionOperation operation) {
        IElementType compoundAssignmentOp = operation.getCompoundAssignmentOp();
        if (variables.size() != 1) {
            return null;
        }
        PsiAssignmentExpression assignment = tb.getSingleExpression(PsiAssignmentExpression.class);
        if (assignment == null) {
            return null;
        }
        PsiVariable var = StreamApiMigrationInspection.extractAccumulator(assignment, compoundAssignmentOp);
        if (var == null || !variables.contains(var)) {
            return null;
        }
        if (!operation.getAccumulatorRestriction().test((PsiVariable)var)) {
            return null;
        }
        if (tb.isReferencedInOperations(var)) {
            return null;
        }
        PsiExpression operand = StreamApiMigrationInspection.extractOperand(assignment, compoundAssignmentOp);
        LOG.assertTrue(operand != null);
        if (VariableAccessUtils.variableIsUsed((PsiVariable)var, (PsiElement)operand)) {
            return null;
        }
        return var;
    }

    static boolean isAddAllCall(TerminalBlock tb) {
        PsiMethodCallExpression call = tb.getSingleMethodCall();
        if (call == null || tb.getVariable().getType() instanceof PsiPrimitiveType) {
            return false;
        }
        if (!ExpressionUtils.isReferenceTo((PsiExpression)call.getArgumentList().getExpressions()[0], (PsiVariable)tb.getVariable())) {
            return false;
        }
        if (!"add".equals(call.getMethodExpression().getReferenceName())) {
            return false;
        }
        PsiExpression qualifierExpression = call.getMethodExpression().getQualifierExpression();
        if (qualifierExpression == null || qualifierExpression instanceof PsiThisExpression) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethod.class);
            return method == null || !method.getName().equals("addAll");
        }
        return !(qualifierExpression instanceof PsiMethodCallExpression);
    }

    @Contract(value="null, _, _ -> false")
    static boolean isCallOf(PsiMethodCallExpression call, String className, String ... methodNames) {
        if (call == null) {
            return false;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (!ArrayUtil.contains((String)name, (String[])methodNames)) {
            return false;
        }
        PsiMethod maybeMapMethod = call.resolveMethod();
        if (maybeMapMethod == null || maybeMapMethod.getParameterList().getParametersCount() != call.getArgumentList().getExpressionCount()) {
            return false;
        }
        PsiClass containingClass = maybeMapMethod.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        if (className.equals(containingClass.getQualifiedName())) {
            return true;
        }
        Object[] superMethods = maybeMapMethod.findDeepestSuperMethods();
        return StreamEx.of((Object[])superMethods).map(PsiMember::getContainingClass).nonNull().map(PsiClass::getQualifiedName).has((Object)className);
    }

    private static boolean isCountOperation(List<PsiVariable> nonFinalVariables, TerminalBlock tb) {
        PsiLocalVariable variable = StreamApiMigrationInspection.getIncrementedVariable(tb.getSingleExpression(PsiExpression.class), tb, nonFinalVariables);
        PsiExpression counter = tb.getCountExpression();
        if (counter == null) {
            return variable != null;
        }
        if (tb.isEmpty()) {
            variable = StreamApiMigrationInspection.getIncrementedVariable(counter, tb, nonFinalVariables);
        } else if (!ExpressionUtils.isReferenceTo((PsiExpression)counter, (PsiVariable)variable)) {
            return false;
        }
        return variable != null && ExpressionUtils.isZero((PsiExpression)variable.getInitializer()) && ControlFlowUtils.getInitializerUsageStatus((PsiVariable)variable, (PsiStatement)tb.getStreamSourceStatement()) != ControlFlowUtils.InitializerUsageStatus.UNKNOWN;
    }

    private static boolean isTrivial(TerminalBlock tb) {
        PsiVariable variable = tb.getVariable();
        PsiExpression candidate = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiElement)tb.getSingleStatement(), (PsiVariable[])new PsiVariable[]{variable}, (PsiType)StreamApiMigrationInspection.createDefaultConsumerType(variable.getProject(), variable), null);
        if (!(candidate instanceof PsiCallExpression)) {
            return true;
        }
        PsiMethod method = ((PsiCallExpression)candidate).resolveMethod();
        return method == null;
    }

    @Nullable
    private static PsiClassType createDefaultConsumerType(Project project, PsiVariable variable) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass consumerClass = psiFacade.findClass("java.util.function.Consumer", variable.getResolveScope());
        return consumerClass != null ? psiFacade.getElementFactory().createType(consumerClass, variable.getType()) : null;
    }

    static boolean isVariableSuitableForStream(PsiVariable variable, PsiStatement statement, TerminalBlock tb) {
        PsiElement block = PsiUtil.getVariableCodeBlock((PsiVariable)variable, (PsiElement)statement);
        if (block != null) {
            Predicate<PsiElement> notAllowedWrite = e -> {
                PsiReferenceExpression ref;
                return e instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)(ref = (PsiReferenceExpression)e)) && ref.isReferenceTo((PsiElement)variable) && tb.operations().noneMatch(op -> op.isWriteAllowed(variable, (PsiExpression)ref));
            };
            if (PsiTreeUtil.processElements((PsiElement)block, notAllowedWrite.negate()::test)) {
                return true;
            }
        }
        return ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)statement);
    }

    static String tryUnbox(PsiVariable variable) {
        PsiType type = variable.getType();
        String mapOp = null;
        if (type.equals(PsiTypes.intType())) {
            mapOp = "mapToInt";
        } else if (type.equals(PsiTypes.longType())) {
            mapOp = "mapToLong";
        } else if (type.equals(PsiTypes.doubleType())) {
            mapOp = "mapToDouble";
        }
        return mapOp == null ? "" : "." + mapOp + "(" + variable.getName() + " -> " + variable.getName() + ")";
    }

    static boolean isExpressionDependsOnUpdatedCollections(PsiExpression condition, PsiExpression qualifierExpression) {
        PsiElement collection;
        PsiElement psiElement = collection = qualifierExpression instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifierExpression).resolve() : null;
        if (collection != null) {
            return collection instanceof PsiVariable && VariableAccessUtils.variableIsUsed((PsiVariable)((PsiVariable)collection), (PsiElement)condition);
        }
        final boolean[] dependsOnCollection = new boolean[]{false};
        condition.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethodCallExpression(expression);
                PsiExpression callQualifier = expression.getMethodExpression().getQualifierExpression();
                if (callQualifier == null || callQualifier instanceof PsiThisExpression && ((PsiThisExpression)callQualifier).getQualifier() == null || callQualifier instanceof PsiSuperExpression && ((PsiSuperExpression)callQualifier).getQualifier() == null) {
                    dependsOnCollection[0] = true;
                }
            }

            public void visitThisExpression(@NotNull PsiThisExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitThisExpression(expression);
                if (expression.getQualifier() == null && expression.getParent() instanceof PsiExpressionList) {
                    dependsOnCollection[0] = true;
                }
            }

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(3);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitThisExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return dependsOnCollection[0];
    }

    @Nullable
    static BaseStreamApiMigration findMigration(PsiStatement loop, PsiElement body, TerminalBlock tb, boolean suggestForeach, boolean replaceTrivialForEach) {
        ControlFlow controlFlow;
        try {
            controlFlow = ControlFlowFactory.getInstance((Project)loop.getProject()).getControlFlow(body, (ControlFlowPolicy)LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
        }
        catch (AnalysisCanceledException ignored) {
            return null;
        }
        int startOffset = controlFlow.getStartOffset(body);
        int endOffset = controlFlow.getEndOffset(body);
        if (startOffset < 0 || endOffset < 0) {
            return null;
        }
        PsiElement surrounder = PsiTreeUtil.getParentOfType((PsiElement)loop, (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class});
        List nonFinalVariables = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of((Collection)ControlFlowUtil.getUsedVariables((ControlFlow)controlFlow, (int)startOffset, (int)endOffset)).remove(variable -> variable instanceof PsiField)).remove(variable -> PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class}) != surrounder)).remove(variable -> StreamApiMigrationInspection.isVariableSuitableForStream(variable, loop, tb))).toList();
        if (StreamApiMigrationInspection.isCountOperation(nonFinalVariables, tb)) {
            return new CountMigration(true);
        }
        CollectMigration.CollectTerminal terminal = CollectMigration.extractCollectTerminal(tb, nonFinalVariables);
        if (terminal != null) {
            boolean addAll;
            boolean bl = addAll = loop instanceof PsiForeachStatement && !tb.hasOperations() && StreamApiMigrationInspection.isAddAllCall(tb);
            if (addAll) {
                return null;
            }
            boolean shouldWarn = replaceTrivialForEach || tb.hasOperations() || tb.getLastOperation() instanceof BufferedReaderLines || !terminal.isTrivial();
            return new CollectMigration(shouldWarn, terminal.getMethodName());
        }
        if (JoiningMigration.extractTerminal(tb, nonFinalVariables) != null) {
            return new JoiningMigration(true);
        }
        if (tb.getCountExpression() != null || tb.isEmpty()) {
            return null;
        }
        if (nonFinalVariables.isEmpty() && StreamApiMigrationInspection.extractArray(tb) != null) {
            return new ToArrayMigration(true);
        }
        if (StreamApiMigrationInspection.getAccumulatedVariable(tb, nonFinalVariables, OperationReductionMigration.SUM_OPERATION) != null) {
            return new SumMigration(true);
        }
        FindExtremumMigration.ExtremumTerminal extremumTerminal = FindExtremumMigration.extract(tb, nonFinalVariables);
        if (extremumTerminal != null) {
            return new FindExtremumMigration(true, FindExtremumMigration.getOperation(extremumTerminal.isMax()));
        }
        for (OperationReductionMigration.ReductionOperation reductionOperation : OperationReductionMigration.OPERATIONS) {
            if (StreamApiMigrationInspection.getAccumulatedVariable(tb, nonFinalVariables, reductionOperation) == null) continue;
            return new OperationReductionMigration(true, reductionOperation);
        }
        Collection<PsiStatement> exitPoints = tb.findExitPoints(controlFlow);
        if (exitPoints == null) {
            return null;
        }
        boolean onlyNonLabeledContinue = ContainerUtil.and(exitPoints, statement -> statement instanceof PsiContinueStatement && ((PsiContinueStatement)statement).getLabelIdentifier() == null);
        if (onlyNonLabeledContinue && nonFinalVariables.isEmpty()) {
            boolean shouldWarn = suggestForeach && (replaceTrivialForEach || tb.hasOperations() || ForEachMigration.tryExtractMapExpression(tb) != null || !StreamApiMigrationInspection.isTrivial(tb));
            return new ForEachMigration(shouldWarn, "forEach");
        }
        if (nonFinalVariables.isEmpty() && tb.getSingleStatement() instanceof PsiReturnStatement) {
            return StreamApiMigrationInspection.findMigrationForReturn(loop, tb, replaceTrivialForEach);
        }
        if (tb.intermediateAndSourceExpressions().flatCollection(expr -> PsiTreeUtil.collectElementsOfType((PsiElement)expr, (Class[])new Class[]{PsiReferenceExpression.class})).map(PsiReference::resolve).select(PsiVariable.class).anyMatch(nonFinalVariables::contains)) {
            return null;
        }
        PsiStatement[] statements = tb.getStatements();
        if (statements.length == 2) {
            PsiStatement breakStatement = statements[1];
            if (loop instanceof PsiLoopStatement && ControlFlowUtils.statementBreaksLoop((PsiStatement)breakStatement, (PsiLoopStatement)((PsiLoopStatement)loop)) && exitPoints.size() == 1 && exitPoints.contains(breakStatement)) {
                return StreamApiMigrationInspection.findMigrationForBreak(tb, nonFinalVariables, statements[0], replaceTrivialForEach);
            }
        }
        return null;
    }

    @Nullable
    private static BaseStreamApiMigration findMigrationForBreak(TerminalBlock tb, List<PsiVariable> nonFinalVariables, PsiStatement statement, boolean replaceTrivialForEach) {
        boolean shouldWarn;
        boolean bl = shouldWarn = replaceTrivialForEach || tb.hasOperations();
        if (ReferencesSearch.search((PsiElement)tb.getVariable(), (SearchScope)new LocalSearchScope((PsiElement)statement)).findFirst() == null) {
            return new MatchMigration(shouldWarn, "anyMatch()/noneMatch()/allMatch");
        }
        if (nonFinalVariables.isEmpty() && statement instanceof PsiExpressionStatement) {
            return new FindFirstMigration(shouldWarn);
        }
        if (nonFinalVariables.size() == 1) {
            PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)statement);
            if (assignment == null) {
                return null;
            }
            PsiReferenceExpression lValue = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
            if (lValue == null) {
                return null;
            }
            PsiVariable var = (PsiVariable)ObjectUtils.tryCast((Object)lValue.resolve(), PsiVariable.class);
            if (var == null || !nonFinalVariables.contains(var)) {
                return null;
            }
            PsiExpression rValue = assignment.getRExpression();
            if (rValue == null || VariableAccessUtils.variableIsUsed((PsiVariable)var, (PsiElement)rValue)) {
                return null;
            }
            if (tb.getVariable().getType() instanceof PsiPrimitiveType && !ExpressionUtils.isReferenceTo((PsiExpression)rValue, (PsiVariable)tb.getVariable())) {
                return null;
            }
            return new FindFirstMigration(shouldWarn);
        }
        return null;
    }

    @Nullable
    private static BaseStreamApiMigration findMigrationForReturn(PsiStatement statement, TerminalBlock tb, boolean replaceTrivialForEach) {
        Boolean foundResult;
        boolean shouldWarn = replaceTrivialForEach || tb.hasOperations();
        PsiReturnStatement returnStatement = (PsiReturnStatement)tb.getSingleStatement();
        if (returnStatement == null) {
            return null;
        }
        PsiExpression value = PsiUtil.skipParenthesizedExprDown((PsiExpression)returnStatement.getReturnValue());
        PsiReturnStatement nextReturnStatement = ControlFlowUtils.getNextReturnStatement((PsiStatement)statement);
        if (nextReturnStatement != null && value instanceof PsiLiteralExpression && (foundResult = (Boolean)ObjectUtils.tryCast((Object)((PsiLiteralExpression)value).getValue(), Boolean.class)) != null) {
            String methodName;
            if (foundResult.booleanValue()) {
                methodName = "anyMatch";
            } else {
                methodName = "noneMatch";
                FilterOp lastFilter = tb.getLastOperation(FilterOp.class);
                if (lastFilter != null && lastFilter.isNegated() ^ BoolUtils.isNegation((PsiExpression)lastFilter.getExpression())) {
                    methodName = "allMatch";
                }
            }
            if (nextReturnStatement.getParent() == statement.getParent() || ExpressionUtils.isLiteral((PsiElement)nextReturnStatement.getReturnValue(), (Object)(foundResult == false ? 1 : 0))) {
                return new MatchMigration(shouldWarn, methodName);
            }
        }
        if (!VariableAccessUtils.variableIsUsed((PsiVariable)tb.getVariable(), (PsiElement)value)) {
            if (!replaceTrivialForEach && !tb.hasOperations() || tb.getLastOperation() instanceof FilterOp && tb.operations().count() == 2L) {
                return null;
            }
            return new MatchMigration(shouldWarn, "anyMatch");
        }
        if (nextReturnStatement != null && ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)nextReturnStatement.getReturnValue()) && (!(tb.getVariable().getType() instanceof PsiPrimitiveType) || ExpressionUtils.isReferenceTo((PsiExpression)value, (PsiVariable)tb.getVariable()))) {
            return new FindFirstMigration(shouldWarn);
        }
        return null;
    }

    @NotNull
    private static TextRange getRange(boolean shouldWarn, PsiStatement statement, boolean isOnTheFly) {
        boolean wholeStatement;
        boolean bl = wholeStatement = isOnTheFly && (!shouldWarn || InspectionProjectProfileManager.isInformationLevel((String)SHORT_NAME, (PsiElement)statement));
        if (statement instanceof PsiForeachStatement) {
            PsiJavaToken rParenth = ((PsiForeachStatement)statement).getRParenth();
            if (wholeStatement && rParenth != null) {
                return new TextRange(statement.getTextOffset(), rParenth.getTextOffset() + 1);
            }
            PsiExpression iteratedValue = ((PsiForeachStatement)statement).getIteratedValue();
            LOG.assertTrue(iteratedValue != null);
            TextRange textRange = iteratedValue.getTextRange();
            if (textRange == null) {
                StreamApiMigrationInspection.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        if (statement instanceof PsiForStatement) {
            PsiJavaToken rParenth = ((PsiForStatement)statement).getRParenth();
            if (wholeStatement && rParenth != null) {
                return new TextRange(statement.getTextOffset(), rParenth.getTextOffset() + 1);
            }
            PsiStatement initialization = ((PsiForStatement)statement).getInitialization();
            LOG.assertTrue(initialization != null);
            TextRange textRange = initialization.getTextRange();
            if (textRange == null) {
                StreamApiMigrationInspection.$$$reportNull$$$0(5);
            }
            return textRange;
        }
        if (statement instanceof PsiWhileStatement) {
            PsiJavaToken rParenth = ((PsiWhileStatement)statement).getRParenth();
            if (wholeStatement && rParenth != null) {
                return new TextRange(statement.getTextOffset(), rParenth.getTextOffset() + 1);
            }
            TextRange textRange = statement.getFirstChild().getTextRange();
            if (textRange == null) {
                StreamApiMigrationInspection.$$$reportNull$$$0(6);
            }
            return textRange;
        }
        throw new IllegalStateException("Unexpected statement type: " + String.valueOf(statement));
    }

    @Nullable
    static PsiLocalVariable extractArray(TerminalBlock tb) {
        CountingLoopSource loop = tb.getLastOperation(CountingLoopSource.class);
        if (loop == null || loop.myIncluding) {
            return null;
        }
        PsiAssignmentExpression assignment = tb.getSingleExpression(PsiAssignmentExpression.class);
        if (assignment == null || !assignment.getOperationTokenType().equals(JavaTokenType.EQ)) {
            return null;
        }
        PsiArrayAccessExpression arrayAccess = (PsiArrayAccessExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiArrayAccessExpression.class);
        if (arrayAccess == null) {
            return null;
        }
        if (!ExpressionUtils.isReferenceTo((PsiExpression)arrayAccess.getIndexExpression(), (PsiVariable)loop.getVariable())) {
            return null;
        }
        PsiReferenceExpression arrayReference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)arrayAccess.getArrayExpression(), PsiReferenceExpression.class);
        if (arrayReference == null) {
            return null;
        }
        PsiLocalVariable arrayVariable = (PsiLocalVariable)ObjectUtils.tryCast((Object)arrayReference.resolve(), PsiLocalVariable.class);
        if (arrayVariable == null || ControlFlowUtils.getInitializerUsageStatus((PsiVariable)arrayVariable, (PsiStatement)tb.getStreamSourceStatement()) == ControlFlowUtils.InitializerUsageStatus.UNKNOWN) {
            return null;
        }
        PsiNewExpression initializer = (PsiNewExpression)ObjectUtils.tryCast((Object)arrayVariable.getInitializer(), PsiNewExpression.class);
        if (initializer == null) {
            return null;
        }
        PsiArrayType arrayType = (PsiArrayType)ObjectUtils.tryCast((Object)initializer.getType(), PsiArrayType.class);
        if (arrayType == null || !StreamApiUtil.isSupportedStreamElement((PsiType)arrayType.getComponentType())) {
            return null;
        }
        PsiExpression dimension = (PsiExpression)ArrayUtil.getFirstElement((Object[])initializer.getArrayDimensions());
        if (dimension == null) {
            return null;
        }
        PsiExpression bound = PsiUtil.skipParenthesizedExprDown((PsiExpression)loop.myBound);
        if (!StreamApiMigrationInspection.isArrayLength(arrayVariable, dimension, bound)) {
            return null;
        }
        if (VariableAccessUtils.variableIsUsed((PsiVariable)arrayVariable, (PsiElement)assignment.getRExpression())) {
            return null;
        }
        return arrayVariable;
    }

    private static boolean isArrayLength(PsiLocalVariable arrayVariable, PsiExpression dimension, PsiExpression bound) {
        PsiExpression qualifier;
        if (ExpressionUtils.isReferenceTo((PsiExpression)ExpressionUtils.getArrayFromLengthExpression((PsiExpression)bound), (PsiVariable)arrayVariable)) {
            return true;
        }
        if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(dimension, bound)) {
            return true;
        }
        if (bound instanceof PsiMethodCallExpression && (qualifier = ((PsiMethodCallExpression)bound).getMethodExpression().getQualifierExpression()) != null && CollectionUtils.isCollectionOrMapSize((PsiExpression)dimension, (PsiExpression)qualifier)) {
            return true;
        }
        return dimension instanceof PsiMethodCallExpression && (qualifier = ((PsiMethodCallExpression)dimension).getMethodExpression().getQualifierExpression()) != null && CollectionUtils.isCollectionOrMapSize((PsiExpression)bound, (PsiExpression)qualifier);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }

    private class StreamApiMigrationVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myIsOnTheFly;

        StreamApiMigrationVisitor(ProblemsHolder holder, boolean isOnTheFly) {
            this.myHolder = holder;
            this.myIsOnTheFly = isOnTheFly;
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                StreamApiMigrationVisitor.$$$reportNull$$$0(0);
            }
            super.visitForeachStatement(statement);
            this.processLoop((PsiLoopStatement)statement);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                StreamApiMigrationVisitor.$$$reportNull$$$0(1);
            }
            super.visitWhileStatement(statement);
            this.processLoop((PsiLoopStatement)statement);
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                StreamApiMigrationVisitor.$$$reportNull$$$0(2);
            }
            super.visitForStatement(statement);
            this.processLoop((PsiLoopStatement)statement);
        }

        void processLoop(PsiLoopStatement statement) {
            PsiStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            StreamSource source = StreamSource.tryCreate(statement);
            if (source == null) {
                return;
            }
            if (!ExceptionUtil.getThrownCheckedExceptions((PsiElement[])new PsiElement[]{body}).isEmpty()) {
                return;
            }
            TerminalBlock tb = TerminalBlock.from(source, body);
            BaseStreamApiMigration migration = StreamApiMigrationInspection.findMigration((PsiStatement)statement, (PsiElement)body, tb, StreamApiMigrationInspection.this.SUGGEST_FOREACH, StreamApiMigrationInspection.this.REPLACE_TRIVIAL_FOREACH);
            if (migration == null || !this.myIsOnTheFly && !migration.isShouldWarn()) {
                return;
            }
            MigrateToStreamFix[] fixes = new MigrateToStreamFix[]{new MigrateToStreamFix(migration)};
            if (migration instanceof ForEachMigration && !(tb.getLastOperation() instanceof CollectionStream)) {
                fixes = (MigrateToStreamFix[])ArrayUtil.append((Object[])fixes, (Object)((Object)new MigrateToStreamFix(new ForEachMigration(migration.isShouldWarn(), "forEachOrdered"))));
            }
            ProblemHighlightType highlightType = migration.isShouldWarn() ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
            String message = JavaBundle.message((String)"inspection.stream.api.migration.can.be.replaced.with.call", (Object[])new Object[]{migration.getReplacement()});
            TextRange range = StreamApiMigrationInspection.getRange(migration.isShouldWarn(), (PsiStatement)statement, this.myIsOnTheFly);
            this.myHolder.registerProblem((PsiElement)statement, message, highlightType, range.shiftRight(-statement.getTextOffset()), (LocalQuickFix[])fixes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$StreamApiMigrationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForeachStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class Operation {
        final PsiExpression myExpression;
        final PsiVariable myVariable;

        protected Operation(PsiExpression expression, PsiVariable variable) {
            this.myExpression = expression;
            this.myVariable = variable;
        }

        void cleanUp() {
        }

        public PsiVariable getVariable() {
            return this.myVariable;
        }

        PsiExpression getExpression() {
            return this.myExpression;
        }

        StreamEx<PsiExpression> expressions() {
            return StreamEx.ofNullable((Object)this.myExpression);
        }

        abstract String createReplacement(CommentTracker var1);

        boolean isWriteAllowed(PsiVariable variable, PsiExpression reference) {
            return false;
        }

        boolean canReassignVariable(PsiVariable variable) {
            return true;
        }
    }

    static final class BufferedReaderLines
    extends StreamSource {
        private static final CallMatcher BUFFERED_READER_READ_LINE = CallMatcher.instanceCall((String)"java.io.BufferedReader", (String[])new String[]{"readLine"}).parameterCount(0);
        private boolean myDeleteVariable;

        private BufferedReaderLines(PsiLoopStatement loop, PsiVariable variable, PsiExpression expression, boolean deleteVariable) {
            super((PsiStatement)loop, variable, expression);
            this.myDeleteVariable = deleteVariable;
        }

        @Override
        String createReplacement(CommentTracker ct) {
            return ct.text((PsiElement)this.myExpression) + ".lines()";
        }

        @Override
        void cleanUp() {
            if (this.myDeleteVariable) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)this.myVariable);
            }
        }

        @Override
        boolean isWriteAllowed(PsiVariable variable, PsiExpression reference) {
            if (this.myVariable == variable) {
                if (PsiUtil.skipParenthesizedExprUp((PsiElement)reference.getParent()) == PsiTreeUtil.getParentOfType((PsiElement)this.myExpression, PsiAssignmentExpression.class)) {
                    return true;
                }
                PsiForStatement forStatement = (PsiForStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiForStatement.class);
                if (forStatement != null && forStatement == PsiTreeUtil.getParentOfType((PsiElement)this.myVariable, PsiForStatement.class)) {
                    return PsiTreeUtil.isAncestor((PsiElement)forStatement.getUpdate(), (PsiElement)reference, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)forStatement.getCondition(), (PsiElement)reference, (boolean)false);
                }
            }
            return false;
        }

        @Nullable
        public static BufferedReaderLines from(PsiLoopStatement loopStatement) {
            BufferedReaderLines whileSimple = BufferedReaderLines.extractWhileSimple(loopStatement);
            if (whileSimple != null) {
                return whileSimple;
            }
            BufferedReaderLines forSimple = BufferedReaderLines.extractForSimple(loopStatement);
            if (forSimple != null) {
                return forSimple;
            }
            return BufferedReaderLines.extractForReadInCondition(loopStatement);
        }

        @Nullable
        private static BufferedReaderLines extractReaderFromCondition(@Nullable PsiExpression condition, @NotNull PsiLoopStatement loopStatement) {
            PsiBinaryExpression binOp;
            if (loopStatement == null) {
                BufferedReaderLines.$$$reportNull$$$0(0);
            }
            if ((binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)condition), PsiBinaryExpression.class)) == null) {
                return null;
            }
            if (!JavaTokenType.NE.equals(binOp.getOperationTokenType())) {
                return null;
            }
            PsiExpression operand = ExpressionUtils.getValueComparedWithNull((PsiBinaryExpression)binOp);
            if (operand == null) {
                return null;
            }
            PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)operand);
            if (assignment == null) {
                return null;
            }
            PsiMethodCallExpression readerCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression()), PsiMethodCallExpression.class);
            if (!BUFFERED_READER_READ_LINE.test(readerCall)) {
                return null;
            }
            PsiExpression reader = readerCall.getMethodExpression().getQualifierExpression();
            PsiLocalVariable lineVar = ExpressionUtils.resolveLocalVariable((PsiExpression)assignment.getLExpression());
            if (lineVar == null) {
                return null;
            }
            if (ReferencesSearch.search((PsiElement)lineVar).anyMatch(ref -> !PsiTreeUtil.isAncestor((PsiElement)loopStatement, (PsiElement)ref.getElement(), (boolean)true))) {
                return null;
            }
            return new BufferedReaderLines(loopStatement, (PsiVariable)lineVar, reader, false);
        }

        @Nullable
        private static BufferedReaderLines extractForReadInCondition(PsiLoopStatement loopStatement) {
            PsiForStatement forLoop = (PsiForStatement)ObjectUtils.tryCast((Object)loopStatement, PsiForStatement.class);
            if (forLoop == null || forLoop.getUpdate() != null) {
                return null;
            }
            BufferedReaderLines reader = BufferedReaderLines.extractReaderFromCondition(forLoop.getCondition(), loopStatement);
            if (reader == null) {
                return null;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)forLoop.getInitialization(), PsiDeclarationStatement.class);
            if (declaration == null) {
                return null;
            }
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return null;
            }
            PsiVariable lineVar = reader.getVariable();
            if (declaredElements[0] != lineVar) {
                return null;
            }
            return reader;
        }

        @Nullable
        private static BufferedReaderLines extractForSimple(PsiLoopStatement loopStatement) {
            PsiForStatement forLoop = (PsiForStatement)ObjectUtils.tryCast((Object)loopStatement, PsiForStatement.class);
            if (forLoop == null) {
                return null;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)forLoop.getInitialization(), PsiDeclarationStatement.class);
            if (declarationStatement == null) {
                return null;
            }
            PsiElement[] declarations = declarationStatement.getDeclaredElements();
            if (declarations.length != 1) {
                return null;
            }
            PsiLocalVariable lineVar = (PsiLocalVariable)ObjectUtils.tryCast((Object)declarations[0], PsiLocalVariable.class);
            if (lineVar == null) {
                return null;
            }
            if (ReferencesSearch.search((PsiElement)lineVar).anyMatch(ref -> !PsiTreeUtil.isAncestor((PsiElement)forLoop, (PsiElement)ref.getElement(), (boolean)true))) {
                return null;
            }
            PsiMethodCallExpression maybeReadLines = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)lineVar.getInitializer()), PsiMethodCallExpression.class);
            if (!BUFFERED_READER_READ_LINE.test(maybeReadLines)) {
                return null;
            }
            PsiExpression reader = PsiUtil.skipParenthesizedExprDown((PsiExpression)maybeReadLines.getMethodExpression().getQualifierExpression());
            PsiReferenceExpression readerRef = (PsiReferenceExpression)ObjectUtils.tryCast((Object)reader, PsiReferenceExpression.class);
            if (readerRef == null) {
                return null;
            }
            PsiVariable readerVar = (PsiVariable)ObjectUtils.tryCast((Object)readerRef.resolve(), PsiVariable.class);
            if (readerVar == null) {
                return null;
            }
            PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)forLoop.getCondition()), PsiBinaryExpression.class);
            if (binOp == null) {
                return null;
            }
            if (!JavaTokenType.NE.equals(binOp.getOperationTokenType())) {
                return null;
            }
            PsiExpression lineExpr = ExpressionUtils.getValueComparedWithNull((PsiBinaryExpression)binOp);
            if (!ExpressionUtils.isReferenceTo((PsiExpression)lineExpr, (PsiVariable)lineVar)) {
                return null;
            }
            PsiExpressionStatement updateStmt = (PsiExpressionStatement)ObjectUtils.tryCast((Object)forLoop.getUpdate(), PsiExpressionStatement.class);
            if (updateStmt == null) {
                return null;
            }
            PsiExpression readNewLineExpr = ExpressionUtils.getAssignmentTo((PsiElement)updateStmt.getExpression(), (PsiVariable)lineVar);
            PsiMethodCallExpression readNewLineCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)readNewLineExpr), PsiMethodCallExpression.class);
            if (!BUFFERED_READER_READ_LINE.test(readNewLineCall)) {
                return null;
            }
            if (!ExpressionUtils.isReferenceTo((PsiExpression)readNewLineCall.getMethodExpression().getQualifierExpression(), (PsiVariable)readerVar)) {
                return null;
            }
            return new BufferedReaderLines((PsiLoopStatement)forLoop, (PsiVariable)lineVar, reader, false);
        }

        @Nullable
        private static BufferedReaderLines extractWhileSimple(PsiLoopStatement loopStatement) {
            PsiWhileStatement whileLoop = (PsiWhileStatement)ObjectUtils.tryCast((Object)loopStatement, PsiWhileStatement.class);
            if (whileLoop == null) {
                return null;
            }
            BufferedReaderLines reader = BufferedReaderLines.extractReaderFromCondition(whileLoop.getCondition(), loopStatement);
            if (reader == null) {
                return null;
            }
            reader.myDeleteVariable = true;
            return reader;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopStatement", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$BufferedReaderLines", "extractReaderFromCondition"));
        }
    }

    static class FilterOp
    extends Operation {
        private final boolean myNegated;

        FilterOp(PsiExpression condition, PsiVariable variable, boolean negated) {
            super(condition, variable);
            this.myNegated = negated;
        }

        public boolean isNegated() {
            return this.myNegated;
        }

        @Override
        public String createReplacement(CommentTracker ct) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myExpression.getProject());
            PsiExpression intermediate = this.makeIntermediateExpression(ct, factory);
            PsiExpression expression = this.myNegated ? factory.createExpressionFromText(BoolUtils.getNegatedExpressionText((PsiExpression)intermediate, (CommentTracker)ct), (PsiElement)this.myExpression) : intermediate;
            return "." + this.getOpName() + "(" + LambdaUtil.createLambda((PsiVariable)this.myVariable, (PsiExpression)expression) + ")";
        }

        @NotNull
        String getOpName() {
            return "filter";
        }

        PsiExpression makeIntermediateExpression(CommentTracker ct, PsiElementFactory factory) {
            return (PsiExpression)ct.markUnchanged((PsiElement)this.myExpression);
        }
    }

    static final class CountingLoopSource
    extends StreamSource {
        final PsiExpression myBound;
        final boolean myIncluding;

        private CountingLoopSource(PsiStatement loop, PsiVariable counter, PsiExpression initializer, PsiExpression bound, boolean including) {
            super(loop, counter, initializer);
            this.myBound = bound;
            this.myIncluding = including;
        }

        @Override
        StreamEx<PsiExpression> expressions() {
            return StreamEx.of((Object[])new PsiExpression[]{this.myExpression, this.myBound});
        }

        @Override
        public String createReplacement(CommentTracker ct) {
            String className = this.myVariable.getType().equals(PsiTypes.longType()) ? "java.util.stream.LongStream" : "java.util.stream.IntStream";
            String methodName = this.myIncluding ? "rangeClosed" : "range";
            return className + "." + methodName + "(" + ct.text((PsiElement)this.myExpression) + ", " + ct.text((PsiElement)this.myBound) + ")";
        }

        CountingLoopSource withBound(PsiExpression bound) {
            return new CountingLoopSource(this.getMainStatement(), this.getVariable(), this.getExpression(), bound, this.myIncluding);
        }

        CountingLoopSource withInitializer(PsiExpression expression) {
            return new CountingLoopSource(this.getMainStatement(), this.getVariable(), expression, this.myBound, this.myIncluding);
        }

        @Override
        boolean isWriteAllowed(PsiVariable variable, PsiExpression reference) {
            PsiForStatement forStatement;
            if (variable == this.myVariable && (forStatement = (PsiForStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiForStatement.class)) != null) {
                return PsiTreeUtil.isAncestor((PsiElement)forStatement.getUpdate(), (PsiElement)reference, (boolean)false);
            }
            return false;
        }

        @Override
        boolean canReassignVariable(PsiVariable variable) {
            return variable != this.myVariable;
        }

        @Nullable
        public static CountingLoopSource from(PsiForStatement forStatement) {
            CountingLoop loop = CountingLoop.from((PsiForStatement)forStatement);
            if (loop == null || loop.isDescending()) {
                return null;
            }
            return new CountingLoopSource((PsiStatement)forStatement, (PsiVariable)loop.getCounter(), loop.getInitializer(), loop.getBound(), loop.isIncluding());
        }
    }

    static class IterateStreamSource
    extends StreamSource {
        private final PsiExpression myInitializer;
        @Nullable
        private final PsiExpression myCondition;
        @Nullable
        private final IElementType myOpType;
        @Nullable
        private final PsiUnaryExpression myUnaryExpression;

        protected IterateStreamSource(@NotNull PsiLoopStatement loop, @NotNull PsiVariable variable, @Nullable PsiExpression expression, @NotNull PsiExpression initializer, @Nullable PsiExpression condition, @Nullable IElementType type, @Nullable PsiUnaryExpression unaryExpression) {
            if (loop == null) {
                IterateStreamSource.$$$reportNull$$$0(0);
            }
            if (variable == null) {
                IterateStreamSource.$$$reportNull$$$0(1);
            }
            if (initializer == null) {
                IterateStreamSource.$$$reportNull$$$0(2);
            }
            super((PsiStatement)loop, variable, expression);
            this.myInitializer = initializer;
            this.myCondition = condition;
            this.myOpType = type;
            this.myUnaryExpression = unaryExpression;
        }

        @Contract(pure=true)
        @Nullable
        private static String getOperationSign(IElementType op) {
            if (op == JavaTokenType.AND) {
                return "&";
            }
            if (op == JavaTokenType.ASTERISK) {
                return "*";
            }
            if (op == JavaTokenType.DIV) {
                return "/";
            }
            if (op == JavaTokenType.GTGT) {
                return ">>";
            }
            if (op == JavaTokenType.GTGTGT) {
                return ">>>";
            }
            if (op == JavaTokenType.LTLT) {
                return "<<";
            }
            if (op == JavaTokenType.MINUS) {
                return "-";
            }
            if (op == JavaTokenType.OR) {
                return "|";
            }
            if (op == JavaTokenType.PERC) {
                return "%";
            }
            if (op == JavaTokenType.PLUS) {
                return "+";
            }
            if (op == JavaTokenType.XOR) {
                return "^";
            }
            return null;
        }

        @Override
        String createReplacement(CommentTracker ct) {
            Object lambda;
            if (this.myOpType != null) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myVariable.getProject());
                PsiExpression expression = this.myUnaryExpression == null ? this.myExpression : factory.createExpressionFromText("1", null);
                String expressionText = ParenthesesUtils.getText((PsiExpression)((PsiExpression)ct.markUnchanged((PsiElement)expression)), (int)ParenthesesUtils.getPrecedenceForOperator((IElementType)this.myOpType));
                String lambdaBody = this.myVariable.getName() + IterateStreamSource.getOperationSign(this.myOpType) + expressionText;
                if (!this.myVariable.getType().equals(expression.getType())) {
                    lambdaBody = "(" + this.myVariable.getType().getCanonicalText() + ")(" + lambdaBody + ")";
                }
                lambda = this.myVariable.getName() + "->" + lambdaBody;
            } else {
                lambda = ct.lambdaText(this.myVariable, this.myExpression);
            }
            String maybeCondition = this.myCondition != null ? ct.lambdaText(this.myVariable, this.myCondition) + "," : "";
            return StreamApiUtil.getStreamClassForType((PsiType)this.myVariable.getType()) + ".iterate(" + ct.text((PsiElement)this.myInitializer) + "," + maybeCondition + (String)lambda + ")";
        }

        @Override
        StreamEx<PsiExpression> expressions() {
            return StreamEx.of((Object[])new PsiExpression[]{this.myInitializer, this.myExpression, this.myCondition}).nonNull();
        }

        @Override
        boolean isWriteAllowed(PsiVariable variable, PsiExpression reference) {
            PsiForStatement forStatement;
            if (variable == this.myVariable && (forStatement = (PsiForStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiForStatement.class)) != null) {
                return PsiTreeUtil.isAncestor((PsiElement)forStatement.getUpdate(), (PsiElement)reference, (boolean)false);
            }
            return false;
        }

        @Override
        boolean canReassignVariable(PsiVariable variable) {
            return variable != this.myVariable;
        }

        @Nullable
        static IterateStreamSource from(@NotNull PsiForStatement forStatement) {
            IElementType op;
            if (forStatement == null) {
                IterateStreamSource.$$$reportNull$$$0(3);
            }
            PsiExpression condition = forStatement.getCondition();
            if (!PsiUtil.isLanguageLevel9OrHigher((PsiElement)forStatement) && condition != null) {
                return null;
            }
            PsiStatement initialization = forStatement.getInitialization();
            PsiDeclarationStatement initStmt = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)initialization, PsiDeclarationStatement.class);
            if (initStmt == null || initStmt.getDeclaredElements().length != 1) {
                return null;
            }
            PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)initStmt.getDeclaredElements()[0], PsiLocalVariable.class);
            if (variable == null) {
                return null;
            }
            if (StreamApiUtil.getStreamClassForType((PsiType)variable.getType()) == null) {
                return null;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return null;
            }
            PsiStatement update = forStatement.getUpdate();
            if (update == null) {
                return null;
            }
            PsiExpressionStatement exprStmt = (PsiExpressionStatement)ObjectUtils.tryCast((Object)update, PsiExpressionStatement.class);
            if (exprStmt == null) {
                return null;
            }
            PsiExpression expression = exprStmt.getExpression();
            PsiExpression updateExpr = null;
            PsiUnaryExpression unaryExpression = null;
            if (expression instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
                op = TypeConversionUtil.convertEQtoOperation((IElementType)assignment.getOperationTokenType());
                updateExpr = assignment.getRExpression();
                if (!ExpressionUtils.isReferenceTo((PsiExpression)assignment.getLExpression(), (PsiVariable)variable)) {
                    return null;
                }
                if (updateExpr == null) {
                    return null;
                }
            } else if (expression instanceof PsiUnaryExpression) {
                unaryExpression = (PsiUnaryExpression)expression;
                IElementType tokenType = unaryExpression.getOperationTokenType();
                op = IterateStreamSource.getOperation(tokenType);
                if (op == null) {
                    return null;
                }
            } else {
                return null;
            }
            if (updateExpr != null && !ExceptionUtil.getThrownCheckedExceptions((PsiElement[])new PsiElement[]{updateExpr}).isEmpty()) {
                return null;
            }
            if (condition != null && !ExceptionUtil.getThrownCheckedExceptions((PsiElement[])new PsiElement[]{condition}).isEmpty()) {
                return null;
            }
            if (!VariableAccessUtils.variableIsUsed((PsiVariable)variable, (PsiElement)update)) {
                return null;
            }
            return new IterateStreamSource((PsiLoopStatement)forStatement, (PsiVariable)variable, updateExpr, initializer, condition, op, unaryExpression);
        }

        @Nullable
        private static IElementType getOperation(IElementType tokenType) {
            if (tokenType == JavaTokenType.PLUSPLUS) {
                return JavaTokenType.PLUS;
            }
            if (tokenType == JavaTokenType.MINUSMINUS) {
                return JavaTokenType.MINUS;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loop";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initializer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forStatement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$IterateStreamSource";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "from";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class CollectionStream
    extends StreamSource {
        private CollectionStream(PsiLoopStatement loop, PsiVariable variable, PsiExpression expression) {
            super((PsiStatement)loop, variable, expression);
        }

        @Override
        String createReplacement(CommentTracker ct) {
            return ct.text(this.myExpression, 1) + ".stream()" + StreamApiMigrationInspection.tryUnbox(this.myVariable);
        }

        @Contract(value="null, _ -> false")
        static boolean isRawSubstitution(PsiType iteratedValueType, PsiClass collectionClass) {
            return iteratedValueType instanceof PsiClassType && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)collectionClass, (PsiSubstitutor)TypeConversionUtil.getSuperClassSubstitutor((PsiClass)collectionClass, (PsiClassType)((PsiClassType)iteratedValueType)));
        }

        @Nullable
        public static CollectionStream from(PsiForeachStatement statement) {
            PsiExpression iteratedValue = statement.getIteratedValue();
            if (iteratedValue == null) {
                return null;
            }
            PsiType iteratedValueType = iteratedValue.getType();
            PsiClass collectionClass = JavaPsiFacade.getInstance((Project)statement.getProject()).findClass("java.util.Collection", statement.getResolveScope());
            PsiClass iteratorClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)iteratedValueType);
            PsiParameter parameter = statement.getIterationParameter();
            if (collectionClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)iteratorClass, (PsiClass)collectionClass, (boolean)true) || CollectionStream.isRawSubstitution(iteratedValueType, collectionClass) || !StreamApiUtil.isSupportedStreamElement((PsiType)parameter.getType())) {
                return null;
            }
            return new CollectionStream((PsiLoopStatement)statement, (PsiVariable)parameter, iteratedValue);
        }
    }

    static final class ArrayStream
    extends StreamSource {
        private ArrayStream(PsiLoopStatement loop, PsiVariable variable, PsiExpression expression) {
            super((PsiStatement)loop, variable, expression);
        }

        @Override
        String createReplacement(CommentTracker ct) {
            Object[] children;
            PsiArrayInitializerExpression initializer;
            if (this.myExpression instanceof PsiNewExpression && (initializer = ((PsiNewExpression)this.myExpression).getArrayInitializer()) != null && (children = initializer.getChildren()).length > 2) {
                PsiType componentType;
                String streamClass;
                String initializerText = StreamEx.of((Object[])children, (int)1, (int)(children.length - 1)).map(arg_0 -> ((CommentTracker)ct).text(arg_0)).joining();
                PsiType type = this.myExpression.getType();
                if (type instanceof PsiArrayType && (streamClass = StreamApiUtil.getStreamClassForType((PsiType)(componentType = ((PsiArrayType)type).getComponentType()))) != null) {
                    return streamClass + "." + (String)(componentType instanceof PsiClassType ? "<" + componentType.getCanonicalText() + ">" : "") + "of(" + initializerText + ")";
                }
            }
            return "java.util.Arrays.stream(" + ct.text((PsiElement)this.myExpression) + ")";
        }

        @Nullable
        public static ArrayStream from(PsiForeachStatement statement) {
            PsiExpression iteratedValue = statement.getIteratedValue();
            if (iteratedValue == null) {
                return null;
            }
            PsiArrayType iteratedValueType = (PsiArrayType)ObjectUtils.tryCast((Object)iteratedValue.getType(), PsiArrayType.class);
            PsiParameter parameter = statement.getIterationParameter();
            if (iteratedValueType != null && StreamApiUtil.isSupportedStreamElement((PsiType)iteratedValueType.getComponentType()) && (!(parameter.getType() instanceof PsiPrimitiveType) || parameter.getType().equals(iteratedValueType.getComponentType()))) {
                return new ArrayStream((PsiLoopStatement)statement, (PsiVariable)parameter, iteratedValue);
            }
            return null;
        }
    }

    static abstract class StreamSource
    extends Operation {
        private final PsiStatement myMainStatement;

        protected StreamSource(PsiStatement mainStatement, PsiVariable variable, PsiExpression expression) {
            super(expression, variable);
            this.myMainStatement = mainStatement;
        }

        PsiStatement getMainStatement() {
            return this.myMainStatement;
        }

        @Contract(value="null -> null")
        static StreamSource tryCreate(PsiLoopStatement statement) {
            if (statement == null) {
                return null;
            }
            BufferedReaderLines readerSource = BufferedReaderLines.from(statement);
            if (readerSource != null) {
                return readerSource;
            }
            if (statement instanceof PsiForStatement) {
                CountingLoopSource countingLoopSource = CountingLoopSource.from((PsiForStatement)statement);
                if (countingLoopSource != null) {
                    return countingLoopSource;
                }
                return IterateStreamSource.from((PsiForStatement)statement);
            }
            if (statement instanceof PsiForeachStatement) {
                ArrayStream source = ArrayStream.from((PsiForeachStatement)statement);
                return source == null ? CollectionStream.from((PsiForeachStatement)statement) : source;
            }
            return null;
        }
    }

    static class DistinctOp
    extends Operation {
        protected DistinctOp(PsiVariable variable) {
            super(null, variable);
        }

        @Override
        String createReplacement(CommentTracker ct) {
            return ".distinct()";
        }
    }

    static class LimitOp
    extends Operation {
        private final PsiExpression myCounter;
        private final PsiLocalVariable myCounterVariable;
        private final int myDelta;

        LimitOp(PsiVariable variable, PsiExpression countExpression, PsiExpression limitExpression, PsiLocalVariable counterVariable, int delta) {
            super(limitExpression, variable);
            LOG.assertTrue(delta >= 0);
            this.myDelta = delta;
            this.myCounter = countExpression;
            this.myCounterVariable = counterVariable;
        }

        @Override
        String createReplacement(CommentTracker ct) {
            return ".limit(" + JavaPsiMathUtil.add((PsiExpression)this.myExpression, (int)this.myDelta, (CommentTracker)ct) + ")";
        }

        PsiLocalVariable getCounterVariable() {
            return this.myCounterVariable;
        }

        PsiExpression getCountExpression() {
            return this.myCounter;
        }

        @Override
        void cleanUp() {
            if (this.myCounterVariable != null) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)this.myCounterVariable);
            }
        }

        @Override
        boolean isWriteAllowed(PsiVariable variable, PsiExpression reference) {
            return variable == this.myCounterVariable && PsiTreeUtil.isAncestor((PsiElement)this.myCounter, (PsiElement)reference, (boolean)false);
        }
    }

    static class FlatMapOp
    extends Operation {
        private final StreamSource mySource;

        FlatMapOp(StreamSource source, PsiVariable variable) {
            super(source.getExpression(), variable);
            this.mySource = source;
        }

        @Override
        public String createReplacement(CommentTracker ct) {
            String operation = "flatMap";
            PsiType inType = this.myVariable.getType();
            PsiType outType = this.mySource.getVariable().getType();
            String lambda = this.myVariable.getName() + " -> " + this.getStreamExpression(ct);
            if (outType instanceof PsiPrimitiveType && !outType.equals(inType)) {
                if (outType.equals(PsiTypes.intType())) {
                    operation = "flatMapToInt";
                } else if (outType.equals(PsiTypes.longType())) {
                    operation = "flatMapToLong";
                } else if (outType.equals(PsiTypes.doubleType())) {
                    operation = "flatMapToDouble";
                }
            }
            if (inType instanceof PsiPrimitiveType && !outType.equals(inType)) {
                return ".mapToObj(" + lambda + ")." + operation + "(java.util.function.Function.identity())";
            }
            return "." + operation + "(" + lambda + ")";
        }

        public StreamSource getSource() {
            return this.mySource;
        }

        @NotNull
        String getStreamExpression(CommentTracker ct) {
            String string = this.mySource.createReplacement(ct);
            if (string == null) {
                FlatMapOp.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        boolean isWriteAllowed(PsiVariable variable, PsiExpression reference) {
            return this.mySource.isWriteAllowed(variable, reference);
        }

        @Override
        boolean canReassignVariable(PsiVariable variable) {
            return this.mySource.canReassignVariable(variable);
        }

        boolean breaksMe(PsiBreakStatement statement) {
            return statement.findExitedStatement() == this.mySource.getMainStatement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$FlatMapOp", "getStreamExpression"));
        }
    }

    static class MapOp
    extends Operation {
        @Nullable
        private final PsiType myType;

        MapOp(PsiExpression expression, PsiVariable variable, @Nullable PsiType targetType) {
            super(expression, variable);
            this.myType = targetType;
        }

        @Override
        public String createReplacement(CommentTracker ct) {
            return StreamRefactoringUtil.generateMapOperation((PsiVariable)this.myVariable, (PsiType)this.myType, (PsiElement)ct.markUnchanged((PsiElement)this.myExpression));
        }

        @Override
        boolean isWriteAllowed(PsiVariable variable, PsiExpression reference) {
            return variable == this.myVariable && reference.getParent() == this.myExpression.getParent();
        }
    }

    static class CompoundFilterOp
    extends FilterOp {
        private final StreamSource mySource;
        private final PsiVariable myMatchVariable;

        protected CompoundFilterOp(StreamSource source, PsiVariable matchVariable, FilterOp sourceFilter) {
            super(sourceFilter.getExpression(), matchVariable, sourceFilter.isNegated());
            this.mySource = source;
            this.myMatchVariable = sourceFilter.getVariable();
        }

        @Override
        PsiExpression makeIntermediateExpression(CommentTracker ct, PsiElementFactory factory) {
            return factory.createExpressionFromText(this.mySource.createReplacement(ct) + ".anyMatch(" + ct.lambdaText(this.myMatchVariable, this.myExpression) + ")", (PsiElement)this.myExpression);
        }

        @Override
        boolean isWriteAllowed(PsiVariable variable, PsiExpression reference) {
            return this.mySource.isWriteAllowed(variable, reference);
        }

        @Override
        StreamEx<PsiExpression> expressions() {
            return StreamEx.of((Object[])new PsiExpression[]{this.myExpression, this.mySource.getExpression()});
        }
    }

    static class TakeWhileOp
    extends FilterOp {
        TakeWhileOp(PsiExpression condition, PsiVariable variable, boolean negated) {
            super(condition, variable, negated);
        }

        @Override
        @NotNull
        String getOpName() {
            return "takeWhile";
        }
    }
}

