/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.merge;

import com.intellij.diff.util.ThreeSide;
import com.intellij.lang.properties.merge.Filter;
import com.intellij.lang.properties.merge.ThreeSideConflictInfoHolder;
import com.intellij.lang.properties.merge.data.PropertyInfo;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aD\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0002\u001a\"\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0015\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u000f0\rH\u0002\u001a*\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001dH\u0002\u001aN\u0010\u001e\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\u0004\u0012\u00020\u000e\u0012\u0002\b\u00030\r2\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\u000e\u0012\u0002\b\u00030\r2\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u000e\u0012\u0002\b\u00030\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001dH\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0014\u0010\b\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\u00a8\u0006 "}, d2={"OUTSIDE_INTERSECTIONS", "Lcom/intellij/lang/properties/merge/Filter;", "getOUTSIDE_INTERSECTIONS", "()Lcom/intellij/lang/properties/merge/Filter;", "INNER_INCONSISTENCY", "getINNER_INCONSISTENCY", "COMMENT_INTERSECTIONS", "getCOMMENT_INTERSECTIONS", "COMMENT_INCONSISTENCY", "getCOMMENT_INCONSISTENCY", "hasCommentInconsistency", "", "currentMap", "", "", "Lcom/intellij/lang/properties/merge/data/PropertyInfo;", "baseMap", "oppositeMap", "hasCommentIntersections", "conflictRange", "Lcom/intellij/openapi/util/TextRange;", "map", "getConflictPropertyMaps", "", "holder", "Lcom/intellij/lang/properties/merge/ThreeSideConflictInfoHolder;", "index", "", "opposite", "Lcom/intellij/diff/util/ThreeSide;", "hasOutsideIntersection", "oppositeSide", "intellij.properties.backend"})
@SourceDebugExtension(value={"SMAP\nfilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 filters.kt\ncom/intellij/lang/properties/merge/FiltersKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n193#2,3:181\n193#2,3:187\n193#2,3:193\n1807#3,3:184\n1807#3,3:190\n1807#3,3:196\n1807#3,3:199\n*S KotlinDebug\n*F\n+ 1 filters.kt\ncom/intellij/lang/properties/merge/FiltersKt\n*L\n131#1:181,3\n176#1:187,3\n72#1:193,3\n144#1:184,3\n41#1:190,3\n97#1:196,3\n123#1:199,3\n*E\n"})
public final class FiltersKt {
    @NotNull
    private static final Filter OUTSIDE_INTERSECTIONS = FiltersKt::OUTSIDE_INTERSECTIONS$lambda$0;
    @NotNull
    private static final Filter INNER_INCONSISTENCY = FiltersKt::INNER_INCONSISTENCY$lambda$0;
    @NotNull
    private static final Filter COMMENT_INTERSECTIONS = FiltersKt::COMMENT_INTERSECTIONS$lambda$0;
    @NotNull
    private static final Filter COMMENT_INCONSISTENCY = FiltersKt::COMMENT_INCONSISTENCY$lambda$0;

    @NotNull
    public static final Filter getOUTSIDE_INTERSECTIONS() {
        return OUTSIDE_INTERSECTIONS;
    }

    @NotNull
    public static final Filter getINNER_INCONSISTENCY() {
        return INNER_INCONSISTENCY;
    }

    @NotNull
    public static final Filter getCOMMENT_INTERSECTIONS() {
        return COMMENT_INTERSECTIONS;
    }

    @NotNull
    public static final Filter getCOMMENT_INCONSISTENCY() {
        return COMMENT_INCONSISTENCY;
    }

    private static final boolean hasCommentInconsistency(Map<String, PropertyInfo> currentMap, Map<String, PropertyInfo> baseMap, Map<String, PropertyInfo> oppositeMap) {
        boolean bl;
        block4: {
            Map<String, PropertyInfo> $this$any$iv = currentMap;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<String, PropertyInfo>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, PropertyInfo> element$iv;
                    Map.Entry<String, PropertyInfo> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    String key = entry.getKey();
                    PropertyInfo currentInfo = entry.getValue();
                    PropertyInfo baseInfo = baseMap.get(key);
                    PropertyInfo oppositeInfo = oppositeMap.get(key);
                    if (baseInfo == null || oppositeInfo == null) {
                        return false;
                    }
                    String currentComment = currentInfo.getComment();
                    String baseComment = baseInfo.getComment();
                    String oppositeComment = oppositeInfo.getComment();
                    if (!(baseComment != null && (currentComment == null && oppositeComment != null || currentComment != null && oppositeComment == null))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean hasCommentIntersections(TextRange conflictRange, Map<?, PropertyInfo> map) {
        boolean bl;
        block5: {
            Iterable $this$any$iv = map.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    PropertyInfo info = (PropertyInfo)element$iv;
                    boolean bl3 = false;
                    if (info.getBorderElement() instanceof PsiComment && !conflictRange.contains(((PsiComment)info.getBorderElement()).getTextRange())) {
                        bl2 = true;
                    } else {
                        Ref.BooleanRef hasCommentOutsideOfRange = new Ref.BooleanRef();
                        PsiTreeUtil.findSiblingBackward((PsiElement)info.getBorderElement(), (IElementType)PropertiesElementTypes.PROPERTY_TYPE, (boolean)true, arg_0 -> FiltersKt.hasCommentIntersections$lambda$0$1(arg_0 -> FiltersKt.hasCommentIntersections$lambda$0$0(hasCommentOutsideOfRange, conflictRange, arg_0), arg_0));
                        bl2 = hasCommentOutsideOfRange.element;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final List<Map<String, PropertyInfo>> getConflictPropertyMaps(ThreeSideConflictInfoHolder holder, int index) {
        Map<String, PropertyInfo> leftMap = holder.conflictToPropertiesMap(ThreeSide.LEFT).getOrDefault(index, MapsKt.emptyMap());
        Map<String, PropertyInfo> baseMap = holder.conflictToPropertiesMap(ThreeSide.BASE).getOrDefault(index, MapsKt.emptyMap());
        Map<String, PropertyInfo> rightMap = holder.conflictToPropertiesMap(ThreeSide.RIGHT).getOrDefault(index, MapsKt.emptyMap());
        Object[] objectArray = new Map[]{leftMap, baseMap, rightMap};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final ThreeSide opposite(ThreeSide $this$opposite) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$opposite.ordinal()]) {
            case 1 -> ThreeSide.RIGHT;
            case 2 -> ThreeSide.BASE;
            case 3 -> ThreeSide.LEFT;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final boolean hasOutsideIntersection(Map<String, ?> currentMap, Map<String, ?> baseMap, Map<String, ?> oppositeMap, ThreeSideConflictInfoHolder holder, ThreeSide oppositeSide) {
        boolean bl;
        block3: {
            Map<String, ?> $this$any$iv = currentMap;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<String, ?>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, ?> element$iv;
                    Map.Entry<String, ?> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    String key = entry.getKey();
                    if (!(!oppositeMap.containsKey(key) && holder.keySet(oppositeSide).contains(key) || !baseMap.containsKey(key) && holder.keySet(ThreeSide.BASE).contains(key))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean OUTSIDE_INTERSECTIONS$lambda$0(ThreeSideConflictInfoHolder holder, int index) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            List<Map<String, PropertyInfo>> mapList = FiltersKt.getConflictPropertyMaps(holder, index);
            Iterable $this$any$iv = (Iterable)ThreeSide.getEntries();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    ThreeSide side = (ThreeSide)element$iv;
                    boolean bl3 = false;
                    if (ThreeSide.BASE == side) {
                        bl2 = false;
                    } else {
                        ThreeSide oppositeSide = FiltersKt.opposite(side);
                        bl2 = FiltersKt.hasOutsideIntersection((Map)side.selectNotNull(mapList), mapList.get(1), (Map)oppositeSide.selectNotNull(mapList), holder, oppositeSide);
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean INNER_INCONSISTENCY$lambda$0(ThreeSideConflictInfoHolder holder, int index) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            List<Map<String, PropertyInfo>> list = FiltersKt.getConflictPropertyMaps(holder, index);
            Map<String, PropertyInfo> leftMap = list.get(0);
            Map<String, PropertyInfo> baseMap = list.get(1);
            Map<String, PropertyInfo> rightMap = list.get(2);
            Map<String, PropertyInfo> $this$any$iv = baseMap;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<String, PropertyInfo>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, PropertyInfo> element$iv;
                    Map.Entry<String, PropertyInfo> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    String key = entry.getKey();
                    if (!(leftMap.containsKey(key) && !rightMap.containsKey(key) || !leftMap.containsKey(key) && rightMap.containsKey(key))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean COMMENT_INTERSECTIONS$lambda$0(ThreeSideConflictInfoHolder holder, int index) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Iterable $this$any$iv = (Iterable)ThreeSide.getEntries();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    ThreeSide it = (ThreeSide)element$iv;
                    boolean bl3 = false;
                    if (ThreeSide.BASE == it) {
                        bl2 = false;
                    } else {
                        List<TextRange> rangeList = holder.rangeList(it);
                        Map<String, PropertyInfo> conflictToPropertiesMap = holder.conflictToPropertiesMap(it).getOrDefault(index, MapsKt.emptyMap());
                        bl2 = FiltersKt.hasCommentIntersections(rangeList.get(index), conflictToPropertiesMap);
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean COMMENT_INCONSISTENCY$lambda$0(ThreeSideConflictInfoHolder holder, int index) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            List<Map<String, PropertyInfo>> mapList = FiltersKt.getConflictPropertyMaps(holder, index);
            Iterable $this$any$iv = (Iterable)ThreeSide.getEntries();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    ThreeSide side = (ThreeSide)element$iv;
                    boolean bl3 = false;
                    if (ThreeSide.BASE == side) {
                        bl2 = false;
                    } else {
                        ThreeSide oppositeSide = FiltersKt.opposite(side);
                        bl2 = FiltersKt.hasCommentInconsistency((Map)side.selectNotNull(mapList), mapList.get(1), (Map)oppositeSide.selectNotNull(mapList));
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Unit hasCommentIntersections$lambda$0$0(Ref.BooleanRef $hasCommentOutsideOfRange, TextRange $conflictRange, PsiElement element) {
        if (!$hasCommentOutsideOfRange.element && !(element instanceof PsiWhiteSpace) && element.getTextRange().intersects($conflictRange)) {
            $hasCommentOutsideOfRange.element = true;
        }
        return Unit.INSTANCE;
    }

    private static final void hasCommentIntersections$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreeSide.values().length];
            try {
                nArray[ThreeSide.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeSide.BASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeSide.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

