/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.scale.AbstractScaleContextAware;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.ScaleType;
import com.intellij.ui.scale.Scaler;
import com.intellij.ui.scale.UserScaleContext;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class JBScalableIcon
extends AbstractScaleContextAware<UserScaleContext>
implements ScalableIcon {
    private final Scaler scaler;
    private boolean autoUpdateScaleContext;

    public JBScalableIcon() {
        super(UserScaleContext.create());
        this.scaler = new Scaler(){

            @Override
            protected double currentScale() {
                if (JBScalableIcon.this.autoUpdateScaleContext) {
                    ((UserScaleContext)JBScalableIcon.this.getScaleContext()).update();
                }
                return JBScalableIcon.this.getScale(ScaleType.USR_SCALE);
            }
        };
        this.autoUpdateScaleContext = true;
    }

    protected JBScalableIcon(@NotNull JBScalableIcon icon) {
        if (icon == null) {
            JBScalableIcon.$$$reportNull$$$0(0);
        }
        this();
        this.updateContextFrom(icon);
    }

    protected final void updateContextFrom(@NotNull JBScalableIcon icon) {
        if (icon == null) {
            JBScalableIcon.$$$reportNull$$$0(1);
        }
        this.updateScaleContext((UserScaleContext)icon.getScaleContext());
        this.scaler.update(icon.scaler);
        this.autoUpdateScaleContext = icon.autoUpdateScaleContext;
    }

    protected boolean isIconPreScaled() {
        return this.scaler.isPreScaled();
    }

    protected void setIconPreScaled(boolean preScaled) {
        this.scaler.setPreScaled(preScaled);
    }

    @NotNull
    public JBScalableIcon withIconPreScaled(boolean preScaled) {
        this.setIconPreScaled(preScaled);
        JBScalableIcon jBScalableIcon = this;
        if (jBScalableIcon == null) {
            JBScalableIcon.$$$reportNull$$$0(2);
        }
        return jBScalableIcon;
    }

    protected void setAutoUpdateScaleContext(boolean autoUpdate) {
        this.autoUpdateScaleContext = autoUpdate;
    }

    public float getScale() {
        return (float)this.getScale(ScaleType.OBJ_SCALE);
    }

    @NotNull
    public Icon scale(float scale) {
        this.setScale(ScaleType.OBJ_SCALE.of(scale));
        JBScalableIcon jBScalableIcon = this;
        if (jBScalableIcon == null) {
            JBScalableIcon.$$$reportNull$$$0(3);
        }
        return jBScalableIcon;
    }

    protected double scaleVal(double value) {
        return this.scaleVal(value, DerivedScaleType.PIX_SCALE);
    }

    /*
     * WARNING - void declaration
     */
    protected double scaleVal(double value, @NotNull ScaleType scaleType) {
        void type;
        if (scaleType == null) {
            JBScalableIcon.$$$reportNull$$$0(4);
        }
        return switch (2.$SwitchMap$com$intellij$ui$scale$ScaleType[type.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> this.scaler.scaleVal(value);
            case 2 -> value * this.getScale(ScaleType.SYS_SCALE);
            case 3 -> value * this.getScale(ScaleType.OBJ_SCALE);
        };
    }

    /*
     * WARNING - void declaration
     */
    protected double scaleVal(double value, @NotNull DerivedScaleType derivedScaleType) {
        void type;
        if (derivedScaleType == null) {
            JBScalableIcon.$$$reportNull$$$0(5);
        }
        return switch (2.$SwitchMap$com$intellij$ui$scale$DerivedScaleType[type.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> value * this.getScale(DerivedScaleType.DEV_SCALE);
            case 2, 3 -> this.scaler.scaleVal(value) * this.getScale(ScaleType.OBJ_SCALE);
        };
    }

    public String toString() {
        return this.getClass().getName() + " " + this.getIconWidth() + "x" + this.getIconHeight();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/JBScalableIcon";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/JBScalableIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withIconPreScaled";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "scale";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateContextFrom";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "scaleVal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

