/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.NlsSafe;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum UnixDesktopEnv {
    BUDGIE("Budgie:GNOME", "budgie-desktop"),
    CINNAMON("X-Cinnamon", "cinnamon"),
    DEEPIN("Deepin", "dde-desktop"),
    GNOME("GNOME", "gnome-shell"),
    HYPRLAND("Hyprland", "hyprctl", "version"),
    KDE("KDE", "plasmashell"),
    LXDE("LXDE", "lxsession"),
    LXQT("LXQt", "lxqt-session"),
    MATE("MATE", "mate-session"),
    PANTHEON("Pantheon", "gala"),
    UNITY("Unity", "unity"),
    XFCE("XFCE", "xfce4-session"),
    I3("i3", "i3"),
    SWAY("sway", "sway");

    @Nullable
    public static final UnixDesktopEnv CURRENT;
    private final String myXdgDesktopSubstring;
    private final String myVersionTool;
    private final String myVersionArg;

    private UnixDesktopEnv(String xdgDesktopSubstring, String versionTool) {
        this(xdgDesktopSubstring, versionTool, "--version");
    }

    private UnixDesktopEnv(String xdgDesktopSubstring, String versionTool, String versionArg) {
        this.myXdgDesktopSubstring = xdgDesktopSubstring;
        this.myVersionTool = versionTool;
        this.myVersionArg = versionArg;
    }

    @NotNull
    @NlsSafe
    public String getPresentableName() {
        if (this == BUDGIE) {
            return "Budgie";
        }
        if (this == CINNAMON) {
            return "Cinnamon";
        }
        String string = this.myXdgDesktopSubstring;
        if (string == null) {
            UnixDesktopEnv.$$$reportNull$$$0(0);
        }
        return string;
    }

    @ApiStatus.Internal
    @NotNull
    public List<String> getVersionCommand() {
        List<String> list = List.of(this.myVersionTool, this.myVersionArg);
        if (list == null) {
            UnixDesktopEnv.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    private static UnixDesktopEnv getDesktop() {
        String desktop = System.getenv("XDG_CURRENT_DESKTOP");
        String gdmSession = System.getenv("GDMSESSION");
        ArrayList<UnixDesktopEnv> knownEnvironments = new ArrayList<UnixDesktopEnv>(List.of(UnixDesktopEnv.values()));
        knownEnvironments.sort(Comparator.comparing(it -> -it.myXdgDesktopSubstring.length()));
        for (UnixDesktopEnv env : knownEnvironments) {
            if (desktop == null || !desktop.contains(env.myXdgDesktopSubstring)) continue;
            return env;
        }
        if (gdmSession != null && gdmSession.contains("gnome")) {
            return GNOME;
        }
        if (System.getenv("KDE_FULL_SESSION") != null) {
            return KDE;
        }
        return null;
    }

    static {
        CURRENT = UnixDesktopEnv.getDesktop();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/ui/UnixDesktopEnv";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionCommand";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

