/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.columns;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.DataFrameGetKt;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnGroup;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.ColumnResolutionContext;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.impl.DataFrameImpl;
import org.jetbrains.kotlinx.dataframe.impl.RenderingKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.ColumnGroupImplKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.ColumnGroupWithParent;
import org.jetbrains.kotlinx.dataframe.impl.columns.DataColumnGroup;
import org.jetbrains.kotlinx.dataframe.impl.columns.DataColumnInternal;
import org.jetbrains.kotlinx.dataframe.impl.columns.ResolvingColumnGroup;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0005B\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0014\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u0018\u001a\u00020\u000fH\u0096\u0002J#\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0019\u001a\u00020\u000f2\n\u0010\u001a\u001a\u00020\u001b\"\u00020\u000fH\u0096\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u001d\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\rH\u0096\u0002J \u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0016J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020\u000fH\u0002J\b\u0010*\u001a\u00020\u000fH\u0016J\b\u0010/\u001a\u00020\u0007H\u0016J\u0010\u00100\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\"\u00101\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000403022\u0006\u00104\u001a\u000205H\u0016J\u001e\u00106\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0018\u0001032\u0006\u00104\u001a\u000205H\u0016J\u0015\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000408H\u0096\u0002J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00028\u00000:H\u0016J\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010;\u001a\u00020<H\u0096\u0002J\u0019\u0010\u0017\u001a\n\u0012\u0002\b\u00030\"j\u0002`=2\u0006\u0010>\u001a\u00020\u0007H\u0096\u0002J\u0017\u0010?\u001a\u00020&2\f\u0010@\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0096\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010*\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b+\u0010,\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/columns/ColumnGroupImpl;", "T", "Lorg/jetbrains/kotlinx/dataframe/impl/DataFrameImpl;", "Lorg/jetbrains/kotlinx/dataframe/impl/columns/DataColumnInternal;", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "Lorg/jetbrains/kotlinx/dataframe/impl/columns/DataColumnGroup;", "name", "", "df", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlinx/dataframe/DataFrame;)V", "values", "", "countDistinct", "", "type", "Lkotlin/reflect/KType;", "distinct", "Lkotlin/Lazy;", "", "toSet", "size", "get", "index", "firstIndex", "otherIndices", "", "rename", "newName", "defaultValue", "", "indices", "addParent", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "parent", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnGroup;", "equals", "", "other", "", "computeHashCode", "hashCode", "getHashCode", "()I", "hashCode$delegate", "Lkotlin/Lazy;", "toString", "changeType", "resolve", "", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "context", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnResolutionContext;", "resolveSingle", "iterator", "", "forceResolve", "Lorg/jetbrains/kotlinx/dataframe/impl/columns/ResolvingColumnGroup;", "range", "Lkotlin/ranges/IntRange;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "columnName", "contains", "value", "core"})
@SourceDebugExtension(value={"SMAP\nColumnGroupImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnGroupImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/columns/ColumnGroupImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 first.kt\norg/jetbrains/kotlinx/dataframe/api/FirstKt\n*L\n1#1,114:1\n1563#2:115\n1634#2,3:116\n295#2:120\n296#2:122\n57#3:119\n58#3:121\n59#3:123\n*S KotlinDebug\n*F\n+ 1 ColumnGroupImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/columns/ColumnGroupImpl\n*L\n70#1:115\n70#1:116,3\n89#1:120\n89#1:122\n89#1:119\n89#1:121\n89#1:123\n*E\n"})
public class ColumnGroupImpl<T>
extends DataFrameImpl<T>
implements DataColumnInternal<DataRow<? extends T>>,
DataColumnGroup<T> {
    @NotNull
    private final String name;
    @NotNull
    private final Lazy<Set<DataRow<T>>> distinct;
    @NotNull
    private final Lazy hashCode$delegate;

    public ColumnGroupImpl(@NotNull String name, @NotNull DataFrame<? extends T> df2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(df2, (String)"df");
        super(df2.columns(), DataFrameKt.getNrow(df2));
        this.name = name;
        this.distinct = LazyKt.lazy(() -> ColumnGroupImpl.distinct$lambda$0(df2));
        this.hashCode$delegate = LazyKt.lazy(() -> ColumnGroupImpl.hashCode_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public Iterable<DataRow<T>> values() {
        return DataFrameGetKt.rows(this);
    }

    @Override
    public int countDistinct() {
        return ((Set)this.distinct.getValue()).size();
    }

    @Override
    @NotNull
    public KType type() {
        return ColumnGroupImplKt.getAnyRowType();
    }

    @Override
    @NotNull
    public Set<DataRow<T>> toSet() {
        return (Set)this.distinct.getValue();
    }

    @Override
    public int size() {
        return this.rowsCount();
    }

    @Override
    @NotNull
    public DataRow<T> get(int index) {
        return super.get(index);
    }

    @Override
    @NotNull
    public ColumnGroupImpl<T> get(int firstIndex, int ... otherIndices) {
        Intrinsics.checkNotNullParameter((Object)otherIndices, (String)"otherIndices");
        return new ColumnGroupImpl(this.name, super.get(firstIndex, Arrays.copyOf(otherIndices, otherIndices.length)));
    }

    @Override
    @NotNull
    public ColumnGroupImpl<T> rename(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return Intrinsics.areEqual((Object)newName, (Object)this.name) ? this : new ColumnGroupImpl<T>(newName, this);
    }

    @Override
    @Nullable
    public Void defaultValue() {
        return null;
    }

    @Override
    @NotNull
    public ColumnGroupImpl<T> get(@NotNull Iterable<Integer> indices) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        return new ColumnGroupImpl(this.name, super.get(indices));
    }

    @Override
    @NotNull
    public DataColumn<DataRow<T>> addParent(@NotNull ColumnGroup<?> parent) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        return new ColumnGroupWithParent((ColumnReference)parent, this);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        ColumnGroup columnGroup = other instanceof ColumnGroup ? (ColumnGroup)other : null;
        if (columnGroup == null) {
            return false;
        }
        ColumnGroup g = columnGroup;
        return Intrinsics.areEqual((Object)this.name, (Object)g.name()) && Intrinsics.areEqual(this.getColumns(), ((ColumnGroup)other).columns());
    }

    private final int computeHashCode() {
        return this.name.hashCode() * 31 + super.hashCode();
    }

    private final int getHashCode() {
        Lazy lazy = this.hashCode$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @Override
    public int hashCode() {
        return this.getHashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.name + ": {" + RenderingKt.renderSchema(this) + '}';
    }

    @NotNull
    public Void changeType(@NotNull KType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ColumnGroupImpl<T> distinct() {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = (Iterable)this.distinct.getValue();
        ColumnGroupImpl columnGroupImpl = this;
        String string = this.name;
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DataRow dataRow = (DataRow)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.index());
        }
        collection = (List)destination$iv$iv;
        DataFrame dataFrame = columnGroupImpl.get(collection);
        String string2 = string;
        return new ColumnGroupImpl<T>(string2, dataFrame);
    }

    @Override
    @NotNull
    public List<ColumnWithPath<DataRow<T>>> resolve(@NotNull ColumnResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return DataColumnInternal.super.resolve(context);
    }

    @Override
    @Nullable
    public ColumnWithPath<DataRow<T>> resolveSingle(@NotNull ColumnResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return DataColumnInternal.super.resolveSingle(context);
    }

    @Override
    @NotNull
    public Iterator<DataRow<T>> iterator() {
        return super.iterator();
    }

    @Override
    @NotNull
    public ResolvingColumnGroup<T> forceResolve() {
        return new ResolvingColumnGroup(this);
    }

    @Override
    @NotNull
    public ColumnGroupImpl<T> get(@NotNull IntRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return new ColumnGroupImpl(this.name, super.get(range));
    }

    @Override
    @NotNull
    public DataColumn<?> get(@NotNull String columnName) {
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        return DataFrameGetKt.getColumn((ColumnsContainer)this, columnName);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(@NotNull DataRow<? extends T> value) {
        boolean bl;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (this.distinct.isInitialized()) {
            bl = ((Set)this.distinct.getValue()).contains(value);
        } else {
            DataRow dataRow;
            block3: {
                DataFrame $this$firstOrNull$iv = TypeConversionsKt.asColumnGroupUntyped(this);
                boolean $i$f$firstOrNull = false;
                Iterable $this$firstOrNull$iv$iv = DataFrameGetKt.rows($this$firstOrNull$iv);
                boolean $i$f$firstOrNull2 = false;
                Iterator iterator2 = $this$firstOrNull$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    DataRow element$iv$iv;
                    DataRow it$iv = element$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    DataRow dataRow2 = it$iv;
                    DataRow $this$contains_u24lambda_u240 = it$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it, value)) continue;
                    dataRow = element$iv$iv;
                    break block3;
                }
                dataRow = null;
            }
            bl = (DataRow)dataRow != null;
        }
        return bl;
    }

    private static final Set distinct$lambda$0(DataFrame $df) {
        return CollectionsKt.toSet(DataFrameGetKt.rows($df));
    }

    private static final int hashCode_delegate$lambda$0(ColumnGroupImpl this$0) {
        return this$0.computeHashCode();
    }
}

