/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.weighers;

import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.proximity.ReferenceListWeigher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public final class GrReferenceListWeigher
extends ReferenceListWeigher {
    private static final PsiElementPattern.Capture<PsiElement> INSIDE_REFERENCE_LIST = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withParents(new Class[]{GrCodeReferenceElement.class, GrReferenceList.class});

    protected ReferenceListWeigher.Preference getPreferredCondition(@NotNull PsiElement position) {
        if (position == null) {
            GrReferenceListWeigher.$$$reportNull$$$0(0);
        }
        if (INSIDE_REFERENCE_LIST.accepts((Object)position)) {
            GrReferenceList list = (GrReferenceList)position.getParent().getParent();
            PsiElement parent = list.getParent();
            if (parent instanceof GrTypeDefinition) {
                GrTypeDefinition cls = (GrTypeDefinition)parent;
                if (cls.isInterface() && list == cls.getExtendsClause() || list == cls.getImplementsClause()) {
                    return ReferenceListWeigher.Preference.Interfaces;
                }
                if (list == cls.getExtendsClause()) {
                    return ReferenceListWeigher.Preference.Classes;
                }
            }
            if (parent instanceof GrMethod && ((GrMethod)parent).getThrowsList() == list) {
                return ReferenceListWeigher.Preference.Exceptions;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/groovy/lang/completion/weighers/GrReferenceListWeigher", "getPreferredCondition"));
    }
}

