/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopBundle;
import com.intellij.aop.AopIntroduction;
import com.intellij.aop.IntroductionManipulator;
import com.intellij.aop.jam.JamAopModel;
import com.intellij.aop.psi.AopPointcutExpressionFile;
import com.intellij.aop.psi.AopPointcutExpressionHolder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public final class DeclareParentsInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Module module;
        if (holder == null) {
            DeclareParentsInspection.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile())) == null || !JamAopModel.isAopAvailable(module)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                DeclareParentsInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof PsiLiteralExpression || element instanceof XmlAttributeValue) {
                    PsiFile file = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)element.getContainingFile(), (int)(element.getTextRange().getStartOffset() + 1));
                    if (file instanceof AopPointcutExpressionFile) {
                        this.process((AopPointcutExpressionHolder)file, element instanceof XmlElement);
                    }
                } else if (element instanceof AopPointcutExpressionHolder && !(element instanceof AopPointcutExpressionFile)) {
                    this.process((AopPointcutExpressionHolder)element, false);
                }
            }

            private void process(AopPointcutExpressionHolder file, boolean isXml) {
                final IntroductionManipulator manipulator = file.getAopModel().getIntroductionManipulator();
                if (manipulator == null) {
                    return;
                }
                AopIntroduction introduction = manipulator.getIntroduction();
                if (introduction == null) {
                    return;
                }
                PsiClass intf = (PsiClass)introduction.getImplementInterface().getValue();
                if (intf == null && introduction.getImplementInterface().getStringValue() != null || intf != null && !intf.isInterface()) {
                    DeclareParentsInspection.registerProblem(manipulator.getInterfaceElement(), AopBundle.message("error.interface.expected", new Object[0]), holder);
                    return;
                }
                if (intf == null) {
                    return;
                }
                PsiClass defaultImpl = (PsiClass)introduction.getDefaultImpl().getValue();
                if (defaultImpl == null) {
                    if (!isXml && !ContainerUtil.findAll((Object[])intf.getAllMethods(), method -> method.hasModifierProperty("abstract")).isEmpty()) {
                        holder.registerProblem(manipulator.getCommonProblemElement(), AopBundle.message("error.default.implementation.class.should.be.specified", new Object[0]), new LocalQuickFix[]{new LocalQuickFix(){

                            @NotNull
                            public String getFamilyName() {
                                String string = AopBundle.message("quickfix.name.define.attribute", manipulator.getDefaultImplAttributeName());
                                if (string == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return string;
                            }

                            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                                if (project == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                if (descriptor == null) {
                                    1.$$$reportNull$$$0(2);
                                }
                                try {
                                    manipulator.defineDefaultImpl(project, descriptor);
                                }
                                catch (IncorrectOperationException e) {
                                    Logger.getInstance(DeclareParentsInspection.class).error((Throwable)e);
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2;
                                Object[] objectArray3 = new Object[switch (n) {
                                    default -> 2;
                                    case 1, 2 -> 3;
                                }];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "com/intellij/aop/jam/DeclareParentsInspection$1$1";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "project";
                                        break;
                                    }
                                    case 2: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "descriptor";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "getFamilyName";
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "com/intellij/aop/jam/DeclareParentsInspection$1$1";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        objectArray = objectArray;
                                        objectArray[2] = "applyFix";
                                        break;
                                    }
                                }
                                String string = String.format(v0, objectArray);
                                throw switch (n) {
                                    default -> new IllegalStateException(string);
                                    case 1, 2 -> new IllegalArgumentException(string);
                                };
                            }
                        }});
                    }
                    return;
                }
                if (defaultImpl.hasModifierProperty("abstract") || !defaultImpl.isInheritor(intf, true)) {
                    PsiElement defaultImplElement = manipulator.getDefaultImplElement();
                    assert (defaultImplElement != null);
                    DeclareParentsInspection.registerProblem(defaultImplElement, AopBundle.message("error.non.abstract.class.implemention.0.expected", intf.getQualifiedName()), holder);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/aop/jam/DeclareParentsInspection$1", "visitElement"));
            }
        };
    }

    private static void registerProblem(PsiElement element, @InspectionMessage String descriptionTemplate, ProblemsHolder holder) {
        int quotes = element.getText().startsWith("\"") ? 1 : 0;
        TextRange range = TextRange.from((int)quotes, (int)Math.max(element.getTextLength() - 2 * quotes, 1));
        holder.registerProblem(holder.getManager().createProblemDescriptor(element, range, descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, holder.isOnTheFly(), new LocalQuickFix[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/aop/jam/DeclareParentsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/aop/jam/DeclareParentsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

