/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.style;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssOneLineStatement;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.fixes.CssInsertMissingSemicolonQuickFix;
import org.jetbrains.annotations.NotNull;

public final class CssMissingSemicolonInspection
extends CssBaseInspection {
    private static final LocalQuickFix localFix = new CssInsertMissingSemicolonQuickFix();

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            CssMissingSemicolonInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssMissingSemicolonInspection.$$$reportNull$$$0(1);
        }
        return new CssElementVisitor(){

            @Override
            public void visitCssDeclaration(CssDeclaration declaration) {
                super.visitCssDeclaration(declaration);
                CssOneLineStatement oneLineStatement = CssUtil.findOneLineStatement(declaration);
                if (CssUtil.isSemicolonMissing(oneLineStatement)) {
                    holder.registerProblem((PsiElement)oneLineStatement, CssBundle.message("css.inspections.missing.semicolon.name", new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{localFix});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/style/CssMissingSemicolonInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/style/CssMissingSemicolonInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

