/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.completion.AxisLookup;
import org.intellij.lang.xpath.completion.FunctionLookup;
import org.intellij.lang.xpath.completion.NamespaceLookup;
import org.intellij.lang.xpath.completion.NodeLookup;
import org.intellij.lang.xpath.completion.VariableLookup;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.context.NamespaceContext;
import org.intellij.lang.xpath.context.VariableContext;
import org.intellij.lang.xpath.context.XPathVersion;
import org.intellij.lang.xpath.psi.PrefixedName;
import org.intellij.lang.xpath.psi.QNameElement;
import org.intellij.lang.xpath.psi.XPathAxisSpecifier;
import org.intellij.lang.xpath.psi.XPathElement;
import org.intellij.lang.xpath.psi.XPathLocationPath;
import org.intellij.lang.xpath.psi.XPathNodeTest;
import org.intellij.lang.xpath.psi.XPathToken;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.XPathVariable;
import org.jetbrains.annotations.NotNull;

public final class CompletionLists {
    public static final String INTELLIJ_IDEA_RULEZ = "IntellijIdeaRulezzz";
    public static final Set<String> NODE_TYPE_FUNCS = Set.of("text", "node", "comment", "processing-instruction");
    public static final Set<String> NODE_TYPE_FUNCS_V2 = Set.of("text", "node", "comment", "processing-instruction", "attribute", "element", "schema-element", "schema-attribute", "document-node");
    public static final Set<String> OPERATORS = Set.of("mul", "div", "and", "or");
    public static final Set<String> AXIS_NAMES = Set.of("ancestor", "ancestor-or-self", "attribute", "child", "descendant", "descendant-or-self", "following", "following-sibling", "namespace", "parent", "preceding", "preceding-sibling", "self");
    private static final Function<String, LookupElement> FUNCTION_MAPPING = s -> {
        if (s.equals("processing-instruction")) {
            return new FunctionLookup((String)s, s + "(pi-target?)");
        }
        return new FunctionLookup((String)s, s + "()");
    };

    private CompletionLists() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection<LookupElement> getFunctionCompletions(XPathElement element) {
        String uri;
        XPathFile xpathFile = (XPathFile)element.getContainingFile();
        ContextProvider contextProvider = ContextProvider.getContextProvider((PsiFile)xpathFile);
        NamespaceContext nsContext = contextProvider.getNamespaceContext();
        PrefixedName qn = null;
        if (element instanceof QNameElement) {
            qn = ((QNameElement)element).getQName();
            if (qn != null) {
                QName qName = contextProvider.getQName(qn, element);
                if (qn.getPrefix() != null) {
                    if (qName == null) return Collections.emptySet();
                    uri = qName.getNamespaceURI();
                } else {
                    uri = null;
                }
            } else {
                uri = null;
            }
        } else {
            uri = null;
        }
        Map<Pair<QName, Integer>, ? extends org.intellij.lang.xpath.context.functions.Function> functions = contextProvider.getFunctionContext().getFunctions();
        ArrayList<LookupElement> lookups = new ArrayList<LookupElement>(functions.size());
        for (Map.Entry<Pair<QName, Integer>, ? extends org.intellij.lang.xpath.context.functions.Function> entry : functions.entrySet()) {
            String p;
            org.intellij.lang.xpath.context.functions.Function functionDecl = entry.getValue();
            QName f = (QName)entry.getKey().first;
            if (nsContext != null) {
                String prefixForURI;
                String namespaceURI = f.getNamespaceURI();
                if (uri != null && !namespaceURI.equals(uri) || (prefixForURI = nsContext.getPrefixForURI(namespaceURI, (XmlElement)PsiTreeUtil.getContextOfType((PsiElement)element, XmlElement.class, (boolean)true))) == null && !namespaceURI.isEmpty()) continue;
                p = qn == null || qn.getPrefix() == null ? CompletionLists.makePrefix(prefixForURI) : "";
            } else {
                p = "";
            }
            lookups.add(FunctionLookup.newFunctionLookup(p + f.getLocalPart(), functionDecl));
        }
        return lookups;
    }

    public static Collection<LookupElement> getVariableCompletions(XPathElement reference) {
        ContextProvider contextProvider = ContextProvider.getContextProvider(reference);
        VariableContext resolver = contextProvider.getVariableContext();
        if (resolver != null) {
            VarType[] variablesInScope = resolver.getVariablesInScope(reference);
            ArrayList<LookupElement> lookups = new ArrayList<LookupElement>(variablesInScope.length);
            for (Object o : variablesInScope) {
                if (o instanceof PsiNamedElement) {
                    XPathType t;
                    String type = o instanceof XPathVariable ? ((t = ((XPathVariable)o).getType()) != XPathType.UNKNOWN ? t.getName() : "") : "";
                    String name = ((PsiNamedElement)o).getName();
                    lookups.add(new VariableLookup("$" + name, type, ((PsiNamedElement)o).getIcon(0), (PsiElement)o));
                    continue;
                }
                lookups.add(new VariableLookup("$" + String.valueOf(o), IconManager.getInstance().getPlatformIcon(PlatformIcons.Variable)));
            }
            return lookups;
        }
        return Collections.emptySet();
    }

    public static Collection<LookupElement> getNodeTestCompletions(XPathNodeTest element) {
        if (!element.isNameTest()) {
            return Collections.emptyList();
        }
        PrefixedName prefixedName = element.getQName();
        assert (prefixedName != null);
        String canonicalText = prefixedName.toString();
        String suffix = canonicalText.substring(canonicalText.indexOf(INTELLIJ_IDEA_RULEZ));
        XPathAxisSpecifier axisSpecifier = element.getStep().getAxisSpecifier();
        ContextProvider contextProvider = ContextProvider.getContextProvider(element);
        XmlElement context = contextProvider.getContextElement();
        boolean insidePrefix = suffix.contains("IntellijIdeaRulezzz:");
        HashSet<LookupElement> list = new HashSet<LookupElement>();
        CompletionLists.addNameCompletions(contextProvider, element, list);
        String namespacePrefix = prefixedName.getPrefix();
        if (namespacePrefix == null || insidePrefix) {
            CompletionLists.addNamespaceCompletions(contextProvider.getNamespaceContext(), list, context);
        }
        XPathNodeTest.PrincipalType principalType = CompletionLists.addContextNames(element, contextProvider, prefixedName, list);
        if (namespacePrefix == null && !insidePrefix) {
            if (axisSpecifier == null || axisSpecifier.isDefaultAxis()) {
                boolean check;
                list.addAll(CompletionLists.getAxisCompletions());
                PsiElement sibling = element.getParent().getPrevSibling();
                while (sibling instanceof PsiWhiteSpace) {
                    sibling = sibling.getPrevSibling();
                }
                boolean bl = check = sibling != null;
                if (!check) {
                    XPathLocationPath lp = null;
                    while ((lp = (XPathLocationPath)PsiTreeUtil.getParentOfType((PsiElement)(lp == null ? element : lp), XPathLocationPath.class, (boolean)true)) != null && lp.getPrevSibling() == null) {
                    }
                    if (lp != null) {
                        sibling = lp.getPrevSibling();
                    }
                }
                if (!(sibling instanceof XPathToken) || !XPathTokenTypes.PATH_OPS.contains(((XPathToken)sibling).getTokenType())) {
                    list.addAll(CompletionLists.getFunctionCompletions(element));
                    list.addAll(CompletionLists.getVariableCompletions(element));
                }
            }
            if (principalType == XPathNodeTest.PrincipalType.ELEMENT && prefixedName.getPrefix() == null) {
                list.addAll(CompletionLists.getNodeTypeCompletions(element));
            }
        }
        return list;
    }

    private static XPathNodeTest.PrincipalType addContextNames(XPathNodeTest element, ContextProvider contextProvider, PrefixedName prefixedName, Set<? super LookupElement> list) {
        XPathNodeTest.PrincipalType principalType;
        block6: {
            Set<QName> attributeNames;
            XmlElement context;
            NamespaceContext namespaceContext;
            block5: {
                namespaceContext = contextProvider.getNamespaceContext();
                context = contextProvider.getContextElement();
                principalType = element.getPrincipalType();
                if (principalType != XPathNodeTest.PrincipalType.ELEMENT) break block5;
                Set<QName> elementNames = contextProvider.getElements(false);
                if (elementNames == null) break block6;
                for (QName pair : elementNames) {
                    if ("*".equals(pair.getLocalPart()) || !CompletionLists.namespaceMatches(prefixedName, pair.getNamespaceURI(), namespaceContext, context, true)) continue;
                    if (prefixedName.getPrefix() == null && namespaceContext != null) {
                        String p = namespaceContext.getPrefixForURI(pair.getNamespaceURI(), context);
                        list.add(new NodeLookup(CompletionLists.makePrefix(p) + pair.getLocalPart(), XPathNodeTest.PrincipalType.ELEMENT));
                        continue;
                    }
                    list.add(new NodeLookup(pair.getLocalPart(), XPathNodeTest.PrincipalType.ELEMENT));
                }
                break block6;
            }
            if (principalType == XPathNodeTest.PrincipalType.ATTRIBUTE && (attributeNames = contextProvider.getAttributes(false)) != null) {
                for (QName pair : attributeNames) {
                    if ("*".equals(pair.getLocalPart()) || !CompletionLists.namespaceMatches(prefixedName, pair.getNamespaceURI(), namespaceContext, context, false)) continue;
                    if (prefixedName.getPrefix() == null && namespaceContext != null) {
                        String p = namespaceContext.getPrefixForURI(pair.getNamespaceURI(), context);
                        list.add(new NodeLookup(CompletionLists.makePrefix(p) + pair.getLocalPart(), XPathNodeTest.PrincipalType.ATTRIBUTE));
                        continue;
                    }
                    list.add(new NodeLookup(pair.getLocalPart(), XPathNodeTest.PrincipalType.ATTRIBUTE));
                }
            }
        }
        return principalType;
    }

    private static String makePrefix(String p) {
        return p != null && !p.isEmpty() ? p + ":" : "";
    }

    private static void addNamespaceCompletions(NamespaceContext namespaceContext, Set<? super LookupElement> list, XmlElement context) {
        if (namespaceContext != null) {
            Collection<String> knownPrefixes = namespaceContext.getKnownPrefixes(context);
            for (String prefix : knownPrefixes) {
                if (prefix == null || prefix.isEmpty()) continue;
                list.add(new NamespaceLookup(prefix));
            }
        }
    }

    private static void addNameCompletions(ContextProvider contextProvider, XPathNodeTest element, final Set<? super LookupElement> list) {
        final PrefixedName prefixedName = element.getQName();
        final XPathNodeTest.PrincipalType principalType = element.getPrincipalType();
        HashSet<XPathFile> files = new HashSet<XPathFile>();
        XPathFile file = (XPathFile)element.getContainingFile();
        files.add(file);
        ContainerUtil.addAll(files, (Object[])contextProvider.getRelatedFiles(file));
        for (PsiFile psiFile : files) {
            psiFile.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement e) {
                    String localName;
                    PrefixedName _prefixedName;
                    XPathNodeTest nodeTest;
                    XPathNodeTest.PrincipalType _principalType;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (e instanceof XPathNodeTest && (_principalType = (nodeTest = (XPathNodeTest)e).getPrincipalType()) == principalType && (_prefixedName = nodeTest.getQName()) != null && prefixedName != null && !"*".equals(localName = _prefixedName.getLocalName()) && !localName.contains(CompletionLists.INTELLIJ_IDEA_RULEZ)) {
                        if (Objects.equals(_prefixedName.getPrefix(), prefixedName.getPrefix())) {
                            list.add(new NodeLookup(localName, _principalType));
                        } else if (prefixedName.getPrefix() == null) {
                            list.add(new NodeLookup(_prefixedName.toString(), _principalType));
                        }
                    }
                    super.visitElement(e);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/lang/xpath/completion/CompletionLists$1", "visitElement"));
                }
            });
        }
    }

    private static boolean namespaceMatches(PrefixedName prefixedName, String uri, NamespaceContext namespaceContext, XmlElement context, boolean allowDefault) {
        String namespaceURI;
        if (namespaceContext == null) {
            return true;
        }
        if (prefixedName.getPrefix() != null) {
            if (uri == null || uri.isEmpty()) {
                return false;
            }
            namespaceURI = namespaceContext.getNamespaceURI(prefixedName.getPrefix(), context);
        } else {
            if (!allowDefault) {
                return uri == null || uri.isEmpty();
            }
            namespaceURI = namespaceContext.getDefaultNamespace(context);
            if (namespaceURI == null) {
                return uri == null || uri.isEmpty();
            }
        }
        return uri.equals(namespaceURI);
    }

    public static Collection<LookupElement> getNodeTypeCompletions(XPathElement context) {
        Set<String> funcs = context.getXPathVersion() == XPathVersion.V1 ? NODE_TYPE_FUNCS : NODE_TYPE_FUNCS_V2;
        return ContainerUtil.map(funcs, FUNCTION_MAPPING);
    }

    public static Collection<LookupElement> getAxisCompletions() {
        ArrayList<LookupElement> lookups = new ArrayList<LookupElement>(AXIS_NAMES.size());
        for (String s : AXIS_NAMES) {
            lookups.add(new AxisLookup(s));
        }
        return lookups;
    }

    public static Class[] getAllInterfaces(Class<?> clazz) {
        HashSet set = new HashSet();
        do {
            ContainerUtil.addAll(set, (Object[])clazz.getInterfaces());
        } while ((clazz = clazz.getSuperclass()) != null);
        return set.toArray(ArrayUtil.EMPTY_CLASS_ARRAY);
    }
}

