/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.context;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import java.util.Set;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.context.ContextProviderExtension;
import org.intellij.lang.xpath.context.ContextType;
import org.intellij.lang.xpath.context.NamespaceContext;
import org.intellij.lang.xpath.context.VariableContext;
import org.intellij.lang.xpath.context.XPathQuickFixFactoryImpl;
import org.intellij.lang.xpath.context.XPathVersion;
import org.intellij.lang.xpath.context.functions.DefaultFunctionContext;
import org.intellij.lang.xpath.context.functions.FunctionContext;
import org.intellij.lang.xpath.psi.PrefixedName;
import org.intellij.lang.xpath.psi.QNameElement;
import org.intellij.lang.xpath.psi.XPath2TypeElement;
import org.intellij.lang.xpath.psi.XPathElement;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathNodeTest;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.validation.inspections.quickfix.XPathQuickFixFactory;
import org.intellij.lang.xpath.xslt.context.XsltNamespaceContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContextProvider {
    private static final Key<ContextProvider> KEY = Key.create((String)"CONTEXT_PROVIDER");
    private static final Key<Boolean> XML_FILE_WITH_XPATH_INJECTTION = Key.create((String)"XML_FILE_WITH_XPATH_INJECTTION");
    private volatile FunctionContext myFunctionContext;

    protected ContextProvider() {
    }

    @NotNull
    public abstract ContextType getContextType();

    @Nullable
    public abstract XmlElement getContextElement();

    @Nullable
    public abstract NamespaceContext getNamespaceContext();

    @Nullable
    public abstract VariableContext getVariableContext();

    @NotNull
    public FunctionContext getFunctionContext() {
        FunctionContext context = this.myFunctionContext;
        if (context == null) {
            context = this.createFunctionContext();
        }
        if ((this.myFunctionContext = context) == null) {
            ContextProvider.$$$reportNull$$$0(0);
        }
        return this.myFunctionContext;
    }

    protected FunctionContext createFunctionContext() {
        return DefaultFunctionContext.getInstance(this.getContextType());
    }

    @NotNull
    public XPathQuickFixFactory getQuickFixFactory() {
        XPathQuickFixFactory xPathQuickFixFactory = XPathQuickFixFactoryImpl.INSTANCE;
        if (xPathQuickFixFactory == null) {
            ContextProvider.$$$reportNull$$$0(1);
        }
        return xPathQuickFixFactory;
    }

    @Nullable
    public abstract Set<QName> getAttributes(boolean var1);

    @Nullable
    public abstract Set<QName> getElements(boolean var1);

    public void attachTo(PsiFile file) {
        assert (file instanceof XPathFile);
        file.putCopyableUserData(KEY, (Object)this);
    }

    protected final void attachTo(XmlElement context) {
        context.putCopyableUserData(KEY, (Object)this);
    }

    public static void copy(@NotNull PsiFile file1, @NotNull XPathFile file2) {
        ContextProvider contextProvider;
        if (file1 == null) {
            ContextProvider.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            ContextProvider.$$$reportNull$$$0(3);
        }
        if (!((contextProvider = ContextProvider.getContextProvider(file1)) instanceof DefaultProvider)) {
            contextProvider.attachTo((PsiFile)file2);
        }
    }

    @NotNull
    public static ContextProvider getContextProvider(PsiFile psiFile) {
        ContextProvider provider = (ContextProvider)psiFile.getCopyableUserData(KEY);
        if (provider != null && provider.isValid()) {
            ContextProvider contextProvider = provider;
            if (contextProvider == null) {
                ContextProvider.$$$reportNull$$$0(4);
            }
            return contextProvider;
        }
        PsiElement context = psiFile.getContext();
        if (context != null && (provider = (ContextProvider)context.getCopyableUserData(KEY)) != null && provider.isValid()) {
            ContextProvider contextProvider = provider;
            if (contextProvider == null) {
                ContextProvider.$$$reportNull$$$0(5);
            }
            return contextProvider;
        }
        ContextProvider contextProvider = ContextProvider.getFromExtensionOrDefault(psiFile);
        if (contextProvider == null) {
            ContextProvider.$$$reportNull$$$0(6);
        }
        return contextProvider;
    }

    protected boolean isValid() {
        XmlElement contextElement = this.getContextElement();
        return contextElement != null && contextElement.isValid();
    }

    private static ContextProvider getFromExtensionOrDefault(PsiFile psiFile) {
        ContextProvider instance;
        if (psiFile instanceof XPathFile && (instance = ContextProviderExtension.getInstance((XPathFile)psiFile)) != null) {
            instance.attachTo(psiFile);
            return instance;
        }
        return new DefaultProvider((XmlElement)PsiTreeUtil.getContextOfType((PsiElement)psiFile, XmlElement.class, (boolean)true), psiFile.getLanguage());
    }

    @NotNull
    public static ContextProvider getContextProvider(PsiElement element) {
        return element instanceof XPathElement ? ContextProvider.getContextProvider(element instanceof XPathFile ? (PsiFile)element : element.getContainingFile()) : new DefaultProvider((XmlElement)PsiTreeUtil.getParentOfType((PsiElement)element, XmlElement.class, (boolean)false));
    }

    public PsiFile[] getRelatedFiles(XPathFile file) {
        return PsiFile.EMPTY_ARRAY;
    }

    @NotNull
    public XPathType getExpectedType(XPathExpression expr) {
        XPathType xPathType = XPathType.UNKNOWN;
        if (xPathType == null) {
            ContextProvider.$$$reportNull$$$0(7);
        }
        return xPathType;
    }

    @Nullable
    public QName getQName(QNameElement element) {
        PrefixedName qname = element.getQName();
        return qname != null ? this.getQName(qname, element) : null;
    }

    @Nullable
    public QName getQName(@NotNull PrefixedName qName, XPathElement context) {
        if (qName == null) {
            ContextProvider.$$$reportNull$$$0(8);
        }
        String prefix = qName.getPrefix();
        NamespaceContext namespaceContext = this.getNamespaceContext();
        if (namespaceContext != null) {
            String namespace;
            if (prefix != null) {
                XmlElement element = (XmlElement)PsiTreeUtil.getContextOfType((PsiElement)context, XmlElement.class, (boolean)true);
                String namespaceURI = namespaceContext.getNamespaceURI(prefix, element);
                return namespaceURI != null && !namespaceURI.isEmpty() ? new QName(namespaceURI, qName.getLocalName(), prefix) : null;
            }
            if (context.getXPathVersion() == XPathVersion.V2 && ContextProvider.isDefaultCapableElement(context) && (namespace = namespaceContext.getDefaultNamespace(this.getContextElement())) != null) {
                return new QName(namespace, qName.getLocalName());
            }
            return new QName(null, qName.getLocalName(), "");
        }
        if (qName.getPrefix() == null) {
            return QName.valueOf(qName.getLocalName());
        }
        return null;
    }

    private static boolean isDefaultCapableElement(XPathElement context) {
        return context instanceof XPathNodeTest && ((XPathNodeTest)context).getPrincipalType() == XPathNodeTest.PrincipalType.ELEMENT || context instanceof XPath2TypeElement;
    }

    public static boolean hasXPathInjections(XmlFile file) {
        return Boolean.TRUE.equals(file.getUserData(XML_FILE_WITH_XPATH_INJECTTION));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/context/ContextProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixFactory";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/context/ContextProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getQName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 8 -> new IllegalArgumentException(string);
        };
    }

    public static final class DefaultProvider
    extends ContextProvider {
        public static NamespaceContext NULL_NAMESPACE_CONTEXT = null;
        private final XmlElement myContextElement;
        private final ContextType myContextType;
        private final NamespaceContext myNamespaceContext;

        DefaultProvider(XmlElement contextElement) {
            this.myContextElement = contextElement;
            this.myContextType = ContextType.PLAIN;
            if (this.myContextElement != null) {
                this.myNamespaceContext = XsltNamespaceContext.NAMESPACE_CONTEXT;
                DefaultProvider.setXPathInjected(this.myContextElement.getContainingFile());
            } else {
                this.myNamespaceContext = NULL_NAMESPACE_CONTEXT;
            }
        }

        public DefaultProvider(XmlElement element, Language language) {
            this.myContextElement = element;
            ContextType contextType = this.myContextType = language == XPathFileType.XPATH2.getLanguage() ? ContextType.PLAIN_V2 : ContextType.PLAIN;
            if (this.myContextElement != null) {
                this.myNamespaceContext = XsltNamespaceContext.NAMESPACE_CONTEXT;
                DefaultProvider.setXPathInjected(this.myContextElement.getContainingFile());
            } else {
                this.myNamespaceContext = NULL_NAMESPACE_CONTEXT;
            }
        }

        private static void setXPathInjected(PsiFile file) {
            Boolean flag = (Boolean)file.getUserData(XML_FILE_WITH_XPATH_INJECTTION);
            if (flag == null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (file.getUserData(XML_FILE_WITH_XPATH_INJECTTION) == null) {
                        file.putUserData(XML_FILE_WITH_XPATH_INJECTTION, (Object)Boolean.TRUE);
                        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                            DaemonCodeAnalyzer.getInstance((Project)file.getProject()).restart(file);
                        }
                    }
                });
            }
        }

        @Override
        @NotNull
        public ContextType getContextType() {
            ContextType contextType = this.myContextType;
            if (contextType == null) {
                DefaultProvider.$$$reportNull$$$0(0);
            }
            return contextType;
        }

        @Override
        @Nullable
        public XmlElement getContextElement() {
            return this.myContextElement;
        }

        @Override
        @Nullable
        public NamespaceContext getNamespaceContext() {
            return this.myNamespaceContext;
        }

        @Override
        @Nullable
        public VariableContext getVariableContext() {
            return null;
        }

        @Override
        @Nullable
        public Set<QName> getAttributes(boolean forValidation) {
            return null;
        }

        @Override
        @Nullable
        public Set<QName> getElements(boolean forValidation) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/context/ContextProvider$DefaultProvider", "getContextType"));
        }
    }
}

