/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter;

import com.vladsch.flexmark.formatter.FormattingPhase;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.MergeContext;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.PhasedNodeFormatter;
import com.vladsch.flexmark.formatter.RenderPurpose;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeRepository;
import com.vladsch.flexmark.util.ast.ReferenceNode;
import com.vladsch.flexmark.util.ast.ReferencingNode;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.DataSet;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeRepositoryFormatter<R extends NodeRepository<B>, B extends Node, N extends Node>
implements PhasedNodeFormatter {
    public static final HashSet<FormattingPhase> FORMATTING_PHASES = new HashSet<FormattingPhase>(Arrays.asList(FormattingPhase.COLLECT, FormattingPhase.DOCUMENT_TOP, FormattingPhase.DOCUMENT_BOTTOM));
    protected final R referenceRepository;
    protected final List<B> referenceList;
    protected final HashSet<Node> unusedReferences;
    protected final B lastReference;
    protected boolean recheckUndefinedReferences;
    protected boolean repositoryNodesDone;
    protected final Comparator<B> myComparator;
    private Map<String, String> referenceTranslationMap;
    protected Map<String, String> referenceUniqificationMap;
    private final DataKey<Map<String, String>> myReferenceMapKey;
    private final DataKey<Map<String, String>> myReferenceUniqificationMapKey;

    public Comparator<B> getReferenceComparator() {
        return this.myComparator;
    }

    public abstract R getRepository(DataHolder var1);

    public abstract ElementPlacement getReferencePlacement();

    public abstract ElementPlacementSort getReferenceSort();

    protected abstract void renderReferenceBlock(B var1, NodeFormatterContext var2, MarkdownWriter var3);

    protected boolean makeReferencesUnique() {
        return true;
    }

    protected ElementPlacement getTranslationReferencePlacement(NodeFormatterContext context) {
        if (context.isTransformingText()) {
            return ElementPlacement.AS_IS;
        }
        return this.getReferencePlacement();
    }

    public String modifyTransformedReference(String transformedReferenceId, NodeFormatterContext context) {
        return transformedReferenceId;
    }

    private void renderReferenceBlockUnique(B node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.getRenderPurpose() == RenderPurpose.TRANSLATED) {
            context.postProcessNonTranslating(id -> {
                if (this.referenceUniqificationMap != null) {
                    String uniqueS = this.referenceUniqificationMap.getOrDefault(id, (String)id);
                    return uniqueS;
                }
                return id;
            }, () -> this.renderReferenceBlock(node, context, markdown));
        } else {
            this.renderReferenceBlock(node, context, markdown);
        }
    }

    protected String transformReferenceId(String nodeText, NodeFormatterContext context) {
        if (context.isTransformingText()) {
            switch (context.getRenderPurpose()) {
                case TRANSLATION_SPANS: 
                case TRANSLATED_SPANS: {
                    String transformed;
                    if (this.referenceTranslationMap != null) {
                        if (this.referenceTranslationMap.containsKey(nodeText)) {
                            transformed = this.referenceTranslationMap.get(nodeText);
                        } else {
                            transformed = context.transformNonTranslating(null, nodeText, null, null).toString();
                            this.referenceTranslationMap.put(nodeText, transformed);
                        }
                    } else {
                        transformed = context.transformNonTranslating(null, nodeText, null, null).toString();
                    }
                    return this.modifyTransformedReference(transformed, context);
                }
                case TRANSLATED: {
                    String untransformed = this.modifyTransformedReference(nodeText, context);
                    String s = context.transformNonTranslating(null, untransformed, null, null).toString();
                    if (!context.isPostProcessingNonTranslating() && this.referenceUniqificationMap != null && this.referenceUniqificationMap.containsKey(s)) {
                        String uniqueS = this.referenceUniqificationMap.get(s);
                        return uniqueS;
                    }
                    return s;
                }
            }
        }
        return nodeText;
    }

    public NodeRepositoryFormatter(DataHolder options, DataKey<Map<String, String>> referenceMapKey, DataKey<Map<String, String>> uniquificationMapKey) {
        this.myReferenceMapKey = referenceMapKey;
        this.myReferenceUniqificationMapKey = uniquificationMapKey;
        this.referenceRepository = this.getRepository(options);
        this.referenceList = ((NodeRepository)this.referenceRepository).values();
        this.lastReference = this.referenceList.isEmpty() ? null : (Node)this.referenceList.get(this.referenceList.size() - 1);
        this.unusedReferences = new HashSet();
        this.recheckUndefinedReferences = HtmlRenderer.RECHECK_UNDEFINED_REFERENCES.get(options);
        this.repositoryNodesDone = false;
        this.myComparator = (rec$, x$0) -> ((Comparable)rec$).compareTo(x$0);
    }

    @Override
    @Nullable
    public Set<FormattingPhase> getFormattingPhases() {
        return FORMATTING_PHASES;
    }

    @Override
    public void renderDocument(@NotNull NodeFormatterContext context, @NotNull MarkdownWriter markdown, @NotNull Document document, @NotNull FormattingPhase phase) {
        if (context.isTransformingText() && this.myReferenceMapKey != null) {
            if (context.getRenderPurpose() == RenderPurpose.TRANSLATION_SPANS) {
                context.getTranslationStore().set(this.myReferenceMapKey, new HashMap());
            }
            this.referenceTranslationMap = this.myReferenceMapKey.get(context.getTranslationStore());
        }
        switch (phase) {
            case COLLECT: {
                this.referenceUniqificationMap = null;
                if (context.isTransformingText() && this.myReferenceUniqificationMapKey != null && this.makeReferencesUnique()) {
                    MergeContext mergeContext;
                    if (context.getRenderPurpose() == RenderPurpose.TRANSLATION_SPANS && (mergeContext = context.getMergeContext()) != null) {
                        this.uniquifyIds(context, markdown, document);
                    }
                    this.referenceUniqificationMap = this.myReferenceUniqificationMapKey.get(context.getTranslationStore());
                }
                if (!this.getTranslationReferencePlacement(context).isChange() || !this.getReferenceSort().isUnused()) break;
                this.unusedReferences.addAll(this.referenceList);
                Set<Class<?>> nodeClasses = this.getNodeClasses();
                if (nodeClasses == null) break;
                Iterable<? extends Node> nodes = context.nodesOfType(nodeClasses);
                for (Node node : nodes) {
                    Node referenceBlock;
                    Object referencingNode = this.lastReference == null ? null : ((ReferenceNode)this.lastReference).getReferencingNode(node);
                    if (referencingNode == null || (referenceBlock = (Node)((ReferencingNode)referencingNode).getReferenceNode(this.referenceRepository)) == null) continue;
                    this.unusedReferences.remove(referenceBlock);
                }
                break;
            }
            case DOCUMENT_TOP: {
                if (this.getTranslationReferencePlacement(context) != ElementPlacement.DOCUMENT_TOP) break;
                this.formatReferences(context, markdown);
                break;
            }
            case DOCUMENT_BOTTOM: {
                if (this.getTranslationReferencePlacement(context) != ElementPlacement.DOCUMENT_BOTTOM) break;
                this.formatReferences(context, markdown);
                break;
            }
        }
    }

    private void formatReferences(NodeFormatterContext context, MarkdownWriter markdown) {
        ArrayList<B> references = new ArrayList<B>(this.referenceList);
        ElementPlacementSort referenceSort = this.getReferenceSort();
        switch (referenceSort) {
            case AS_IS: {
                break;
            }
            case SORT: {
                references.sort(this.getReferenceComparator());
                break;
            }
            case SORT_UNUSED_LAST: 
            case SORT_DELETE_UNUSED: 
            case DELETE_UNUSED: {
                ArrayList<Node> used = new ArrayList<Node>();
                ArrayList<Node> unused = new ArrayList<Node>();
                for (Node reference : references) {
                    if (!this.unusedReferences.contains(reference)) {
                        used.add(reference);
                        continue;
                    }
                    if (referenceSort.isDeleteUnused()) continue;
                    unused.add(reference);
                }
                if (referenceSort.isSort()) {
                    used.sort(this.getReferenceComparator());
                    if (!referenceSort.isDeleteUnused()) {
                        unused.sort(this.getReferenceComparator());
                    }
                }
                references.clear();
                references.addAll(used);
                if (referenceSort.isDeleteUnused()) break;
                references.addAll(unused);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + referenceSort);
            }
        }
        markdown.blankLine();
        for (Node reference : references) {
            this.renderReferenceBlockUnique(reference, context, markdown);
        }
        markdown.blankLine();
        this.repositoryNodesDone = true;
    }

    protected void renderReference(B node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (!this.repositoryNodesDone) {
            switch (this.getTranslationReferencePlacement(context)) {
                case AS_IS: {
                    this.renderReferenceBlockUnique(node, context, markdown);
                    if (((Node)node).getNext() != null && ((Node)node).getNext().getClass() == node.getClass()) break;
                    markdown.blankLine();
                    break;
                }
                case GROUP_WITH_FIRST: {
                    this.formatReferences(context, markdown);
                    break;
                }
                case GROUP_WITH_LAST: {
                    if (node != this.lastReference) break;
                    this.formatReferences(context, markdown);
                }
            }
        }
    }

    protected void uniquifyIds(NodeFormatterContext context, MarkdownWriter markdown, Document document) {
        R combinedRefs = this.getRepository(new DataSet());
        HashMap<String, String> idMap = new HashMap<String, String>();
        MergeContext mergeContext = context.getMergeContext();
        mergeContext.forEachPrecedingDocument(document, (docContext, doc, index) -> {
            R docRefs = this.getRepository(doc);
            Map<String, String> uniquificationMap = this.myReferenceUniqificationMapKey.get(docContext.getTranslationStore());
            NodeRepository.transferReferences(combinedRefs, docRefs, true, uniquificationMap);
        });
        R repository = this.getRepository(document);
        for (Map.Entry entry : ((NodeRepository)repository).entrySet()) {
            String key;
            String newKey = key = entry.getKey();
            int i = 0;
            while (((NodeRepository)combinedRefs).containsKey(newKey)) {
                newKey = String.format("%s%d", key, ++i);
            }
            if (i <= 0) continue;
            idMap.put(key, newKey);
        }
        if (!idMap.isEmpty()) {
            context.getTranslationStore().set(this.myReferenceUniqificationMapKey, idMap);
        }
    }
}

