/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.run.execution.update;

import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.run.execution.update.UpdatingPolicy;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectUpdatingPolicyDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(SelectUpdatingPolicyDialog.class);
    private JPanel myMainPanel;
    private JPanel myPoliciesPanel;
    private JCheckBox myDoNotAskAgainCheckBox;
    private JLabel myDescriptionLabel;
    private UpdatingPolicy mySelectedPolicy;

    public SelectUpdatingPolicyDialog(Project project, String runConfigurationName, @Nls @Nullable String description, boolean showDoNotAskAgainCheckBox, Collection<? extends UpdatingPolicy> policies, @Nullable UpdatingPolicy toSelect) {
        super(project);
        Object[] objectArray = new Object[]{runConfigurationName};
        this.$$$setupUI$$$();
        this.setTitle(AppServersIntegrationBundle.message((String)"SelectUpdatingPolicyDialog.update", (Object[])objectArray));
        this.init();
        this.myDoNotAskAgainCheckBox.setVisible(showDoNotAskAgainCheckBox);
        this.myDoNotAskAgainCheckBox.setSelected(false);
        this.mySelectedPolicy = toSelect;
        if (this.mySelectedPolicy == null || !policies.contains(this.mySelectedPolicy)) {
            this.mySelectedPolicy = (UpdatingPolicy)ContainerUtil.getFirstItem(policies, null);
        }
        if (policies.size() > 1) {
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            final ButtonGroup buttonGroup = new ButtonGroup();
            final ArrayList<JRadioButton> buttons = new ArrayList<JRadioButton>();
            for (final UpdatingPolicy updatingPolicy : policies) {
                JRadioButton button = new JRadioButton(updatingPolicy.getDescription(), updatingPolicy.equals(this.mySelectedPolicy));
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SelectUpdatingPolicyDialog.this.mySelectedPolicy = updatingPolicy;
                    }
                });
                panel.add(button);
                buttonGroup.add(button);
                buttons.add(button);
            }
            AnAction action = new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    InputEvent inputEvent;
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((inputEvent = e.getInputEvent()) instanceof KeyEvent) {
                        int code = ((KeyEvent)inputEvent).getKeyCode();
                        SelectUpdatingPolicyDialog.changeSelection(buttonGroup, buttons, code == 40 ? 1 : -1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javaee/appServers/run/execution/update/SelectUpdatingPolicyDialog$2", "actionPerformed"));
                }
            };
            KeyboardShortcut keyboardShortcut = new KeyboardShortcut(KeyStroke.getKeyStroke(38, 0), null);
            KeyboardShortcut down = new KeyboardShortcut(KeyStroke.getKeyStroke(40, 0), null);
            action.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{keyboardShortcut, down}), (JComponent)this.getRootPane());
            this.myPoliciesPanel.add((Component)panel, "Center");
        } else {
            LOG.assertTrue(policies.size() == 1);
            LOG.assertTrue(this.mySelectedPolicy != null);
            @Nls String question = AppServersIntegrationBundle.message((String)"SelectUpdatingPolicyDialog.do.you.want.to.launch.policy", (Object[])new Object[]{StringUtil.decapitalize((String)this.mySelectedPolicy.getDescription())});
            description = (String)(description != null ? (String)description + " " : "") + question;
            this.myPoliciesPanel.setVisible(false);
            this.setOKButtonText(CommonBundle.getYesButtonText());
            this.setCancelButtonText(CommonBundle.getNoButtonText());
        }
        this.myDescriptionLabel.setVisible(description != null);
        if (description != null) {
            this.myDescriptionLabel.setText((String)description);
        }
    }

    private static void changeSelection(ButtonGroup buttonGroup, List<JRadioButton> buttons, int delta) {
        ButtonModel selection = buttonGroup.getSelection();
        int buttonsSize = buttons.size();
        for (int i = 0; i < buttonsSize; ++i) {
            if (!buttons.get(i).getModel().equals(selection)) continue;
            buttons.get((i + delta + buttonsSize) % buttonsSize).doClick(0);
            break;
        }
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public UpdatingPolicy getSelectedPolicy() {
        return this.mySelectedPolicy;
    }

    public boolean isShowDialogAgain() {
        return !this.myDoNotAskAgainCheckBox.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPoliciesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDoNotAskAgainCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/AppServersIntegrationBundle", SelectUpdatingPolicyDialog.class).getString("SelectUpdatingPolicyDialog.checkbox.dont.ask.again"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDescriptionLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/AppServersIntegrationBundle", SelectUpdatingPolicyDialog.class).getString("SelectUpdatingPolicyDialog.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

