/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.util;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class Os {
    private static final Set<String> validFamilies = Os.setValidFamilies();
    private static final String PATH_SEP = System.getProperty("path.separator");
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    public static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.US);
    public static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.US);
    public static final String OS_FAMILY = Os.getOsFamily();

    private static Set<String> setValidFamilies() {
        HashSet<String> valid = new HashSet<String>();
        valid.add("dos");
        valid.add("mac");
        valid.add("netware");
        valid.add("os/2");
        valid.add("tandem");
        valid.add("unix");
        valid.add("windows");
        valid.add("win9x");
        valid.add("z/os");
        valid.add("os/400");
        valid.add("openvms");
        return valid;
    }

    public static boolean isFamily(String family) {
        return Os.isOs(family, null, null, null);
    }

    public static boolean isName(String name) {
        return Os.isOs(null, name, null, null);
    }

    public static boolean isArch(String arch) {
        return Os.isOs(null, null, arch, null);
    }

    public static boolean isVersion(String version) {
        return Os.isOs(null, null, null, version);
    }

    public static boolean isOs(String family, String name, String arch, String version) {
        boolean retValue = false;
        if (family != null || name != null || arch != null || version != null) {
            boolean isFamily = true;
            boolean isName = true;
            boolean isArch = true;
            boolean isVersion = true;
            if (family != null) {
                isFamily = family.equalsIgnoreCase("windows") ? OS_NAME.contains("windows") : (family.equalsIgnoreCase("os/2") ? OS_NAME.contains("os/2") : (family.equalsIgnoreCase("netware") ? OS_NAME.contains("netware") : (family.equalsIgnoreCase("dos") ? PATH_SEP.equals(";") && !Os.isFamily("netware") && !Os.isFamily("windows") && !Os.isFamily("win9x") : (family.equalsIgnoreCase("mac") ? OS_NAME.contains("mac") : (family.equalsIgnoreCase("tandem") ? OS_NAME.contains("nonstop_kernel") : (family.equalsIgnoreCase("unix") ? PATH_SEP.equals(":") && !Os.isFamily("openvms") && (!Os.isFamily("mac") || OS_NAME.endsWith("x")) : (family.equalsIgnoreCase("win9x") ? Os.isFamily("windows") && (OS_NAME.contains("95") || OS_NAME.contains("98") || OS_NAME.contains("me") || OS_NAME.contains("ce")) : (family.equalsIgnoreCase("z/os") ? OS_NAME.contains("z/os") || OS_NAME.contains("os/390") : (family.equalsIgnoreCase("os/400") ? OS_NAME.contains("os/400") : (family.equalsIgnoreCase("openvms") ? OS_NAME.contains("openvms") : OS_NAME.contains(family.toLowerCase(Locale.US))))))))))));
            }
            if (name != null) {
                isName = name.toLowerCase(Locale.US).equals(OS_NAME);
            }
            if (arch != null) {
                isArch = arch.toLowerCase(Locale.US).equals(OS_ARCH);
            }
            if (version != null) {
                isVersion = version.toLowerCase(Locale.US).equals(OS_VERSION);
            }
            retValue = isFamily && isName && isArch && isVersion;
        }
        return retValue;
    }

    private static String getOsFamily() {
        Set<String> families = null;
        families = !validFamilies.isEmpty() ? validFamilies : Os.setValidFamilies();
        for (String fam : families) {
            if (!Os.isFamily(fam)) continue;
            return fam;
        }
        return null;
    }
}

