/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.model.jam;

import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.jam.JamBaseElement;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamEnumAttributeElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamEnumAttributeMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.model.aliasFor.SpringAliasFor;
import com.intellij.spring.model.aliasFor.SpringAliasForUtils;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.spring.mvc.model.jam.MVCPathVariable;
import com.intellij.spring.mvc.model.jam.RequestMapping;
import com.intellij.spring.mvc.model.jam.RequestMappingUtil;
import com.intellij.spring.mvc.model.jam.SpringMVCModelAttribute;
import com.intellij.spring.mvc.model.jam.SpringRequestMapping;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(provider=CustomRequestPresentationProvider.class)
public abstract class CustomRequestMapping<T extends PsiMember>
extends JamBaseElement<T>
implements RequestMapping<T> {
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;
    protected final JamAnnotationMeta myAnnotationMeta;
    private final NullableLazyValue<SpringRequestMapping.ClassMapping> myDefiningMetaAnnotation;
    private static final Map<String, JamAnnotationMeta> annotationMetaMap = new HashMap<String, JamAnnotationMeta>();

    CustomRequestMapping(@NotNull String anno, @NotNull T psiElement) {
        if (anno == null) {
            CustomRequestMapping.$$$reportNull$$$0(0);
        }
        if (psiElement == null) {
            CustomRequestMapping.$$$reportNull$$$0(1);
        }
        super(PsiElementRef.real(psiElement));
        this.myDefiningMetaAnnotation = new NullableLazyValue<SpringRequestMapping.ClassMapping>(){

            @Nullable
            protected SpringRequestMapping.ClassMapping compute() {
                PsiAnnotation definingMetaAnnotation = SpringAliasForUtils.findDefiningMetaAnnotation((PsiElement)CustomRequestMapping.this.getPsiElement(), (String)CustomRequestMapping.this.myAnnotationMeta.getAnnoName(), (String)"org.springframework.web.bind.annotation.RequestMapping");
                if (definingMetaAnnotation == null) {
                    return null;
                }
                PsiClass annotationType = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)definingMetaAnnotation, PsiClass.class, (boolean)true);
                if (annotationType == null) {
                    return null;
                }
                return (SpringRequestMapping.ClassMapping)SpringRequestMapping.ClassMapping.META.getJamElement((PsiModifierListOwner)annotationType);
            }
        };
        this.myAnnotationMeta = CustomRequestMapping.getMeta(anno);
        this.myPsiAnnotation = this.myAnnotationMeta.getAnnotationRef((PsiModifierListOwner)this.getPsiElement());
    }

    @NotNull
    private static synchronized JamAnnotationMeta getMeta(@NotNull String anno) {
        JamAnnotationMeta meta;
        if (anno == null) {
            CustomRequestMapping.$$$reportNull$$$0(2);
        }
        if ((meta = annotationMetaMap.get(anno)) == null) {
            meta = new JamAnnotationMeta(anno);
            annotationMetaMap.put(anno, meta);
        }
        JamAnnotationMeta jamAnnotationMeta = meta;
        if (jamAnnotationMeta == null) {
            CustomRequestMapping.$$$reportNull$$$0(3);
        }
        return jamAnnotationMeta;
    }

    @Override
    public List<JamStringAttributeElement<String>> getMappingUrls() {
        SpringAliasFor valueAliasFor = this.findAliasFor("value");
        SpringAliasFor pathAliasFor = this.findAliasFor("path");
        if (valueAliasFor == null && pathAliasFor == null) {
            SpringRequestMapping.ClassMapping definingAnnotation = this.getDefiningAnnotation();
            return definingAnnotation != null ? definingAnnotation.getMappingUrls() : Collections.emptyList();
        }
        List<JamStringAttributeElement<String>> valueElements = this.getCollectionStringAttributeElements(valueAliasFor);
        List<JamStringAttributeElement<String>> pathElements = this.getCollectionStringAttributeElements(pathAliasFor);
        return ContainerUtil.concat(valueElements, pathElements);
    }

    @NotNull
    private List<JamStringAttributeElement<String>> getCollectionStringAttributeElements(SpringAliasFor aliasFor) {
        List list = aliasFor == null ? Collections.emptyList() : JamAttributeMeta.collectionString((String)aliasFor.getMethodName()).getJam(this.myPsiAnnotation);
        if (list == null) {
            CustomRequestMapping.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public List<String> getUrls() {
        List<JamStringAttributeElement<String>> urlElements = this.getMappingUrls();
        List<String> urls = SpringRequestMapping.mapToStringList(urlElements);
        if (!urls.isEmpty()) {
            return urls;
        }
        SpringRequestMapping.ClassMapping definingAnnotation = this.getDefiningAnnotation();
        return definingAnnotation != null ? definingAnnotation.getUrls() : Collections.emptyList();
    }

    @Override
    public RequestMethod[] getMethods() {
        SpringAliasFor aliasFor = this.findAliasFor("method");
        if (aliasFor == null) {
            SpringRequestMapping.ClassMapping definingAnnotation = this.getDefiningAnnotation();
            return definingAnnotation != null ? definingAnnotation.getMethods() : RequestMethod.EMPTY_ARRAY;
        }
        JamEnumAttributeMeta.Collection attributeMeta = new JamEnumAttributeMeta.Collection(aliasFor.getMethodName(), RequestMethod.class);
        List methods = ContainerUtil.mapNotNull((Collection)attributeMeta.getJam(this.myPsiAnnotation), JamEnumAttributeElement::getValue);
        return methods.toArray(RequestMethod.EMPTY_ARRAY);
    }

    @Override
    public List<String> getConsumes() {
        List<String> values = this.getStringValues("consumes");
        if (values != null) {
            return values;
        }
        SpringRequestMapping.ClassMapping definingAnnotation = this.getDefiningAnnotation();
        return definingAnnotation != null ? definingAnnotation.getConsumes() : Collections.emptyList();
    }

    @Override
    public List<String> getProduces() {
        List<String> values = this.getStringValues("produces");
        if (values != null) {
            return values;
        }
        SpringRequestMapping.ClassMapping definingAnnotation = this.getDefiningAnnotation();
        return definingAnnotation != null ? definingAnnotation.getProduces() : Collections.emptyList();
    }

    @Override
    public List<String> getParams() {
        List<String> values = this.getStringValues("params");
        if (values != null) {
            return values;
        }
        SpringRequestMapping.ClassMapping definingAnnotation = this.getDefiningAnnotation();
        return definingAnnotation != null ? definingAnnotation.getParams() : Collections.emptyList();
    }

    @Override
    public List<String> getHeaders() {
        List<String> values = this.getStringValues("headers");
        if (values != null) {
            return values;
        }
        SpringRequestMapping.ClassMapping definingAnnotation = this.getDefiningAnnotation();
        return definingAnnotation != null ? definingAnnotation.getHeaders() : Collections.emptyList();
    }

    @Override
    @Nullable
    public PsiAnnotation getIdentifyingAnnotation() {
        return (PsiAnnotation)this.myPsiAnnotation.getPsiElement();
    }

    @Override
    @NotNull
    public String getIdentifyingAnnotationFQN() {
        String string = this.myAnnotationMeta.getAnnoName();
        if (string == null) {
            CustomRequestMapping.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    protected List<String> getStringValues(String attributeName) {
        SpringAliasFor aliasFor = this.findAliasFor(attributeName);
        if (aliasFor == null) {
            return null;
        }
        JamStringAttributeMeta.Collection stringAttributeMeta = JamAttributeMeta.collectionString((String)aliasFor.getMethodName());
        return SpringRequestMapping.mapToStringList(stringAttributeMeta.getJam(this.myPsiAnnotation));
    }

    @Nullable
    private SpringAliasFor findAliasFor(@NotNull String attrName) {
        if (attrName == null) {
            CustomRequestMapping.$$$reportNull$$$0(6);
        }
        return SpringAliasForUtils.findAliasFor((PsiElement)this.getPsiElement(), (String)this.myAnnotationMeta.getAnnoName(), (String)"org.springframework.web.bind.annotation.RequestMapping", (String)attrName);
    }

    protected List<PsiTarget> getPomTargets() {
        return CollectionsKt.mapNotNull(this.getMappingUrls(), url -> url.getPsiLiteral() == null ? null : new JamPomTarget((JamElement)this, url));
    }

    @Nullable
    protected SpringRequestMapping.ClassMapping getDefiningAnnotation() {
        return (SpringRequestMapping.ClassMapping)this.myDefiningMetaAnnotation.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/model/jam/CustomRequestMapping";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/model/jam/CustomRequestMapping";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMeta";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectionStringAttributeElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifyingAnnotationFQN";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMeta";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAliasFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    public static class CustomRequestPresentationProvider
    extends PresentationProvider<CustomRequestMapping<?>> {
        @Nullable
        public String getTypeName(CustomRequestMapping<?> mapping) {
            String annotationName = mapping.myAnnotationMeta.getAnnoName();
            return "@" + StringUtil.getShortName((String)annotationName);
        }

        @Nullable
        public Icon getIcon(CustomRequestMapping<?> mapping) {
            return SpringApiIcons.RequestMapping;
        }
    }

    public static final class MethodMapping
    extends CustomRequestMapping<PsiMethod>
    implements RequestMapping.Method {
        private static final Map<String, RequestMethod> KNOWN_METHODS = new HashMap<String, RequestMethod>();
        static final SemKey<MethodMapping> JAM_KEY;
        static final SemKey<JamMemberMeta<PsiMethod, MethodMapping>> META_KEY;

        public MethodMapping(@NotNull String anno, @NotNull PsiMethod psiElement) {
            if (anno == null) {
                MethodMapping.$$$reportNull$$$0(0);
            }
            if (psiElement == null) {
                MethodMapping.$$$reportNull$$$0(1);
            }
            super(anno, psiElement);
        }

        @Override
        public RequestMethod[] getMethods() {
            return RequestMappingUtil.getAllRequestMethods(this);
        }

        @Override
        public List<SpringMVCModelAttribute> getModelAttributes() {
            return MODEL_ATTRIBUTE_PARAMETERS_QUERY.findChildren(PsiElementRef.real((PsiElement)((PsiMethod)this.getPsiElement())));
        }

        @Override
        public RequestMethod[] getLocalMethods() {
            RequestMethod[] requestMethodArray;
            RequestMethod method = KNOWN_METHODS.get(this.myAnnotationMeta.getAnnoName());
            if (method == null) {
                requestMethodArray = super.getMethods();
            } else {
                RequestMethod[] requestMethodArray2 = new RequestMethod[1];
                requestMethodArray = requestMethodArray2;
                requestMethodArray2[0] = method;
            }
            return requestMethodArray;
        }

        @Override
        public List<MVCPathVariable> getPathVariables() {
            return PATH_VARIABLE_PARAMETERS_QUERY.findChildren(PsiElementRef.real((PsiElement)((PsiMethod)this.getPsiElement())));
        }

        static Consumer<JamMemberMeta<PsiMethod, MethodMapping>> createMetaConsumer() {
            return meta -> meta.addChildrenQuery(MODEL_ATTRIBUTE_PARAMETERS_QUERY).addChildrenQuery(PATH_VARIABLE_PARAMETERS_QUERY).addPomTargetProducer((method, consumer) -> {
                for (PsiTarget target : method.getPomTargets()) {
                    consumer.consume((Object)target);
                }
            });
        }

        static {
            KNOWN_METHODS.put("org.springframework.web.bind.annotation.GetMapping", RequestMethod.GET);
            KNOWN_METHODS.put("org.springframework.web.bind.annotation.PutMapping", RequestMethod.PUT);
            KNOWN_METHODS.put("org.springframework.web.bind.annotation.PostMapping", RequestMethod.POST);
            KNOWN_METHODS.put("org.springframework.web.bind.annotation.DeleteMapping", RequestMethod.DELETE);
            KNOWN_METHODS.put("org.springframework.web.bind.annotation.PatchMapping", RequestMethod.PATCH);
            JAM_KEY = RequestMapping.METHOD_JAM_KEY.subKey("CustomMethodMapping", new SemKey[0]);
            META_KEY = JamService.getMetaKey(JAM_KEY).subKey("CustomMethodMappingMeta", new SemKey[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anno";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/mvc/model/jam/CustomRequestMapping$MethodMapping";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ClassMapping
    extends CustomRequestMapping<PsiClass> {
        static final SemKey<ClassMapping> JAM_KEY = RequestMapping.CLASS_JAM_KEY.subKey("CustomClassMapping", new SemKey[0]);
        static final SemKey<JamMemberMeta<PsiClass, ClassMapping>> META_KEY = JamService.getMetaKey(JAM_KEY).subKey("CustomClassMappingMeta", new SemKey[0]);

        public ClassMapping(@NotNull String anno, @NotNull PsiClass psiElement) {
            if (anno == null) {
                ClassMapping.$$$reportNull$$$0(0);
            }
            if (psiElement == null) {
                ClassMapping.$$$reportNull$$$0(1);
            }
            super(anno, psiElement);
        }

        @Override
        public List<SpringMVCModelAttribute> getModelAttributes() {
            return MODEL_ATTRIBUTE_METHODS_QUERY.findChildren(this.getPsiElementRef());
        }

        static Consumer<JamMemberMeta<PsiClass, ClassMapping>> createMetaConsumer() {
            return meta -> meta.addChildrenQuery(MODEL_ATTRIBUTE_METHODS_QUERY).addPomTargetProducer((clazz, consumer) -> {
                for (PsiTarget target : clazz.getPomTargets()) {
                    consumer.consume((Object)target);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anno";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/mvc/model/jam/CustomRequestMapping$ClassMapping";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

