/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.navigation.requests;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.navigation.requests.SpringMvcDumbAnnotationsKt;
import com.intellij.spring.mvc.request.SpringMergingMvcRequestMappingLineMarkerProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J,\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\u0012\u0010\u000f\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010H\u0016J2\u0010\u0012\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0012\u0010\u000f\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00140\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J@\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0012\u0010\u000f\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00140\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J,\u0010\u0019\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\u0012\u0010\u000f\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010H\u0002J2\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\u0006\u0010\u001a\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00140\u0010H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u000eH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/spring/mvc/navigation/requests/SpringMvcRequestMappingLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getIcon", "Ljavax/swing/Icon;", "getId", "", "getName", "collectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "collectNavigationMarkers", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "forNavigation", "", "extensions", "Lcom/intellij/spring/mvc/request/SpringMergingMvcRequestMappingLineMarkerProvider;", "annotateInDumbMode", "element", "findModuleForElementWhenDumb", "Lcom/intellij/openapi/module/Module;", "psiElement", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nSpringMvcRequestMappingLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringMvcRequestMappingLineMarkerProvider.kt\ncom/intellij/spring/mvc/navigation/requests/SpringMvcRequestMappingLineMarkerProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n774#2:147\n865#2,2:148\n*S KotlinDebug\n*F\n+ 1 SpringMvcRequestMappingLineMarkerProvider.kt\ncom/intellij/spring/mvc/navigation/requests/SpringMvcRequestMappingLineMarkerProvider\n*L\n48#1:147\n48#1:148,2\n*E\n"})
public final class SpringMvcRequestMappingLineMarkerProvider
extends RelatedItemLineMarkerProvider
implements DumbAware {
    @NotNull
    public Icon getIcon() {
        Icon icon = SpringApiIcons.Gutter.RequestMapping;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RequestMapping");
        return icon;
    }

    @NotNull
    public String getId() {
        return "SpringMvcRequestMappingLineMarkerProvider";
    }

    @NotNull
    public String getName() {
        String string = SpringMvcBundle.message("request.mapping.gutter.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (psiElement == null) {
            return;
        }
        PsiElement first = psiElement;
        Project project = first.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            this.annotateInDumbMode(elements, result);
        } else {
            super.collectSlowLineMarkers(elements, result);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (psiElement == null) {
            return;
        }
        PsiElement first = psiElement;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)first);
        if (module != null && !SpringCommonUtils.isSpringConfigured((Module)module)) {
            return;
        }
        Iterable iterable = SpringMergingMvcRequestMappingLineMarkerProvider.EP_NAME.getExtensionList();
        boolean $i$f$filter = false;
        void var9_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SpringMergingMvcRequestMappingLineMarkerProvider it = (SpringMergingMvcRequestMappingLineMarkerProvider)element$iv$iv;
            boolean bl = false;
            if (!it.isAvailable(first.getProject())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List extension = (List)destination$iv$iv;
        this.collectNavigationMarkers(extension, elements, result, forNavigation);
    }

    private final void collectNavigationMarkers(List<? extends SpringMergingMvcRequestMappingLineMarkerProvider> extensions, List<? extends PsiElement> elements, Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            PsiElement nameIdentifier;
            PsiElement element = elements.get(i);
            this.collectNavigationMarkers(extensions, element, result);
            if (!forNavigation || !(element instanceof PsiNameIdentifierOwner) || (nameIdentifier = ((PsiNameIdentifierOwner)element).getNameIdentifier()) == null || elements.contains(nameIdentifier)) continue;
            this.collectNavigationMarkers(extensions, nameIdentifier, result);
        }
    }

    private final void annotateInDumbMode(List<? extends PsiElement> elements, Collection<? super LineMarkerInfo<?>> result) {
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (psiElement == null) {
            return;
        }
        PsiElement first = psiElement;
        Module module = this.findModuleForElementWhenDumb(first);
        if (module == null || !SpringCommonUtils.isSpringConfigured((Module)module)) {
            return;
        }
        int i = 0;
        int size = elements.size();
        while (i < size) {
            UElement uElement;
            PsiElement element = elements.get(i);
            try {
                uElement = UastUtils.getUParentForIdentifier((PsiElement)element);
            }
            catch (IndexNotReadyException e) {
                continue;
            }
            UElement uElement2 = uElement;
            if (uElement2 instanceof UMethod) {
                Object object;
                try {
                    object = ((UMethod)uElement2).getUAnnotations();
                }
                catch (IndexNotReadyException e) {
                    object = CollectionsKt.emptyList();
                }
                List uAnnotations = object;
                for (UAnnotation uAnnotation : uAnnotations) {
                    UIdentifier uAnchor;
                    if (uAnnotation.getUastAnchor() == null || !SpringMvcDumbAnnotationsKt.getREQUEST_MAPPING_ANNOTATIONS_SHORTNAMES().contains(uAnchor.getName())) continue;
                    result.add(new LineMarkerInfo(element, element.getTextRange(), SpringApiIcons.Gutter.RequestMapping, SpringMvcRequestMappingLineMarkerProvider::annotateInDumbMode$lambda$1, SpringMvcDumbAnnotationsKt.getDumbNavigationHandler(), SpringGutterIconBuilder.DEFAULT_GUTTER_ICON_ALIGNMENT, SpringMvcRequestMappingLineMarkerProvider::annotateInDumbMode$lambda$2));
                    break;
                }
            }
            ++i;
        }
    }

    private final void collectNavigationMarkers(List<? extends SpringMergingMvcRequestMappingLineMarkerProvider> extensions, PsiElement element, Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        int size = extensions.size();
        for (int i = 0; i < size; ++i) {
            SpringMergingMvcRequestMappingLineMarkerProvider provider = extensions.get(i);
            if (!provider.collectLineMarkers(element, result)) continue;
            return;
        }
    }

    private final Module findModuleForElementWhenDumb(PsiElement psiElement) {
        Module module;
        try {
            module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        }
        catch (IndexNotReadyException ignored) {
            module = null;
        }
        return module;
    }

    private static final String annotateInDumbMode$lambda$1(PsiElement psiElement) {
        return SpringMvcBundle.message("request.mapping.gutter.open.in.http.name", new Object[0]);
    }

    private static final String annotateInDumbMode$lambda$2() {
        return SpringMvcBundle.message("request.mapping.gutter.open.in.http.name", new Object[0]);
    }
}

