/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.views;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.mvc.model.xml.UrlViewResolverType;
import com.intellij.spring.mvc.model.xml.ViewResolverBeanName;
import com.intellij.spring.mvc.model.xml.ViewResolverContentNegotiation;
import com.intellij.spring.mvc.model.xml.ViewResolverFreeMarker;
import com.intellij.spring.mvc.model.xml.ViewResolverGroovy;
import com.intellij.spring.mvc.model.xml.ViewResolverJsp;
import com.intellij.spring.mvc.model.xml.ViewResolverTiles;
import com.intellij.spring.mvc.model.xml.ViewResolverVelocity;
import com.intellij.spring.mvc.model.xml.ViewResolvers;
import com.intellij.spring.mvc.views.BeanNameViewResolverFactory;
import com.intellij.spring.mvc.views.CompositeViewResolver;
import com.intellij.spring.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.mvc.views.ViewResolver;
import com.intellij.spring.mvc.views.ViewResolverFactory;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewResolversViewResolverFactory
extends ViewResolverFactory {
    @Override
    public String getBeanClass() {
        return null;
    }

    @Override
    protected boolean isMine(@Nullable CommonSpringBean bean, @NotNull PsiClass beanClass) {
        if (beanClass == null) {
            ViewResolversViewResolverFactory.$$$reportNull$$$0(0);
        }
        return bean instanceof ViewResolvers;
    }

    @Override
    @NotNull
    protected Set<ViewResolver> createViewResolvers(@Nullable CommonSpringBean bean, CommonSpringModel model) {
        assert (bean != null);
        ViewResolvers viewResolvers = (ViewResolvers)bean;
        List<ViewResolver> resolvers = ViewResolversViewResolverFactory.determineViewResolvers(viewResolvers, model);
        Set<ViewResolver> set = Collections.singleton(new CompositeViewResolver(resolvers));
        if (set == null) {
            ViewResolversViewResolverFactory.$$$reportNull$$$0(1);
        }
        return set;
    }

    private static List<ViewResolver> determineViewResolvers(ViewResolvers viewResolvers, CommonSpringModel model) {
        SmartList resolvers = new SmartList();
        for (DomElement domElement : DomUtil.getDefinedChildren((DomElement)viewResolvers, (boolean)true, (boolean)false)) {
            SpringBeanPointer beanPointer;
            if (domElement instanceof ViewResolverContentNegotiation) continue;
            ViewResolver resolver = ViewResolversViewResolverFactory.createBuiltinResolver(domElement, model);
            if (resolver != null) {
                resolvers.add(resolver);
                continue;
            }
            Object psiClass = domElement instanceof SpringBean ? PsiTypesUtil.getPsiClass((PsiType)((SpringBean)domElement).getBeanType()) : (domElement instanceof SpringRef ? ((beanPointer = (SpringBeanPointer)((SpringRef)domElement).getBean().getValue()) != null ? beanPointer.getBeanClass() : null) : (domElement instanceof ViewResolverTiles ? DomJavaUtil.findClass((String)"org.springframework.web.servlet.view.tiles3.TilesViewResolver", (DomElement)domElement) : null));
            if (psiClass == null) continue;
            ViewResolversViewResolverFactory.findResolversByClass(psiClass, (CommonSpringBean)viewResolvers, model, (List<? super ViewResolver>)resolvers, factory -> !(factory instanceof ViewResolversViewResolverFactory));
        }
        return resolvers;
    }

    @Nullable
    private static ViewResolver createBuiltinResolver(DomElement domElement, CommonSpringModel model) {
        if (domElement instanceof ViewResolverBeanName) {
            Module module = model.getModule();
            return module == null ? null : new BeanNameViewResolverFactory.BeanNameViewResolver(module, "ViewResolverBeanName");
        }
        if (!(domElement instanceof UrlViewResolverType)) {
            return null;
        }
        UrlViewResolverType urlViewResolverType = (UrlViewResolverType)domElement;
        if (domElement instanceof ViewResolverJsp) {
            return ViewResolversViewResolverFactory.createUrlBasedViewResolver(urlViewResolverType, "org.springframework.web.servlet.view.UrlBasedViewResolver", model, "/WEB-INF/", ".jsp");
        }
        if (domElement instanceof ViewResolverVelocity) {
            return ViewResolversViewResolverFactory.createUrlBasedViewResolver(urlViewResolverType, "org.springframework.web.servlet.view.velocity.VelocityViewResolver", model, "", ".vm");
        }
        if (domElement instanceof ViewResolverFreeMarker) {
            return ViewResolversViewResolverFactory.createUrlBasedViewResolver(urlViewResolverType, "org.springframework.web.servlet.view.freemarker.FreeMarkerViewResolver", model, "", ".ftl");
        }
        if (domElement instanceof ViewResolverGroovy) {
            return ViewResolversViewResolverFactory.createUrlBasedViewResolver(urlViewResolverType, "org.springframework.web.servlet.view.UrlBasedViewResolver", model, "", ".tpl");
        }
        return null;
    }

    @Nullable
    private static ViewResolver createUrlBasedViewResolver(UrlViewResolverType urlViewResolverType, String viewResolverClassName, CommonSpringModel model, String defaultPrefix, String defaultSuffix) {
        Module module = model.getModule();
        if (module == null) {
            return null;
        }
        PsiClass viewResolverClass = DomJavaUtil.findClass((String)viewResolverClassName, (DomElement)urlViewResolverType);
        if (viewResolverClass == null) {
            return null;
        }
        Ref result = new Ref();
        ViewResolversViewResolverFactory.processAllMineFactories(null, viewResolverClass, (Processor<? super ViewResolverFactory>)((Processor)factory -> {
            for (ViewResolver resolver : factory.createResolvers(null, viewResolverClass, model)) {
                if (!(resolver instanceof UrlBasedViewResolver)) continue;
                String prefix = StringUtil.defaultIfEmpty((String)urlViewResolverType.getPrefix().getStringValue(), (String)defaultPrefix);
                String suffix = StringUtil.defaultIfEmpty((String)urlViewResolverType.getSuffix().getStringValue(), (String)defaultSuffix);
                result.set((Object)new UrlBasedViewResolver(module, urlViewResolverType.getXmlElementName(), ((UrlBasedViewResolver)resolver).getPath(), StringUtil.defaultIfEmpty((String)((UrlBasedViewResolver)resolver).getPrefix(), (String)prefix), StringUtil.defaultIfEmpty((String)((UrlBasedViewResolver)resolver).getSuffix(), (String)suffix)));
                return false;
            }
            return true;
        }));
        if (!result.isNull()) {
            return (ViewResolver)result.get();
        }
        throw new IllegalArgumentException("no registered resolver for " + viewResolverClassName + " and " + String.valueOf(urlViewResolverType));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/views/ViewResolversViewResolverFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/views/ViewResolversViewResolverFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewResolvers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

