/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.webClient.exchange;

import com.intellij.jam.JamService;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.microservices.utils.UrlMappingBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.spring.mvc.webClient.exchange.HttpExchange;
import com.intellij.spring.mvc.webClient.exchange.SpringExchangeClient;
import com.intellij.spring.mvc.webClient.exchange.SpringExchangeConstants;
import com.intellij.spring.mvc.webClient.exchange.SpringExchangeMapping;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n\u001a\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\f2\u0006\u0010\u000e\u001a\u00020\b\u001a \u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r\u00a8\u0006\u0012"}, d2={"isSpringExchangeClientAvailable", "", "module", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "findSpringExchangeClients", "", "Lcom/intellij/spring/mvc/webClient/exchange/SpringExchangeClient;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getSpringExchangeClientEndpoints", "", "Lcom/intellij/spring/mvc/webClient/exchange/SpringExchangeMapping;", "group", "getFullUrlPath", "", "method", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nSpringExchangeClientModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringExchangeClientModel.kt\ncom/intellij/spring/mvc/webClient/exchange/SpringExchangeClientModelKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1617#2,9:60\n1869#2:69\n1870#2:71\n1626#2:72\n1#3:70\n1#3:73\n*S KotlinDebug\n*F\n+ 1 SpringExchangeClientModel.kt\ncom/intellij/spring/mvc/webClient/exchange/SpringExchangeClientModelKt\n*L\n40#1:60,9\n40#1:69\n40#1:71\n40#1:72\n40#1:70\n*E\n"})
public final class SpringExchangeClientModelKt {
    public static final boolean isSpringExchangeClientAvailable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)"org.springframework.web.service.annotation.HttpExchange");
    }

    public static final boolean isSpringExchangeClientAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)"org.springframework.web.service.annotation.HttpExchange");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<SpringExchangeClient> findSpringExchangeClients(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        GlobalSearchScope globalSearchScope = SpringGlobalSearchScopes.runtime((Module)module, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"runtime(...)");
        GlobalSearchScope apiSearchScope = globalSearchScope;
        LinkedHashSet<PsiClass> hosts = new LinkedHashSet<PsiClass>();
        for (String annotation : SpringExchangeConstants.SPRING_EXCHANGE_METHOD_ANNOTATIONS) {
            for (PsiClass annotationClass : javaPsiFacade.findClasses(annotation, apiSearchScope)) {
                for (PsiMethod method : AnnotatedElementsSearch.searchPsiMethods((PsiClass)annotationClass, (SearchScope)((SearchScope)scope)).asIterable()) {
                    PsiClass containingClass = method.getContainingClass();
                    if (containingClass == null || !containingClass.isInterface()) continue;
                    hosts.add(containingClass);
                }
            }
        }
        PsiClass[] $this$mapNotNull$iv = (PsiClass[])hosts;
        boolean $i$f$mapNotNull = false;
        PsiClass[] psiClassArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            SpringExchangeClient it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PsiClass c = (PsiClass)element$iv$iv;
            boolean bl2 = false;
            if ((SpringExchangeClient)SpringExchangeClient.META.getJamElement((PsiModifierListOwner)c) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<SpringExchangeMapping<?>> getSpringExchangeClientEndpoints(@NotNull SpringExchangeClient group) {
        Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
        PsiElement psiElement = group.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
        PsiClass psiElement2 = (PsiClass)psiElement;
        JamService jamService = JamService.getJamService((Project)psiElement2.getProject());
        List list = jamService.getAnnotatedMembersList(psiElement2, SpringExchangeMapping.MAPPING_JAM_KEY, 10);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAnnotatedMembersList(...)");
        return list;
    }

    @Nullable
    public static final String getFullUrlPath(@Nullable SpringExchangeClient group, @Nullable SpringExchangeMapping<?> method) {
        SpringExchangeMapping httpExchange;
        SpringExchangeMapping springExchangeMapping;
        if (method == null) {
            return null;
        }
        SpringExchangeClient springExchangeClient = group;
        if (springExchangeClient != null && (springExchangeClient = (PsiClass)springExchangeClient.getPsiElement()) != null) {
            SpringExchangeClient it = springExchangeClient;
            boolean bl = false;
            springExchangeMapping = (HttpExchange.ClassMapping)HttpExchange.ClassMapping.META.getJamElement((PsiModifierListOwner)it);
        } else {
            springExchangeMapping = null;
        }
        SpringExchangeMapping springExchangeMapping2 = httpExchange = springExchangeMapping;
        return new UrlMappingBuilder(springExchangeMapping2 != null ? springExchangeMapping2.getResourceValue() : null).appendSegment(method.getResourceValue()).buildOrNull();
    }
}

