/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.implementations;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiFile;
import com.intellij.reactivestreams.implementations.ReactiveStreamsImplementation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lcom/intellij/reactivestreams/implementations/ReactiveStreamsImplementationsManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "implementationsCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "epList", "", "Lcom/intellij/reactivestreams/implementations/ReactiveStreamsImplementation;", "availableImplementations", "", "getAvailableImplementations", "()Ljava/lang/Iterable;", "anyAvailableFor", "", "file", "Lcom/intellij/psi/PsiFile;", "implementationsTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getImplementationsTracker", "()Lcom/intellij/openapi/util/ModificationTracker;", "dispose", "", "Companion", "intellij.reactivestreams"})
@SourceDebugExtension(value={"SMAP\nReactiveStreamsImplementationsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactiveStreamsImplementationsManager.kt\ncom/intellij/reactivestreams/implementations/ReactiveStreamsImplementationsManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n774#2:45\n865#2,2:46\n1761#2,3:48\n*S KotlinDebug\n*F\n+ 1 ReactiveStreamsImplementationsManager.kt\ncom/intellij/reactivestreams/implementations/ReactiveStreamsImplementationsManager\n*L\n27#1:45\n27#1:46,2\n30#1:48,3\n*E\n"})
public final class ReactiveStreamsImplementationsManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicLong implementationsCounter;
    @NotNull
    private volatile List<? extends ReactiveStreamsImplementation> epList;
    @NotNull
    private final ModificationTracker implementationsTracker;
    @NotNull
    private static final ExtensionPointName<ReactiveStreamsImplementation> EP_NAME = ExtensionPointName.Companion.create("com.intellij.reactivestreams.implementation");

    public ReactiveStreamsImplementationsManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.implementationsCounter = new AtomicLong(0L);
        EP_NAME.addChangeListener(() -> ReactiveStreamsImplementationsManager._init_$lambda$0(this), (Disposable)this);
        this.epList = EP_NAME.getExtensionList();
        this.implementationsTracker = () -> ReactiveStreamsImplementationsManager.implementationsTracker$lambda$3(this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<ReactiveStreamsImplementation> getAvailableImplementations() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.epList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ReactiveStreamsImplementation it = (ReactiveStreamsImplementation)element$iv$iv;
            boolean bl = false;
            if (!it.isAvailable(this.project)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean anyAvailableFor(@NotNull PsiFile file) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable $this$any$iv = this.epList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ReactiveStreamsImplementation it = (ReactiveStreamsImplementation)element$iv;
                    boolean bl2 = false;
                    if (!it.isAvailableFor(file)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final ModificationTracker getImplementationsTracker() {
        return this.implementationsTracker;
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(ReactiveStreamsImplementationsManager this$0) {
        this$0.epList = EP_NAME.getExtensionList();
        this$0.implementationsCounter.incrementAndGet();
    }

    private static final long implementationsTracker$lambda$3(ReactiveStreamsImplementationsManager this$0) {
        return this$0.implementationsCounter.get();
    }

    @JvmStatic
    @NotNull
    public static final ReactiveStreamsImplementationsManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/reactivestreams/implementations/ReactiveStreamsImplementationsManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/reactivestreams/implementations/ReactiveStreamsImplementationsManager;", "project", "Lcom/intellij/openapi/project/Project;", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/reactivestreams/implementations/ReactiveStreamsImplementation;", "intellij.reactivestreams"})
    @SourceDebugExtension(value={"SMAP\nReactiveStreamsImplementationsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactiveStreamsImplementationsManager.kt\ncom/intellij/reactivestreams/implementations/ReactiveStreamsImplementationsManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,44:1\n30#2,2:45\n*S KotlinDebug\n*F\n+ 1 ReactiveStreamsImplementationsManager.kt\ncom/intellij/reactivestreams/implementations/ReactiveStreamsImplementationsManager$Companion\n*L\n37#1:45,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ReactiveStreamsImplementationsManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ReactiveStreamsImplementationsManager> serviceClass$iv = ReactiveStreamsImplementationsManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ReactiveStreamsImplementationsManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

