/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.reactivestreams.uast.ex.UFunctionalObject;
import com.intellij.reactivestreams.util.ReactiveStreamsUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastCodeGenerationPluginKt;
import org.jetbrains.uast.generate.UastElementFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@FileModifier.SafeTypeForPreview
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b3\u0018\u00002\u00020\u0001:\u0003\u0010\u0011\u0012B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH&R\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u0082\u0001\u0003\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy;", "", "<init>", "()V", "replace", "", "throwExpression", "Lorg/jetbrains/uast/UThrowExpression;", "project", "Lcom/intellij/openapi/project/Project;", "functionalObject", "Lcom/intellij/reactivestreams/uast/ex/UFunctionalObject;", "text", "", "getText", "()Ljava/lang/String;", "ReplaceWithCall", "ReplaceWithReturn", "ReplaceWithWrappedCall", "Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy$ReplaceWithCall;", "Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy$ReplaceWithReturn;", "Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy$ReplaceWithWrappedCall;", "intellij.reactivestreams.core"})
abstract class InternalReplacementStrategy {
    private InternalReplacementStrategy() {
    }

    public abstract boolean replace(@NotNull UThrowExpression var1, @NotNull Project var2, @NotNull UFunctionalObject<?> var3);

    @NotNull
    public abstract String getText();

    public /* synthetic */ InternalReplacementStrategy(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @FileModifier.SafeTypeForPreview
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy$ReplaceWithCall;", "Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy;", "parameterName", "", "methodName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getMethodName", "()Ljava/lang/String;", "text", "getText", "replace", "", "throwExpression", "Lorg/jetbrains/uast/UThrowExpression;", "project", "Lcom/intellij/openapi/project/Project;", "functionalObject", "Lcom/intellij/reactivestreams/uast/ex/UFunctionalObject;", "Companion", "intellij.reactivestreams.core"})
    public static final class ReplaceWithCall
    extends InternalReplacementStrategy {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String parameterName;
        @NotNull
        private final String methodName;
        @NotNull
        private final String text;

        public ReplaceWithCall(@NotNull String parameterName, @NotNull String methodName) {
            Intrinsics.checkNotNullParameter((Object)parameterName, (String)"parameterName");
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            super(null);
            this.parameterName = parameterName;
            this.methodName = methodName;
            this.text = this.parameterName + "." + this.methodName + "()";
        }

        @NotNull
        public final String getMethodName() {
            return this.methodName;
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        @Override
        public boolean replace(@NotNull UThrowExpression throwExpression, @NotNull Project project, @NotNull UFunctionalObject<?> functionalObject) {
            Intrinsics.checkNotNullParameter((Object)throwExpression, (String)"throwExpression");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(functionalObject, (String)"functionalObject");
            UastElementFactory uastElementFactory = UastCodeGenerationPluginKt.getUastElementFactory((UElement)((UElement)throwExpression), (Project)project);
            if (uastElementFactory == null) {
                return false;
            }
            UastElementFactory factory = uastElementFactory;
            return ReactiveStreamsUtils.replaceAndAddReturnIfNotLastExpression$default((UExpression)throwExpression, throwExpression.getThrownExpression(), factory, functionalObject, this.parameterName, this.methodName, null, 64, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy$ReplaceWithCall$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy$ReplaceWithCall;", "functionalObject", "Lcom/intellij/reactivestreams/uast/ex/UFunctionalObject;", "parameterIndex", "", "methodName", "", "intellij.reactivestreams.core"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final ReplaceWithCall create(@NotNull UFunctionalObject<?> functionalObject, int parameterIndex, @NotNull String methodName) {
                ReplaceWithCall replaceWithCall;
                String string;
                Intrinsics.checkNotNullParameter(functionalObject, (String)"functionalObject");
                Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
                UParameter uParameter = (UParameter)CollectionsKt.getOrNull(functionalObject.getValueParameters(), (int)parameterIndex);
                if (uParameter != null && (string = uParameter.getName()) != null) {
                    String it = string;
                    boolean bl = false;
                    replaceWithCall = new ReplaceWithCall(it, methodName);
                } else {
                    replaceWithCall = null;
                }
                return replaceWithCall;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @FileModifier.SafeTypeForPreview
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy$ReplaceWithReturn;", "Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy;", "receiverReferenceName", "", "methodName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getReceiverReferenceName", "()Ljava/lang/String;", "getMethodName", "text", "getText", "replace", "", "throwExpression", "Lorg/jetbrains/uast/UThrowExpression;", "project", "Lcom/intellij/openapi/project/Project;", "functionalObject", "Lcom/intellij/reactivestreams/uast/ex/UFunctionalObject;", "Companion", "intellij.reactivestreams.core"})
    @SourceDebugExtension(value={"SMAP\nReactiveStreamsThrowInOperatorInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactiveStreamsThrowInOperatorInspection.kt\ncom/intellij/reactivestreams/inspections/InternalReplacementStrategy$ReplaceWithReturn\n+ 2 UastCodeGenerationPlugin.kt\norg/jetbrains/uast/generate/UastCodeGenerationPluginKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,284:1\n229#2,6:285\n236#2:292\n14#3:291\n*S KotlinDebug\n*F\n+ 1 ReactiveStreamsThrowInOperatorInspection.kt\ncom/intellij/reactivestreams/inspections/InternalReplacementStrategy$ReplaceWithReturn\n*L\n174#1:285,6\n174#1:292\n174#1:291\n*E\n"})
    public static final class ReplaceWithReturn
    extends InternalReplacementStrategy {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String receiverReferenceName;
        @NotNull
        private final String methodName;
        @NotNull
        private final String text;

        private ReplaceWithReturn(String receiverReferenceName, String methodName) {
            super(null);
            this.receiverReferenceName = receiverReferenceName;
            this.methodName = methodName;
            this.text = "return " + StringsKt.substringAfterLast$default((String)this.receiverReferenceName, (String)".", null, (int)2, null) + "." + this.methodName + "()";
        }

        @NotNull
        public final String getReceiverReferenceName() {
            return this.receiverReferenceName;
        }

        @NotNull
        public final String getMethodName() {
            return this.methodName;
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean replace(@NotNull UThrowExpression throwExpression, @NotNull Project project, @NotNull UFunctionalObject<?> functionalObject) {
            UElement uElement;
            void $this$replace$iv;
            UExpression uExpression;
            Intrinsics.checkNotNullParameter((Object)throwExpression, (String)"throwExpression");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(functionalObject, (String)"functionalObject");
            UastElementFactory uastElementFactory = UastCodeGenerationPluginKt.getUastElementFactory((UElement)((UElement)throwExpression), (Project)project);
            if (uastElementFactory == null) {
                return false;
            }
            UastElementFactory factory = uastElementFactory;
            UQualifiedReferenceExpression receiver = factory.createQualifiedReference(this.receiverReferenceName, throwExpression.getSourcePsi());
            UCallExpression uCallExpression = UastElementFactory.createCallExpression$default((UastElementFactory)factory, (UExpression)((UExpression)receiver), (String)this.methodName, (List)CollectionsKt.listOf((Object)throwExpression.getThrownExpression()), null, (UastCallKind)UastCallKind.METHOD_CALL, null, (int)32, null);
            if (uCallExpression == null || (uExpression = UastUtils.getQualifiedParentOrThis((UExpression)((UExpression)uCallExpression))) == null) {
                return false;
            }
            UExpression methodCall = uExpression;
            UReturnExpression uReturnExpression = factory.createReturnExpression(methodCall, functionalObject.getWrappedExpression() instanceof ULambdaExpression, throwExpression.getSourcePsi());
            if (uReturnExpression == null) {
                return false;
            }
            UReturnExpression returnExpression = uReturnExpression;
            UElement uElement2 = (UElement)throwExpression;
            UElement newElement$iv = (UElement)returnExpression;
            boolean $i$f$replace = false;
            if (Intrinsics.areEqual((Object)$this$replace$iv, (Object)newElement$iv)) {
                uElement = newElement$iv;
            } else {
                UastCodeGenerationPlugin uastCodeGenerationPlugin = UastCodeGenerationPlugin.Companion.byLanguage($this$replace$iv.getLang());
                UastCodeGenerationPlugin it$iv = uastCodeGenerationPlugin = uastCodeGenerationPlugin != null ? uastCodeGenerationPlugin.replace((UElement)$this$replace$iv, newElement$iv, UReturnExpression.class) : null;
                boolean bl = false;
                if (it$iv == null) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(UastCodeGenerationPlugin.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("failed replacing the " + (UElement)$this$replace$iv + " with " + newElement$iv);
                }
                uElement = uastCodeGenerationPlugin;
            }
            return (UReturnExpression)uElement != null;
        }

        public /* synthetic */ ReplaceWithReturn(String receiverReferenceName, String methodName, DefaultConstructorMarker $constructor_marker) {
            this(receiverReferenceName, methodName);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy$ReplaceWithReturn$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy$ReplaceWithReturn;", "referenceName", "", "methodName", "intellij.reactivestreams.core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ReplaceWithReturn create(@NotNull String referenceName, @NotNull String methodName) {
                Intrinsics.checkNotNullParameter((Object)referenceName, (String)"referenceName");
                Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
                return new ReplaceWithReturn(referenceName, methodName, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @FileModifier.SafeTypeForPreview
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy$ReplaceWithWrappedCall;", "Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy;", "classFqn", "", "methodName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "text", "getText", "()Ljava/lang/String;", "replace", "", "throwExpression", "Lorg/jetbrains/uast/UThrowExpression;", "project", "Lcom/intellij/openapi/project/Project;", "functionalObject", "Lcom/intellij/reactivestreams/uast/ex/UFunctionalObject;", "getSimpleClassName", "Companion", "intellij.reactivestreams.core"})
    @SourceDebugExtension(value={"SMAP\nReactiveStreamsThrowInOperatorInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactiveStreamsThrowInOperatorInspection.kt\ncom/intellij/reactivestreams/inspections/InternalReplacementStrategy$ReplaceWithWrappedCall\n+ 2 UastCodeGenerationPlugin.kt\norg/jetbrains/uast/generate/UastCodeGenerationPluginKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,284:1\n229#2,6:285\n236#2:292\n14#3:291\n*S KotlinDebug\n*F\n+ 1 ReactiveStreamsThrowInOperatorInspection.kt\ncom/intellij/reactivestreams/inspections/InternalReplacementStrategy$ReplaceWithWrappedCall\n*L\n203#1:285,6\n203#1:292\n203#1:291\n*E\n"})
    public static final class ReplaceWithWrappedCall
    extends InternalReplacementStrategy {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String classFqn;
        @NotNull
        private final String methodName;

        public ReplaceWithWrappedCall(@NotNull String classFqn, @NotNull String methodName) {
            Intrinsics.checkNotNullParameter((Object)classFqn, (String)"classFqn");
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            super(null);
            this.classFqn = classFqn;
            this.methodName = methodName;
        }

        @Override
        @NotNull
        public String getText() {
            return this.getSimpleClassName() + "." + this.methodName + "()";
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean replace(@NotNull UThrowExpression throwExpression, @NotNull Project project, @NotNull UFunctionalObject<?> functionalObject) {
            UElement uElement;
            void $this$replace$iv;
            Intrinsics.checkNotNullParameter((Object)throwExpression, (String)"throwExpression");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(functionalObject, (String)"functionalObject");
            UastElementFactory uastElementFactory = UastCodeGenerationPluginKt.getUastElementFactory((UElement)((UElement)throwExpression), (Project)project);
            if (uastElementFactory == null) {
                return false;
            }
            UastElementFactory factory = uastElementFactory;
            UQualifiedReferenceExpression receiver = factory.createQualifiedReference(this.classFqn, throwExpression.getSourcePsi());
            UCallExpression uCallExpression = UastElementFactory.createCallExpression$default((UastElementFactory)factory, (UExpression)((UExpression)receiver), (String)this.methodName, (List)CollectionsKt.listOf((Object)functionalObject.getWrappedExpression()), null, (UastCallKind)UastCallKind.METHOD_CALL, null, (int)32, null);
            if (uCallExpression == null) {
                return false;
            }
            UCallExpression uncheckedCall = uCallExpression;
            UElement uElement2 = (UElement)functionalObject.getWrappedExpression();
            UElement newElement$iv = (UElement)uncheckedCall;
            boolean $i$f$replace = false;
            if (Intrinsics.areEqual((Object)$this$replace$iv, (Object)newElement$iv)) {
                uElement = newElement$iv;
            } else {
                UastCodeGenerationPlugin uastCodeGenerationPlugin = UastCodeGenerationPlugin.Companion.byLanguage($this$replace$iv.getLang());
                UastCodeGenerationPlugin it$iv = uastCodeGenerationPlugin = uastCodeGenerationPlugin != null ? uastCodeGenerationPlugin.replace((UElement)$this$replace$iv, newElement$iv, UCallExpression.class) : null;
                boolean bl = false;
                if (it$iv == null) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(UastCodeGenerationPlugin.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("failed replacing the " + (UElement)$this$replace$iv + " with " + newElement$iv);
                }
                uElement = uastCodeGenerationPlugin;
            }
            return (UCallExpression)uElement != null;
        }

        private final String getSimpleClassName() {
            char[] cArray = new char[]{'.'};
            return (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)this.classFqn, (char[])cArray, (boolean)false, (int)0, (int)6, null));
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy$ReplaceWithWrappedCall$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy$ReplaceWithWrappedCall;", "classFqn", "", "methodName", "intellij.reactivestreams.core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ReplaceWithWrappedCall create(@NotNull String classFqn, @NotNull String methodName) {
                Intrinsics.checkNotNullParameter((Object)classFqn, (String)"classFqn");
                Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
                return new ReplaceWithWrappedCall(classFqn, methodName);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

