/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.inspections;

import com.intellij.codeInspection.AnalysisUastUtilKt;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.reactivestreams.ReactiveStreamsBundle;
import com.intellij.reactivestreams.implementations.ReactiveStreamsInspectionsManager;
import com.intellij.reactivestreams.inspections.ReactiveStreamsInterfaceImplementationInspectionBase;
import com.intellij.uast.UastHintedVisitorAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0014J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000b*\u0004\u0018\u00010\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsPublisherImplementationInspection;", "Lcom/intellij/reactivestreams/inspections/ReactiveStreamsInterfaceImplementationInspectionBase;", "<init>", "()V", "doBuildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "onTheFly", "", "getInterfaceQualifiedName", "", "getProblemDescription", "getExpectedType", "Lcom/intellij/psi/PsiType;", "Lorg/jetbrains/uast/UCallableReferenceExpression;", "getQualifiedClassName", "intellij.reactivestreams.core"})
public final class ReactiveStreamsPublisherImplementationInspection
extends ReactiveStreamsInterfaceImplementationInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ReactiveStreamsInspectionsManager inspectionsManager = ReactiveStreamsInspectionsManager.Companion.getInstance(project);
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{UClass.class, ULambdaExpression.class, UCallableReferenceExpression.class};
        return UastHintedVisitorAdapter.Companion.create$default((UastHintedVisitorAdapter.Companion)UastHintedVisitorAdapter.Companion, (Language)language, (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(this, holder, onTheFly, inspectionsManager){
            final /* synthetic */ ReactiveStreamsPublisherImplementationInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ ReactiveStreamsInspectionsManager $inspectionsManager;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$onTheFly = $onTheFly;
                this.$inspectionsManager = $inspectionsManager;
            }

            /*
             * WARNING - void declaration
             */
            public boolean visitClass(UClass node) {
                ProblemDescriptor[] problemDescriptors;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (problemDescriptors != null) {
                    void $this$forEach$iv;
                    ProblemDescriptor[] problemDescriptorArray = problemDescriptors = this.this$0.checkClass(node, this.$holder.getManager(), this.$onTheFly);
                    ProblemsHolder problemsHolder = this.$holder;
                    boolean $i$f$forEach = false;
                    int n = ((void)$this$forEach$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void it = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        problemsHolder.registerProblem((ProblemDescriptor)it);
                    }
                }
                return super.visitClass(node);
            }

            public boolean visitLambdaExpression(ULambdaExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (ReactiveStreamsInterfaceImplementationInspectionBase.isInsideImplementation(this.$inspectionsManager, (UElement)node)) {
                    return super.visitLambdaExpression(node);
                }
                PsiElement elementToHighlight = node.getSourcePsi();
                if (Intrinsics.areEqual((Object)ReactiveStreamsPublisherImplementationInspection.access$getQualifiedClassName(this.this$0, AnalysisUastUtilKt.getLambdaType((ULambdaExpression)node)), (Object)this.this$0.getInterfaceQualifiedName()) && elementToHighlight != null) {
                    this.$holder.registerProblem(elementToHighlight, ReactiveStreamsBundle.message("inspections.publisher.problem.lambda.description", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
                return super.visitLambdaExpression(node);
            }

            public boolean visitCallableReferenceExpression(UCallableReferenceExpression node) {
                UElement elementToHighlight;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (ReactiveStreamsInterfaceImplementationInspectionBase.isInsideImplementation(this.$inspectionsManager, (UElement)node)) {
                    return super.visitCallableReferenceExpression(node);
                }
                UElement uElement = node.getReferenceNameElement();
                if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
                    uElement = elementToHighlight = node.getSourcePsi();
                }
                if (Intrinsics.areEqual((Object)ReactiveStreamsPublisherImplementationInspection.access$getQualifiedClassName(this.this$0, ReactiveStreamsPublisherImplementationInspection.access$getExpectedType(this.this$0, node)), (Object)this.this$0.getInterfaceQualifiedName()) && elementToHighlight != null) {
                    this.$holder.registerProblem((PsiElement)elementToHighlight, ReactiveStreamsBundle.message("inspections.publisher.problem.callable.reference.description", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
                return super.visitCallableReferenceExpression(node);
            }
        }, (Class[])classArray, (boolean)false, (int)8, null);
    }

    @Override
    @NotNull
    protected String getInterfaceQualifiedName() {
        return "org.reactivestreams.Publisher";
    }

    @Override
    @NotNull
    protected String getProblemDescription() {
        return ReactiveStreamsBundle.message("inspections.publisher.problem.description", new Object[0]);
    }

    private final PsiType getExpectedType(UCallableReferenceExpression $this$getExpectedType) {
        UElement uElement;
        block12: {
            block11: {
                Object object;
                uElement = $this$getExpectedType.getUastParent();
                if (uElement == null) break block11;
                UElement it = uElement;
                boolean bl = false;
                UElement uElement2 = it;
                if (uElement2 instanceof UVariable) {
                    object = ((UVariable)it).getType();
                } else if (uElement2 instanceof UCallExpression) {
                    PsiParameter psiParameter = UastUtils.getParameterForArgument((UCallExpression)((UCallExpression)it), (UExpression)((UExpression)$this$getExpectedType));
                    object = psiParameter != null ? psiParameter.getType() : null;
                } else if (uElement2 instanceof UReturnExpression) {
                    UElement uElement3 = ((UReturnExpression)it).getJumpTarget();
                    if (uElement3 != null) {
                        UElement jumpTarget = uElement3;
                        boolean bl2 = false;
                        UElement uElement4 = jumpTarget;
                        object = uElement4 instanceof UMethod ? ((UMethod)jumpTarget).getReturnType() : (uElement4 instanceof ULambdaExpression ? AnalysisUastUtilKt.getReturnType((ULambdaExpression)((ULambdaExpression)jumpTarget)) : null);
                    } else {
                        object = null;
                    }
                } else {
                    object = null;
                }
                uElement = object;
                if (object != null) break block12;
            }
            uElement = $this$getExpectedType.getExpressionType();
        }
        return uElement;
    }

    private final String getQualifiedClassName(PsiType $this$getQualifiedClassName) {
        if ($this$getQualifiedClassName == null) {
            return null;
        }
        PsiClassType psiClassType = $this$getQualifiedClassName instanceof PsiClassType ? (PsiClassType)$this$getQualifiedClassName : null;
        return psiClassType != null && (psiClassType = psiClassType.resolve()) != null ? psiClassType.getQualifiedName() : null;
    }

    public static final /* synthetic */ String access$getQualifiedClassName(ReactiveStreamsPublisherImplementationInspection $this, PsiType $receiver) {
        return $this.getQualifiedClassName($receiver);
    }

    public static final /* synthetic */ PsiType access$getExpectedType(ReactiveStreamsPublisherImplementationInspection $this, UCallableReferenceExpression $receiver) {
        return $this.getExpectedType($receiver);
    }
}

