/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.reactivestreams.ReactiveStreamsBundle;
import com.intellij.reactivestreams.implementations.ReactiveStreamsInspectionsManager;
import com.intellij.reactivestreams.inspections.ReactiveStreamsUastInspectionBase;
import com.intellij.reactivestreams.intentions.CollapseFiltersWithPreviousQuickFix;
import com.intellij.reactivestreams.intentions.CollapseMapsWithPreviousQuickFix;
import com.intellij.reactivestreams.intentions.CollapseSameMethodsWithPreviousQuickFix;
import com.intellij.reactivestreams.util.ReactiveStreamsUtils;
import com.intellij.ultimate.PluginVerifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsTooLongSameOperatorsChainInspection;", "Lcom/intellij/reactivestreams/inspections/ReactiveStreamsUastInspectionBase;", "<init>", "()V", "methodsToCheck", "", "", "maxChainLength", "", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "doBuildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "onTheFly", "", "getSameMethodsChain", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/uast/UCallExpression;", "methodCall", "intellij.reactivestreams.core"})
@SourceDebugExtension(value={"SMAP\nReactiveStreamsTooLongSameOperatorsChainInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactiveStreamsTooLongSameOperatorsChainInspection.kt\ncom/intellij/reactivestreams/inspections/ReactiveStreamsTooLongSameOperatorsChainInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class ReactiveStreamsTooLongSameOperatorsChainInspection
extends ReactiveStreamsUastInspectionBase {
    @NotNull
    private final Set<String> methodsToCheck;
    @JvmField
    public int maxChainLength;

    public ReactiveStreamsTooLongSameOperatorsChainInspection() {
        super(new Class[0]);
        PluginVerifier.verifyUltimatePlugin();
        Object[] objectArray = new String[]{"filter", "map"};
        this.methodsToCheck = SetsKt.setOf((Object[])objectArray);
        this.maxChainLength = 2;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.number((String)"maxChainLength", (String)ReactiveStreamsBundle.message("inspections.too.long.map.chain.settings.field", new Object[0]), (int)1, (int)100)};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PsiElementVisitor(this, holder, onTheFly){
            final /* synthetic */ ReactiveStreamsTooLongSameOperatorsChainInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $onTheFly;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$onTheFly = $onTheFly;
            }

            /*
             * WARNING - void declaration
             */
            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement $this$toUElementOfType$iv = element;
                boolean $i$f$toUElementOfType = false;
                UCallExpression uCallExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UCallExpression.class);
                if (uCallExpression == null) {
                    return;
                }
                UCallExpression methodCall = uCallExpression;
                if (!CollectionsKt.contains((Iterable)ReactiveStreamsTooLongSameOperatorsChainInspection.access$getMethodsToCheck$p(this.this$0), (Object)methodCall.getMethodName())) {
                    return;
                }
                String string = methodCall.getMethodName();
                Intrinsics.checkNotNull((Object)string);
                String currentMethodName = string;
                UCallExpression uCallExpression2 = ReactiveStreamsUtils.getPrevCallInChain(methodCall);
                if (Intrinsics.areEqual((Object)(uCallExpression2 != null ? uCallExpression2.getMethodName() : null), (Object)currentMethodName)) {
                    return;
                }
                Project project = this.$holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (!ReactiveStreamsInspectionsManager.Companion.getInstance(project).isCollapsableMethodDefinedInPublisher(methodCall)) {
                    return;
                }
                Sequence $this$forEachIndexed$iv = ReactiveStreamsTooLongSameOperatorsChainInspection.access$getSameMethodsChain(this.this$0, methodCall);
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (E item$iv : $this$forEachIndexed$iv) {
                    void h;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    UCallExpression uCallExpression3 = (UCallExpression)item$iv;
                    int methodCallNumber = n;
                    boolean bl = false;
                    this.registerProblem((UCallExpression)h, currentMethodName, methodCallNumber + 1);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void registerProblem(UCallExpression $this$registerProblem, String methodName, int methodCallNumber) {
                void $this$filterTo$iv$iv;
                Object[] $this$filter$iv;
                List list;
                if (!this.$onTheFly && methodCallNumber <= this.this$0.maxChainLength) {
                    return;
                }
                Object object = methodName;
                if (Intrinsics.areEqual((Object)object, (Object)"map")) {
                    list = CollectionsKt.listOf((Object)((Object)new CollapseMapsWithPreviousQuickFix()));
                } else if (Intrinsics.areEqual((Object)object, (Object)"filter")) {
                    list = CollectionsKt.listOf((Object)((Object)new CollapseFiltersWithPreviousQuickFix()));
                } else {
                    return;
                }
                object = list;
                boolean $i$f$filter = false;
                void var7_6 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    CollapseSameMethodsWithPreviousQuickFix it = (CollapseSameMethodsWithPreviousQuickFix)((Object)element$iv$iv);
                    boolean bl = false;
                    if (!it.isAvailable$intellij_reactivestreams_core($this$registerProblem)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List quickFixes = (List)destination$iv$iv;
                UIdentifier uIdentifier = $this$registerProblem.getMethodIdentifier();
                if (uIdentifier == null || (uIdentifier = uIdentifier.getSourcePsi()) == null) {
                    return;
                }
                $this$filter$iv = new Object[]{methodName};
                Collection $this$toTypedArray$iv = quickFixes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                this.$holder.registerProblem(this.$holder.getManager().createProblemDescriptor((PsiElement)uIdentifier, ReactiveStreamsBundle.message("inspections.too.long.map.chain.description", $this$filter$iv), this.$onTheFly, (LocalQuickFix[])thisCollection$iv.toArray(new CollapseSameMethodsWithPreviousQuickFix[0]), methodCallNumber > this.this$0.maxChainLength ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION));
            }
        };
    }

    private final Sequence<UCallExpression> getSameMethodsChain(UCallExpression methodCall) {
        return SequencesKt.generateSequence((Object)methodCall, arg_0 -> ReactiveStreamsTooLongSameOperatorsChainInspection.getSameMethodsChain$lambda$1(methodCall, arg_0));
    }

    private static final UCallExpression getSameMethodsChain$lambda$1(UCallExpression $methodCall, UCallExpression call) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        UCallExpression uCallExpression = ReactiveStreamsUtils.getNextCallInChain(call);
        if (uCallExpression != null) {
            UCallExpression uCallExpression2;
            UCallExpression it = uCallExpression2 = uCallExpression;
            boolean bl = false;
            object = Intrinsics.areEqual((Object)it.getMethodName(), (Object)$methodCall.getMethodName()) ? uCallExpression2 : null;
        } else {
            object = null;
        }
        return object;
    }

    public static final /* synthetic */ Set access$getMethodsToCheck$p(ReactiveStreamsTooLongSameOperatorsChainInspection $this) {
        return $this.methodsToCheck;
    }

    public static final /* synthetic */ Sequence access$getSameMethodsChain(ReactiveStreamsTooLongSameOperatorsChainInspection $this, UCallExpression methodCall) {
        return $this.getSameMethodsChain(methodCall);
    }
}

