/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.reactivestreams.inspections.ReactiveStreamsNullableInLambdaInTransformInspectionKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/intellij/reactivestreams/inspections/ReturnVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "functionElement", "Lorg/jetbrains/uast/UElement;", "quickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;ZLorg/jetbrains/uast/UElement;Ljava/util/List;)V", "getQuickFixes", "()Ljava/util/List;", "visitReturnExpression", "node", "Lorg/jetbrains/uast/UReturnExpression;", "intellij.reactivestreams.core"})
@SourceDebugExtension(value={"SMAP\nReactiveStreamsNullableInLambdaInTransformInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactiveStreamsNullableInLambdaInTransformInspection.kt\ncom/intellij/reactivestreams/inspections/ReturnVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1#2:130\n*E\n"})
final class ReturnVisitor
extends AbstractUastVisitor {
    @NotNull
    private final ProblemsHolder problemsHolder;
    private final boolean isOnTheFly;
    @NotNull
    private final UElement functionElement;
    @NotNull
    private final List<LocalQuickFix> quickFixes;

    public ReturnVisitor(@NotNull ProblemsHolder problemsHolder, boolean isOnTheFly, @NotNull UElement functionElement, @NotNull List<? extends LocalQuickFix> quickFixes) {
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        Intrinsics.checkNotNullParameter((Object)functionElement, (String)"functionElement");
        Intrinsics.checkNotNullParameter(quickFixes, (String)"quickFixes");
        this.problemsHolder = problemsHolder;
        this.isOnTheFly = isOnTheFly;
        this.functionElement = functionElement;
        this.quickFixes = quickFixes;
    }

    @NotNull
    public final List<LocalQuickFix> getQuickFixes() {
        return this.quickFixes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean visitReturnExpression(@NotNull UReturnExpression node) {
        UExpression uExpression;
        UReturnExpression uReturnExpression;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UReturnExpression it = uReturnExpression = node;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)it.getJumpTarget(), (Object)this.functionElement)) return false;
        UExpression uExpression2 = it.getReturnExpression();
        if (uExpression2 == null) return false;
        Project project = this.problemsHolder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!ReactiveStreamsNullableInLambdaInTransformInspectionKt.access$isNullable(uExpression2, project)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        UReturnExpression uReturnExpression2 = uReturnExpression;
        UReturnExpression uReturnExpression3 = uReturnExpression2;
        if (uReturnExpression3 == null) return false;
        UReturnExpression it2 = uReturnExpression3;
        boolean bl4 = false;
        if (it2.getSourcePsi() == null) {
            UExpression uExpression = it2.getReturnExpression();
            uExpression = uExpression;
            Intrinsics.checkNotNull((Object)uExpression3);
        } else {
            uExpression = (UExpression)it2;
        }
        if ((uReturnExpression = uExpression) == null) return false;
        ReactiveStreamsNullableInLambdaInTransformInspectionKt.access$addProblemToHolder((UExpression)uReturnExpression, this.problemsHolder, this.isOnTheFly, this.quickFixes);
        return false;
    }
}

