/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.mutiny.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.reactivestreams.ReactiveStreamsBundle;
import com.intellij.reactivestreams.inspections.ReactiveStreamsBaseNonBlockingScopeInspection;
import com.intellij.reactivestreams.mutiny.MutinyLibraryUtilKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J-\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011H\u0014\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/reactivestreams/mutiny/inspections/MutinyCallingSubscribeInNonBlockingScopeInspection;", "Lcom/intellij/reactivestreams/inspections/ReactiveStreamsBaseNonBlockingScopeInspection;", "<init>", "()V", "SUBSCRIBE_METHOD_NAME", "", "isAvailable", "", "file", "Lcom/intellij/psi/PsiFile;", "report", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "methodIdentifierPsi", "Lcom/intellij/psi/PsiElement;", "quickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/psi/PsiElement;[Lcom/intellij/codeInspection/LocalQuickFix;)V", "shouldReportCall", "receiver", "Lorg/jetbrains/uast/UExpression;", "expression", "Lorg/jetbrains/uast/UCallExpression;", "intellij.reactivestreams.mutiny"})
public final class MutinyCallingSubscribeInNonBlockingScopeInspection
extends ReactiveStreamsBaseNonBlockingScopeInspection {
    @NotNull
    private final String SUBSCRIBE_METHOD_NAME;

    public MutinyCallingSubscribeInNonBlockingScopeInspection() {
        this.SUBSCRIBE_METHOD_NAME = "subscribe";
    }

    @Override
    protected boolean isAvailable(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return MutinyLibraryUtilKt.hasMutinyLibraryFor(file);
    }

    @Override
    protected void report(@NotNull ProblemsHolder holder, @NotNull PsiElement methodIdentifierPsi, @NotNull LocalQuickFix[] quickFixes) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)methodIdentifierPsi, (String)"methodIdentifierPsi");
        Intrinsics.checkNotNullParameter((Object)quickFixes, (String)"quickFixes");
        holder.registerProblem(methodIdentifierPsi, ReactiveStreamsBundle.message("inspections.subscription.in.reactive.scope.text", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(quickFixes, quickFixes.length));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean shouldReportCall(@Nullable UExpression receiver, @Nullable UCallExpression expression) {
        UCallExpression uCallExpression = expression;
        if (!MutinyLibraryUtilKt.isMutinyPublisher(uCallExpression != null && (uCallExpression = uCallExpression.resolve()) != null ? uCallExpression.getContainingClass() : null)) return false;
        UCallExpression uCallExpression2 = expression;
        if (!Intrinsics.areEqual((Object)this.SUBSCRIBE_METHOD_NAME, (Object)(uCallExpression2 != null ? uCallExpression2.getMethodName() : null))) return false;
        return true;
    }
}

