/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.mutiny.inspections.mutiny;

import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.codeInspection.blockingCallsDetection.MethodContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.reactivestreams.mutiny.MutinyConstantsKt;
import com.intellij.reactivestreams.mutiny.MutinyLibraryUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/reactivestreams/mutiny/inspections/mutiny/MutinyBlockingMethodChecker;", "Lcom/intellij/codeInspection/blockingCallsDetection/BlockingMethodChecker;", "<init>", "()V", "isApplicable", "", "file", "Lcom/intellij/psi/PsiFile;", "isMethodBlocking", "context", "Lcom/intellij/codeInspection/blockingCallsDetection/MethodContext;", "isMethodNonBlocking", "intellij.reactivestreams.mutiny"})
public final class MutinyBlockingMethodChecker
implements BlockingMethodChecker {
    public boolean isApplicable(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JavaPsiFacade.getInstance((Project)file.getProject()).findClass("io.smallrye.mutiny.Uni", file.getResolveScope()) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMethodBlocking(@NotNull MethodContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiMethod method = context.getElement();
        PsiClass psiClass = method.getContainingClass();
        if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"io.smallrye.mutiny.groups.UniAwait")) return true;
        PsiClass psiClass2 = method.getContainingClass();
        if (!Intrinsics.areEqual((Object)(psiClass2 != null ? psiClass2.getQualifiedName() : null), (Object)"io.smallrye.mutiny.groups.MultiSubscribe")) return false;
        if (!MutinyConstantsKt.getMULTI_BLOCKING_SUBSCRIPTIONS().contains(method.getName())) return false;
        return true;
    }

    public boolean isMethodNonBlocking(@NotNull MethodContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiType psiType = context.getElement().getReturnType();
        return psiType != null ? MutinyLibraryUtilKt.isMutinyPublisher(psiType) : false;
    }
}

