/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.debugger.streams;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.reactivestreams.reactor.ReactorCoreBundle;
import com.intellij.reactivestreams.settings.ReactiveStreamsSettings;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J:\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0004J\u001e\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020 \u0018\u00010\u001f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lcom/intellij/reactivestreams/reactor/debugger/streams/ReactorChildEvaluator;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "settings", "Lcom/intellij/reactivestreams/settings/ReactiveStreamsSettings;", "getSettings", "()Lcom/intellij/reactivestreams/settings/ReactiveStreamsSettings;", "tryToBuildChildren", "", "parentObject", "Lcom/sun/jdi/ObjectReference;", "builder", "Lcom/intellij/debugger/ui/tree/render/ChildrenBuilder;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "buildChildren", "convertToFutureAndGetResult", "monoResult", "invokeMethod", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "parent", "methodName", "", "arguments", "", "Lcom/sun/jdi/Value;", "getDebugProcessAndVmProxy", "Lkotlin/Pair;", "Lcom/intellij/debugger/jdi/VirtualMachineProxyImpl;", "intellij.reactivestreams.reactor"})
@SourceDebugExtension(value={"SMAP\nReactorChildEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactorChildEvaluator.kt\ncom/intellij/reactivestreams/reactor/debugger/streams/ReactorChildEvaluator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n295#2,2:201\n1#3:203\n*S KotlinDebug\n*F\n+ 1 ReactorChildEvaluator.kt\ncom/intellij/reactivestreams/reactor/debugger/streams/ReactorChildEvaluator\n*L\n60#1:201,2\n*E\n"})
public abstract class ReactorChildEvaluator {
    @NotNull
    private final ReactiveStreamsSettings settings;

    public ReactorChildEvaluator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.settings = ReactiveStreamsSettings.Companion.getInstance(project);
    }

    @NotNull
    protected final ReactiveStreamsSettings getSettings() {
        return this.settings;
    }

    public abstract void tryToBuildChildren(@NotNull ObjectReference var1, @NotNull ChildrenBuilder var2, @NotNull EvaluationContext var3);

    /*
     * Unable to fully structure code
     */
    public final void buildChildren(@NotNull ObjectReference parentObject, @NotNull ChildrenBuilder builder, @Nullable EvaluationContext evaluationContext) {
        Intrinsics.checkNotNullParameter((Object)parentObject, (String)"parentObject");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (evaluationContext == null) {
            return;
        }
        try {
            this.tryToBuildChildren(parentObject, builder, evaluationContext);
        }
        catch (EvaluateException e) {
            block8: {
                targetException = e.getExceptionFromTargetVM();
                if (targetException == null || (var7_6 = targetException.referenceType()) == null || (var8_7 = var7_6.allFields()) == null) ** GOTO lbl-1000
                var10_8 = var8_7;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (Field)element$iv;
                    $i$a$-firstOrNull-ReactorChildEvaluator$buildChildren$childException$1 = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)"cause")) continue;
                    v0 = element$iv;
                    break block8;
                }
                v0 = null;
            }
            var9_17 = v0;
            if (var9_17 != null) {
                it = var9_17;
                $i$a$-let-ReactorChildEvaluator$buildChildren$childException$2 = false;
                v1 = targetException.getValue(it);
            } else lbl-1000:
            // 2 sources

            {
                v1 = childException = null;
            }
            if (childException == null && targetException == null) {
                builder.addChildren(CollectionsKt.emptyList(), true);
                builder.setErrorMessage(ReactorCoreBundle.message("debug.expression.exception.retrieve.error.name", new Object[0]));
                return;
            }
            v2 = childException;
            if (v2 == null) {
                v2 = targetException;
            }
            Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type com.sun.jdi.ObjectReference");
            exceptionToShow = (ObjectReference)v2;
            v3 = DebugProcessImpl.getDefaultRenderer((Value)exceptionToShow);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getDefaultRenderer(...)");
            renderer = v3;
            renderer.buildChildren((Value)exceptionToShow, builder, evaluationContext);
            var11_11 = new Object[]{exceptionToShow.referenceType().name()};
            v4 = JavaDebuggerBundle.message((String)"evaluation.error.method.exception", (Object[])var11_11);
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"message(...)");
            text = v4;
            builder.setErrorMessage(text);
        }
    }

    @Nullable
    protected final ObjectReference convertToFutureAndGetResult(@NotNull ObjectReference monoResult, @NotNull EvaluationContext evaluationContext) {
        Intrinsics.checkNotNullParameter((Object)monoResult, (String)"monoResult");
        Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
        Pair<DebugProcess, VirtualMachineProxyImpl> pair = this.getDebugProcessAndVmProxy(evaluationContext);
        if (pair == null) {
            return null;
        }
        Pair<DebugProcess, VirtualMachineProxyImpl> pair2 = pair;
        DebugProcess debugProcess = (DebugProcess)pair2.component1();
        VirtualMachineProxyImpl proxy = (VirtualMachineProxyImpl)pair2.component2();
        Object object = proxy.classesByName("java.time.Duration");
        if (object == null || (object = (ReferenceType)CollectionsKt.firstOrNull((List)object)) == null) {
            return null;
        }
        Object durationClass = object;
        Method method = DebuggerUtils.findMethod((ReferenceType)durationClass, (String)"ofSeconds", null);
        if (method == null) {
            return null;
        }
        Method method2 = method;
        IntegerValue timeoutArgument = proxy.mirrorOf(this.settings.getDebuggerStreamTimeoutInSeconds());
        Value duration = debugProcess.invokeMethod(evaluationContext, (ClassType)durationClass, method2, CollectionsKt.listOf((Object)timeoutArgument));
        ObjectReference objectReference = this.invokeMethod(debugProcess, evaluationContext, monoResult, "timeout", CollectionsKt.listOf((Object)duration));
        if (objectReference == null) {
            return null;
        }
        ObjectReference timeoutResult = objectReference;
        ObjectReference objectReference2 = this.invokeMethod(debugProcess, evaluationContext, timeoutResult, "toFuture", CollectionsKt.emptyList());
        if (objectReference2 == null) {
            return null;
        }
        ObjectReference futureResult = objectReference2;
        return this.invokeMethod(debugProcess, evaluationContext, futureResult, "get", CollectionsKt.emptyList());
    }

    @Nullable
    protected final ObjectReference invokeMethod(@NotNull DebugProcess debugProcess, @NotNull EvaluationContext evaluationContext, @NotNull ObjectReference parent, @NotNull String methodName, @NotNull List<? extends Value> arguments) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Method method = DebuggerUtils.findMethod((ReferenceType)parent.referenceType(), (String)methodName, null);
        if (method == null) {
            return null;
        }
        Method method2 = method;
        Value value = debugProcess.invokeMethod(evaluationContext, parent, method2, arguments);
        return value instanceof ObjectReference ? (ObjectReference)value : null;
    }

    public static /* synthetic */ ObjectReference invokeMethod$default(ReactorChildEvaluator reactorChildEvaluator, DebugProcess debugProcess, EvaluationContext evaluationContext, ObjectReference objectReference, String string, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invokeMethod");
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        return reactorChildEvaluator.invokeMethod(debugProcess, evaluationContext, objectReference, string, list);
    }

    @Nullable
    protected final Pair<DebugProcess, VirtualMachineProxyImpl> getDebugProcessAndVmProxy(@NotNull EvaluationContext evaluationContext) {
        Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
        EvaluationContextImpl evaluationContextImpl = evaluationContext instanceof EvaluationContextImpl ? (EvaluationContextImpl)evaluationContext : null;
        if (evaluationContextImpl == null || (evaluationContextImpl = evaluationContextImpl.getSuspendContext()) == null || (evaluationContextImpl = evaluationContextImpl.getVirtualMachineProxy()) == null) {
            return null;
        }
        EvaluationContextImpl proxy = evaluationContextImpl;
        return TuplesKt.to((Object)((EvaluationContextImpl)evaluationContext).getDebugProcess(), (Object)proxy);
    }
}

