/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.reactivestreams.inspections.ReactiveStreamsBaseNonBlockingScopeInspection;
import com.intellij.reactivestreams.reactor.ReactorCoreBundle;
import com.intellij.reactivestreams.reactor.util.ReactorLibraryUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J+\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/reactivestreams/reactor/inspections/CallingSubscribeInNonBlockingScopeInspection;", "Lcom/intellij/reactivestreams/inspections/ReactiveStreamsBaseNonBlockingScopeInspection;", "<init>", "()V", "SUBSCRIBE_METHOD_NAME", "", "isAvailable", "", "file", "Lcom/intellij/psi/PsiFile;", "report", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "methodIdentifierPsi", "Lcom/intellij/psi/PsiElement;", "quickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/psi/PsiElement;[Lcom/intellij/codeInspection/LocalQuickFix;)V", "shouldReportCall", "receiver", "Lorg/jetbrains/uast/UExpression;", "expression", "Lorg/jetbrains/uast/UCallExpression;", "intellij.reactivestreams.reactor"})
@SourceDebugExtension(value={"SMAP\nCallingSubscribeInNonBlockingScopeInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallingSubscribeInNonBlockingScopeInspection.kt\ncom/intellij/reactivestreams/reactor/inspections/CallingSubscribeInNonBlockingScopeInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1761#2,3:44\n*S KotlinDebug\n*F\n+ 1 CallingSubscribeInNonBlockingScopeInspection.kt\ncom/intellij/reactivestreams/reactor/inspections/CallingSubscribeInNonBlockingScopeInspection\n*L\n27#1:44,3\n*E\n"})
public final class CallingSubscribeInNonBlockingScopeInspection
extends ReactiveStreamsBaseNonBlockingScopeInspection {
    @NotNull
    private final String SUBSCRIBE_METHOD_NAME;

    public CallingSubscribeInNonBlockingScopeInspection() {
        this.SUBSCRIBE_METHOD_NAME = "subscribe";
    }

    @Override
    protected boolean isAvailable(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ReactorLibraryUtil.hasReactorLibraryFor(file);
    }

    @Override
    protected void report(@NotNull ProblemsHolder holder, @NotNull PsiElement methodIdentifierPsi, @NotNull LocalQuickFix[] quickFixes) {
        UCallExpression uCall;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)methodIdentifierPsi, (String)"methodIdentifierPsi");
        Intrinsics.checkNotNullParameter((Object)quickFixes, (String)"quickFixes");
        UElement uElement = UastContextKt.toUElement((PsiElement)methodIdentifierPsi);
        UCallExpression uCallExpression = uCall = uElement != null ? UastUtils.getUCallExpression$default((UElement)uElement, (int)0, (int)1, null) : null;
        if (uCall != null) {
            boolean bl;
            block5: {
                UElement uElement2 = uCall.getUastParent();
                List chain = UastUtils.getQualifiedChain((UExpression)(uElement2 instanceof UExpression ? (UExpression)uElement2 : null));
                Iterable $this$any$iv = chain;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UExpression it = (UExpression)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof UCallExpression && Intrinsics.areEqual((Object)((UCallExpression)it).getMethodName(), (Object)"subscribeOn"))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return;
            }
        }
        holder.registerProblem(methodIdentifierPsi, ReactorCoreBundle.message("inspections.subscribe.in.non.blocking.scope.name", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(quickFixes, quickFixes.length));
    }

    @Override
    protected boolean shouldReportCall(@NotNull UExpression receiver, @NotNull UCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        PsiMethod psiMethod = expression.resolve();
        return ReactorLibraryUtil.isReactorPublisher((PsiClass)(psiMethod != null ? psiMethod.getContainingClass() : null)) && Intrinsics.areEqual((Object)this.SUBSCRIBE_METHOD_NAME, (Object)expression.getMethodName());
    }
}

