/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.reactivestreams.reactor.inspections.DisableQuickFix;
import com.intellij.reactivestreams.reactor.inspections.ReactorAutomaticDebuggerInspectionKt;
import com.intellij.reactivestreams.reactor.inspections.ReactorUastInspectionBase;
import com.intellij.reactivestreams.reactor.inspections.RemoveQuickfix;
import com.intellij.reactivestreams.settings.DebugInitializationType;
import com.intellij.reactivestreams.settings.ReactiveStreamsSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/reactivestreams/reactor/inspections/ReactorAutomaticDebuggerInspection;", "Lcom/intellij/reactivestreams/reactor/inspections/ReactorUastInspectionBase;", "<init>", "()V", "doBuildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.reactivestreams.reactor"})
public final class ReactorAutomaticDebuggerInspection
extends ReactorUastInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ReactiveStreamsSettings reactorSettings = ReactiveStreamsSettings.Companion.getInstance(project);
        if (!reactorSettings.isStackFrameCustomizationEnabled() || reactorSettings.getDebugInitializationType() == DebugInitializationType.NONE) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return new PsiElementVisitor(reactorSettings, holder){
            final /* synthetic */ ReactiveStreamsSettings $reactorSettings;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$reactorSettings = $reactorSettings;
                this.$holder = $holder;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement $this$toUElementOfType$iv = element;
                boolean $i$f$toUElementOfType = false;
                UCallExpression uCallExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UCallExpression.class);
                if (uCallExpression == null) {
                    return;
                }
                UCallExpression callExpression = uCallExpression;
                String string = callExpression.getMethodName();
                if (string == null) {
                    return;
                }
                String methodName = string;
                if (!Intrinsics.areEqual((Object)methodName, (Object)"init") && !Intrinsics.areEqual((Object)methodName, (Object)"onOperatorDebug")) {
                    return;
                }
                PsiMethod psiMethod = callExpression.resolve();
                if (psiMethod == null || (psiMethod = psiMethod.getContainingClass()) == null) {
                    return;
                }
                PsiMethod containingClass = psiMethod;
                if (!Intrinsics.areEqual((Object)containingClass.getQualifiedName(), (Object)"reactor.tools.agent.ReactorDebugAgent") && !Intrinsics.areEqual((Object)containingClass.getQualifiedName(), (Object)"reactor.core.publisher.Hooks")) {
                    return;
                }
                DebugInitializationType initializationType = this.$reactorSettings.getDebugInitializationType();
                boolean isHooksAndAgent = initializationType == DebugInitializationType.AGENT && Intrinsics.areEqual((Object)methodName, (Object)"onOperatorDebug") || initializationType == DebugInitializationType.HOOKS && Intrinsics.areEqual((Object)methodName, (Object)"init");
                UIdentifier uIdentifier = callExpression.getMethodIdentifier();
                if (uIdentifier == null || (uIdentifier = uIdentifier.getSourcePsi()) == null) {
                    return;
                }
                UIdentifier identifier = uIdentifier;
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RemoveQuickfix(), new DisableQuickFix()};
                this.$holder.registerProblem((PsiElement)identifier, ReactorAutomaticDebuggerInspectionKt.access$getProblemDescription(isHooksAndAgent), localQuickFixArray);
            }
        };
    }
}

