/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.reactivestreams.reactor.ReactorCoreBundle;
import com.intellij.reactivestreams.reactor.inspections.ReactorMonoUtilKt;
import com.intellij.reactivestreams.reactor.inspections.ReactorUastInspectionBase;
import com.intellij.reactivestreams.reactor.inspections.ReactorZipWithMonoVoidInspectionKt;
import com.intellij.reactivestreams.reactor.inspections.quickfix.ReactorReplaceZipWithWhenQuickFix;
import com.intellij.reactivestreams.util.ReactiveStreamsUtils;
import com.intellij.ultimate.PluginVerifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/reactivestreams/reactor/inspections/ReactorZipWithMonoVoidInspection;", "Lcom/intellij/reactivestreams/reactor/inspections/ReactorUastInspectionBase;", "<init>", "()V", "doBuildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "onTheFly", "", "intellij.reactivestreams.reactor"})
public final class ReactorZipWithMonoVoidInspection
extends ReactorUastInspectionBase {
    public ReactorZipWithMonoVoidInspection() {
        PluginVerifier.verifyUltimatePlugin();
    }

    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PsiElementVisitor(holder, onTheFly){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$holder = $holder;
                this.$onTheFly = $onTheFly;
            }

            public void visitElement(PsiElement element) {
                UIdentifier uIdentifier;
                Object quickFixes;
                String methodName;
                UCallExpression methodCall;
                block26: {
                    Object object;
                    block25: {
                        boolean isProblemExists;
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        PsiElement $this$toUElementOfType$iv = element;
                        boolean $i$f$toUElementOfType = false;
                        UQualifiedReferenceExpression referenceExpression = (UQualifiedReferenceExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UQualifiedReferenceExpression.class);
                        if (referenceExpression == null) {
                            return;
                        }
                        if (!Intrinsics.areEqual((Object)referenceExpression.getSourcePsi(), (Object)element)) {
                            return;
                        }
                        UExpression uExpression = referenceExpression.getSelector();
                        UCallExpression uCallExpression = uExpression instanceof UCallExpression ? (UCallExpression)uExpression : null;
                        if (uCallExpression == null) {
                            return;
                        }
                        methodCall = uCallExpression;
                        UExpression receiver = referenceExpression.getReceiver();
                        String string = methodCall.getMethodName();
                        if (string == null) {
                            return;
                        }
                        methodName = string;
                        if (!ReactorZipWithMonoVoidInspectionKt.access$getMONO_ZIP_METHODS$p().contains(methodName)) {
                            return;
                        }
                        switch (methodName) {
                            case "zip": {
                                boolean bl = this.visitZip(receiver, methodCall);
                                break;
                            }
                            case "zipWith": {
                                boolean bl = this.visitZipWith(receiver, methodCall);
                                break;
                            }
                            case "zipWhen": {
                                boolean bl = this.visitZipWhen(receiver, methodCall);
                                break;
                            }
                            default: {
                                boolean bl = isProblemExists = false;
                            }
                        }
                        if (!isProblemExists) {
                            return;
                        }
                        object = this.getQuickFixes(methodName, methodCall);
                        if (object == null) break block25;
                        LocalQuickFix it = object;
                        boolean bl = false;
                        List list = CollectionsKt.listOf((Object)it);
                        object = list;
                        if (list != null) break block26;
                    }
                    object = quickFixes = CollectionsKt.emptyList();
                }
                if ((uIdentifier = methodCall.getMethodIdentifier()) == null || (uIdentifier = uIdentifier.getSourcePsi()) == null) {
                    return;
                }
                Object[] objectArray = new Object[]{methodName};
                Collection $this$toTypedArray$iv = (Collection)quickFixes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                ProblemDescriptor problemDescriptor = this.$holder.getManager().createProblemDescriptor((PsiElement)uIdentifier, ReactorCoreBundle.message("inspections.monovoid.mono.with.zip.transformation.description", objectArray), this.$onTheFly, thisCollection$iv.toArray(new LocalQuickFix[0]), ProblemHighlightType.WARNING);
                Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
                ProblemDescriptor problem = problemDescriptor;
                this.$holder.registerProblem(problem);
            }

            private final LocalQuickFix getQuickFixes(String methodName, UCallExpression methodCall) {
                UCallExpression uCallExpression = ReactiveStreamsUtils.getNextCallInChain(methodCall);
                if (uCallExpression == null) {
                    return null;
                }
                UCallExpression nextCall = uCallExpression;
                String nextCallMethodName = nextCall.getMethodName();
                if (!CollectionsKt.contains((Iterable)ReactorZipWithMonoVoidInspectionKt.access$getMETHODS_WITH_QUICK_FIXES$p(), (Object)nextCallMethodName)) {
                    return null;
                }
                int argumentUsedCountInNextCall = ReactorMonoUtilKt.calculateLambdaArgumentUsage(nextCall);
                if (argumentUsedCountInNextCall > 0) {
                    return null;
                }
                return Intrinsics.areEqual((Object)methodName, (Object)"zipWhen") ? this.getQuickFixForZipWhen(methodCall) : (LocalQuickFix)new ReactorReplaceZipWithWhenQuickFix(methodName);
            }

            private final LocalQuickFix getQuickFixForZipWhen(UCallExpression methodCall) {
                int argumentUsedCountInZipWithArgument = ReactorMonoUtilKt.calculateLambdaArgumentUsage(methodCall);
                if (argumentUsedCountInZipWithArgument > 0) {
                    return null;
                }
                return (LocalQuickFix)new ReactorReplaceZipWithWhenQuickFix("zipWhen");
            }

            /*
             * WARNING - void declaration
             */
            private final boolean visitZipWhen(UExpression receiver, UCallExpression selector) {
                UExpression uExpression;
                block6: {
                    block5: {
                        void $this$filterIsInstanceTo$iv$iv;
                        void $this$filterIsInstance$iv;
                        UBlockExpression uBlockExpression;
                        ULambdaExpression uLambdaExpression = ReactorMonoUtilKt.retrieveLambdaExpression(selector);
                        if (uLambdaExpression == null) {
                            return false;
                        }
                        ULambdaExpression lambda = uLambdaExpression;
                        Object object = lambda.getBody();
                        UBlockExpression uBlockExpression2 = uBlockExpression = object instanceof UBlockExpression ? (UBlockExpression)object : null;
                        if (uBlockExpression == null || (object = uBlockExpression.getExpressions()) == null) break block5;
                        Iterable iterable = (Iterable)object;
                        boolean $i$f$filterIsInstance = false;
                        void var9_9 = $this$filterIsInstance$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof UReturnExpression)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        iterable = (UReturnExpression)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                        if (iterable != null && (uExpression = iterable.getReturnExpression()) != null) break block6;
                    }
                    return false;
                }
                UExpression returnExpression = uExpression;
                return ReactorMonoUtilKt.isMonoVoidType(receiver) || ReactorMonoUtilKt.isMonoVoidType(returnExpression);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean visitZipWith(UExpression receiver, UCallExpression selector) {
                UExpression it;
                if (ReactorMonoUtilKt.isMonoVoidType(receiver)) return true;
                Iterable $this$any$iv = selector.getValueArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    T element$iv = iterator.next();
                    it = (UExpression)element$iv;
                    boolean bl = false;
                } while (!ReactorMonoUtilKt.isMonoVoidType(it));
                return true;
            }

            private final boolean visitZip(UExpression receiver, UCallExpression selector) {
                boolean bl;
                block4: {
                    if (!ReactorMonoUtilKt.isMonoStaticMethod(receiver)) {
                        return false;
                    }
                    List arguments = selector.getValueArguments();
                    Iterable $this$any$iv = arguments;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            UExpression it = (UExpression)element$iv;
                            boolean bl2 = false;
                            if (!ReactorMonoUtilKt.isMonoVoidType(it)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        };
    }
}

