/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.inspections.reactor;

import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.codeInspection.blockingCallsDetection.MethodContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.reactivestreams.inspections.ReactiveStreamsBaseNonBlockingScopeInspection;
import com.intellij.reactivestreams.reactor.util.ReactorLibraryUtil;
import org.jetbrains.annotations.NotNull;

public final class ReactorBlockingMethodChecker
implements BlockingMethodChecker {
    private static final String BLOCKING_NAME_PREFIX = "block";

    public boolean isApplicable(@NotNull PsiFile file) {
        if (file == null) {
            ReactorBlockingMethodChecker.$$$reportNull$$$0(0);
        }
        return JavaPsiFacade.getInstance((Project)file.getProject()).findClass("reactor.core.publisher.Mono", file.getResolveScope()) != null;
    }

    public boolean isMethodBlocking(@NotNull MethodContext context) {
        PsiMethod method;
        if (context == null) {
            ReactorBlockingMethodChecker.$$$reportNull$$$0(1);
        }
        return ReactiveStreamsBaseNonBlockingScopeInspection.isMethodFromPublisher(method = context.getElement()) && ReactorBlockingMethodChecker.isReactorBlockingMethod(method);
    }

    public boolean isMethodNonBlocking(@NotNull MethodContext context) {
        if (context == null) {
            ReactorBlockingMethodChecker.$$$reportNull$$$0(2);
        }
        return ReactorLibraryUtil.isReactorPublisher(context.getElement().getReturnType());
    }

    private static boolean isReactorBlockingMethod(@NotNull PsiMethod method) {
        String methodName;
        if (method == null) {
            ReactorBlockingMethodChecker.$$$reportNull$$$0(3);
        }
        if ((methodName = method.getName()).startsWith(BLOCKING_NAME_PREFIX)) {
            return true;
        }
        PsiType returnType = method.getReturnType();
        if (ReactorLibraryUtil.isReactorPublisher(returnType)) {
            return false;
        }
        if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.lang.Iterable")) {
            return true;
        }
        return InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.Stream");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/reactivestreams/reactor/inspections/reactor/ReactorBlockingMethodChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodBlocking";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodNonBlocking";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isReactorBlockingMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

