/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.util;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.reactivestreams.implementations.ReactiveStreamsImplementationsManager;
import com.intellij.reactivestreams.implementations.ReactiveStreamsInspectionsManager;
import com.intellij.reactivestreams.intention.IntentionUtilKt;
import com.intellij.reactivestreams.uast.ex.UFunctionalObject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastElementFactory;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0015\u0010\u0014\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u0015*\u0004\u0018\u00010\u0012H\u0002\u001a\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\f\u0010\u001f\u001a\u0004\u0018\u00010\u0001*\u00020 \u001a\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\b\u0010\"\u001a\u0004\u0018\u00010\u0012\u001a\u0010\u0010#\u001a\u00020\u000e2\b\u0010$\u001a\u0004\u0018\u00010%\u001aF\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030-2\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\b2\n\b\u0002\u00100\u001a\u0004\u0018\u000101\u001aD\u00102\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+2\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\b2\n\b\u0002\u00100\u001a\u0004\u0018\u0001012\b\b\u0002\u00103\u001a\u00020\u000e\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0017\u0010\r\u001a\u00020\u000e*\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0010\"\u0017\u0010\u0011\u001a\u00020\u000e*\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010\"\u0017\u0010\r\u001a\u00020\u000e*\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0013\"\u0017\u0010\u0011\u001a\u00020\u000e*\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013\"\u0017\u0010\u0016\u001a\u00020\u000e*\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018\"\u0017\u0010\u0019\u001a\u00020\u000e*\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0010\"\u0017\u0010\u001a\u001a\u00020\u000e*\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010\"\u0017\u0010\u001b\u001a\u00020\u000e*\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0010\u00a8\u00064"}, d2={"nextCallInChain", "Lorg/jetbrains/uast/UCallExpression;", "getNextCallInChain", "(Lorg/jetbrains/uast/UCallExpression;)Lorg/jetbrains/uast/UCallExpression;", "prevCallInChain", "getPrevCallInChain", "getKnownPublishersImplementations", "", "", "project", "Lcom/intellij/openapi/project/Project;", "getKnownPublishersInterfaces", "getBuilderClassesToCheck", "isPublisher", "", "Lcom/intellij/psi/PsiClass;", "(Lcom/intellij/psi/PsiClass;)Z", "isMockitoAnswer", "Lcom/intellij/psi/PsiType;", "(Lcom/intellij/psi/PsiType;)Z", "resolvePsiClass", "Lorg/jetbrains/annotations/Nullable;", "isMethodDefinedInKnownPublisher", "Lcom/intellij/psi/PsiMethod;", "(Lcom/intellij/psi/PsiMethod;)Z", "isPublisherFromImplementation", "isPublisherSupertype", "isBuilderClassToCheck", "hasReactiveStreamsFor", "file", "Lcom/intellij/psi/PsiFile;", "getCallExpressionSelectorOrThis", "Lorg/jetbrains/uast/UElement;", "isTypeNullable", "type", "isLambdaReturnTypeAcceptsNulls", "lambdaParameter", "Lcom/intellij/psi/PsiParameter;", "replaceAndAddReturnIfNotLastExpression", "expression", "Lorg/jetbrains/uast/UExpression;", "rawExpression", "factory", "Lorg/jetbrains/uast/generate/UastElementFactory;", "functionalObject", "Lcom/intellij/reactivestreams/uast/ex/UFunctionalObject;", "parameterName", "methodName", "context", "Lcom/intellij/psi/PsiElement;", "replaceReceiverAndMethodCall", "isLast", "intellij.reactivestreams"})
@JvmName(name="ReactiveStreamsUtils")
@SourceDebugExtension(value={"SMAP\nreactiveStreamsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 reactiveStreamsUtils.kt\ncom/intellij/reactivestreams/util/ReactiveStreamsUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 UastCodeGenerationPlugin.kt\norg/jetbrains/uast/generate/UastCodeGenerationPluginKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,166:1\n1#2:167\n19#3:168\n1761#4,3:169\n229#5,6:172\n236#5:179\n14#6:178\n*S KotlinDebug\n*F\n+ 1 reactiveStreamsUtils.kt\ncom/intellij/reactivestreams/util/ReactiveStreamsUtils\n*L\n111#1:168\n115#1:169,3\n162#1:172,6\n162#1:179\n162#1:178\n*E\n"})
public final class ReactiveStreamsUtils {
    @Nullable
    public static final UCallExpression getNextCallInChain(@NotNull UCallExpression $this$nextCallInChain) {
        UCallExpression uCallExpression;
        UExpression uExpression;
        Intrinsics.checkNotNullParameter((Object)$this$nextCallInChain, (String)"<this>");
        UElement uElement = $this$nextCallInChain.getUastParent();
        UElement it = uElement != null ? uElement.getUastParent() : null;
        boolean bl = false;
        UQualifiedReferenceExpression uQualifiedReferenceExpression = it instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)it : null;
        if (uQualifiedReferenceExpression != null && (uExpression = uQualifiedReferenceExpression.getSelector()) != null) {
            UExpression it2 = uExpression;
            boolean bl2 = false;
            uCallExpression = it2 instanceof UCallExpression ? (UCallExpression)it2 : null;
        } else {
            uCallExpression = null;
        }
        return uCallExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final UCallExpression getPrevCallInChain(@NotNull UCallExpression $this$prevCallInChain) {
        Intrinsics.checkNotNullParameter((Object)$this$prevCallInChain, (String)"<this>");
        UElement uElement = $this$prevCallInChain.getUastParent();
        if (uElement == null) return null;
        UElement it = uElement;
        boolean bl = false;
        if (!(it instanceof UQualifiedReferenceExpression)) return null;
        UQualifiedReferenceExpression uQualifiedReferenceExpression = (UQualifiedReferenceExpression)it;
        UQualifiedReferenceExpression uQualifiedReferenceExpression2 = uQualifiedReferenceExpression;
        if (uQualifiedReferenceExpression2 == null) return null;
        UQualifiedReferenceExpression it2 = uQualifiedReferenceExpression2;
        boolean bl2 = false;
        UExpression uExpression = it2.getReceiver();
        if (!(uExpression instanceof UQualifiedReferenceExpression)) return null;
        UQualifiedReferenceExpression uQualifiedReferenceExpression3 = (UQualifiedReferenceExpression)uExpression;
        UQualifiedReferenceExpression uQualifiedReferenceExpression4 = uQualifiedReferenceExpression3;
        if (uQualifiedReferenceExpression4 == null) return null;
        it2 = uQualifiedReferenceExpression4;
        boolean bl3 = false;
        uExpression = it2.getSelector();
        if (!(uExpression instanceof UCallExpression)) return null;
        UCallExpression uCallExpression = (UCallExpression)uExpression;
        return uCallExpression;
    }

    private static final Set<String> getKnownPublishersImplementations(Project project) {
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> ReactiveStreamsUtils.getKnownPublishersImplementations$lambda$5(project));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Set)object;
    }

    private static final Set<String> getKnownPublishersInterfaces(Project project) {
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> ReactiveStreamsUtils.getKnownPublishersInterfaces$lambda$6(project));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Set)object;
    }

    private static final Set<String> getBuilderClassesToCheck(Project project) {
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> ReactiveStreamsUtils.getBuilderClassesToCheck$lambda$7(project));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Set)object;
    }

    public static final boolean isPublisher(@Nullable PsiClass $this$isPublisher) {
        PsiClass psiClass = $this$isPublisher;
        return Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"org.reactivestreams.Publisher") || ReactiveStreamsUtils.isPublisherFromImplementation($this$isPublisher) || ReactiveStreamsUtils.isPublisherSupertype($this$isPublisher);
    }

    public static final boolean isMockitoAnswer(@Nullable PsiClass $this$isMockitoAnswer) {
        PsiClass psiClass = $this$isMockitoAnswer;
        return Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"org.mockito.stubbing.Answer");
    }

    public static final boolean isPublisher(@Nullable PsiType $this$isPublisher) {
        return ReactiveStreamsUtils.isPublisher(ReactiveStreamsUtils.resolvePsiClass($this$isPublisher));
    }

    public static final boolean isMockitoAnswer(@Nullable PsiType $this$isMockitoAnswer) {
        return ReactiveStreamsUtils.isMockitoAnswer(ReactiveStreamsUtils.resolvePsiClass($this$isMockitoAnswer));
    }

    private static final PsiClass resolvePsiClass(PsiType $this$resolvePsiClass) {
        PsiType psiType = GenericsUtil.eliminateWildcards((PsiType)$this$resolvePsiClass);
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        return psiClassType != null ? psiClassType.resolve() : null;
    }

    public static final boolean isMethodDefinedInKnownPublisher(@Nullable PsiMethod $this$isMethodDefinedInKnownPublisher) {
        PsiMethod psiMethod = $this$isMethodDefinedInKnownPublisher;
        return ReactiveStreamsUtils.isPublisherFromImplementation((PsiClass)(psiMethod != null ? psiMethod.getContainingClass() : null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPublisherFromImplementation(@Nullable PsiClass $this$isPublisherFromImplementation) {
        Set<String> set;
        if ($this$isPublisherFromImplementation == null) return false;
        Project project = $this$isPublisherFromImplementation.getProject();
        if (project == null) return false;
        Project it = project;
        boolean bl = false;
        Set<String> set2 = ReactiveStreamsUtils.getKnownPublishersImplementations(it);
        if (set2 == null) return false;
        Set<String> it2 = set = set2;
        boolean bl2 = false;
        if ($this$isPublisherFromImplementation.getQualifiedName() == null) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        Set<String> set3 = set;
        Set<String> set4 = set3;
        if (set4 == null) return false;
        if (!CollectionsKt.contains((Iterable)set4, (Object)$this$isPublisherFromImplementation.getQualifiedName())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPublisherSupertype(@Nullable PsiClass $this$isPublisherSupertype) {
        if ($this$isPublisherSupertype == null) return false;
        Project project = $this$isPublisherSupertype.getProject();
        if (project == null) return false;
        Project it = project;
        boolean bl = false;
        Set<String> set = ReactiveStreamsUtils.getKnownPublishersInterfaces(it);
        if (set == null) return false;
        if (!CollectionsKt.contains((Iterable)set, (Object)$this$isPublisherSupertype.getQualifiedName())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBuilderClassToCheck(@Nullable PsiClass $this$isBuilderClassToCheck) {
        if ($this$isBuilderClassToCheck == null) return false;
        Project project = $this$isBuilderClassToCheck.getProject();
        if (project == null) return false;
        Project it = project;
        boolean bl = false;
        Project project2 = $this$isBuilderClassToCheck.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Set<String> set = ReactiveStreamsUtils.getBuilderClassesToCheck(project2);
        if (set == null) return false;
        if (!CollectionsKt.contains((Iterable)set, (Object)$this$isBuilderClassToCheck.getQualifiedName())) return false;
        return true;
    }

    public static final boolean hasReactiveStreamsFor(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JavaLibraryUtil.hasLibraryClass((Module)ModuleUtilCore.findModuleForFile((PsiFile)file), (String)"org.reactivestreams.Publisher");
    }

    @Nullable
    public static final UCallExpression getCallExpressionSelectorOrThis(@NotNull UElement $this$getCallExpressionSelectorOrThis) {
        Intrinsics.checkNotNullParameter((Object)$this$getCallExpressionSelectorOrThis, (String)"<this>");
        if ($this$getCallExpressionSelectorOrThis instanceof UCallExpression) {
            return (UCallExpression)$this$getCallExpressionSelectorOrThis;
        }
        UElement $this$asSafely$iv = $this$getCallExpressionSelectorOrThis;
        boolean $i$f$asSafely = false;
        UElement uElement = $this$asSafely$iv;
        if (!(uElement instanceof UQualifiedReferenceExpression)) {
            uElement = null;
        }
        UQualifiedReferenceExpression uQualifiedReferenceExpression = (UQualifiedReferenceExpression)uElement;
        UExpression uExpression = uQualifiedReferenceExpression != null ? uQualifiedReferenceExpression.getSelector() : null;
        return uExpression instanceof UCallExpression ? (UCallExpression)uExpression : null;
    }

    public static final boolean isTypeNullable(@NotNull Project project, @Nullable PsiType type) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List list = NullableNotNullManager.getInstance((Project)project).getNullables();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNullables(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    PsiType psiType = type;
                    if (!((psiType != null ? psiType.findAnnotation(it) : null) != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isLambdaReturnTypeAcceptsNulls(@Nullable PsiParameter lambdaParameter) {
        PsiParameter psiParameter = lambdaParameter;
        PsiType lambdaReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)(psiParameter != null ? psiParameter.getType() : null));
        if (Intrinsics.areEqual((Object)PsiTypes.voidType(), (Object)lambdaReturnType)) return true;
        PsiParameter psiParameter2 = lambdaParameter;
        PsiParameter psiParameter3 = psiParameter2;
        if (psiParameter2 == null) return false;
        Project project = psiParameter3.getProject();
        psiParameter3 = project;
        if (project == null) return false;
        PsiParameter it = psiParameter3;
        boolean bl = false;
        if (!ReactiveStreamsUtils.isTypeNullable((Project)it, lambdaReturnType)) return false;
        return true;
    }

    public static final boolean replaceAndAddReturnIfNotLastExpression(@NotNull UExpression expression, @NotNull UExpression rawExpression, @NotNull UastElementFactory factory, @NotNull UFunctionalObject<?> functionalObject, @NotNull String parameterName, @NotNull String methodName, @Nullable PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)rawExpression, (String)"rawExpression");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter(functionalObject, (String)"functionalObject");
        Intrinsics.checkNotNullParameter((Object)parameterName, (String)"parameterName");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        UExpression uExpression = functionalObject.getBody();
        if (uExpression == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return ReactiveStreamsUtils.replaceReceiverAndMethodCall(expression, rawExpression, factory, parameterName, methodName, context, UastUtils.isLastElementInControlFlow((UElement)((UElement)expression), (UElement)((UElement)uExpression)));
    }

    public static /* synthetic */ boolean replaceAndAddReturnIfNotLastExpression$default(UExpression uExpression, UExpression uExpression2, UastElementFactory uastElementFactory, UFunctionalObject uFunctionalObject, String string, String string2, PsiElement psiElement, int n, Object object) {
        if ((n & 0x40) != 0) {
            psiElement = null;
        }
        return ReactiveStreamsUtils.replaceAndAddReturnIfNotLastExpression(uExpression, uExpression2, uastElementFactory, uFunctionalObject, string, string2, psiElement);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean replaceReceiverAndMethodCall(@NotNull UExpression expression, @NotNull UExpression rawExpression, @NotNull UastElementFactory factory, @NotNull String parameterName, @NotNull String methodName, @Nullable PsiElement context, boolean isLast) {
        UElement uElement;
        void $this$replace$iv;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)rawExpression, (String)"rawExpression");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)parameterName, (String)"parameterName");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        USimpleNameReferenceExpression receiver = factory.createSimpleReference(parameterName, expression.getSourcePsi());
        UCallExpression uCallExpression = UastElementFactory.createCallExpression$default((UastElementFactory)factory, (UExpression)((UExpression)receiver), (String)methodName, (List)CollectionsKt.listOf((Object)rawExpression), null, (UastCallKind)UastCallKind.METHOD_CALL, null, (int)32, null);
        if (uCallExpression == null) {
            return false;
        }
        UCallExpression methodCall = uCallExpression;
        UElement uElement2 = (UElement)expression;
        UElement newElement$iv = (UElement)methodCall;
        boolean $i$f$replace = false;
        if (Intrinsics.areEqual((Object)$this$replace$iv, (Object)newElement$iv)) {
            uElement = newElement$iv;
        } else {
            UastCodeGenerationPlugin uastCodeGenerationPlugin = UastCodeGenerationPlugin.Companion.byLanguage($this$replace$iv.getLang());
            UastCodeGenerationPlugin it$iv = uastCodeGenerationPlugin = uastCodeGenerationPlugin != null ? uastCodeGenerationPlugin.replace((UElement)$this$replace$iv, newElement$iv, UCallExpression.class) : null;
            boolean bl = false;
            if (it$iv == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(UastCodeGenerationPlugin.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("failed replacing the " + (UElement)$this$replace$iv + " with " + newElement$iv);
            }
            uElement = uastCodeGenerationPlugin;
        }
        UCallExpression uCallExpression2 = (UCallExpression)uElement;
        if (uCallExpression2 == null) {
            return false;
        }
        UCallExpression newElement = uCallExpression2;
        if (!isLast) {
            IntentionUtilKt.addReturnAfter((UExpression)newElement, factory, context);
        }
        return true;
    }

    public static /* synthetic */ boolean replaceReceiverAndMethodCall$default(UExpression uExpression, UExpression uExpression2, UastElementFactory uastElementFactory, String string, String string2, PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            psiElement = null;
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        return ReactiveStreamsUtils.replaceReceiverAndMethodCall(uExpression, uExpression2, uastElementFactory, string, string2, psiElement, bl);
    }

    private static final CachedValueProvider.Result getKnownPublishersImplementations$lambda$5(Project $project) {
        Iterable<String> list = ReactiveStreamsInspectionsManager.Companion.getInstance($project).getPublisherImplementationsTypes();
        Set result = CollectionsKt.toSet(list);
        Object[] objectArray = new Object[]{JavaLibraryModificationTracker.getInstance((Project)$project), ReactiveStreamsImplementationsManager.Companion.getInstance($project).getImplementationsTracker()};
        return CachedValueProvider.Result.create((Object)result, (Object[])objectArray);
    }

    private static final CachedValueProvider.Result getKnownPublishersInterfaces$lambda$6(Project $project) {
        Iterable<String> list = ReactiveStreamsInspectionsManager.Companion.getInstance($project).getPublisherInterfacesTypes();
        Set result = CollectionsKt.toSet(list);
        Object[] objectArray = new Object[]{JavaLibraryModificationTracker.getInstance((Project)$project), ReactiveStreamsImplementationsManager.Companion.getInstance($project).getImplementationsTracker()};
        return CachedValueProvider.Result.create((Object)result, (Object[])objectArray);
    }

    private static final CachedValueProvider.Result getBuilderClassesToCheck$lambda$7(Project $project) {
        Iterable<String> list = ReactiveStreamsInspectionsManager.Companion.getInstance($project).getBuilderClassesToCheck();
        Set result = CollectionsKt.toSet(list);
        Object[] objectArray = new Object[]{JavaLibraryModificationTracker.getInstance((Project)$project), ReactiveStreamsImplementationsManager.Companion.getInstance($project).getImplementationsTracker()};
        return CachedValueProvider.Result.create((Object)result, (Object[])objectArray);
    }
}

