/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.model.dbtype;

import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbprop.MssqlDbProperties;
import com.intellij.jpa.jpb.model.core.model.dbtype.AbstractDbType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MssqlType
extends AbstractDbType {
    public static final String ID = "mssql";
    public static final String URL_PREFIX = "jdbc:sqlserver://";
    public static final String DRIVER_CLASS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";

    MssqlType() {
        this("Microsoft SQL Server 2008", ID, URL_PREFIX, "2008");
    }

    protected MssqlType(String caption, String id, String urlPrefix, String dbmsVersion) {
        super(caption, id, urlPrefix, dbmsVersion, ";", ";");
        this.driverClass = DRIVER_CLASS_NAME;
    }

    @Override
    @NotNull
    public DbProperties createDbProperties() {
        return new MssqlDbProperties(this);
    }

    @Override
    public int getLoginTimeout() {
        return 5;
    }

    @Override
    public boolean isMssql() {
        return true;
    }

    @Override
    @Nullable
    public String getDefaultSchema() {
        return "dbo";
    }
}

