/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.model;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jpa.jpb.model.backend.ed.annotation.AnnotationHelper;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaAttributeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaEntityAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.indexing.HibernateCustomTypeModel;
import com.intellij.jpa.jpb.model.model.AttributeOverride;
import com.intellij.jpa.jpb.model.model.AuditTable;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributePsi;
import com.intellij.jpa.jpb.model.model.EntityListener;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.model.GenericGenerator;
import com.intellij.jpa.jpb.model.model.Index;
import com.intellij.jpa.jpb.model.model.Method;
import com.intellij.jpa.jpb.model.model.MethodPsi;
import com.intellij.jpa.jpb.model.model.NamedQuery;
import com.intellij.jpa.jpb.model.model.SequenceGenerator;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.PsiUtilsKt;
import com.intellij.jpa.jpb.model.util.StudioAnnotationUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class EntityCacheProvider {
    private final Project project;
    private final AnnotationHelper annotationHelper;

    public EntityCacheProvider(Project project) {
        this.project = project;
        this.annotationHelper = AnnotationHelper.getInstance(project);
    }

    public static EntityCacheProvider getInstance(@NotNull Project project) {
        if (project == null) {
            EntityCacheProvider.$$$reportNull$$$0(0);
        }
        return (EntityCacheProvider)project.getService(EntityCacheProvider.class);
    }

    public LinkedHashSet<AttributeOverride> getAttributeOverrides(PsiClass psiClass) {
        return (LinkedHashSet)EntityUtil.raPsiCached((PsiElement)psiClass, () -> EntityUtil.getAttributeOverrides((PsiModifierListOwner)psiClass, false));
    }

    public Map<Index, PsiAnnotation> getIndexesMap(PsiClass psiClass) {
        return (Map)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            PsiAnnotation tableAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{JpaEntityAnnotation.Table.getFqn(this.project, ModuleUtil.findModuleForPsiElement((PsiElement)psiClass))});
            if (tableAnn == null) {
                return Collections.emptyMap();
            }
            return EntityUtil.getIndexesMap(tableAnn);
        });
    }

    public List<Index> getIndexes(PsiClass psiClass) {
        return (List)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            PsiAnnotation tableAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{JpaEntityAnnotation.Table.getFqn(this.project, ModuleUtil.findModuleForPsiElement((PsiElement)psiClass))});
            if (tableAnn == null) {
                return Collections.emptyList();
            }
            return EntityUtil.getIndexes(tableAnn);
        });
    }

    public List<NamedQuery> getNamedQueries(PsiClass entityClass) {
        return (List)EntityUtil.ra(() -> EntityUtil.getNamedQueries(entityClass));
    }

    public List<HibernateCustomTypeModel> getHibernateTypes(PsiClass psiClass) {
        return (List)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            PsiAnnotation typeDefsAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"org.hibernate.annotations.TypeDefs"});
            if (typeDefsAnn == null) {
                ArrayList typeDefAnnotations = new ArrayList(AnnotationUtil.findAllAnnotations((PsiModifierListOwner)psiClass, Collections.singletonList("org.hibernate.annotations.TypeDef"), (boolean)false));
                if (typeDefAnnotations.isEmpty()) {
                    return Collections.emptyList();
                }
                return StreamEx.of(typeDefAnnotations).map(EntityUtil::getHibernateType).nonNull().toList();
            }
            return EntityUtil.getHibernateTypes(typeDefsAnn);
        });
    }

    public List<Index> getUniqueConstraints(PsiClass psiClass) {
        return (List)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            PsiAnnotation tableAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{JpaEntityAnnotation.Table.getFqn(this.project, ModuleUtil.findModuleForPsiElement((PsiElement)psiClass))});
            if (tableAnn == null) {
                return Collections.emptyList();
            }
            return EntityUtil.getUniqueConstraints(tableAnn);
        });
    }

    public List<Method> getMethods(PsiClass psiClass) {
        return (List)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            ArrayList<Method> result = new ArrayList<Method>();
            for (PsiMethod psiMethod : psiClass.getMethods()) {
                Method method = this.processMethod(psiMethod, true);
                if (method == null) continue;
                result.add(method);
            }
            return result;
        });
    }

    public List<MethodPsi> getAllMethodsPsi(PsiClass psiClass) {
        return (List)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            ArrayList<MethodPsi> result = new ArrayList<MethodPsi>();
            for (PsiMethod psiMethod : psiClass.getMethods()) {
                MethodPsi method = this.processMethodPsi(psiMethod, false);
                if (method == null) continue;
                result.add(method);
            }
            return result;
        });
    }

    private MethodPsi processMethodPsi(PsiMethod psiMethod, MethodPsi method, Boolean skipStaticOrPrivate) {
        return (MethodPsi)this.processMethod(psiMethod, method, skipStaticOrPrivate);
    }

    private MethodPsi processMethodPsi(PsiMethod psiMethod, Boolean skipStaticOrPrivate) {
        return this.processMethodPsi(psiMethod, new MethodPsi(psiMethod), skipStaticOrPrivate);
    }

    private Method processMethod(PsiMethod psiMethod, Boolean skipStaticOrPrivate) {
        return this.processMethod(psiMethod, new Method(), skipStaticOrPrivate);
    }

    @Nullable
    private Method processMethod(PsiMethod psiMethod, Method method, Boolean skipStaticOrPrivate) {
        if (skipStaticOrPrivate.booleanValue() && (psiMethod.hasModifierProperty("static") || psiMethod.hasModifierProperty("private"))) {
            return null;
        }
        method.setName(psiMethod.getName());
        PsiType returnType = psiMethod.getReturnType();
        if (returnType != null) {
            method.setType(returnType.getCanonicalText());
        } else {
            method.setType("");
        }
        method.setModifiers(psiMethod.getModifierList().getText());
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        if (parameters.length != 0) {
            String[] signature = new String[parameters.length];
            String[] paramsNames = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter param = parameters[i];
                signature[i] = param.getType().getPresentableText();
                paramsNames[i] = param.getName();
            }
            method.setSignature(signature);
            method.setParamNames(paramsNames);
        } else {
            method.setSignature(ArrayUtil.EMPTY_STRING_ARRAY);
            method.setParamNames(ArrayUtil.EMPTY_STRING_ARRAY);
        }
        this.processMethodsAnnotation(method, psiMethod);
        return method;
    }

    private void processMethodsAnnotation(Method method, PsiMethod psiMethod) {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        for (PsiAnnotation psiAnnotation : psiMethod.getAnnotations()) {
            String fqn = psiAnnotation.getQualifiedName();
            annotations.add(fqn != null && fqn.contains(".") ? StringUtils.substringAfterLast((String)fqn, (String)".") : fqn);
        }
        method.setAnnotations(annotations);
    }

    public List<EntityAttribute> getAttributes(PsiClass psiClass) {
        return (List)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            ArrayList<EntityAttribute> attributes = new ArrayList<EntityAttribute>();
            for (PsiField psiField : psiClass.getFields()) {
                EntityAttributePsi attribute;
                String attrName;
                if (psiField.hasModifierProperty("static") || psiField.hasModifierProperty("transient") || StringUtils.startsWith((CharSequence)(attrName = psiField.getName()), (CharSequence)"__") || !(attribute = EntityAttributePsi.getInstance((PsiMember)psiField)).isValid() || !attribute.isPersistent()) continue;
                attributes.add(attribute);
            }
            if (psiClass.getLanguage() instanceof JavaLanguage) {
                for (PsiField psiField : psiClass.getMethods()) {
                    if (psiField.getReturnType() == null || PsiTypes.voidType().equals((Object)psiField.getReturnType()) || !psiField.getName().startsWith("get") || psiField.getName().length() <= 3 || psiField.getAnnotations().length == 0 || !EntityUtil.isMemberHaveAttributeAnnotations((PsiMember)psiField)) continue;
                    EntityAttributePsi attribute = EntityAttributePsi.getInstance((PsiMember)psiField);
                    attributes.removeIf(it -> Objects.equals(it.getName(), attribute.getName()));
                    attributes.add(attribute);
                }
            }
            return Collections.unmodifiableList(attributes);
        });
    }

    public Entity.InheritanceType getInheritanceType(PsiClass psiClass) {
        return (Entity.InheritanceType)((Object)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            String strategyValue = StudioAnnotationUtil.getDeclaredEnumStringValue((PsiModifierListOwner)psiClass, JpaEntityAnnotation.Inheritance.getFqn(this.project, ModuleUtil.findModuleForPsiElement((PsiElement)psiClass)), "strategy");
            if (strategyValue == null) {
                return null;
            }
            try {
                return Entity.InheritanceType.valueOf(strategyValue);
            }
            catch (IllegalArgumentException exception) {
                return null;
            }
        }));
    }

    @Nullable
    public String getCatalog(PsiClass psiClass) {
        return (String)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{JpaEntityAnnotation.Table.getFqn(this.project, ModuleUtil.findModuleForPsiElement((PsiElement)psiClass))});
            if (annotation == null) {
                return null;
            }
            return EntityUtil.getAttributeValue(annotation, "catalog");
        });
    }

    public String getSchema(PsiClass psiClass) {
        return (String)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{JpaEntityAnnotation.Table.getFqn(this.project, ModuleUtil.findModuleForPsiElement((PsiElement)psiClass))});
            if (annotation == null) {
                return null;
            }
            return EntityUtil.getAttributeValue(annotation, "schema");
        });
    }

    public String getTable(PsiClass psiClass) {
        return (String)EntityUtil.ra(() -> EntityUtil.getTable(psiClass));
    }

    public EntityPsi getParent(PsiClass psiClass) {
        PsiClass parent = (PsiClass)EntityUtil.ra(() -> ((PsiClass)psiClass).getSuperClass());
        return (EntityPsi)EntityUtil.raPsiCached((PsiElement)psiClass, parent != null ? parent.getName() : "", () -> {
            PsiClass superClass = EntityCacheProvider.getParentEntityClass(psiClass);
            if (superClass == null) {
                return null;
            }
            return EntityPsi.getInstance(superClass);
        });
    }

    private static PsiClass getParentEntityClass(@Nullable PsiClass entityClass) {
        if (entityClass == null) {
            return null;
        }
        PsiClass superClass = entityClass.getSuperClass();
        return EntityUtil.isEntity(superClass) ? superClass : EntityCacheProvider.getParentEntityClass(superClass);
    }

    public boolean isPersistentEntity(PsiClass psiClass) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)psiClass, () -> EntityUtil.isPersistentEntity(psiClass));
    }

    public boolean isMappedSuperClass(PsiClass psiClass) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{JpaEntityAnnotation.MappedSuperclass.getFqn(this.project, ModuleUtil.findModuleForPsiElement((PsiElement)psiClass))});
            return annotation != null;
        });
    }

    public boolean isLombokGetter(PsiClass psiClass) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)psiClass, () -> AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"lombok.Getter"}) != null || AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"lombok.Data"}) != null);
    }

    public boolean isLombokSetter(PsiClass psiClass) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)psiClass, () -> AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"lombok.Setter"}) != null || AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"lombok.Data"}) != null);
    }

    public boolean isLombokAllArgsConstructor(PsiClass psiClass) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)psiClass, () -> AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"lombok.AllArgsConstructor"}) != null);
    }

    public boolean isLombokNoArgsConstructor(PsiClass psiClass) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)psiClass, () -> AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"lombok.NoArgsConstructor"}) != null);
    }

    public boolean isLombokBuilder(PsiClass psiClass) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)psiClass, () -> AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"lombok.Builder"}) != null);
    }

    public boolean isLombokSuperBuilder(PsiClass psiClass) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)psiClass, () -> AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"lombok.experimental.SuperBuilder"}) != null);
    }

    public boolean isLombokToString(PsiClass psiClass) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"lombok.ToString"});
            return annotation != null;
        });
    }

    public boolean isLombokData(PsiClass psiClass) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)psiClass, () -> AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"lombok.Data"}) != null);
    }

    public boolean isLombokRequiredArgsConstructor(PsiClass psiClass) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)psiClass, () -> AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"lombok.RequiredArgsConstructor"}) != null);
    }

    public boolean isLombokEqualsAndHashCode(PsiClass psiClass) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)psiClass, () -> AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"lombok.EqualsAndHashCode"}) != null);
    }

    public boolean isLombokOnlyExplicitlyIncluded(PsiClass psiClass) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"lombok.ToString"});
            return annotation != null && Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)annotation, (String)"onlyExplicitlyIncluded"));
        });
    }

    public String getParentFqn(PsiClass psiClass) {
        return (String)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            PsiClassType[] extendsListTypes = psiClass.getExtendsListTypes();
            return extendsListTypes.length == 0 ? null : extendsListTypes[0].getCanonicalText();
        });
    }

    public String getDiscriminatorLength(PsiClass psiClass) {
        return (String)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            PsiAnnotation discrColumnAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{JpaEntityAnnotation.DiscriminatorColumn.getFqn(this.project, ModuleUtil.findModuleForPsiElement((PsiElement)psiClass))});
            if (discrColumnAnn == null) {
                return "31";
            }
            Long length = AnnotationUtil.getLongAttributeValue((PsiAnnotation)discrColumnAnn, (String)"length");
            return length == null ? "31" : length.toString();
        });
    }

    public String getDiscriminatorColumnName(PsiClass psiClass) {
        return (String)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            PsiAnnotation discrColumnAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{JpaEntityAnnotation.DiscriminatorColumn.getFqn(this.project, ModuleUtil.findModuleForPsiElement((PsiElement)psiClass))});
            if (discrColumnAnn == null) {
                return null;
            }
            String name = AnnotationUtil.getStringAttributeValue((PsiAnnotation)discrColumnAnn, (String)"name");
            return StringUtils.isBlank((CharSequence)name) ? "DTYPE" : name;
        });
    }

    public Entity.DiscriminatorType getDiscriminatorType(PsiClass psiClass) {
        return (Entity.DiscriminatorType)((Object)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            PsiAnnotation discrColumnAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{JpaEntityAnnotation.DiscriminatorColumn.getFqn(this.project, ModuleUtil.findModuleForPsiElement((PsiElement)psiClass))});
            if (discrColumnAnn == null) {
                return null;
            }
            PsiAnnotationMemberValue discriminatorType = discrColumnAnn.findAttributeValue("discriminatorType");
            if (discriminatorType == null) {
                return Entity.DiscriminatorType.getDefault();
            }
            String typeValue = discriminatorType.getText();
            try {
                return Entity.DiscriminatorType.valueOf(typeValue.contains(".") ? StringUtils.substringAfterLast((String)typeValue, (String)".") : typeValue);
            }
            catch (IllegalArgumentException exception) {
                return Entity.DiscriminatorType.getDefault();
            }
        }));
    }

    public List<String> getPrimaryKeyJoinColumnNames(PsiClass psiClass) {
        return (List)EntityUtil.raPsiCachedWithDependencies((PsiElement)psiClass, "com.intellij.jpa.jpb.model.model.EntityAttributeCacheProvider.getPrimaryKeyJoinColumnNames", () -> {
            List<String> currentClassValue = StudioAnnotationUtil.getDeclaredStringAttributeValues((PsiModifierListOwner)psiClass, JpaEntityAnnotation.PrimaryKeyJoinColumn, "name");
            if (!currentClassValue.isEmpty()) {
                return new EntityUtil.ResultWithDependenciesWrapper<List<String>>(currentClassValue, Collections.singletonList(psiClass));
            }
            PsiClass parentEntityClass = EntityCacheProvider.getParentEntityClass(psiClass);
            if (parentEntityClass != null) {
                List<String> parentValue = this.getPrimaryKeyJoinColumnNames(parentEntityClass);
                return new EntityUtil.ResultWithDependenciesWrapper<List<String>>(parentValue, List.of(psiClass, parentEntityClass));
            }
            return new EntityUtil.ResultWithDependenciesWrapper(List.of(), Collections.singletonList(psiClass));
        });
    }

    public String getPrimaryKeyReferencedColumnName(PsiClass psiClass) {
        return (String)EntityUtil.raPsiCached((PsiElement)psiClass, () -> StudioAnnotationUtil.getDeclaredStringAttributeValue((PsiModifierListOwner)psiClass, JpaEntityAnnotation.PrimaryKeyJoinColumn, "referencedColumnName"));
    }

    public String getPrimaryKeyColumnDefinition(PsiClass psiClass) {
        return (String)EntityUtil.raPsiCached((PsiElement)psiClass, () -> StudioAnnotationUtil.getDeclaredStringAttributeValue((PsiModifierListOwner)psiClass, JpaEntityAnnotation.PrimaryKeyJoinColumn, "columnDefinition"));
    }

    public boolean isEmbeddable(PsiClass psiClass) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)psiClass, () -> AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{JpaEntityAnnotation.Embeddable.getFqn(this.project, ModuleUtil.findModuleForPsiElement((PsiElement)psiClass))}) != null);
    }

    public String getDiscriminator(PsiClass psiClass) {
        return (String)EntityUtil.raPsiCached((PsiElement)psiClass, () -> StudioAnnotationUtil.getStringAttributeValue((PsiModifierListOwner)psiClass, JpaEntityAnnotation.DiscriminatorValue.getFqn(this.project, ModuleUtil.findModuleForPsiElement((PsiElement)psiClass)), "value"));
    }

    public String getIdClassFqn(PsiClass psiClass) {
        return (String)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            PsiAnnotation idClassAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{JpaEntityAnnotation.IdClass.getFqn(this.project, ModuleUtil.findModuleForPsiElement((PsiElement)psiClass))});
            if (idClassAnn == null) {
                return null;
            }
            return StudioAnnotationUtil.getDeclaredReferenceFqnStringValue(idClassAnn, "value");
        });
    }

    public SequenceGenerator getSequenceGenerator(PsiClass psiClass) {
        return (SequenceGenerator)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            PsiAnnotation seqGeneratorAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{JpaAttributeAnnotation.SequenceGenerator.getFqn(this.project, ModuleUtil.findModuleForPsiElement((PsiElement)psiClass))});
            if (seqGeneratorAnn == null) {
                GenericGenerator genericGenerator = EntityUtil.getGenericGenerator((PsiModifierListOwner)psiClass);
                return genericGenerator == null ? null : this.getSequenceGeneratorFromGeneric(genericGenerator, psiClass);
            }
            String generatorName = StudioAnnotationUtil.getStringAttributeValue(seqGeneratorAnn, "name", null);
            if (StringUtil.isEmpty((String)generatorName)) {
                return null;
            }
            String sequenceName = StudioAnnotationUtil.getStringAttributeValue(seqGeneratorAnn, "sequenceName", null);
            Long initialValue = AnnotationUtil.getLongAttributeValue((PsiAnnotation)seqGeneratorAnn, (String)"initialValue");
            Long allocationSize = AnnotationUtil.getLongAttributeValue((PsiAnnotation)seqGeneratorAnn, (String)"allocationSize");
            return new SequenceGenerator(generatorName, sequenceName, initialValue, allocationSize);
        });
    }

    public SequenceGenerator getSequenceGeneratorFromGeneric(@NotNull GenericGenerator genericGenerator, @NotNull PsiClass psiClass) {
        if (genericGenerator == null) {
            EntityCacheProvider.$$$reportNull$$$0(1);
        }
        if (psiClass == null) {
            EntityCacheProvider.$$$reportNull$$$0(2);
        }
        if (!EntityAttribute.GENERIC_GENERATOR_SEQUENCE_STRATEGIES.contains(genericGenerator.getStrategy())) {
            return null;
        }
        Map<String, String> parameters = genericGenerator.getParameters();
        String generatorName = genericGenerator.getName();
        Long initialValue = NumberUtils.toLong((String)parameters.get("initial_value"), (long)1L);
        Long allocationSize = NumberUtils.toLong((String)parameters.get("increment_size"), (long)EntityUtil.getHibernateDefaultIncrementSize(psiClass.getProject()));
        String sequenceName = EntityUtil.getSequenceNameFromGenericGenerator((PsiMember)psiClass, parameters);
        return new SequenceGenerator(generatorName, sequenceName, initialValue, allocationSize);
    }

    @Nullable
    public AuditTable getAuditTable(PsiClass psiClass) {
        return (AuditTable)EntityUtil.raPsiCached((PsiElement)psiClass, () -> {
            PsiAnnotation auditTableAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"org.hibernate.envers.AuditTable"});
            if (auditTableAnn == null) {
                return null;
            }
            String tableName = EntityUtil.getAttributeValue(auditTableAnn, "value");
            if (StringUtil.isNotEmpty((String)tableName)) {
                String schemaName = EntityUtil.getAttributeValue(auditTableAnn, "schema");
                return new AuditTable(tableName, schemaName);
            }
            return null;
        });
    }

    @Nullable
    public List<EntityListener> getEntityListeners(PsiClass psiClass) {
        return (List)EntityUtil.ra(() -> {
            ArrayList<EntityListener> entityListeners = new ArrayList<EntityListener>();
            PsiClass entityClass = psiClass;
            boolean isCurrentClass = true;
            do {
                boolean isCurr = isCurrentClass;
                entityListeners.addAll(PsiUtilsKt.getEntityListenersClasses(entityClass).stream().map(listenerClass -> new EntityListener((SmartPsiElementPointer<PsiClass>)SmartPointersKt.createSmartPointer((PsiElement)listenerClass), isCurr)).toList());
                entityClass = EntityCacheProvider.getParentEntityClass(entityClass);
                isCurrentClass = false;
            } while (entityClass != null);
            return entityListeners;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericGenerator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/jpb/model/model/EntityCacheProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSequenceGeneratorFromGeneric";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

