/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.repository;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.model.Part;
import com.intellij.jpa.jpb.model.model.PartTree;
import com.intellij.jpa.jpb.model.model.Sort;
import com.intellij.jpa.jpb.model.repository.ExtractJpqlQueryException;
import com.intellij.jpa.jpb.model.repository.JoinProperty;
import com.intellij.jpa.jpb.model.repository.PropertyPath;
import com.intellij.jpa.jpb.model.repository.RepositoryMethod;
import com.intellij.jpa.jpb.model.repository.RepositoryMethodModel;
import com.intellij.jpa.jpb.model.repository.RepositoryMethodPsi;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0011\b\u0007\u0018\u0000 <2\u00020\u0001:\u0002<=B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\fJ \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u001a\u0010\u001c\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020\u0016H\u0002J \u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%H\u0002J \u0010&\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0005H\u0002J \u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010.\u001a\u00020\nH\u0002J0\u0010/\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010,\u001a\u00020-2\u0006\u00100\u001a\u00020%2\u0006\u00101\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J(\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020\tH\u0002J\u0018\u00107\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u00052\u0006\u00106\u001a\u00020\tH\u0002J \u00108\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n2\u0006\u00109\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010:\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010;\u001a\u00020-2\u0006\u0010\u0006\u001a\u00020\nH\u0002\u00a8\u0006>"}, d2={"Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodConverter;", "", "<init>", "()V", "extractJPQL", "", "method", "Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodPsi;", "useNamedParameters", "", "Lcom/intellij/jpa/jpb/model/repository/RepositoryMethod;", "entityClass", "Lcom/intellij/psi/PsiClass;", "isNeedInsertTransactionalReadOnlyFalse", "isTransactionalReadOnly", "repoClass", "queryOrderBy", "entityAlias", "", "queryMainBody", "canUppercase", "propertyPath", "Lcom/intellij/jpa/jpb/model/repository/PropertyPath;", "calculateJoinType", "Lcom/intellij/jpa/jpb/model/repository/JoinProperty$Type;", "partAndOperators", "", "Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodConverter$PartWithOperator;", "relativePropertyPathToDoth", "ancestorProp", "childProp", "createJoinExpr", "joinProperties", "Ljava/util/LinkedHashSet;", "Lcom/intellij/jpa/jpb/model/repository/JoinProperty;", "findParentCollectionProperty", "operatorType", "Lcom/intellij/jpa/jpb/model/model/Part$Type;", "checkUnsupportedOperation", "", "part", "Lcom/intellij/jpa/jpb/model/model/Part;", "methodName", "getParamName", "parameterIdx", "", "repoMethod", "createAssignedExpr", "type", "isIgnoreCase", "upperAndConcatIfIgnoreCase", "prefix", "parameterName", "postfix", "ignoreCase", "upperIfIgnoreCase", "queryDefinition", "entityName", "generateUpdateValueAssignment", "countUpdateQueryParams", "Companion", "PartWithOperator", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nRepositoryMethodConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositoryMethodConverter.kt\ncom/intellij/jpa/jpb/model/repository/RepositoryMethodConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,371:1\n1878#2,3:372\n1878#2,3:375\n1761#2,3:378\n1740#2,3:381\n1617#2,9:384\n1869#2:393\n1870#2:395\n1626#2:396\n1878#2,3:397\n1669#2,8:400\n1788#2,4:408\n1#3:394\n1#3:412\n*S KotlinDebug\n*F\n+ 1 RepositoryMethodConverter.kt\ncom/intellij/jpa/jpb/model/repository/RepositoryMethodConverter\n*L\n76#1:372,3\n91#1:375,3\n152#1:378,3\n157#1:381,3\n162#1:384,9\n162#1:393\n162#1:395\n162#1:396\n173#1:397,3\n205#1:400,8\n354#1:408,4\n162#1:394\n*E\n"})
public final class RepositoryMethodConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String extractJPQL(@NotNull RepositoryMethodPsi method, boolean useNamedParameters) throws ExtractJpqlQueryException {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        PsiClassType domainType = method.getRepositoryDomainType();
        PsiClass psiClass = domainType.resolve();
        if (psiClass == null) {
            throw new ExtractJpqlQueryException("Domain type not resolved");
        }
        PsiClass entityClass = psiClass;
        return this.extractJPQL(method, entityClass, useNamedParameters);
    }

    @NotNull
    public final String extractJPQL(@NotNull RepositoryMethod method, @NotNull PsiClass entityClass, boolean useNamedParameters) throws ExtractJpqlQueryException {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)entityClass, (String)"entityClass");
        String string = EntityUtil.getInstance(entityClass.getProject()).getEntityName(entityClass);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEntityName(...)");
        String entityName = string;
        if (method.getLimitPrefix() != null && method.getType() == RepositoryMethod.MethodType.Find) {
            String string2 = JpaModelBundle.message("extracting.jpql.using.limit.query", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            throw new ExtractJpqlQueryException(string2);
        }
        char[] cArray = entityName.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char entityAlias = Character.toLowerCase(cArray[0]);
        return this.queryDefinition(method, entityName, entityAlias) + this.queryMainBody(method, entityClass, entityAlias, useNamedParameters) + this.queryOrderBy(method, entityClass, entityAlias);
    }

    public final boolean isNeedInsertTransactionalReadOnlyFalse(boolean isTransactionalReadOnly, @NotNull PsiClass repoClass) {
        Intrinsics.checkNotNullParameter((Object)repoClass, (String)"repoClass");
        if (isTransactionalReadOnly) {
            return false;
        }
        PsiAnnotation transactionalAnn = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)((PsiModifierListOwner)repoClass), (Set)SetsKt.setOf((Object)"org.springframework.transaction.annotation.Transactional"));
        return transactionalAnn == null || Intrinsics.areEqual((Object)AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)transactionalAnn, (String)"readOnly"), (Object)true);
    }

    private final String queryOrderBy(RepositoryMethod method, PsiClass entityClass, char entityAlias) {
        PartTree partTree = method.getPartTree();
        List<Sort.Order> orders = partTree.getOrderBySource().getOrders();
        if (orders.isEmpty()) {
            return "";
        }
        Intrinsics.checkNotNull(orders);
        return " order by " + CollectionsKt.joinToString$default((Iterable)orders, (CharSequence)", ", null, null, (int)0, null, arg_0 -> RepositoryMethodConverter.queryOrderBy$lambda$0(entityClass, entityAlias, arg_0), (int)30, null);
    }

    /*
     * Unable to fully structure code
     */
    private final String queryMainBody(RepositoryMethod method, PsiClass entityClass, char entityAlias, boolean useNamedParameters) {
        partTree = method.getPartTree();
        partAndOperators = new ArrayList<E>();
        for (PartTree.OrPart predicateNode : partTree.getPredicateNodes()) {
            v0 = predicateNode.getChildren();
            Intrinsics.checkNotNullExpressionValue(v0, (String)"getChildren(...)");
            $this$forEachIndexed$iv = v0;
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (T item$iv : $this$forEachIndexed$iv) {
                if ((var14_19 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                var15_21 = (Part)item$iv;
                index = var14_19;
                $i$a$-forEachIndexed-RepositoryMethodConverter$queryMainBody$1 = false;
                if (index == 0 && Intrinsics.areEqual((Object)"findAll", (Object)part.getProperty())) continue;
                Intrinsics.checkNotNull((Object)part);
                partAndOperators.add(new PartWithOperator((Part)part, index == 0 ? "or" : "and"));
            }
        }
        if (partAndOperators.isEmpty()) {
            return "";
        }
        result = new StringBuilder(" where");
        joinProperties = new LinkedHashSet<JoinProperty>();
        paramIdx = 0;
        paramIdx = 1 + this.countUpdateQueryParams(method);
        joinType = this.calculateJoinType(entityClass, partAndOperators);
        $this$forEachIndexed$iv = partAndOperators;
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (T item$iv : $this$forEachIndexed$iv) {
            if ((var16_22 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            $i$a$-forEachIndexed-RepositoryMethodConverter$queryMainBody$1 = (PartWithOperator)item$iv;
            index = var16_22;
            $i$a$-forEachIndexed-RepositoryMethodConverter$queryMainBody$2 = false;
            part = partAndOperator.getPart();
            this.checkUnsupportedOperation(entityClass, part, method.getName());
            property = part.getProperty();
            result.append(" ");
            if (index != 0) {
                result.append(partAndOperator.getOperator() + " ");
            }
            propertyPath = PropertyPath.fromSafely(property, entityClass);
            if (part.shouldIgnoreCase() == Part.IgnoreCaseType.ALWAYS) ** GOTO lbl-1000
            if (part.shouldIgnoreCase() == Part.IgnoreCaseType.WHEN_POSSIBLE) {
                Intrinsics.checkNotNull((Object)propertyPath);
                ** if (!this.canUppercase((PropertyPath)propertyPath)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v1 = true;
                ** GOTO lbl56
            }
lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
lbl56:
            // 2 sources

            isIgnoreCase = v1;
            Intrinsics.checkNotNull((Object)propertyPath);
            v2 = part.getType();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getType(...)");
            parentCollectionProperty = this.findParentCollectionProperty(propertyPath, v2);
            if (parentCollectionProperty == null) {
                v3 = result.append(this.upperIfIgnoreCase(entityAlias + "." + propertyPath.toDotPath(), isIgnoreCase));
            } else {
                joinPropertyName = this.relativePropertyPathToDoth(propertyPath, parentCollectionProperty);
                joinProperties.add(new JoinProperty(joinPropertyName, joinType));
                nextProp = parentCollectionProperty.getNext();
                var27_34 = nextProp != null ? parentCollectionProperty.getName() + "." + nextProp.toDotPath() : parentCollectionProperty.getName();
                Intrinsics.checkNotNull((Object)var27_34);
                v3 = result.append(this.upperIfIgnoreCase(var27_34, isIgnoreCase));
            }
            result.append(" ");
            partType = part.getType();
            Intrinsics.checkNotNull((Object)partType);
            result.append(this.createAssignedExpr(method, paramIdx, partType, isIgnoreCase, useNamedParameters));
            paramIdx += partType.getNumberOfArguments();
        }
        leftJoinExpr = this.createJoinExpr(entityAlias, joinProperties);
        if (leftJoinExpr != null) {
            result.insert(0, " " + leftJoinExpr);
        }
        v4 = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"toString(...)");
        return v4;
    }

    private final boolean canUppercase(PropertyPath propertyPath) {
        PropertyPath currProperty = propertyPath;
        do {
            if (currProperty.getNext() != null) continue;
            return Intrinsics.areEqual((Object)"java.lang.String", (Object)currProperty.getPropertyType().getQualifiedName());
        } while (!Intrinsics.areEqual((Object)currProperty, (Object)propertyPath));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final JoinProperty.Type calculateJoinType(PsiClass entityClass, List<PartWithOperator> partAndOperators) {
        void $this$mapNotNullTo$iv$iv;
        Object element$iv2;
        block19: {
            block18: {
                boolean bl;
                block17: {
                    void $this$all$iv;
                    PartWithOperator it;
                    Iterable $this$any$iv;
                    int size = partAndOperators.size();
                    if (size == 1) {
                        boolean bl2;
                        block16: {
                            $this$any$iv = partAndOperators;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv) {
                                    it = (PartWithOperator)element$iv2;
                                    boolean bl3 = false;
                                    Part.Type[] typeArray = new Part.Type[]{Part.Type.IN, Part.Type.NOT_IN};
                                    if (!CollectionsKt.listOf((Object[])typeArray).contains((Object)it.getPart().getType())) continue;
                                    bl2 = true;
                                    break block16;
                                }
                                bl2 = false;
                            }
                        }
                        if (bl2) {
                            return JoinProperty.Type.LEFT;
                        }
                    }
                    if (size <= 1) break block18;
                    $this$any$iv = partAndOperators.subList(1, partAndOperators.size());
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            it = (PartWithOperator)element$iv2;
                            boolean bl4 = false;
                            if (Intrinsics.areEqual((Object)it.getOperator(), (Object)"and")) continue;
                            bl = false;
                            break block17;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block19;
            }
            return JoinProperty.Type.INNER;
        }
        Iterable $this$mapNotNull$iv = partAndOperators;
        boolean $i$f$mapNotNull = false;
        element$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            PropertyPath it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            PartWithOperator it = (PartWithOperator)element$iv$iv;
            boolean bl5 = false;
            String property = it.getPart().getProperty();
            if ((property == null || !StringsKt.contains$default((CharSequence)property, (char)'_', (boolean)false, (int)2, null) ? null : PropertyPath.fromSafely(property, entityClass)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List propertyPaths = (List)destination$iv$iv;
        if (propertyPaths.size() != partAndOperators.size()) {
            return JoinProperty.Type.LEFT;
        }
        String firstPropName = ((PropertyPath)propertyPaths.get(0)).getName();
        Iterable $this$forEachIndexed$iv = propertyPaths;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void propertyPath;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            object = (PropertyPath)item$iv;
            int index = n;
            boolean bl = false;
            if (index == 0 || Intrinsics.areEqual((Object)firstPropName, (Object)propertyPath.getName())) continue;
            return JoinProperty.Type.LEFT;
        }
        return JoinProperty.Type.INNER;
    }

    private final String relativePropertyPathToDoth(PropertyPath ancestorProp, PropertyPath childProp) {
        List result = new ArrayList();
        PropertyPath currPropertyPath = ancestorProp;
        while (currPropertyPath != null) {
            String string = currPropertyPath.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            result.add(string);
            currPropertyPath = Intrinsics.areEqual((Object)currPropertyPath, (Object)childProp) ? null : currPropertyPath.getNext();
        }
        return CollectionsKt.joinToString$default((Iterable)result, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    private final String createJoinExpr(char entityAlias, LinkedHashSet<JoinProperty> joinProperties) {
        if (joinProperties.isEmpty()) {
            return null;
        }
        Iterable $this$distinctBy$iv = joinProperties;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            JoinProperty it = (JoinProperty)e$iv;
            boolean bl = false;
            String key$iv = it.getPropertyName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)list$iv, (CharSequence)" ", null, null, (int)0, null, arg_0 -> RepositoryMethodConverter.createJoinExpr$lambda$8(entityAlias, arg_0), (int)30, null);
    }

    private final PropertyPath findParentCollectionProperty(PropertyPath propertyPath, Part.Type operatorType) {
        PropertyPath lastCollectionProperty;
        block4: {
            block3: {
                lastCollectionProperty = null;
                for (PropertyPath currProperty = propertyPath; currProperty != null; currProperty = currProperty.getNext()) {
                    if (!currProperty.isCollection()) continue;
                    lastCollectionProperty = currProperty;
                }
                if (lastCollectionProperty == null) break block3;
                if (lastCollectionProperty.getNext() != null) break block4;
                Part.Type[] typeArray = new Part.Type[]{Part.Type.IN, Part.Type.NOT_IN};
                if (CollectionsKt.listOf((Object[])typeArray).contains((Object)operatorType)) break block4;
            }
            return null;
        }
        return lastCollectionProperty;
    }

    private final void checkUnsupportedOperation(PsiClass entityClass, Part part, String methodName) {
        Part.Type partType = part.getType();
        if (part.shouldIgnoreCase() == Part.IgnoreCaseType.ALWAYS && (partType == Part.Type.IN || partType == Part.Type.NOT_IN)) {
            PropertyPath propertyPath = PropertyPath.fromSafely(part.getProperty(), entityClass);
            throw new ExtractJpqlQueryException("Unable to convert repository method to JPQL query.\nJPQL query does not have a valid representation for \"in\" case-insensitive operation.\nMethod name - " + methodName + "; Property path - '" + propertyPath.toDotPath() + "'.");
        }
    }

    private final String getParamName(int parameterIdx, boolean useNamedParameters, RepositoryMethod repoMethod) {
        String orderParameterName = "?" + parameterIdx;
        if (!useNamedParameters) {
            return orderParameterName;
        }
        if (repoMethod.getParametersCount() < parameterIdx) {
            return orderParameterName;
        }
        return ":" + repoMethod.getParameterName(parameterIdx - 1);
    }

    private final String createAssignedExpr(RepositoryMethod method, int parameterIdx, Part.Type type, boolean isIgnoreCase, boolean useNamedParameters) {
        String parameterName = this.getParamName(parameterIdx, useNamedParameters, method);
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> "is not null";
            case 2 -> "is null";
            case 3 -> "= true";
            case 4 -> "= false";
            case 5 -> "is empty";
            case 6 -> "is not empty";
            case 7 -> "<= " + parameterName;
            case 8, 9 -> "> " + parameterName;
            case 10 -> ">= " + parameterName;
            case 11, 12 -> "< " + parameterName;
            case 13 -> "<> " + this.upperIfIgnoreCase(parameterName, isIgnoreCase);
            case 14 -> "not like " + this.upperIfIgnoreCase(parameterName, isIgnoreCase);
            case 15 -> "like " + this.upperIfIgnoreCase(parameterName, isIgnoreCase);
            case 16 -> "like " + this.upperAndConcatIfIgnoreCase("", parameterName, "%", isIgnoreCase);
            case 17 -> "like " + this.upperAndConcatIfIgnoreCase("%", parameterName, "", isIgnoreCase);
            case 18 -> "like " + this.upperAndConcatIfIgnoreCase("%", parameterName, "%", isIgnoreCase);
            case 19 -> "not like " + this.upperAndConcatIfIgnoreCase("%", parameterName, "%", isIgnoreCase);
            case 20 -> "in " + parameterName;
            case 21 -> "not in " + parameterName;
            case 22 -> {
                Object twoParamName = this.getParamName(parameterIdx + 1, useNamedParameters, method);
                if (useNamedParameters && !StringsKt.startsWith$default((String)parameterName, (String)"?", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)twoParamName, (String)"?", (boolean)false, (int)2, null)) {
                    twoParamName = parameterName + "End";
                }
                yield "between " + parameterName + " and " + (String)twoParamName;
            }
            default -> "= " + this.upperIfIgnoreCase(parameterName, isIgnoreCase);
        };
    }

    private final String upperAndConcatIfIgnoreCase(String prefix, String parameterName, String postfix, boolean ignoreCase) {
        Object expr = ignoreCase ? "upper(" : "";
        expr = (String)expr + "concat(";
        if (((CharSequence)prefix).length() > 0) {
            expr = (String)expr + "'" + prefix + "', ";
        }
        expr = (String)expr + parameterName;
        if (((CharSequence)postfix).length() > 0) {
            expr = (String)expr + ", '" + postfix + "'";
        }
        expr = (String)expr + ")";
        if (ignoreCase) {
            expr = (String)expr + ")";
        }
        return expr;
    }

    private final String upperIfIgnoreCase(String parameterName, boolean ignoreCase) {
        return ignoreCase ? "upper(" + parameterName + ")" : parameterName;
    }

    private final String queryDefinition(RepositoryMethod method, String entityName, char entityAlias) {
        String distinctExpr = method.isQueryDistinct() ? "distinct " : "";
        return switch (WhenMappings.$EnumSwitchMapping$1[method.getType().ordinal()]) {
            case 1 -> "select count(" + distinctExpr + entityAlias + ") from " + entityName + " " + entityAlias;
            case 2 -> "select (count(" + entityAlias + ") > 0) from " + entityName + " " + entityAlias;
            case 3 -> "delete from " + entityName + " " + entityAlias;
            case 4 -> "update " + entityName + " " + entityAlias + " set " + this.generateUpdateValueAssignment(method, entityAlias);
            default -> "select " + distinctExpr + entityAlias + " from " + entityName + " " + entityAlias;
        };
    }

    private final String generateUpdateValueAssignment(RepositoryMethod method, char entityAlias) {
        if (!(method instanceof RepositoryMethodModel)) {
            return "";
        }
        Ref.IntRef parameterIdx = new Ref.IntRef();
        parameterIdx.element = 1;
        return CollectionsKt.joinToString$default((Iterable)((RepositoryMethodModel)method).getUpdateValues(), (CharSequence)", ", null, null, (int)0, null, arg_0 -> RepositoryMethodConverter.generateUpdateValueAssignment$lambda$10(this, parameterIdx, method, entityAlias, arg_0), (int)30, null);
    }

    private final int countUpdateQueryParams(RepositoryMethod method) {
        int n;
        if (!(method instanceof RepositoryMethodModel)) {
            return 0;
        }
        Iterable $this$count$iv = ((RepositoryMethodModel)method).getUpdateValues();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                RepositoryMethodModel.UpdateValue it = (RepositoryMethodModel.UpdateValue)element$iv;
                boolean bl = false;
                if (!(it.getValueType() == RepositoryMethodModel.ValueType.Parameter) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    private static final CharSequence queryOrderBy$lambda$0(PsiClass $entityClass, char $entityAlias, Sort.Order o) {
        PropertyPath propertyPath = PropertyPath.fromSafely(o.getProperty(), $entityClass);
        String directionValue = o.getDirection() == Sort.Direction.ASC ? "" : " DESC";
        return $entityAlias + "." + propertyPath.toDotPath() + directionValue;
    }

    private static final CharSequence createJoinExpr$lambda$8(char $entityAlias, JoinProperty joinProp) {
        Intrinsics.checkNotNullParameter((Object)joinProp, (String)"joinProp");
        String propertyName = joinProp.getPropertyName();
        String string = joinProp.getType().toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string + " join " + $entityAlias + "." + propertyName + " " + StringsKt.substringAfterLast$default((String)propertyName, (char)'.', null, (int)2, null);
    }

    private static final CharSequence generateUpdateValueAssignment$lambda$10(RepositoryMethodConverter this$0, Ref.IntRef $parameterIdx, RepositoryMethod $method, char $entityAlias, RepositoryMethodModel.UpdateValue it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getValueType() == RepositoryMethodModel.ValueType.Literal) {
            String string2 = it.getValue();
            if (string2 != null) {
                CharSequence charSequence;
                CharSequence charSequence2 = string2;
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    boolean bl = false;
                    charSequence = null;
                } else {
                    charSequence = charSequence2;
                }
                string = (String)charSequence;
            } else {
                string = null;
            }
        } else {
            int n = $parameterIdx.element;
            $parameterIdx.element = n + 1;
            string = this$0.getParamName(n, ((RepositoryMethodModel)$method).getUseNamedParameters(), $method);
        }
        String updateValue = string;
        return $entityAlias + "." + it.getAttributeName() + " = " + StringEscapeUtils.escapeJava((String)updateValue);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodConverter$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodConverter;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javaee.jpa.jpb.model"})
    @SourceDebugExtension(value={"SMAP\nRepositoryMethodConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositoryMethodConverter.kt\ncom/intellij/jpa/jpb/model/repository/RepositoryMethodConverter$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,371:1\n30#2,2:372\n*S KotlinDebug\n*F\n+ 1 RepositoryMethodConverter.kt\ncom/intellij/jpa/jpb/model/repository/RepositoryMethodConverter$Companion\n*L\n19#1:372,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RepositoryMethodConverter getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RepositoryMethodConverter> serviceClass$iv = RepositoryMethodConverter.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RepositoryMethodConverter)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodConverter$PartWithOperator;", "", "part", "Lcom/intellij/jpa/jpb/model/model/Part;", "operator", "", "<init>", "(Lcom/intellij/jpa/jpb/model/model/Part;Ljava/lang/String;)V", "getPart", "()Lcom/intellij/jpa/jpb/model/model/Part;", "getOperator", "()Ljava/lang/String;", "Companion", "intellij.javaee.jpa.jpb.model"})
    private static final class PartWithOperator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Part part;
        @NotNull
        private final String operator;
        @NotNull
        public static final String AND_OPERATOR = "and";
        @NotNull
        public static final String OR_OPERATOR = "or";

        public PartWithOperator(@NotNull Part part, @NotNull String operator) {
            Intrinsics.checkNotNullParameter((Object)part, (String)"part");
            Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
            this.part = part;
            this.operator = operator;
        }

        public /* synthetic */ PartWithOperator(Part part, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = OR_OPERATOR;
            }
            this(part, string);
        }

        @NotNull
        public final Part getPart() {
            return this.part;
        }

        @NotNull
        public final String getOperator() {
            return this.operator;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodConverter$PartWithOperator$Companion;", "", "<init>", "()V", "AND_OPERATOR", "", "OR_OPERATOR", "intellij.javaee.jpa.jpb.model"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Part.Type.values().length];
            try {
                nArray[Part.Type.IS_NOT_NULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.IS_NULL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.TRUE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.FALSE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.IS_EMPTY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.IS_NOT_EMPTY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.LESS_THAN_EQUAL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.GREATER_THAN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.AFTER.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.GREATER_THAN_EQUAL.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.BEFORE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.LESS_THAN.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.NEGATING_SIMPLE_PROPERTY.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.NOT_LIKE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.LIKE.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.STARTING_WITH.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.ENDING_WITH.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.CONTAINING.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.NOT_CONTAINING.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.IN.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.NOT_IN.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.Type.BETWEEN.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RepositoryMethod.MethodType.values().length];
            try {
                nArray[RepositoryMethod.MethodType.Count.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RepositoryMethod.MethodType.Exists.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RepositoryMethod.MethodType.Delete.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RepositoryMethod.MethodType.Update.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

