/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.service;

import com.intellij.jpa.jpb.model.backend.ds.DbDriversManagerExtension;
import com.intellij.jpa.jpb.model.config.DataSourceInfo;
import com.intellij.jpa.jpb.model.config.DatabaseDriversConfigState;
import com.intellij.jpa.jpb.model.config.DbDriver;
import com.intellij.jpa.jpb.model.config.JpbDataSourceConfig;
import com.intellij.jpa.jpb.model.core.model.DataStore;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.core.notifydialog.HNotificationManager;
import com.intellij.jpa.jpb.model.dbdrivers.DatabaseArtifactsManager;
import com.intellij.jpa.jpb.model.model.CustomDataStore;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.service.JpaDbDriversManagerExtension;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\tJ&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jpa/jpb/model/service/JpaDbDriversManagerExtension;", "Lcom/intellij/jpa/jpb/model/backend/ds/DbDriversManagerExtension;", "<init>", "()V", "getActualDriverURLs", "", "Ljava/net/URL;", "driverClassName", "", "(Ljava/lang/String;)[Ljava/net/URL;", "downloadDriversAndSaveState", "", "project", "Lcom/intellij/openapi/project/Project;", "dbTypes", "", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "successCallback", "Ljava/lang/Runnable;", "getCustomDataStores", "Lcom/intellij/jpa/jpb/model/core/model/DataStore;", "getReverseEngineeringDataStores", "ormFramework", "Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nJpaDbDriversManagerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpaDbDriversManagerExtension.kt\ncom/intellij/jpa/jpb/model/service/JpaDbDriversManagerExtension\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,91:1\n1#2:92\n1#2:111\n1563#3:93\n1634#3,3:94\n1617#3,9:101\n1869#3:110\n1870#3:112\n1626#3:113\n37#4:97\n36#4,3:98\n*S KotlinDebug\n*F\n+ 1 JpaDbDriversManagerExtension.kt\ncom/intellij/jpa/jpb/model/service/JpaDbDriversManagerExtension\n*L\n83#1:111\n28#1:93\n28#1:94,3\n83#1:101,9\n83#1:110\n83#1:112\n83#1:113\n30#1:97\n30#1:98,3\n*E\n"})
public final class JpaDbDriversManagerExtension
implements DbDriversManagerExtension {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public URL[] getActualDriverURLs(@NotNull String driverClassName) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Object v0;
        Iterable iterable;
        DatabaseArtifactsManager artifactsManager;
        block3: {
            Intrinsics.checkNotNullParameter((Object)driverClassName, (String)"driverClassName");
            artifactsManager = DatabaseArtifactsManager.Companion.getInstance();
            DatabaseDriversConfigState state = DatabaseDriversConfigState.Companion.getInstance();
            iterable = state.getDrivers();
            for (Object t : iterable) {
                DbDriver it = (DbDriver)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)driverClassName)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        DbDriver dbDriver = v0;
        if (dbDriver == null) {
            return new URL[0];
        }
        DbDriver foundDriverState = dbDriver;
        Iterable $this$map$iv = artifactsManager.getExistsClasspathElements(foundDriverState);
        boolean $i$f$map = false;
        iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void classpathElement;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(classpathElement.toURI().toURL());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new URL[0]);
    }

    @Override
    public void downloadDriversAndSaveState(@NotNull Project project, @NotNull List<? extends DbType> dbTypes, @NotNull Runnable successCallback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(dbTypes, (String)"dbTypes");
        Intrinsics.checkNotNullParameter((Object)successCallback, (String)"successCallback");
        String driverClassMsg = (dbTypes.size() == 1 ? "class " : "classes ") + CollectionsKt.joinToString$default((Iterable)dbTypes, (CharSequence)", ", null, null, (int)0, null, JpaDbDriversManagerExtension::downloadDriversAndSaveState$lambda$2, (int)30, null);
        Object[] objectArray = new Object[]{driverClassMsg};
        int res = Messages.showYesNoDialog((Project)project, (String)JpaModelBundle.message("driver.0.not.found", objectArray), (String)JpaModelBundle.message("driver.files.not.found", new Object[0]), (String)JpaModelBundle.message("download.driver.files", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getWarningIcon());
        if (res != 0) {
            return;
        }
        DatabaseArtifactsManager artifactsManager = DatabaseArtifactsManager.Companion.getInstance();
        if (artifactsManager.getArtifacts().isEmpty()) {
            HNotificationManager.getInstance(project).showNotification(JpaModelBundle.message("artifact.drivers.files.unload", new Object[0]), NotificationType.WARNING);
            return;
        }
        String string = JpaModelBundle.message("downloading.driver.files", new Object[0]);
        new Task.Modal(project, dbTypes, artifactsManager, successCallback, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ List<DbType> $dbTypes;
            final /* synthetic */ DatabaseArtifactsManager $artifactsManager;
            final /* synthetic */ Runnable $successCallback;
            {
                this.$project = $project;
                this.$dbTypes = $dbTypes;
                this.$artifactsManager = $artifactsManager;
                this.$successCallback = $successCallback;
                super($project, $super_call_param$1, true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    Application application = ApplicationManager.getApplication();
                    for (DbType dbType : this.$dbTypes) {
                        String driverClass;
                        DatabaseArtifactsManager.ArtifactVersion downloadedVersion = this.$artifactsManager.downloadLastArtifact(dbType);
                        if (downloadedVersion == null) {
                            application.invokeLater(() -> downloadDriversAndSaveState.1.run$lambda$0(this.$project));
                            return;
                        }
                        Intrinsics.checkNotNull((Object)dbType.getDriverClass());
                        DbDriver dbDriver = DatabaseDriversConfigState.Companion.getInstance().getOrCreateDriver(driverClass);
                        dbDriver.setVersion(downloadedVersion.getVersion());
                    }
                    application.invokeLater(this.$successCallback);
                }
                catch (IOException e) {
                    HNotificationManager.getInstance(this.$project).showNotification(e.getMessage() + "\n " + JpaModelBundle.message("please.check.internet.connection", new Object[0]), NotificationType.WARNING);
                }
            }

            private static final void run$lambda$0(Project $project) {
                Messages.showMessageDialog((Project)$project, (String)JpaModelBundle.message("driver.files.were.not.loaded", new Object[0]), (String)JpaModelBundle.message("download.driver.files", new Object[0]), (Icon)Messages.getErrorIcon());
            }
        }.queue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DataStore> getCustomDataStores(@NotNull Project project) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JpbDataSourceConfig jpbDataSourceConfig = JpbDataSourceConfig.getInstance(project);
        List<DataSourceInfo> list = jpbDataSourceConfig.customDataSources;
        Intrinsics.checkNotNullExpressionValue(list, (String)"customDataSources");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DataSourceInfo it = (DataSourceInfo)element$iv$iv;
            boolean bl2 = false;
            CustomDataStore it$iv$iv = new CustomDataStore(project, it);
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public List<DataStore> getReverseEngineeringDataStores(@NotNull Project project, @NotNull OrmFramework ormFramework) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ormFramework, (String)"ormFramework");
        return this.getCustomDataStores(project);
    }

    private static final CharSequence downloadDriversAndSaveState$lambda$2(DbType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getDriverClass();
        if (string == null) {
            string = it.getClass().getName();
        }
        return "'" + string + "'";
    }
}

