/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.component;

import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.backend.ds.DataSourceLoader;
import com.intellij.jpa.jpb.model.core.model.AbstractRdbmsStore;
import com.intellij.jpa.jpb.model.core.model.DataStore;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.model.CustomDataStore;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.service.DataStoreManager;
import com.intellij.jpa.jpb.model.ui.SSwingUtilKt;
import com.intellij.jpa.jpb.model.ui.component.DataSourceCellRenderEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u00011B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"J,\u0010#\u001a\u00020\u001b2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010%\u001a\u00020&2\u000e\b\u0002\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030(J\u0006\u0010)\u001a\u00020&J\u0010\u0010*\u001a\u00020&2\b\u0010+\u001a\u0004\u0018\u00010\u0010J\u0012\u0010,\u001a\u0004\u0018\u00010-2\b\u0010+\u001a\u0004\u0018\u00010\u0010J\b\u0010.\u001a\u0004\u0018\u00010\u0003J\b\u0010/\u001a\u0004\u0018\u00010\u0010J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u00030(H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R5\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b0\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u00062"}, d2={"Lcom/intellij/jpa/jpb/model/ui/component/DataSourceField;", "Lcom/intellij/openapi/ui/ComponentWithBrowseButton;", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/jpa/jpb/model/core/model/DataStore;", "project", "Lcom/intellij/openapi/project/Project;", "ormFramework", "Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getOrmFramework", "()Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "actionIds", "", "", "getActionIds", "()Ljava/util/Set;", "field", "getField", "()Lcom/intellij/openapi/ui/ComboBox;", "addActionPerformed", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "dataStore", "", "getAddActionPerformed", "()Lkotlin/jvm/functions/Function1;", "setAddActionPerformed", "(Lkotlin/jvm/functions/Function1;)V", "addAction", "actionListener", "Ljava/awt/event/ActionListener;", "initItems", "toSelectDataSource", "selectFirstItem", "", "dataStores", "", "isEmpty", "selectByDataSourceId", "id", "findDataSourceById", "Lcom/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore;", "getSelectedDataSource", "getSelectedDataSourceId", "loadAvailableDataStores", "AddDataStoreAction", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nDataSourceField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceField.kt\ncom/intellij/jpa/jpb/model/ui/component/DataSourceField\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,171:1\n1491#2:172\n1516#2,3:173\n1519#2,3:183\n1374#2:186\n1460#2,5:187\n382#3,7:176\n*S KotlinDebug\n*F\n+ 1 DataSourceField.kt\ncom/intellij/jpa/jpb/model/ui/component/DataSourceField\n*L\n91#1:172\n91#1:173,3\n91#1:183,3\n96#1:186\n96#1:187,5\n91#1:176,7\n*E\n"})
public final class DataSourceField
extends ComponentWithBrowseButton<ComboBox<DataStore>> {
    @NotNull
    private final Project project;
    @NotNull
    private final OrmFramework ormFramework;
    @NotNull
    private final Set<String> actionIds;
    @NotNull
    private Function1<? super DataStore, Unit> addActionPerformed;

    public DataSourceField(@NotNull Project project, @NotNull OrmFramework ormFramework) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ormFramework, (String)"ormFramework");
        super((JComponent)new ComboBox(), null);
        this.project = project;
        this.ormFramework = ormFramework;
        this.actionIds = new LinkedHashSet();
        this.addActionPerformed = DataSourceField::addActionPerformed$lambda$0;
        this.addAction(new AddDataStoreAction());
        this.setButtonIcon(AllIcons.General.Add);
        this.getField().setRenderer((ListCellRenderer)((Object)new DataSourceCellRenderEx(this.project)));
    }

    public /* synthetic */ DataSourceField(Project project, OrmFramework ormFramework, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ormFramework = JpaOrmFramework.INSTANCE;
        }
        this(project, ormFramework);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final OrmFramework getOrmFramework() {
        return this.ormFramework;
    }

    @NotNull
    public final Set<String> getActionIds() {
        return this.actionIds;
    }

    @NotNull
    public final ComboBox<DataStore> getField() {
        JComponent jComponent = this.getChildComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getChildComponent(...)");
        return (ComboBox)jComponent;
    }

    @NotNull
    public final Function1<DataStore, Unit> getAddActionPerformed() {
        return this.addActionPerformed;
    }

    public final void setAddActionPerformed(@NotNull Function1<? super DataStore, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.addActionPerformed = function1;
    }

    public final void addAction(@NotNull ActionListener actionListener) {
        Intrinsics.checkNotNullParameter((Object)actionListener, (String)"actionListener");
        super.addActionListener(actionListener);
        this.actionIds.add(actionListener.getClass().getName() + actionListener.hashCode());
    }

    public final void initItems(@Nullable DataStore toSelectDataSource, boolean selectFirstItem, @NotNull List<? extends DataStore> dataStores) {
        Intrinsics.checkNotNullParameter(dataStores, (String)"dataStores");
        this.getField().removeAllItems();
        ComboBoxModel comboBoxModel = this.getField().getModel();
        DefaultComboBoxModel defaultComboBoxModel = comboBoxModel instanceof DefaultComboBoxModel ? (DefaultComboBoxModel)comboBoxModel : null;
        if (defaultComboBoxModel != null) {
            defaultComboBoxModel.addAll((Collection)dataStores);
        }
        if (toSelectDataSource != null) {
            this.getField().setSelectedItem((Object)toSelectDataSource);
        } else if (selectFirstItem && !((Collection)dataStores).isEmpty()) {
            this.getField().setSelectedIndex(0);
        }
    }

    public static /* synthetic */ void initItems$default(DataSourceField dataSourceField, DataStore dataStore, boolean bl, List list, int n, Object object) {
        if ((n & 1) != 0) {
            dataStore = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            list = dataSourceField.loadAvailableDataStores();
        }
        dataSourceField.initItems(dataStore, bl, list);
    }

    public final boolean isEmpty() {
        return this.getField().getModel().getSize() == 0;
    }

    public final boolean selectByDataSourceId(@Nullable String id) {
        AbstractRdbmsStore abstractRdbmsStore = this.findDataSourceById(id);
        if (abstractRdbmsStore == null) {
            return false;
        }
        AbstractRdbmsStore dataSource = abstractRdbmsStore;
        this.getField().setSelectedItem((Object)dataSource);
        return true;
    }

    @Nullable
    public final AbstractRdbmsStore findDataSourceById(@Nullable String id) {
        if (id == null) {
            return null;
        }
        int n = this.getField().getItemCount();
        for (int i = 0; i < n; ++i) {
            DataStore ds = (DataStore)this.getField().getItemAt(i);
            if (!(ds instanceof AbstractRdbmsStore) || !Intrinsics.areEqual((Object)((AbstractRdbmsStore)ds).getId(), (Object)id)) continue;
            return (AbstractRdbmsStore)ds;
        }
        return null;
    }

    @Nullable
    public final DataStore getSelectedDataSource() {
        return (DataStore)SSwingUtilKt.getSelectedItemTyped((JComboBox)this.getField());
    }

    @Nullable
    public final String getSelectedDataSourceId() {
        Object t = SSwingUtilKt.getSelectedItemTyped((JComboBox)this.getField());
        AbstractRdbmsStore abstractRdbmsStore = t instanceof AbstractRdbmsStore ? (AbstractRdbmsStore)t : null;
        return abstractRdbmsStore != null ? abstractRdbmsStore.getId() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DataStore> loadAvailableDataStores() {
        void $this$flatMapTo$iv$iv;
        Iterable list$iv$iv;
        Iterable $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = DataSourceLoader.Companion.getInstance(this.project).getReverseEngineeringDataStores(this.ormFramework);
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DataStore it = (DataStore)element$iv$iv;
            boolean bl = false;
            Object object2 = it instanceof CustomDataStore ? (CustomDataStore)it : null;
            String key$iv$iv = object2 != null && (object2 = ((AbstractRdbmsStore)object2).getDbProperties()) != null ? ((DbProperties)object2).getUrlWithoutParams() : null;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = CollectionsKt.sortedWith((Iterable)destination$iv$iv.entrySet(), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((DataStore)CollectionsKt.first((List)((List)it.getValue()))).getName());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((DataStore)CollectionsKt.first((List)((List)it.getValue()))).getName())));
            }
        });
        boolean $i$f$flatMap = false;
        $this$groupByTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Function1[] function1Array = new Function1[]{DataSourceField::loadAvailableDataStores$lambda$5$lambda$3, DataSourceField::loadAvailableDataStores$lambda$5$lambda$4};
            list$iv$iv = CollectionsKt.sortedWith((Iterable)((Iterable)entry.getValue()), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Unit addActionPerformed$lambda$0(DataStore it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Comparable loadAvailableDataStores$lambda$5$lambda$3(DataStore it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it instanceof CustomDataStore ? (CustomDataStore)it : null;
        return object != null && (object = ((AbstractRdbmsStore)object).getName()) != null ? (Comparable)object : (Comparable)((Object)it.getName());
    }

    private static final Comparable loadAvailableDataStores$lambda$5$lambda$4(DataStore it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CustomDataStore customDataStore = it instanceof CustomDataStore ? (CustomDataStore)it : null;
        return (Comparable)((Object)(customDataStore != null ? customDataStore.getCustomSchemaName() : null));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/jpa/jpb/model/ui/component/DataSourceField$AddDataStoreAction;", "Ljava/awt/event/ActionListener;", "<init>", "(Lcom/intellij/jpa/jpb/model/ui/component/DataSourceField;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.javaee.jpa.jpb.model"})
    public final class AddDataStoreAction
    implements ActionListener {
        @Override
        public void actionPerformed(@Nullable ActionEvent e) {
            DataStore dataStore = DataStoreManager.Companion.getInstance(DataSourceField.this.getProject()).createDataStoreAction();
            if (dataStore == null) {
                return;
            }
            DataStore newDataSource = dataStore;
            DataSourceField.initItems$default(DataSourceField.this, newDataSource, false, null, 6, null);
            DataSourceField.this.getAddActionPerformed().invoke((Object)newDataSource);
        }
    }
}

