/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.NavigatableFileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0004LMNOB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u000bH&J\f\u0010(\u001a\u00060\u0018R\u00020\u0000H\u0002J\b\u0010)\u001a\u00020\u001dH\u0004J\b\u0010*\u001a\u00020\u000bH\u0016J\n\u0010+\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0012\u00100\u001a\u0004\u0018\u00010\u00122\u0006\u00101\u001a\u00020\"H\u0014J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000203H\u0016J\u0010\u00105\u001a\u0002032\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020-2\u0006\u00106\u001a\u000207H\u0016J\u0010\u00109\u001a\u00020-2\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020-2\u0006\u0010:\u001a\u00020;H\u0016J\n\u0010=\u001a\u0004\u0018\u00010>H\u0016J\n\u0010?\u001a\u0004\u0018\u00010@H\u0016J\u0010\u0010A\u001a\u00020-2\u0006\u0010B\u001a\u00020\u0012H\u0004J\u0010\u0010C\u001a\u0002032\u0006\u0010B\u001a\u00020\u0012H\u0014J\u0012\u0010D\u001a\u0004\u0018\u00010\"2\u0006\u0010E\u001a\u00020\u0012H\u0015J\n\u0010F\u001a\u0004\u0018\u00010GH\u0016J\b\u0010H\u001a\u00020-H\u0016J\u0010\u0010I\u001a\u00020/2\u0006\u0010J\u001a\u00020KH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001f\u0010\u0017\u001a\u00060\u0018R\u00020\u00008DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u000f\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001c\u001a\u00020\u001d8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u000f\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u0004\u0018\u00010\"8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001b\u0010%\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u000f\u001a\u0004\b&\u0010\r\u00a8\u0006P"}, d2={"Lcom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Lcom/intellij/openapi/fileEditor/NavigatableFileEditor;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "<init>", "(Lcom/intellij/openapi/fileEditor/TextEditor;)V", "getTextEditor", "()Lcom/intellij/openapi/fileEditor/TextEditor;", "previewComponent", "Ljavax/swing/JComponent;", "getPreviewComponent", "()Ljavax/swing/JComponent;", "previewComponent$delegate", "Lkotlin/Lazy;", "createPreviewComponent", "myLayout", "Lcom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview$LayoutType;", "getMyLayout", "()Lcom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview$LayoutType;", "setMyLayout", "(Lcom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview$LayoutType;)V", "toolbar", "Lcom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview$EditorWithPreviewToolbar;", "getToolbar", "()Lcom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview$EditorWithPreviewToolbar;", "toolbar$delegate", "splitter", "Lcom/intellij/ui/OnePixelSplitter;", "getSplitter", "()Lcom/intellij/ui/OnePixelSplitter;", "splitter$delegate", "splitterProportionKey", "", "getSplitterProportionKey", "()Ljava/lang/String;", "myComponent", "getMyComponent", "myComponent$delegate", "createToolbar", "createSplitter", "getComponent", "getPreferredFocusedComponent", "setState", "", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "getLayout", "layoutId", "isModified", "", "isValid", "canNavigateTo", "navigatable", "Lcom/intellij/pom/Navigatable;", "navigateTo", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "getCurrentLocation", "Lcom/intellij/openapi/fileEditor/FileEditorLocation;", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "selectLayout", "layoutType", "doSelectLayout", "getLayoutName", "layout", "getBackgroundHighlighter", "Lcom/intellij/codeHighlighting/BackgroundEditorHighlighter;", "dispose", "getState", "level", "Lcom/intellij/openapi/fileEditor/FileEditorStateLevel;", "EditorWithPreviewToolbar", "LayoutType", "DefaultLayoutType", "MyState", "intellij.javaee.jpa.jpb.model.ui"})
@SourceDebugExtension(value={"SMAP\nEditorWithPreview.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorWithPreview.kt\ncom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,219:1\n1310#2,2:220\n*S KotlinDebug\n*F\n+ 1 EditorWithPreview.kt\ncom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview\n*L\n85#1:220,2\n*E\n"})
public abstract class EditorWithPreview
extends UserDataHolderBase
implements FileEditor,
NavigatableFileEditor {
    @NotNull
    private final TextEditor textEditor;
    @NotNull
    private final Lazy previewComponent$delegate;
    @NotNull
    private LayoutType myLayout;
    @NotNull
    private final Lazy toolbar$delegate;
    @NotNull
    private final Lazy splitter$delegate;
    @NotNull
    private final Lazy myComponent$delegate;

    public EditorWithPreview(@NotNull TextEditor textEditor) {
        Intrinsics.checkNotNullParameter((Object)textEditor, (String)"textEditor");
        this.textEditor = textEditor;
        this.previewComponent$delegate = LazyKt.lazy(() -> EditorWithPreview.previewComponent_delegate$lambda$0(this));
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)this.textEditor));
        this.myLayout = DefaultLayoutType.EDITOR_AND_PREVIEW;
        this.toolbar$delegate = LazyKt.lazy(() -> EditorWithPreview.toolbar_delegate$lambda$1(this));
        this.splitter$delegate = LazyKt.lazy(() -> EditorWithPreview.splitter_delegate$lambda$2(this));
        this.myComponent$delegate = LazyKt.lazy(() -> EditorWithPreview.myComponent_delegate$lambda$3(this));
    }

    @NotNull
    public final TextEditor getTextEditor() {
        return this.textEditor;
    }

    @NotNull
    protected final JComponent getPreviewComponent() {
        Lazy lazy = this.previewComponent$delegate;
        return (JComponent)lazy.getValue();
    }

    @NotNull
    public abstract JComponent createPreviewComponent();

    @NotNull
    protected final LayoutType getMyLayout() {
        return this.myLayout;
    }

    protected final void setMyLayout(@NotNull LayoutType layoutType) {
        Intrinsics.checkNotNullParameter((Object)layoutType, (String)"<set-?>");
        this.myLayout = layoutType;
    }

    @NotNull
    protected final EditorWithPreviewToolbar getToolbar() {
        Lazy lazy = this.toolbar$delegate;
        return (EditorWithPreviewToolbar)lazy.getValue();
    }

    @NotNull
    protected final OnePixelSplitter getSplitter() {
        Lazy lazy = this.splitter$delegate;
        return (OnePixelSplitter)lazy.getValue();
    }

    @Nullable
    protected String getSplitterProportionKey() {
        return Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass()).getQualifiedName();
    }

    private final JComponent getMyComponent() {
        Lazy lazy = this.myComponent$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (JComponent)object;
    }

    private final EditorWithPreviewToolbar createToolbar() {
        return new EditorWithPreviewToolbar(this, null, 1, null);
    }

    @NotNull
    protected final OnePixelSplitter createSplitter() {
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.5f, 0.15f, 0.85f);
        splitter.setSplitterProportionKey(this.getSplitterProportionKey());
        return splitter;
    }

    @NotNull
    public JComponent getComponent() {
        return this.getMyComponent();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        LayoutType layoutType = this.myLayout;
        return layoutType == DefaultLayoutType.EDITOR_AND_PREVIEW || layoutType == DefaultLayoutType.EDITOR ? this.textEditor.getPreferredFocusedComponent() : (layoutType == DefaultLayoutType.PREVIEW ? this.getPreviewComponent() : null);
    }

    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state instanceof MyState) {
            this.textEditor.setState(((MyState)state).getMyFirstState());
            LayoutType layoutType = this.getLayout(((MyState)state).getLayoutId());
            if (layoutType == null) {
                layoutType = DefaultLayoutType.EDITOR_AND_PREVIEW;
            }
            this.selectLayout(layoutType);
        }
    }

    @Nullable
    protected LayoutType getLayout(@NotNull String layoutId) {
        DefaultLayoutType defaultLayoutType;
        block1: {
            Intrinsics.checkNotNullParameter((Object)layoutId, (String)"layoutId");
            DefaultLayoutType[] $this$firstOrNull$iv = DefaultLayoutType.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                DefaultLayoutType element$iv;
                DefaultLayoutType it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)layoutId)) continue;
                defaultLayoutType = element$iv;
                break block1;
            }
            defaultLayoutType = null;
        }
        return defaultLayoutType;
    }

    public boolean isModified() {
        return this.textEditor.isModified();
    }

    public boolean isValid() {
        return this.textEditor.isValid();
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        return this.textEditor.canNavigateTo(navigatable);
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        this.textEditor.navigateTo(navigatable);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.textEditor.addPropertyChangeListener(listener);
        this.getPreviewComponent().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.textEditor.removePropertyChangeListener(listener);
        this.getPreviewComponent().removePropertyChangeListener(listener);
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return this.textEditor.getCurrentLocation();
    }

    @Nullable
    public VirtualFile getFile() {
        return this.textEditor.getFile();
    }

    protected final void selectLayout(@NotNull LayoutType layoutType) {
        Intrinsics.checkNotNullParameter((Object)layoutType, (String)"layoutType");
        if (this.doSelectLayout(layoutType)) {
            this.myLayout = layoutType;
        }
    }

    protected boolean doSelectLayout(@NotNull LayoutType layoutType) {
        Intrinsics.checkNotNullParameter((Object)layoutType, (String)"layoutType");
        LayoutType layoutType2 = layoutType;
        if (layoutType2 == DefaultLayoutType.EDITOR) {
            this.textEditor.getComponent().setVisible(true);
            this.getPreviewComponent().setVisible(false);
        } else if (layoutType2 == DefaultLayoutType.PREVIEW) {
            this.textEditor.getComponent().setVisible(false);
            this.getPreviewComponent().setVisible(true);
        } else if (layoutType2 == DefaultLayoutType.EDITOR_AND_PREVIEW) {
            this.textEditor.getComponent().setVisible(true);
            this.getPreviewComponent().setVisible(true);
        }
        return true;
    }

    @NlsActions.ActionText
    @Nullable
    protected String getLayoutName(@NotNull LayoutType layout) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        LayoutType layoutType = layout;
        return layoutType == DefaultLayoutType.EDITOR ? JpaModelBundle.message("action.editor.text", new Object[0]) : (layoutType == DefaultLayoutType.PREVIEW ? JpaModelBundle.message("action.preview.text", new Object[0]) : (layoutType == DefaultLayoutType.EDITOR_AND_PREVIEW ? JpaModelBundle.message("action.editor.and.preview.text", new Object[0]) : null));
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return this.textEditor.getBackgroundHighlighter();
    }

    public void dispose() {
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        String string = this.myLayout.getId();
        FileEditorState fileEditorState = this.textEditor.getState(level);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorState, (String)"getState(...)");
        return new MyState(string, fileEditorState);
    }

    private static final JComponent previewComponent_delegate$lambda$0(EditorWithPreview this$0) {
        return this$0.createPreviewComponent();
    }

    private static final EditorWithPreviewToolbar toolbar_delegate$lambda$1(EditorWithPreview this$0) {
        return this$0.createToolbar();
    }

    private static final OnePixelSplitter splitter_delegate$lambda$2(EditorWithPreview this$0) {
        return this$0.createSplitter();
    }

    private static final BorderLayoutPanel myComponent_delegate$lambda$3(EditorWithPreview this$0) {
        this$0.getSplitter().setFirstComponent(this$0.textEditor.getComponent());
        this$0.getSplitter().setSecondComponent(this$0.getPreviewComponent());
        return JBUI.Panels.simplePanel((Component)((Component)this$0.getSplitter())).addToTop((Component)this$0.getToolbar());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview$DefaultLayoutType;", "Lcom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview$LayoutType;", "", "icon", "Ljavax/swing/Icon;", "<init>", "(Ljava/lang/String;ILjavax/swing/Icon;)V", "getIcon", "()Ljavax/swing/Icon;", "EDITOR", "PREVIEW", "EDITOR_AND_PREVIEW", "id", "", "getId", "()Ljava/lang/String;", "intellij.javaee.jpa.jpb.model.ui"})
    public static final class DefaultLayoutType
    extends Enum<DefaultLayoutType>
    implements LayoutType {
        @NotNull
        private final Icon icon;
        @NotNull
        private final String id;
        public static final /* enum */ DefaultLayoutType EDITOR;
        public static final /* enum */ DefaultLayoutType PREVIEW;
        public static final /* enum */ DefaultLayoutType EDITOR_AND_PREVIEW;
        private static final /* synthetic */ DefaultLayoutType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DefaultLayoutType(Icon icon) {
            this.icon = icon;
            this.id = this.name();
        }

        @Override
        @NotNull
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        public static DefaultLayoutType[] values() {
            return (DefaultLayoutType[])$VALUES.clone();
        }

        public static DefaultLayoutType valueOf(String value) {
            return Enum.valueOf(DefaultLayoutType.class, value);
        }

        @NotNull
        public static EnumEntries<DefaultLayoutType> getEntries() {
            return $ENTRIES;
        }

        static {
            Icon icon = AllIcons.General.LayoutEditorOnly;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"LayoutEditorOnly");
            EDITOR = new DefaultLayoutType(icon);
            Icon icon2 = AllIcons.General.LayoutPreviewOnly;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"LayoutPreviewOnly");
            PREVIEW = new DefaultLayoutType(icon2);
            Icon icon3 = AllIcons.General.LayoutEditorPreview;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"LayoutEditorPreview");
            EDITOR_AND_PREVIEW = new DefaultLayoutType(icon3);
            $VALUES = defaultLayoutTypeArray = new DefaultLayoutType[]{DefaultLayoutType.EDITOR, DefaultLayoutType.PREVIEW, DefaultLayoutType.EDITOR_AND_PREVIEW};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0096\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u000fB\u0017\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0016R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview$EditorWithPreviewToolbar;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "layouts", "", "Lcom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview$LayoutType;", "<init>", "(Lcom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview;Ljava/util/List;)V", "myRightToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "getMyRightToolbar", "()Lcom/intellij/openapi/actionSystem/ActionToolbar;", "refresh", "", "dispose", "ChangeViewModeAction", "intellij.javaee.jpa.jpb.model.ui"})
    @SourceDebugExtension(value={"SMAP\nEditorWithPreview.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorWithPreview.kt\ncom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview$EditorWithPreviewToolbar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,219:1\n1563#2:220\n1634#2,3:221\n37#3:224\n36#3,3:225\n*S KotlinDebug\n*F\n+ 1 EditorWithPreview.kt\ncom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview$EditorWithPreviewToolbar\n*L\n161#1:220\n161#1:221,3\n161#1:224\n161#1:225,3\n*E\n"})
    public class EditorWithPreviewToolbar
    extends JPanel
    implements Disposable {
        @NotNull
        private final ActionToolbar myRightToolbar;
        final /* synthetic */ EditorWithPreview this$0;

        /*
         * WARNING - void declaration
         */
        public EditorWithPreviewToolbar(@NotNull EditorWithPreview this$0, List<? extends LayoutType> layouts) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(layouts, (String)"layouts");
            this.this$0 = this$0;
            super(new BorderLayout());
            Iterable $this$map$iv = layouts;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                LayoutType layoutType = (LayoutType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ChangeViewModeAction((LayoutType)p0));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            ChangeViewModeAction[] changeViewModeActionArray = thisCollection$iv.toArray(new ChangeViewModeAction[0]);
            AnAction[] anActionArray = (AnAction[])Arrays.copyOf(changeViewModeActionArray, changeViewModeActionArray.length);
            ActionGroup group = (ActionGroup)new DefaultActionGroup(anActionArray);
            ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("TextEditorWithPreview", group, true);
            Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
            this.myRightToolbar = actionToolbar;
            this.myRightToolbar.setTargetComponent((JComponent)this.this$0.getSplitter());
            this.add((Component)this.myRightToolbar.getComponent(), "East");
        }

        public /* synthetic */ EditorWithPreviewToolbar(EditorWithPreview editorWithPreview, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                Object[] objectArray = new DefaultLayoutType[]{DefaultLayoutType.EDITOR, DefaultLayoutType.EDITOR_AND_PREVIEW, DefaultLayoutType.PREVIEW};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
            this(editorWithPreview, list);
        }

        @NotNull
        protected final ActionToolbar getMyRightToolbar() {
            return this.myRightToolbar;
        }

        public final void refresh() {
            this.myRightToolbar.updateActionsImmediately();
        }

        public void dispose() {
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview$EditorWithPreviewToolbar$ChangeViewModeAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "layout", "Lcom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview$LayoutType;", "<init>", "(Lcom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview$EditorWithPreviewToolbar;Lcom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview$LayoutType;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.javaee.jpa.jpb.model.ui"})
        private final class ChangeViewModeAction
        extends ToggleAction
        implements DumbAware {
            @NotNull
            private final LayoutType layout;

            public ChangeViewModeAction(LayoutType layout) {
                Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
                super(EditorWithPreviewToolbar.this.this$0.getLayoutName(layout), null, layout.getIcon());
                this.layout = layout;
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return Intrinsics.areEqual((Object)EditorWithPreviewToolbar.this.this$0.getMyLayout(), (Object)this.layout);
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (state) {
                    EditorWithPreviewToolbar.this.this$0.selectLayout(this.layout);
                    EditorWithPreviewToolbar.this.refresh();
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview$LayoutType;", "", "id", "", "getId", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "intellij.javaee.jpa.jpb.model.ui"})
    public static interface LayoutType {
        @NotNull
        public String getId();

        @NotNull
        public Icon getIcon();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jpa/jpb/model/ui/editor/EditorWithPreview$MyState;", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "layoutId", "", "myFirstState", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/fileEditor/FileEditorState;)V", "getLayoutId", "()Ljava/lang/String;", "getMyFirstState", "()Lcom/intellij/openapi/fileEditor/FileEditorState;", "canBeMergedWith", "", "otherState", "level", "Lcom/intellij/openapi/fileEditor/FileEditorStateLevel;", "intellij.javaee.jpa.jpb.model.ui"})
    public static final class MyState
    implements FileEditorState {
        @NotNull
        private final String layoutId;
        @NotNull
        private final FileEditorState myFirstState;

        public MyState(@NotNull String layoutId, @NotNull FileEditorState myFirstState) {
            Intrinsics.checkNotNullParameter((Object)layoutId, (String)"layoutId");
            Intrinsics.checkNotNullParameter((Object)myFirstState, (String)"myFirstState");
            this.layoutId = layoutId;
            this.myFirstState = myFirstState;
        }

        @NotNull
        public final String getLayoutId() {
            return this.layoutId;
        }

        @NotNull
        public final FileEditorState getMyFirstState() {
            return this.myFirstState;
        }

        public boolean canBeMergedWith(@NotNull FileEditorState otherState, @NotNull FileEditorStateLevel level) {
            Intrinsics.checkNotNullParameter((Object)otherState, (String)"otherState");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            return otherState instanceof MyState && this.myFirstState.canBeMergedWith(((MyState)otherState).myFirstState, level);
        }
    }
}

