/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.propertyform;

import com.intellij.jpa.jpb.model.ui.validation.ValueModelValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.util.SmartList;
import com.jgoodies.binding.value.AbstractValueModel;
import java.beans.PropertyChangeListener;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public class FormValueModel
extends AbstractValueModel {
    private AbstractValueModel model;
    protected String propertyName;
    private List<ValueModelValidator> validators = new SmartList();

    public FormValueModel(AbstractValueModel model2, String propertyName) {
        this.model = model2;
        this.propertyName = propertyName;
    }

    public Object getValue() {
        return this.model.getValue();
    }

    public void setValue(Object newValue) {
        Object oldValue = this.model.getValue();
        this.model.setValue(newValue);
        if (oldValue != newValue) {
            this.firePropertyChange(this.propertyName, oldValue, newValue, false);
        }
    }

    public void addValidator(ValueModelValidator validator) {
        this.validators.add(validator);
    }

    @Nullable
    public <T> T getValidator(Class<T> validatorClass) {
        return StreamEx.of(this.validators).findFirst(v -> validatorClass.isAssignableFrom(v.getClass())).map(validatorClass::cast).orElse(null);
    }

    public void removeValidator(ValueModelValidator validator) {
        this.validators.remove(validator);
    }

    public List<ValidationInfo> validate() {
        Object value = this.getValue();
        return StreamEx.of(this.validators).map(it -> it.validate(value)).nonNull().toList();
    }

    public void addModelValueChangeListener(PropertyChangeListener valueChangeListener) {
        this.addPropertyChangeListener(this.propertyName, valueChangeListener);
    }

    public void initialPropertyChange() {
        this.firePropertyChange(this.propertyName, null, this.getValue());
    }
}

