/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.debug.recents;

import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.debug.KubectlDebugParameters;
import com.intellij.kubernetes.debug.KubectlDebugUtilsKt;
import com.intellij.kubernetes.debug.KubectlDebugWithSpecifiedParamsAction;
import com.intellij.kubernetes.debug.recents.KubectlDebugRecentParametersTemplate;
import com.intellij.kubernetes.debug.recents.KubernetesRecentDebugsParametersService;
import com.intellij.kubernetes.debug.recents.KubernetesRecentEphemeralDebugsActionGroupKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.ui.actions.KubernetesModelBasedDumbAwareActionKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1Pod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001f\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0017\u00a2\u0006\u0002\u0010\u0010J \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/kubernetes/debug/recents/KubernetesRecentEphemeralDebugsActionGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isVisible", "", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "calculateTargetContainers", "", "Lio/kubernetes/client/openapi/models/V1Container;", "selectedContainer", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "selectedPod", "Lio/kubernetes/client/openapi/models/V1Pod;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesRecentEphemeralDebugsActionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesRecentEphemeralDebugsActionGroup.kt\ncom/intellij/kubernetes/debug/recents/KubernetesRecentEphemeralDebugsActionGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1563#2:125\n1634#2,3:126\n37#3:129\n36#3,3:130\n1#4:133\n*S KotlinDebug\n*F\n+ 1 KubernetesRecentEphemeralDebugsActionGroup.kt\ncom/intellij/kubernetes/debug/recents/KubernetesRecentEphemeralDebugsActionGroup\n*L\n70#1:125\n70#1:126,3\n76#1:129\n76#1:130,3\n*E\n"})
public final class KubernetesRecentEphemeralDebugsActionGroup
extends DefaultActionGroup
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!KubectlDebugUtilsKt.isKubectlDebugSupportEnabled()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(this.isVisible(e));
    }

    private final boolean isVisible(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        KubernetesApiModelInterface kubernetesApiModelInterface = KubernetesModelBasedDumbAwareActionKt.getApiModel((AnActionEvent)e);
        if (kubernetesApiModelInterface == null) {
            return false;
        }
        KubernetesApiModelInterface apiModel2 = kubernetesApiModelInterface;
        Pair<V1Pod, KubernetesContainerObject> pair = KubectlDebugUtilsKt.getSelectedPodAndContainer(e);
        V1Pod selectedPod2 = (V1Pod)pair.component1();
        KubernetesContainerObject selectedContainer = (KubernetesContainerObject)pair.component2();
        if (selectedPod2 == null) {
            return false;
        }
        if (selectedContainer != null && KubectlDebugUtilsKt.isEphemeral(selectedContainer)) {
            return false;
        }
        List<V1Container> targetContainers = this.calculateTargetContainers(selectedContainer, selectedPod2);
        if (targetContainers.isEmpty()) {
            return false;
        }
        List<KubectlDebugRecentParametersTemplate> debugParametersTemplates = KubernetesRecentDebugsParametersService.Companion.getInstance(project2).getTemplates();
        List actionTexts2debugParams = KubernetesRecentEphemeralDebugsActionGroupKt.access$getActionsTitles2FilteredDebugParametersSets(apiModel2.getNamespace(), selectedPod2, targetContainers, debugParametersTemplates);
        return !((Collection)actionTexts2debugParams).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        if (e == null) {
            return new AnAction[0];
        }
        Project project = e.getProject();
        if (project == null) {
            return new AnAction[0];
        }
        Project project2 = project;
        KubernetesApiModelInterface kubernetesApiModelInterface = KubernetesModelBasedDumbAwareActionKt.getApiModel((AnActionEvent)e);
        if (kubernetesApiModelInterface == null) {
            return new AnAction[0];
        }
        KubernetesApiModelInterface apiModel2 = kubernetesApiModelInterface;
        Pair<V1Pod, KubernetesContainerObject> pair = KubectlDebugUtilsKt.getSelectedPodAndContainer(e);
        V1Pod selectedPod2 = (V1Pod)pair.component1();
        KubernetesContainerObject selectedContainer = (KubernetesContainerObject)pair.component2();
        if (selectedPod2 == null) {
            return new AnAction[0];
        }
        List<V1Container> targetContainers = this.calculateTargetContainers(selectedContainer, selectedPod2);
        if (targetContainers.isEmpty()) {
            return new AnAction[0];
        }
        List<KubectlDebugRecentParametersTemplate> debugParametersTemplates = KubernetesRecentDebugsParametersService.Companion.getInstance(project2).getTemplates();
        List actionTitle2debugParamsSetPairs = KubernetesRecentEphemeralDebugsActionGroupKt.access$getActionsTitles2FilteredDebugParametersSets(apiModel2.getNamespace(), selectedPod2, targetContainers, debugParametersTemplates);
        if (actionTitle2debugParamsSetPairs.isEmpty()) {
            return new AnAction[0];
        }
        Object[] $this$map$iv = (Object[])actionTitle2debugParamsSetPairs;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair2 = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KubectlDebugParameters debugParameters = (KubectlDebugParameters)it.getSecond();
            String actionTitle = (String)it.getFirst();
            collection.add(new KubectlDebugWithSpecifiedParamsAction(apiModel2, debugParameters, actionTitle));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        KubectlDebugWithSpecifiedParamsAction[] actions = thisCollection$iv.toArray(new KubectlDebugWithSpecifiedParamsAction[0]);
        Separator separator = Separator.create((String)KubernetesBundle.message((String)"separator.Kubernetes.EphemeralContainers.recents.name", (Object[])new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)separator, (String)"create(...)");
        Separator separator2 = separator;
        AnAction gotoSettingsAction = ActionManager.getInstance().getAction("Kubernetes.EphemeralContainers.open.recent.debugs.settings");
        objectArray = new AnAction[]{separator2};
        Object[] objectArray2 = ArraysKt.plus((Object[])objectArray, (Object[])actions);
        objectArray = new AnAction[]{gotoSettingsAction};
        return (AnAction[])ArraysKt.plus((Object[])objectArray2, (Object[])objectArray);
    }

    private final List<V1Container> calculateTargetContainers(KubernetesContainerObject selectedContainer, V1Pod selectedPod2) {
        List list;
        block3: {
            block5: {
                block4: {
                    block2: {
                        if (selectedContainer != null) break block2;
                        list = KubectlDebugUtilsKt.getContainersExceptEphemeral(selectedPod2);
                        break block3;
                    }
                    if (!KubectlDebugUtilsKt.isEphemeral(selectedContainer)) break block4;
                    list = CollectionsKt.emptyList();
                    break block3;
                }
                list = selectedContainer.getContainerSpec();
                if (list == null) break block5;
                List it = list;
                boolean bl = false;
                List list2 = CollectionsKt.listOf((Object)it);
                list = list2;
                if (list2 != null) break block3;
            }
            KubernetesRecentEphemeralDebugsActionGroup $this$calculateTargetContainers_u24lambda_u242 = this;
            boolean bl = false;
            KubernetesRecentEphemeralDebugsActionGroupKt.access$getLOG$p().debug("`null` from `containerSpec` for non-ephemeral KubernetesContainerObject: " + selectedContainer);
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

