/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.highlighting;

import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.highlighting.KubernetesAnnotatorColor;
import com.intellij.kubernetes.model.KubernetesApiVersionType;
import com.intellij.kubernetes.model.KubernetesCompoundModelDefinition;
import com.intellij.kubernetes.model.KubernetesResourceKindType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlBooleanType;
import org.jetbrains.yaml.meta.model.YamlEnumType;
import org.jetbrains.yaml.meta.model.YamlIntegerType;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kubernetes/highlighting/KubernetesValuesAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotateValue", "e", "annotatorColor", "Lcom/intellij/kubernetes/highlighting/KubernetesAnnotatorColor;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesValuesAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesValuesAnnotator.kt\ncom/intellij/kubernetes/highlighting/KubernetesValuesAnnotator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1#2:46\n*E\n"})
public final class KubernetesValuesAnnotator
implements Annotator,
DumbAware {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        block15: {
            KubernetesAnnotatorColor kubernetesAnnotatorColor;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            PsiFile psiFile = holder.getCurrentAnnotationSession().getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
            PsiFile psiFile2 = psiFile;
            if (!KubernetesUtilKt.isKubernetesYaml(psiFile2) && !Chart.Companion.isChartsTemplateFile(psiFile2.getVirtualFile())) {
                return;
            }
            YAMLKeyValue yAMLKeyValue = element instanceof YAMLKeyValue ? (YAMLKeyValue)element : null;
            if (yAMLKeyValue == null || (yAMLKeyValue = yAMLKeyValue.getValue()) == null) break block15;
            YAMLKeyValue yamlValue = yAMLKeyValue;
            boolean bl = false;
            YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = KubernetesUtilKt.getK8sMetaTypeProxy((YAMLPsiElement)yamlValue);
            if (metaTypeProxy == null || (metaTypeProxy = metaTypeProxy.getMetaType()) == null) {
                return;
            }
            YamlMetaTypeProvider.MetaTypeProxy valueMetaType = metaTypeProxy;
            YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy2 = valueMetaType;
            if (metaTypeProxy2 instanceof YamlIntegerType) {
                kubernetesAnnotatorColor = KubernetesAnnotatorColor.NUMBER;
            } else if (metaTypeProxy2 instanceof YamlBooleanType) {
                kubernetesAnnotatorColor = KubernetesAnnotatorColor.BOOLEAN;
            } else if (metaTypeProxy2 instanceof YamlEnumType) {
                kubernetesAnnotatorColor = KubernetesAnnotatorColor.ENUM;
            } else if (metaTypeProxy2 instanceof KubernetesApiVersionType || metaTypeProxy2 instanceof KubernetesResourceKindType) {
                kubernetesAnnotatorColor = KubernetesAnnotatorColor.GVK;
            } else if (metaTypeProxy2 instanceof KubernetesCompoundModelDefinition) {
                Object v4;
                block14: {
                    Iterable iterable = ((KubernetesCompoundModelDefinition)valueMetaType).getTypes$intellij_clouds_kubernetes_backend();
                    for (Object t : iterable) {
                        YamlMetaType it = (YamlMetaType)t;
                        boolean bl2 = false;
                        if (!(it instanceof YamlEnumType)) continue;
                        v4 = t;
                        break block14;
                    }
                    v4 = null;
                }
                if ((YamlMetaType)v4 == null) {
                    return;
                }
                kubernetesAnnotatorColor = KubernetesAnnotatorColor.ENUM;
            } else {
                return;
            }
            KubernetesAnnotatorColor annotatorColor = kubernetesAnnotatorColor;
            this.annotateValue((PsiElement)yamlValue, holder, annotatorColor);
        }
    }

    private final void annotateValue(PsiElement e, AnnotationHolder holder, KubernetesAnnotatorColor annotatorColor) {
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(e).textAttributes(annotatorColor.getTextAttributeKey()).create();
    }
}

