/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.logs.KubernetesContextLogsModelKt;
import com.intellij.kubernetes.logs.TimeSlice;
import com.intellij.kubernetes.logs.pattern.matching.LogCluster;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.openapi.util.NlsSafe;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0001\u001a0\u0010\u0006\u001a\u00020\u00012\u001e\u0010\u0007\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00030\b0\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0001\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0001\u00a8\u0006\u000f"}, d2={"buildPatternsDescriptionHtmlText", "", "selectedPatterns", "", "Lcom/intellij/kubernetes/logs/pattern/matching/LogCluster;", "excludedPatterns", "getFormattedSourcesHtml", "podsByName", "Lkotlin/Pair;", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "addEvents", "", "getTimeSliceHtmlDescription", "timeSlice", "Lcom/intellij/kubernetes/logs/TimeSlice;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesLogsPresentableTextBuilders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLogsPresentableTextBuilders.kt\ncom/intellij/kubernetes/logs/KubernetesLogsPresentableTextBuildersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1869#2,2:61\n1#3:63\n*S KotlinDebug\n*F\n+ 1 KubernetesLogsPresentableTextBuilders.kt\ncom/intellij/kubernetes/logs/KubernetesLogsPresentableTextBuildersKt\n*L\n42#1:61,2\n*E\n"})
public final class KubernetesLogsPresentableTextBuildersKt {
    @NlsSafe
    @NotNull
    public static final String buildPatternsDescriptionHtmlText(@NotNull List<? extends LogCluster> selectedPatterns, @NotNull List<? extends LogCluster> excludedPatterns) {
        Intrinsics.checkNotNullParameter(selectedPatterns, (String)"selectedPatterns");
        Intrinsics.checkNotNullParameter(excludedPatterns, (String)"excludedPatterns");
        String selectedPatternsHtml = !((Collection)selectedPatterns).isEmpty() ? "\n      <b>Selected patterns:</b><br/>\n      " + CollectionsKt.joinToString$default((Iterable)selectedPatterns, (CharSequence)"<br/>", null, null, (int)0, null, KubernetesLogsPresentableTextBuildersKt::buildPatternsDescriptionHtmlText$lambda$0, (int)30, null) + "<br/>\n      " : "";
        String excludedPatternsHtml = !((Collection)excludedPatterns).isEmpty() ? "\n        <br/><b>Excluded patterns:</b><br/>\n        " + CollectionsKt.joinToString$default((Iterable)excludedPatterns, (CharSequence)"<br/>", null, null, (int)0, null, KubernetesLogsPresentableTextBuildersKt::buildPatternsDescriptionHtmlText$lambda$1, (int)30, null) + "<br/>\n        " : "";
        String htmlText = StringsKt.trimIndent((String)("\n      <html>\n      " + selectedPatternsHtml + "\n      " + excludedPatternsHtml + "\n      </html>\n  "));
        return htmlText;
    }

    @NlsSafe
    @NotNull
    public static final String getFormattedSourcesHtml(@NotNull List<? extends Pair<String, ? extends List<? extends KubernetesContainerObject>>> podsByName, boolean addEvents) {
        Pair pair;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(podsByName, (String)"podsByName");
        StringBuilder $this$getFormattedSourcesHtml_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getFormattedSourcesHtml_u24lambda_u245.append("<html>");
        if (addEvents) {
            $this$getFormattedSourcesHtml_u24lambda_u245.append("<b>Cluster Events</b>;&emsp;<br/>");
        }
        Iterable $this$forEach$iv = CollectionsKt.take((Iterable)podsByName, (int)2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            pair = (Pair)element$iv;
            boolean bl2 = false;
            String podName = (String)pair.component1();
            List containers2 = (List)pair.component2();
            $this$getFormattedSourcesHtml_u24lambda_u245.append("<b>Pod:</b> " + podName + "&emsp;");
            $this$getFormattedSourcesHtml_u24lambda_u245.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)containers2, (int)2), (CharSequence)", ", null, null, (int)0, null, KubernetesLogsPresentableTextBuildersKt::getFormattedSourcesHtml$lambda$5$lambda$3$lambda$2, (int)30, null));
            if (containers2.size() > 2) {
                $this$getFormattedSourcesHtml_u24lambda_u245.append(", + " + (containers2.size() - 2) + " more");
            }
            $this$getFormattedSourcesHtml_u24lambda_u245.append(";<br/>");
        }
        if (podsByName.size() > 2) {
            int n;
            Iterable iterable = CollectionsKt.drop((Iterable)podsByName, (int)2);
            int n2 = podsByName.size() - 2;
            StringBuilder stringBuilder2 = $this$getFormattedSourcesHtml_u24lambda_u245;
            int n3 = 0;
            for (Object t : iterable) {
                pair = (Pair)t;
                n = n3;
                boolean bl3 = false;
                List containers3 = (List)pair.component2();
                int n4 = containers3.size();
                n3 = n + n4;
            }
            n = n3;
            stringBuilder2.append("+ " + n2 + " more pods with " + n + " more containers");
        }
        $this$getFormattedSourcesHtml_u24lambda_u245.append("</html>");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NlsSafe
    @NotNull
    public static final String getTimeSliceHtmlDescription(@NotNull TimeSlice timeSlice) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)((Object)timeSlice), (String)"timeSlice");
        StringBuilder $this$getTimeSliceHtmlDescription_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getTimeSliceHtmlDescription_u24lambda_u246.append("<html>");
        Instant beginTime = timeSlice.getBeginTime();
        Instant endTime = timeSlice.getEndTime();
        if (beginTime != null) {
            $this$getTimeSliceHtmlDescription_u24lambda_u246.append("<b>From:</b> " + KubernetesContextLogsModelKt.prettyFormatInstant(beginTime) + "<br/>");
        }
        if (endTime != null) {
            $this$getTimeSliceHtmlDescription_u24lambda_u246.append("<b>To:</b> " + KubernetesContextLogsModelKt.prettyFormatInstant(endTime));
        }
        $this$getTimeSliceHtmlDescription_u24lambda_u246.append("</html>");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final CharSequence buildPatternsDescriptionHtmlText$lambda$0(LogCluster pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return pattern.toHTML();
    }

    private static final CharSequence buildPatternsDescriptionHtmlText$lambda$1(LogCluster pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return pattern.toHTML();
    }

    private static final CharSequence getFormattedSourcesHtml$lambda$5$lambda$3$lambda$2(KubernetesContainerObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }
}

