/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs.actions;

import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.logs.KubernetesContextLogsManager;
import com.intellij.kubernetes.logs.KubernetesLogPresentationSettings;
import com.intellij.kubernetes.logs.actions.KubernetesLogFilteringActionsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/logs/actions/ToggleLogColumnsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.clouds.kubernetes.backend"})
public final class ToggleLogColumnsAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesContextLogsManager logsManager = KubernetesLogFilteringActionsKt.logManager(e);
        if (logsManager == null || logsManager.isStateManagerDisposed() || !logsManager.getApiModel().isConnected()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesContextLogsManager kubernetesContextLogsManager = KubernetesLogFilteringActionsKt.logManager(e);
        if (kubernetesContextLogsManager == null) {
            return;
        }
        KubernetesContextLogsManager logsManager = kubernetesContextLogsManager;
        KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(logsManager.getApiModel().getProject(), (Object)"logs-select-columns-action");
        JBCheckBox timestampCheckbox = new JBCheckBox(KubernetesBundle.message((String)"k8s.logs.select.log.columns.action.checkbox.show.timestamp", (Object[])new Object[0]), ((KubernetesLogPresentationSettings)logsManager.getStateManager$intellij_clouds_kubernetes_backend().getPresentationSettingsStateFlow$intellij_clouds_kubernetes_backend().getValue()).getShowTimestamp());
        JBCheckBox sourceCheckbox = new JBCheckBox(KubernetesBundle.message((String)"k8s.logs.select.log.columns.action.checkbox.show.source", (Object[])new Object[0]), ((KubernetesLogPresentationSettings)logsManager.getStateManager$intellij_clouds_kubernetes_backend().getPresentationSettingsStateFlow$intellij_clouds_kubernetes_backend().getValue()).getShowSource());
        JBCheckBox messageCheckbox = new JBCheckBox(KubernetesBundle.message((String)"k8s.logs.select.log.columns.action.checkbox.show.message", (Object[])new Object[0]), ((KubernetesLogPresentationSettings)logsManager.getStateManager$intellij_clouds_kubernetes_backend().getPresentationSettingsStateFlow$intellij_clouds_kubernetes_backend().getValue()).getShowMessage());
        JPanel panel2 = new JPanel(new GridLayout(3, 1));
        panel2.add((Component)timestampCheckbox);
        panel2.add((Component)sourceCheckbox);
        panel2.add((Component)messageCheckbox);
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)panel2).setTitle(KubernetesBundle.message((String)"k8s.logs.select.log.columns.action.popup.title.toggle.log.columns", (Object[])new Object[0])).setFocusable(true).setRequestFocus(true).setMovable(true).setResizable(true).setCancelOnClickOutside(true).setCancelOnOtherWindowOpen(true).setCancelKeyEnabled(true).setModalContext(false).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup = jBPopup;
        popup.addListener(new JBPopupListener(logsManager, timestampCheckbox, sourceCheckbox, messageCheckbox){
            final /* synthetic */ KubernetesContextLogsManager $logsManager;
            final /* synthetic */ JBCheckBox $timestampCheckbox;
            final /* synthetic */ JBCheckBox $sourceCheckbox;
            final /* synthetic */ JBCheckBox $messageCheckbox;
            {
                this.$logsManager = $logsManager;
                this.$timestampCheckbox = $timestampCheckbox;
                this.$sourceCheckbox = $sourceCheckbox;
                this.$messageCheckbox = $messageCheckbox;
            }

            public void onClosed(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$logsManager.getStateManager$intellij_clouds_kubernetes_backend().getPresentationSettingsStateFlow$intellij_clouds_kubernetes_backend().setValue((Object)new KubernetesLogPresentationSettings(this.$timestampCheckbox.isSelected(), this.$sourceCheckbox.isSelected(), this.$messageCheckbox.isSelected()));
                this.triggerUsageCollector();
            }

            private final void triggerUsageCollector() {
                if (this.$timestampCheckbox.isSelected()) {
                    KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(this.$logsManager.getApiModel().getProject(), (Object)"logs-timestamp-column-selected");
                } else {
                    KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(this.$logsManager.getApiModel().getProject(), (Object)"logs-timestamp-column-excluded");
                }
                if (this.$sourceCheckbox.isSelected()) {
                    KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(this.$logsManager.getApiModel().getProject(), (Object)"logs-source-column-selected");
                } else {
                    KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(this.$logsManager.getApiModel().getProject(), (Object)"logs-source-column-excluded");
                }
                if (this.$messageCheckbox.isSelected()) {
                    KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(this.$logsManager.getApiModel().getProject(), (Object)"logs-message-column-selected");
                } else {
                    KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(this.$logsManager.getApiModel().getProject(), (Object)"logs-message-column-excluded");
                }
            }
        });
        InputEvent inputEvent = e.getInputEvent();
        if (inputEvent instanceof MouseEvent) {
            popup.show(new RelativePoint((MouseEvent)inputEvent));
        } else {
            popup.showInFocusCenter();
        }
    }
}

